(* ........................................................................ *)
(*        								    *)
(* MODULE	:   SBBS.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   MAIN BBS CORE PROGRAM                                   *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)               
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)      
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Search;

interface

{$IFDEF _LINUX_}
  Uses Crt, Dos, Lib, Data, ErrorLog, Colours;
{$ELSE}
  {F+}
  Uses Crt, Dos, Lib, Data, ErrorLog, Colours, PIBAsync, WaitTix;
{$ENDIF}

procedure SearchFiles;

Implementation

{ Search Record Temp File }

Type
   SeaRec = Record
        FileName  : String[12];
        Dir       : String[80];
        Lst       : String[80];
        Des       : String[60];
	Size      : LongInt;
        DLTimes   : Integer;
        ULUser    : String[30];
        Date      : String[8];
        RecNumber : Integer;
end;

Var
  KeyWord    : String;  { String To Search For }
  RecNumber  : Integer; { Search File Record Number }
  WideSearch : Boolean; { Searches Descriptions As Well As FileNames }
  TagError   : Boolean;
  SRec       : SeaRec;
  SearchR    : file of SeaRec;
  SerTemp,

  DirSeperator : String;

  Found      : Boolean;
  AreaNumber : Integer;
  FilesFound,
  ShowFile,
  FirstFile   : integer;
(*..........................................................................*)
procedure OpenTagFile;
Var
  UserTag : String;
begin
  {$IFDEF _LINUX_}
    DirSeperator := '/';
  {$ELSE}
    DirSeperator := '\';
  {$ENDIF}
  If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = DirSeperator then
    begin
      UserTag := BBSCfg.TempDir + UserInfo.UserAcc + '.tag';
    end
  Else
    begin
      UserTag := BBSCfg.TempDir + DirSeperator + UserInfo.UserAcc + '.tag';
    end;
  Assign(TagInfo, UserTag);
  {$I-} Reset(TagInfo); {$I+}
  If IOResult <> 0 then
   begin
     {$I-} Rewrite(TagInfo); {$I+}
     If IOResult <> 0 Then
      begin
        LogError('Unable To Open ' + UserTag);
        { Printed Locally Only }
        { Sends User Error }
      end;
   end;
   TagSize := FileSize(TagInfo);
end;
(*..........................................................................*)
procedure Tag(Number : Integer);
Var
  FileName : String;
  Step, St : Integer;
  Found    : Boolean;
begin
  OpenTagFile;
  St := Number;
  LineFeed;
  If Number = -1 then
    begin
      Print('Enter File Number To Tag : ');
      Colour(FYellow);
      Response := ReadKB(5);
      Val(Response, St, Step);
    end;
  Seek(SearchR, St);
  Read(SearchR, SRec);
  FileName := SRec.FileName;
  LineFeed;
  Print('TAGGING '+ Filename);
  found := false;
  for St := 0 to FileSize(SearchR) - 1 do
  begin
  Seek(SearchR, St);
  Read(SearchR, SRec);
  If Pos(FileName, SRec.FileName) <> 0 then
    begin
      {Check For Duplicate}
     If TagSize <> 0 then
      begin
        for Step := 0 to TagSize - 1 do
         begin
           Seek(TagInfo, Step);
           Read(TagInfo, Tags);
           If (Pos(FileName, Tags.FileName) > 0) and (Tags.Tagged <> 0) then
             begin
               LineFeed;
	       Print('File Already Tagged..');
	       {$IFDEF _LINUX_}
		 Delay(3000);
               {$ELSE}
		 Wait(30);
               {$ENDIF}
               Found := True;
               Exit;
             end
           Else
             begin
               Seek(TagInfo, TagSize);
               Tags.FileName  := SRec.FileName;
               Tags.Dir       := SRec.Dir;
               Tags.DirLst    := SRec.Lst;
               Tags.Des       := SRec.Des;
               Tags.Tagged    := 1;
               Tags.Size      := SRec.Size;
               Tags.DLTimes   := SRec.DLTimes;
               Tags.ULUser    := SRec.ULUser;
               Tags.Date      := SRec.Date;
               Tags.RecNumber := St;
               Write(TagInfo, Tags);
	       Found := True;
	       {$IFDEF _LINUX_}
		 Delay(3000);
               {$ELSE}
		 Wait(30);
               {$ENDIF}
             end;
         end;
      end
    Else
     begin
       If Found Then Exit;
       Seek(TagInfo, TagSize);
       Tags.FileName  := SRec.FileName;
       Tags.Dir       := SRec.Dir;
       Tags.DirLst    := SRec.Lst;
       Tags.Des       := SRec.Des;
       Tags.Tagged    := 1;
       Tags.Size      := SRec.Size;
       Tags.DLTimes   := SRec.DLTimes;
       Tags.ULUser    := SRec.ULUser;
       Tags.Date      := SRec.Date;
       Tags.RecNumber := St;
       Write(TagInfo, Tags);
       Found := True;
       {$IFDEF _LINUX_}
	 Delay(3000);
       {$ELSE}
	 Wait(30);
       {$ENDIF}
     end;
    end;
  end;
  Close(TagInfo);
  If Not Found then
    begin
      LineFeed;
      Print('*Unable To Locate File..');
      {$IFDEF _LINUX_}
        Delay(3000); 
      {$ELSE}
	Wait(30);
      {$ENDIF}
    end;
end;
(*..........................................................................*)
procedure Header;
begin
  ClearDisplay(True);
  Colour(FCyan);
  Print('Ŀ');
  LineFeed;
  Print('       Filename           Size            Date            Downloads         ');
  LineFeed;
  Print('');
  LineFeed;
end;
(*..........................................................................*)
procedure OpenSearchTemp;
begin
  RecNumber := 0;
  If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = '/' then
    begin
      SerTemp := BBSCfg.TempDir + UserInfo.UserName + '.sea';
    end
  Else
    begin
      SerTemp := BBSCfg.TempDir + '/' + UserInfo.Username + '.sea';
    end;
  Assign(SearchR, SerTemp);
  {$I-} Rewrite(SearchR); {$I+}   (* Rewrite Search File On Every Page *)
  If IOResult <> 0 then
    begin
    end
  Else
    begin
    end;
end;
(*..........................................................................*)
procedure ListSearchFiles;
  Label Relist, Stops;
Var
  Counter  : Integer;
  Counts   : String;
  FSize    : LongInt;
  Step     : Integer;
  DirInfo  : SearchRec;
  FileName,
  Strgs    : String;
begin
  ReList:
  Header;
  FSize := FileSize(SearchR);
  If UserInfo.UserAnsi = 1 then
    begin
      Counter := 2;
    end
  Else
    begin
      Counter := 0;
    end;
  Step := 0;
  Repeat
     {$I-}
      Seek(SearchR, Step);
      Read(SearchR, SRec);
      {$I+}
      FileError := IOResult;
      If FileError <> 0 then
       begin
         LogError('Seek Error Reading Search File ' + ErrorString(FileError));
         Close(Files);
         Exit;
       end;
       Inc(Counter);
       Colour(FRed);
       SetX('2');
       Str(Step, Strgs);
       Print(Strgs);
       Colour(FGreen);
       SetX('8');
       Print(SRec.FileName);
       Colour(FYellow);
       SetX('26');
       Str(SRec.Size, Counts);
       Print(Counts);
       SetX('41');
       Print(SRec.Date);
       Str(SRec.DLTimes, Strgs);
       Colour(FBlue);
       SetX('63');
       Print(Strgs);
       LineFeed;
       Colour(FWhite);
       SetX('7');
       Print(SRec.Des);
       LineFeed;
         If Counter = 12 then
           begin
             Repeat
               LineFeed;
               Print ('Continue - (Enter) / Tag File - (T) / Stop - (S) : ');
               Response := ReadKB(1);
               If (Response = 't') or (Response = 'T') then
                 begin
                   Tag(-1);
                 end;
               If (Response = 's') or (Response = 'S') then goto Stops;
            Until Response = '';
                Header;
                Counter := 2;
              end;
           Inc(Step);
    Until Step = FSize;
    Repeat
    LineFeed;
    Print(' Coutinue - (Enter) / Tag File - (T) / Relist - (R) : ');
    Response := ReadKB(1);
    If (Response = 't') or (Response = 'T') then
     begin
       Tag(-1);
     end;
    If (Response = 'r') or (Response = 'R') then
      begin
        Goto Relist;
      end;
  Until Response = '';
  Stops:
end;
(*..........................................................................*)
procedure BeginSearch;
Var
  Step,
  Steps,
  Ste    : Integer;
  FSize  : LongInt;
  Strgs  : string;
  Stop   : Boolean;
begin
  Step := 0;
  Stop := False;  { If Stop = True then halt search }
{  If (not Local) and (InputReady) then PurgeInput;} { Clear Buffer }
  SetY('7');
  Colour(FYellow);
  Print('Press ');
  Colour(FGreen);
  Print('Space');
  Colour(FYellow);
  Print(' To Stop Search..');
  while (Step < AreaSize) and (Stop = False) do
    begin
      If Step > 0 then
        begin
          {$I-} Close(Files); {$I+}
          If IOResult <> 0 then LogError('Unable To Close File In Search - ' + ErrorString(IOResult));
        end;
      inc(Step);
      {$I-} Seek(FileArea, Step - 1);
            Read(FileArea, Areas); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
           LogError('Error Reading File Area In Search - ' + ErrorString(FileError));
        end
      else
        begin
          if Areas.Access <= UserInfo.UserLevel then
           begin
	     {$IFDEF _LINUX_}
	       If Keypressed then Stop := True;
             {$ELSE}
               If (Not Local) and (Async_Buffer_Check) then
                 begin
                   Stop := True;
                 end
               Else
                 begin
                   If Local then
                     begin
		       If Keypressed then Stop := True;
		     end;
		  end;
              {$ENDIF}
            SetX('1');
            SetY('3');
            Colour(FYellow);
            Print(' Searching : ');
            Colour(FWhite);
            Print(Areas.DirDes + '                              ');
            LineFeed;
            Colour(FYellow);
            Print('     Found : ');
            Colour(FMagenta);
            Str(FilesFound, Strgs);
            Print(Strgs);
            {$I-} Assign(Files, Areas.FileLst); { Open File Data File }
            Reset(Files); {$I+}
            FileError := IOResult;
            If FileError <> 0 then
             begin
               LogError('Error Opening : ' + Areas.FileLst + ' - ' + ErrorString(FileError));
             end
            Else
              begin
                FSize := FileSize(Files);
                For Steps := 0 to FSize - 1 do
                 begin
                   Seek(Files, Steps);
                   Read(Files, FInfo);
                   for ste := 0 to length(FInfo.FileName) do
                    begin
                     FInfo.FileName[Ste] := UpCase(FInfo.FileName[Ste]);
                    end;
                   for ste := 0 to length(FInfo.Des1) do
                    begin
                      FInfo.Des1[ste] := UpCase(FInfo.Des1[Ste]);
                    end;
                  If (Pos(KeyWord, FInfo.FileName)) or
                       (Pos(KeyWord, FInfo.Des1)) > 0 then
                      begin
                        SRec.FileName  := FInfo.FileName;
                        SRec.Dir       := Areas.Dir;
                        SRec.Lst       := Areas.FileLst;
                        SRec.Des       := FInfo.Des1;
                        SRec.Size      := FInfo.Size;
                        SRec.DLTimes   := FINfo.DLTimes;
                        SRec.ULUser    := FInfo.ULUser;
                        SRec.Date      := FInfo.FDate;
                        SRec.RecNumber := Steps;
                        Seek(SearchR, RecNumber);
                        Write(SearchR, SRec);
                        inc(RecNumber);
                        inc(FilesFound);
                       Found := True;
                     end;
                  end;
              end;
           end;
      end;
   end;
 Echo := True;
 if Found then ListSearchFiles;
end;
(*..........................................................................*)
procedure NotFound;
Begin
  SetY('11');
  SetX('27');
  Colour(BMagenta);
  Colour(FWhite);
  Print('Ŀ');
  SetY('12');
  SetX('27');
  Print(' SORRY TEXT NOT FOUND ');
  SetY('13');
  SetX('27');
  Print('');
  Colour(BBlack);
  Colour(FWhite);
  {$IFDEF _LINUX_}
     Delay(4000); 
  {$ELSE}
     Wait(40);
  {$ENDIF}
  Echo := True;
end;
(*..........................................................................*)
procedure SearchFiles;
begin
  WideSearch := false;
  Found      := false;
  FilesFound := 0;
  AreaNumber := Areas.DirNo;
  RecNumber  := 0;
  ShowFile   := 1;
  LocalPrint(' LOCAL OUTPUT - Colours Need To Be Added');
  LineFeed;
  Print(' Search Scans The Description & fileNames for Selected Text, This Includes All');
  LineFeed;
  Print(' File Category Areas..');
  LineFeed;
  LineFeed;
  Print(' Please Enter Text To Scan For : > ');
  KeyWord  := ReadKB(20);
  if KeyWord = '' then Exit; { If no text is entered then exit }
  Echo     := False;
  TagError := False;
  ClearDisplay(True);  { Clear Screen }
  OpenSearchTemp;
  BeginSearch;
  If Not Found then NotFound;
  {$I-} Close(SearchR);
       If IOResult <> 0 Then LogError('Unable To Close Search File - ' + ErrorString(FileError));
       Close(Files);
       If IOResult <> 0 Then LogError('Unable To Close Area.* - ' + ErrorString(FileError));
       Seek(FileArea, AreaNumber - 1);
       Read(FileArea, Areas);
       If IOResult <> 0 Then LogError('Error Reading Area.*  - ' + ErrorString(FileError));
  {$I+}
end;
end.
