#!/bin/bash
# $Id: upload.sh,v 1.1 2008-03-04 21:04:41 simon Exp $
#..........................................................................
#                                                                          
# SCRIPT       :   UPLOAD.SH
#                                                                          
# DESCRIPTION  :   BBS script to upload file 
#                                                                          
# ENVIRONMENTS :   Sauron Linux BBS version 0.2.0.5+
#                                                                          
# COPYRIGHT    :   SIMON HORTON 2008                                
#                                                                          
#..........................................................................
# TODO:
#
# Expand to other modem protocols
# Error checking
# Virus Check

# Setup variables

BBSDIR=/usr/local/sauron/
BBSBINDIR=/usr/local/sauron/bin/
BBSUPLOAD=/usr/local/sauron/upload/
ZMODEM=/usr/bin/rz
UPLOG=/usr/local/sauron/log/upload.log

if [ "$(whoami)" = "guest" ]
  then
    exit 1
  else
    TAGLIST=${HOME}/upload.tag
    TAGINI=${HOME}/upload.ini
    TEMPDIR=${BBSUPLOAD}$(whoami)
fi

# Store upload file info into an array
filearray=(`cat ${TAGLIST}`)

# Check that the tag list exists
if [ -e ${TAGLIST} ]
   then
     let "next = 0"
     for tagfiles in ${filearray[@]}; do
      case $next in
         0)
         FILENAME=${filearray[${next}]}
         ;;
         1)
         UPDIR=${filearray[${next}]}
         ;;
      esac 
      let "next = next + 1"
     done
   else
     echo
     echo -e "Error no tag list..\n\f"
     exit 1
fi

# Make temporary directory for storing uploaded file
mkdir ${TEMPDIR}

if [ -e ${TEMPDIR} ]
  then
    cd ${TEMPDIR}

    # Start zmodem transfer
    ${ZMODEM}

    # Check that the right file has been uploaded
    if [ -e ${FILENAME} ] 
     then

       # Change permissions on file
       chmod 666 ${FILENAME}

       # Get File Size (bytes)
       FILESIZE=`ls ${FILENAME} -l | awk -F' ' '{ print $5 }'`

       # Add file size to tag file
       echo "[FILE]" > ${TAGINI}
       echo "SIZE=${FILESIZE}" >> ${TAGINI}

       # Copy the file to the correct file repo
       cp -f ${FILENAME} ${UPDIR}

       # Change to BBS directory
       cd ${BBSDIR}

       # Remove temp directory
       rm -Rf ${TEMPDIR} 

       echo "FILE UPLOAD IN [${UPDIR} ${FILENAME}] size [${FILESIZE}]" >> ${UPLOG} 
       exit 0;
     else
       
       # Remove temp directory
       rm -Rf ${TEMPDIR} &>2
       
       echo "FILE DOES NOT EXIT IN UPLOAD [${UPDIR} ${FILENAME}]" >> ${UPLOG} 
       cd ${BBSBINDIR}
       exit 1
    fi
    cd ${BBSBINDIR}
    exit 
  else
   exit 1
fi

# $Log: upload.sh,v $
# Revision 1.1  2008-03-04 21:04:41  simon
# Added upload.sh
