#!/bin/bash
# $Id: $
#..........................................................................
#
# SCRIPT       :   REMOVEOLDLOGFILES.SH (BBS MAINTENANCE SCRIPT)
#
# DESCRIPTION  :   Removes old user lockfiles
#
# ENVIRONMENTS :   Sauron Linux BBS version 0.31.0.1+
#
# COPYRIGHT    :   SIMON HORTON 2008
#
#..........................................................................
#
# Removes any old lock files which the BBS has failed to delete
# This will be the case if the user has been in a door and either
# disconnected, or hung up, as the <user>.lock file sets a door
# flag in the lock file to prevent it from being deleted by the
# deleteoldlockfiles routine within the BBS. Whilst the users
# lock file remains in the door lock state, the user will be
# unable to connect to the BBS.
#
# This script should be run every 5 - 15 minutes as a cron job. 
#
#..........................................................................
# CHANGELOG:
#
# 19 May 2008	Simon	First version
#..........................................................................

BBSNODEDIR=/usr/local/sauron/node/
CURRENTDIR=$(pwd)
BBSERRORLOG=/usr/local/sauron/log/maintenace.log

# Read the node directory for lock files, check if the user is still logged
# in and if they are not, remove the lock file..

# Change to the node directory
cd ${BBSNODEDIR}

# Store lock files info into an array
lockarray=(`ls -1 *.lock | awk -F. '{ print $1 }' `)
lockfiles=(`ls -1 *.lock`)

# Check that the tag list exists
let "next = 0"

for lockfile in ${lockarray[@]}; do
     
     # Read the whos logged in command and check the name
     # against the lock files

     w | grep ${lockarray[${next}]}

     if [ $? -ne 0 ]
      then
       
        # Remove the old lock file and log into  maintence.log  
        echo "$(date +%d-%b-%y:%H:%M:%S):Deleting old lock file ${lockfile[${next}]}.lock" >> ${BBSERRORLOG}

        rm -f ${lockarray[${next}]}.*lock
        echo "error ($?)"
 
        ERROR=$?
        echo "error (${ERROR})"

        if [ ${ERROR} -ne 0 ]
         then
           echo "$(date +%d-%b-%y:%H:%M:%S):Error deleting old lock file ${lockfile[${next}]}.lock Error (${ERROR})" >> ${BBSERRORLOG}
        fi
       
     fi

     let "next = next + 1"
   
done

# Change back to the orignal directory
cd ${CURRENTDIR}


