#!/bin/bash

# No Longer required

BBSNOCKDIR=/usr/local/sauron/node/
BBSLOGDIR=/usr/local/sauron/log/

# Create a node shell lock file based on the param

CreateLockFile () 
{
	case $1 in
	   door) 
	      nodelockfile=${BBSNOCKDIR}$(whoami).door.loc
	   ;;
	   download)
	      nodelockfile=${BBSNOCKDIR}.dl.loc
	   ;;
	   upload)
	      nodelockfile=${BBSNOCKDIR}.up.loc
	   ;;
	esac

        # Create users shell lock file
	
	echo "$(whoami)" > ${nodelockfile}

        # Change the perms on the users node.lock file
        # so it cannot be removed by the BBS because the
        # the user is in a shell
        
        chmod 655 ${BBSNOCKDIR}$(whoami).lock 1> /dev/null 
        
        if [ $? -ne 0 ] 
         then
         
          # Opps, cannot change perms
 
          echo "$(whoami).lock cannot change perm 600 for $1 shell" >> ${BBSLOGDIR}error.log
          exit 1

         fi       
}


DeleteLockFile ()
{
	case $1 in
	   door) 
	      nodelockfile=${BBSNOCKDIR}$(whoami).door.loc
	   ;;
	   download)
	      nodelockfile=${BBSNOCKDIR}.dl.loc
	   ;;
	   upload)
	      nodelockfile=${BBSNOCKDIR}.up.loc
	   ;;
	esac

	rm -f ${nodelockfile} 1> /dev/null

        # Change the perms on the users node.lock file
        # so it can be removed by the BBS now the
        # the user is returning from the shell
        
        chmod 666 ${BBSNOCKDIR}$(whoami).lock 1> /dev/null

        if [ $? -ne 0 ] 
          then
         
            # Opps, cannot change perms
 
            echo "$(whoami).lock cannot change perm 600 for $1 shell" >> ${BBSLOGDIR}error.log
            exit 1

          fi
}


case $2 in
   create)
      CreateLockFile $1
   ;;
   delete)
      DeleteLockFile $1
   ;;
esac
