#!/bin/bash
# ########################################################################
# Sauron Linux BBS Installation Script
# 
# Sauron BBS (C) Simon C Horton 1995 - 2000
# Sauron Linux BBS (C) Simon Horton 1998 - 2000
# 
# Sauron BBS Website : www.sauron.uklinux.net
# 	      E-Mail : simon@sauron.uklinux.net
# 
# HISTORY
#
#  VERSION    DATE        BY      DESCRIPTION   
# ########################################################################
#   0.1.1    18/03/00    Simon     Added more information regarding
#                                  installation.
#                                  Added create logfile procedure, I have
#                                  included this as there is still a bug
#                                  with log file creation in Sauron.
# ########################################################################
#   0.1.0    26/02/00    Simon     Rewrite
# ########################################################################
#   0.0.1    18/09/99    Simon     First Version
# ########################################################################
# NOTES:
#
# This is not a very well written script file, I do not fully understand
# bash scripting.  Any help from anybody to improve this installation script
# would be greatly received.. :-)

SCRIPTVERSION=0.1.2
BBSVERSION=0.2.0.5
SADDUSERVERSION=0.3.0.0

# ########################################################################
# Script routinues

getinput ()
{
   #  $1 VAR $2  PROMPT
   read -p "${2} (Default is : ${1}) ?:  " INPUT
   if [ -n "${INPUT}" ]
    then
      RESPONSE="${INPUT}"
    else
      RESPONSE="${1}"
   fi
   echo "Answer : ${RESPONSE}"
}

yesno ()
{
  while true;
   do
    echo -n "$1 [Y/N] ? "
    read answer
    case $answer in
      y|Y) return 0;;
      n|N) return 1;;
    esac
   done
}


createdirectory ()
{
  echo "Creating $1"
  mkdir $1
}

extract ()
{
   echo "Extracting $1 --> $2"
   tar -xzf ${INSTALLPATH}/$1 --directory $2 $3
}

permsdirectory ()
{
   echo "Changing permissons & ownership on $4"
   # $1 = owner $2 = group $3 = file permisson $4 = directory
   chown $1 $4
   chgrp $2 $4
   chmod $3 $4
}

permsfiles ()
{
   echo "Changing permissons & ownership on files in $4"
   # $1 = owner $2 = group $3 = file permisson $4 = directory $5 = files
   cd $4
   if [ "$5"  =  "all" ]
     then
       chown $1 *
       chgrp $2 *
       chmod $3 *
     else
       chown $1 $5
       chgrp $2 $5
       chmod $3 $5
   fi
   cd ${INSTALLPATH}
}


createsadduserini ()
{
   echo [CONFIG] > ${SADDUSERINI}.ini
   echo BBS_FILES=${INSTALLDIR} >> ${SADDUSERINI}.ini
   echo NEW_USER_FILES=${NEWUSERDIR} >> ${SADDUSERINI}.ini
   echo LOG_FILE_LOCATION=${LOGDIR} >> ${SADDUSERINI}.ini
   echo LOG_FILE_NAME=sadduser.log >> ${SADDUSERINI}.ini
   echo SHADOW_TOKEN=x >> ${SADDUSERINI}.ini
   echo PASSWD_FILE=/etc/passwd >> ${SADDUSERINI}.ini
   echo SHADOWFILE=/etc/shadow >> ${SADDUSERINI}.ini
   echo SHELL=${BINDIR}/sauron.sh >> ${SADDUSERINI}.ini
   echo HOME_DIR_PERMS=0777 >> ${SADDUSERINI}.ini
   echo MAILGRP=12 >> ${SADDUSERINI}.ini
   echo USERGRP=${GROUPID} >> ${SADDUSERINI}.ini
   echo USER=${USERID} >> ${SADDUSERINI}.ini
   echo HOME_DIR=/home >> ${SADDUSERINI}.ini
   echo SKEL_DIR=${SKELDIR} >> ${SADDUSERINI}.ini
   echo MAIL_DIR=/var/spool/mail >> ${SADDUSERINI}.ini
}

createlogfiles ()
{
   date > ${LOGDIR}/error.log
   date > ${LOGDIR}/user.log
}

createlinuxini ()
{

  echo "[CONFIG]" > ${BINDIR}/linux.ini
  echo ";Sauron BBS Directories" >> ${BINDIR}/linux.ini
  echo "SCRIPTDIR=${SCRIPTDIR}" >> ${BINDIR}/linux.ini
  echo "MENUDIR=${MENUDIR}" >> ${BINDIR}/linux.ini
  echo "FILESDIR=${FILESDIR}" >> ${BINDIR}/linux.ini
  echo "UPLOADDIR=${UPLOADDIR}" >> ${BINDIR}/linux.ini
  echo "MAILDIR=${MAILDIR}" >> ${BINDIR}/linux.ini
  echo "MSGDIR=${MSGDIR}" >> ${BINDIR}/linux.ini
  echo "DATADIR=${DATADIR}" >> ${BINDIR}/linux.ini
  echo "SYSDIR=${SYSDIR}" >> ${BINDIR}/linux.ini
  echo "TEXTDIR=${TEXTDIR}" >> ${BINDIR}/linux.ini
  echo "DOCDIR=${DOCDIR}" >> ${BINDIR}/linux.ini
  echo "LOGDIR=${LOGDIR}" >> ${BINDIR}/linux.ini
  echo "TEMPDIR=${TEMPDIR}" >> ${BINDIR}/linux.ini
  echo "NEWUSERDIR=${SKELDIR}" >> ${BINDIR}/linux.ini
  echo "HOMEDIR=${HOMEDIR}" >> ${BINDIR}/linux.ini
#  echo "SKELDIR=${SKELDIR}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; BBS Config" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "SYSOPFIRST=${SYSOPFIRST}" >> ${BINDIR}/linux.ini
  echo "SYSOPSEC=${SYSOPSEC}" >> ${BINDIR}/linux.ini
  echo "BBSNAME=${BBSNAME}" >> ${BINDIR}/linux.ini
  echo "BBSTEL=${BBSTEL}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; SYSOP USER UID" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "SYSOP=${SYSOPUID}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Send Sysop a message when a new user signs-ip" >> ${BINDIR}/linux.ini
  echo "; 1 = Enabled 0 = Disabled" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "SYSOPNEW=${SYSOPNEW}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Concurrent connections (Nodes)  are allowed to the bbs at one time" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "BBSNODES=${BBSNODES}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Guest user Linux UID number" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Required to be able to use guest access.." >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "GUESTUID=${GUESTUID}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Number of guests allowed on the system at one time" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "GUESTSALLOWED=${GUESTSALLOWED}" >> ${BINDIR}/linux.ini 
  echo ";Calls to the system. *Do Not change calls, as this updated by the BBS*" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "CALLS=0" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; MaxTag: Number of files a user is allowed to tag for download" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "MAXTAGS=${MAXTAGS}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; New user level" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "NEWLEVEL=${USERLEVEL}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Idle time in minutes to disconnect users" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "IDLETIME=${IDLETIME}" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Maximum number of users allowed on the system" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "MAXUSERS=100 *NOT YET IMPLEMENTED*" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; When max users is reached, expire dead users so new users may be created" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "EXPIREUSERS=YES *NOT YET IMPLEMENTED*" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Maximum number of messages allowed in each message area, when reached old" >> ${BINDIR}/linux.ini
  echo "; messages will be automatically deleted." >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; MAXMSG is currently bugged, crashes program....... Keep value high" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "MAXMSG=999" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Log files" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "USERLOG=user.log" >> ${BINDIR}/linux.ini
  echo "ERRORLOG=error.log" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; Current bulletin number. *This updated by the BBS, do not change*" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "BULLETIN=1" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; User level minutes per day allowed on the BBS" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "L1TIME=600" >> ${BINDIR}/linux.ini
  echo "L2TIME=999" >> ${BINDIR}/linux.ini
  echo "L3TIME=999" >> ${BINDIR}/linux.ini
  echo "L4TIME=999" >> ${BINDIR}/linux.ini
  echo "L5TIME=999" >> ${BINDIR}/linux.ini
  echo "L6TIME=999" >> ${BINDIR}/linux.ini
  echo "L7TIME=999" >> ${BINDIR}/linux.ini
  echo "L8TIME=999 " >> ${BINDIR}/linux.ini
  echo "L9TIME=999" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "; User level calls allowed per day" >> ${BINDIR}/linux.ini
  echo ";" >> ${BINDIR}/linux.ini
  echo "L1CALLS=100" >> ${BINDIR}/linux.ini
  echo "L2CALLS=999" >> ${BINDIR}/linux.ini
  echo "L3CALLS=999" >> ${BINDIR}/linux.ini
  echo "L4CALLS=999" >> ${BINDIR}/linux.ini
  echo "L5CALLS=999" >> ${BINDIR}/linux.ini
  echo "L6CALLS=999" >> ${BINDIR}/linux.ini
  echo "L7CALLS=999" >> ${BINDIR}/linux.ini
  echo "L8CALLS=999" >> ${BINDIR}/linux.ini
  echo "L9CALLS=999" >> ${BINDIR}/linux.ini
}


# ########################################################################
# Program files

BINFILES=bin.tar.gz
SCRIPTFILES=script.tar.gz
MENUFILES=menu.tar.gz
DATAFILES=data.tar.gz
SYSFILES=sys.tar.gz
TEXTFILES=text.tar.gz
DOCFILES=doc.tar.gz

# ########################################################################
# Program directories

INSTALLDIR=/downloads/bbs/test
BINDIR=$INSTALLDIR/bin/
SCRIPTDIR=$INSTALLDIR/script/
MENUDIR=$INSTALLDIR/menu/
FILESDIR=$INSTALLDIR/files/
UPLOADDIR=$INSTALLDIR/upload/
MAILDIR=$INSTALLDIR/mail/
DATADIR=$INSTALLDIR/data/
SYSDIR=$INSTALLDIR/sys/
TEXTDIR=$INSTALLDIR/text/
DOCDIR=$INSTALLDIR/doc/
LOGDIR=$INSTALLDIR/log/
MSGDIR=$INSTALLDIR/message/
TEMPDIR=$INSTALLDIR/temp/
NEWUSERDIR=$INSTALLDIR/newuser/
SKELDIR=$INSTALLDIR/newuser/skel/
HOMEDIR=$INSTALLDIR/home/

# ########################################################################
# Install variables

SADDUSERINI=$BINDIR/sadduser
SADDUSER=$BINDIR/sadduser

GROUP=sbbs
GROUPID=700
USERID=2000
SYSOPUID=2000
SYSOPUSER=sysop
SYSOPPASSWD=sysop1234
GUESTUID=2001
GUESTUSER=guest
GUESTPASSWD=guest
SYSOPFIRST=Simon
SYSOPSEC=Horton
BBSNAME="Sauron Linux BBS"
BBSTEL=bbs.foo.bar

IDLETIME=5
BBSNODES=5
GUESTSALLOWED=2
USERLEVEL=2

# ########################################################################
# Main

INSTALLPATH=`pwd`

# Clear Screen

if [ -e /usr/bin/clear ]
  then
    /usr/bin/clear
fi

echo "################################################################################"
echo "                         Sauron Linux BBS version $BBSVERSION"
echo "                   Sauron Linux BBS (c) Simon Horton 1998 - 2008"
echo "                              Installation ver $SCRIPTVERSION"
echo "                              www.sauron.uklinux.net"
echo "                                 bbs@sauron.org.uk"
echo "################################################################################"
echo

#if  [ "$(whoami)" != "root" ]
# then
#  echo "You must be logged in as root to install Sauron Linux BBS.."
#  echo
#  exit
#fi

echo "This is the first  public test release of Sauron Linux since 2000."
echo 
echo "This is still an unstable version of Sauron Linux, please see the PROBLEMS file"
echo "in the doc directory."
echo


if ! yesno "Procced with installation";
  then
    echo "Installation aborted..."
    echo
    exit
fi

clear
echo
echo "INSTALL PART 1/x - Installation Directory"
echo
echo
echo "NOT RECOMMAND TO CHANGE INSTALL PATH.."
echo
echo "If you change the installation path you will have to edit some of"
echo "script files in the $INSTALLDIR/script directory to the new path."
echo

if yesno "Change install directory [$INSTALLDIR]";
  then
    echo -n "Enter installation path : "
    read INSTALLDIR
    # ########################################################################
    # Program directories

	BINDIR=$INSTALLDIR/bin/
	SCRIPTDIR=$INSTALLDIR/script/
	MENUDIR=$INSTALLDIR/menu/
	FILESDIR=$INSTALLDIR/files/
	UPLOADDIR=$INSTALLDIR/upload/
	MAILDIR=$INSTALLDIR/mail/
	DATADIR=$INSTALLDIR/data/
	SYSDIR=$INSTALLDIR/sys/
	TEXTDIR=$INSTALLDIR/text/
	DOCDIR=$INSTALLDIR/doc/
	LOGDIR=$INSTALLDIR/log/
	MSGDIR=$INSTALLDIR/message/
	TEMPDIR=$INSTALLDIR/temp/
	NEWUSERDIR=$INSTALLDIR/newuser/
	SKELDIR=$INSTALLDIR/newuser/skel/
	HOMEDIR=$INSTALLDIR/home/
        SADDUSER=$BINDIR/sadduser

fi

clear
echo "INSTALL PART 2/x - BBS Configuration"
echo
echo
getinput ${SYSOPFIRST} "Sysop's First Name" 
SYSOPFIRST=${RESPONSE}
echo
getinput ${SYSOPSEC} "Sysop's Second Name"
SYSOPSEC=${RESPONSE}
echo
getinput "Sauron Linux" "What is the name of your BBS"
BBSNAME=${RESPONSE}
echo
getinput ${BBSTEL} "What is the hostname of your BBS"
BBSTEL=${RESPONSE}
echo
getinput ${IDLETIME} "How many minutes can a user be idle for before being disconnected"
IDLETIME=${RESPONSE}
echo
getinput ${BBSNODES} "How many concurrent connections (nodes) do you want on the BBS"
BBSNODES=${RESPONSE}
echo
getinput ${GUESTSALLOWED}  "How many GUEST users are allowed on the BBS at anyone time"
GUESTSALLOWED=${RESPONSE}
echo
if yesno "Do want a BBS mail sent to Sysop when a new user signs up ?: ";
 then
   SYSOPNEW=1
   echo "Answer : Yes"
 else
   SYSOPNEW=0
   echo "Answer : No"
fi
echo
echo "INSTALL PART 3/x - User/Group Configuration"
echo
getinput ${USERID} "BBS UIDs to start"
USERID=${RESPONSE}
let "SYSOPUID=${USERID}"
let "GUESTUID=${USERID} + 1"
echo
getinput ${GROUP} "Group Name"
GROUP=${RESPONSE}
echo
getinput ${GROUPID} "Group(${GROUP}) ID"
GROUPID=${RESPONSE}
echo
getinput ${SYSOPUSER} "Sysop User Name"
SYSOPUSER=${RESPONSE}
echo
getinput ${SYSOPPASSWD}  "${SYSOPUSER}'s Password"
SYSOPPASSWD=${RESPONSE}
echo
getinput ${GUESTUSER} "Guest User Name"
GUESTUSER=${RESPONSE}
echo
getinput ${GUESTPASSWD} "${GUESTUSER}'s Password"
GUESTPASSWD=${RESPONSE}
echo
getinput ${USERLEVEL}  "New User Level"
USERLEVEL=${RESPONSE}
echo

if ! yesno "Procced with installation to [$INSTALLDIR]";
  then
    echo "Installation aborted..."
    echo
    exit
fi

echo
echo "Creating program directories.."
echo
createdirectory $INSTALLDIR
createdirectory $BINDIR
createdirectory $SCRIPTDIR
createdirectory $MENUDIR
createdirectory $DATADIR
createdirectory $SYSDIR
createdirectory $TEXTDIR
createdirectory $DOCDIR
createdirectory $LOGDIR
createdirectory $TEMPDIR
createdirectory $NEWUSERDIR
createdirectory $FILESDIR
createdirectory $UPLOADDIR
createdirectory $MAILDIR
createdirectory $MSGDIR
createdirectory $SKELDIR
createdirectory $HOMEDIR

echo
echo "Please wait..."
sleep 2

echo
echo "Extracting program files.."
echo
#extract $BINFILES $BINDIR
#extract $SCRIPTFILES $SCRIPTDIR
#extract $MENUFILES $MENUDIR
#extract $DATAFILES $DATADIR
#extract $SYSFILES $SYSDIR
#extract $TEXTFILES $TEXTDIR
#extract $DOCFILES $DOCDIR

echo
echo "Please wait..."
sleep 2

echo
echo "Creating log files in $LOGDIR"
createlogfiles
echo
echo "Creating LINUX.INI & SADDUSER.INI"
createlinuxini
createsadduserini
echo
echo "Adding .hushlogin to ${SKELDIR}.."
echo "" > ${SKELDIR}/.hushlogin
echo
echo "In order for the bbs to function correctly a BBS group will be created."
echo "The installation will execute the command /sbin/groupadd, if this fails"
echo "you will need to create this group yourself with the following command:"
echo "groupadd -g $GRP -o $GROUP"
echo
echo "Creating BBS group.."
groupadd -g ${GROUPID} ${GROUP}
sleep 2
echo
echo "${SYSOPUSER}: UID=${SYSOPUID} GID=${GROUPID} (BBS) PASSWORD=${SYSOPPASSWD}"
echo "${GUESTUSER}: UID=${GUESTUID} GID=${GROUPID} (BBS) PASSWORD=${GUESTPASSWD}"
echo
read -p "Press any key to add users"
echo
echo ${SYSOPPASSWD} > sysop.passwd
echo ${GUESTPASSWD} > guest.passwd
echo
useradd -n -m -k ${SKELDIR} -d ${HOMEDIR}${SYSOPUSER} -s ${BINDIR}sauron.sh -u ${SYSOPUID} -g ${GROUPID} ${SYSOPUSER}
passwd ${SYSOPUSER} --stdin < sysop.passwd
useradd -n -m -k ${SKELDIR} -d ${HOMEDIR}${GUESTUSER} -s ${BINDIR}sauron.sh -u ${GUESTUID} -g ${GROUPID} ${GUESTUSER}
passwd ${GUESTUSER} --stdin < guest.passwd
rm -f guest.passwd sysop.passwd
echo
if ! yesno "Permissons and ownership need to be changed on the Sauron BBS files";
  then
    echo "You will need to change these manually."
    echo
  else
    echo
   # $1 = owner $2 = group $3 = file permisson $4 = directory
   permsdirectory $USER $GROUP 777 $INSTALLDIR
   permsdirectory $USER $GROUP 777 $BINDIR
   permsdirectory $USER $GROUP 777 $SCRIPTDIR
   permsdirectory $USER $GROUP 777 $MENUDIR
   permsdirectory $USER $GROUP 777 $DATADIR
   permsdirectory $USER $GROUP 777 $SYSDIR
   permsdirectory $USER $GROUP 777 $TEXTDIR
   permsdirectory $USER $GROUP 777 $DOCDIR
   permsdirectory $USER $GROUP 777 $LOGDIR
   permsdirectory $USER $GROUP 777 $TEMPDIR
   permsdirectory $USER $GROUP 777 $NEWUSERDIR
   permsdirectory $USER $GROUP 777 $MESSAGEDIR
   # $1 = owner $2 = group $3 = file permisson $4 = directory $5 = files
   echo
   permsfiles $USER $GROUP 777 $BINDIR all
   permsfiles $USER $GROUP 777 $BINDIR linux.ini
   permsfiles $USER $GROUP 700 $BINDIR sadduser
   permsfiles $USER $GROUP 700 $BINDIR sadduser.ini
   permsfiles $USER $GROUP 666 $SCRIPTDIR all
   permsfiles $USER $GROUP 666 $MENUDIR all
   permsfiles $USER $GROUP 666 $DATADIR all
   permsfiles $USER $GROUP 666 $SYSDIR all
   permsfiles $USER $GROUP 666 $TEXTDIR all
   permsfiles $USER $GROUP 666 $DOCDIR all
   permsfiles $USER $GROUP 666 $LOGDIR all
fi
echo
echo "Installation Complete............. :-)"
echo
echo "Now login as [$USER] password [$PASS] and try out Sauron Linux BBS..."
echo
echo "Visit www.sauron.uklinux.net for updates, source code and information.."
echo "Please report all errors to bugs@sauron.uklinux.net"
echo


