#!/bin/bash
# $Id: downloadtags.sh,v 1.3 2008-02-26 22:44:19 simon Exp $
#..........................................................................
#                                                                          
# SCRIPT       :   DOWNLOADTAGS.SH
#                                                                          
# DESCRIPTION  :   BBS script to download multiple files 
#                                                                          
# ENVIRONMENTS :   Sauron Linux BBS version 0.2.0.5+
#                                                                          
# COPYRIGHT    :   SIMON HORTON 2008                                
#                                                                          
#..........................................................................
# TODO:
#
# Expand to other modem protocols
# Error checking

# Setup variables

ZMODEM=/usr/bin/sz

if [ "$(whoami)" = "guest" ]
  then
    TAGLIST=${HOME}/file.lst.${REMOTEHOST}
    LOGFILE=/usr/local/sauron/log/download.$(whoami).${REMOTEHOST}.log
  else
    TAGLIST=${HOME}/file.lst
    LOGFILE=/usr/local/sauron/log/download.$(whoami).log
fi

# Store tagged files into an array
filearray=(`cat ${TAGLIST}`)

# Check that the tag list exists
if [ -e ${TAGLIST} ]
   then
     for tagfiles in ${filearray[@]}; do
       ${ZMODEM} -b -8 ${filearray[${next}]}
       let "next = next + 1"
     done
   else
     echo
     echo -e "Error no tag list..\n\f"
fi

# $Log: downloadtags.sh,v $
# Revision 1.3  2008-02-26 22:44:19  simon
# Cleaned up code
# Tested download with 2 files (yeah alot I know...... :-)
#
# Revision 1.2  2008-02-26 22:03:29  simon
# May have fixed bug by putting files to be downloaded into array.. 
# More testing required

# Revision 1.1  2008-02-26 21:16:25  simon
# Download tagged files, first version
# Bugged in the sz execution which appears to upset the zmodem with nak errors
#
