#!/bin/bash
# $Id: $
#..........................................................................
#
# SCRIPT       :   CHANGEPASSWORD.SH
#
# DESCRIPTION  :   BBS script to change a users password
#
# ENVIRONMENTS :   Sauron Linux BBS version 0.31.0.1+
#
# COPYRIGHT    :   SIMON HORTON 2008
#
#..........................................................................

# The script command CREATEPASSWORDTAG must be called
# from a BBS script to create the file password.tag

PASSWORDTAG=${HOME}/password.tag

# Store passwords into an array
passwdarray=(`cat ${PASSWORDTAG}`) 

# Check that the password tag file exists
if [ -e ${PASSWORDTAG} ]
   then
     let "next = 0"
     for passwds in ${passwdarray[@]}; do
      case $next in
         0)
         OLDPASSWD=${passwdarray[${next}]}
         ;;
         1)
         NEWPASSWD=${passwdarray[${next}]}
         ;;
      esac
      let "next = next + 1"
     done
   else
     echo
     echo -e "Error no password tag list..\n\f"
     exit 1
fi

#remove the password tag file
rm -f ${PASSWORDTAG}

# Call expect script to change user password
./changepassword.ex ${OLDPASSWD} ${NEWPASSWD} 1>/dev/null 
#./changepassword.ex ${OLDPASSWD} ${NEWPASSWD} 


ERROR=$?

if [ ${ERROR} -ne 0 ] 
then
  case ${ERROR} in
     1*)
      echo "ERROR : Your old password is incorrect..!"
     ;;
     2*)
      echo "ERROR : Your new password is to simple..!"
     ;;
     3*)
      echo "ERROR : Your new password to simple..!"
     ;;
     4*)
      echo "ERROR : Your new password should be longer..!"
     ;;
     5)
      echo "ERROR : Your password has not been changed..!"
  esac
  exit ${ERROR}
else
  exit 0
fi
