-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.0.45


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema bbs
--

CREATE DATABASE IF NOT EXISTS bbs;
USE bbs;
CREATE TABLE  `bbs`.`bbs_config` (
  `sysopfirst` varchar(40) NOT NULL COMMENT 'Sysop First Name',
  `sysopsec` varchar(40) NOT NULL COMMENT 'Sysop Last Name',
  `bbsname` varchar(40) NOT NULL COMMENT 'BBS Name',
  `bbstel` varchar(40) NOT NULL COMMENT 'BBS Name',
  `useruid` int(11) NOT NULL default '2000' COMMENT 'BBS User Linux Start UID',
  `sysopuid` int(11) NOT NULL default '2001' COMMENT 'Linux UID of the Sysop User',
  `guestuid` int(11) NOT NULL default '2002' COMMENT 'Linux UID of the BBS Guest User',
  `bbsnodes` int(11) default NULL COMMENT 'Concurrent connections (Nodes) are allowed at one time',
  `sysopnew` tinyint(1) NOT NULL COMMENT 'Send Sysop a Message on New User Signup',
  `guestno` int(11) NOT NULL default '0' COMMENT 'Number of Current Registered Guests',
  `guestsallowed` int(11) NOT NULL default '2' COMMENT 'Number of Guests allowed on the System at One Time',
  `calls` int(11) NOT NULL default '0' COMMENT 'Calls to the BBS',
  `idletime` int(11) NOT NULL default '5' COMMENT 'Idle Time in Minutes to Disconnect Users',
  `userlog` varchar(40) NOT NULL COMMENT 'User Log FileName',
  `errorlog` varchar(40) NOT NULL COMMENT 'Error Log FileName',
  `bulletinforum` int(11) NOT NULL default '0' COMMENT 'Forum ID used as the Bulletin Messages',
  `showwho` int(11) NOT NULL default '2' COMMENT 'Displays either IP,Current Page Title or Disabled',
  `l1time` int(11) NOT NULL default '999' COMMENT 'Level 1 Time Allowed Online per 24hrs',
  `l2time` int(11) NOT NULL default '999' COMMENT 'Level 2 Time Allowed Online per 24hrs',
  `l3time` int(11) NOT NULL default '999' COMMENT 'Level 3 Time Allowed Online per 24hrs',
  `l4time` int(11) NOT NULL default '999' COMMENT 'Level 4 Time Allowed Online per 24hrs',
  `l5time` int(11) NOT NULL default '999' COMMENT 'Level 5 Time Allowed Online per 24hrs',
  `l6time` int(11) NOT NULL default '999' COMMENT 'Level 6 Time Allowed Online per 24hrs',
  `l7time` int(11) NOT NULL default '999' COMMENT 'Level 7 Time Allowed Online per 24hrs',
  `l8time` int(11) NOT NULL default '999' COMMENT 'Level 8 Time Allowed Online per 24hrs',
  `l9time` int(11) NOT NULL default '999' COMMENT 'Level 9 Time Allowed Online per 24hrs',
  `l1calls` int(11) NOT NULL default '999' COMMENT 'Level 1 Calles Allowed per 24hrs',
  `l2calls` int(11) NOT NULL default '999' COMMENT 'Level 2 Calles Allowed per 24hrs',
  `l3calls` int(11) NOT NULL default '999' COMMENT 'Level 3 Calles Allowed per 24hrs',
  `l4calls` int(11) NOT NULL default '999' COMMENT 'Level 4 Calles Allowed per 24hrs',
  `l5calls` int(11) NOT NULL default '999' COMMENT 'Level 5 Calles Allowed per 24hrs',
  `l6calls` int(11) NOT NULL default '999' COMMENT 'Level 6 Calles Allowed per 24hrs',
  `l7calls` int(11) NOT NULL default '999' COMMENT 'Level 7 Calles Allowed per 24hrs',
  `l8calls` int(11) NOT NULL default '999' COMMENT 'Level 8 Calles Allowed per 24hrs',
  `l9calls` int(11) NOT NULL default '999' COMMENT 'Level 9 Calles Allowed per 24hrs'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='BBS Configuration';
INSERT INTO `bbs`.`bbs_config` VALUES  ('The','Master','Sauron BBS','bbs.foo.bar',1000,1000,1001,5,0,10,5,1323,5,'user.log','error.log',1,1,999,999,999,999,123,999,999,999,999,90,999,999,999,999,999,999,34,450);
CREATE TABLE  `bbs`.`forum` (
  `fid` int(11) NOT NULL auto_increment COMMENT 'Forum ID',
  `title` varchar(40) NOT NULL COMMENT 'Forum Title',
  `description` varchar(80) NOT NULL COMMENT 'Forum description',
  `levelread` tinyint(2) NOT NULL default '1' COMMENT 'Lowest user level can read',
  `levelpostlo` tinyint(2) NOT NULL default '1' COMMENT 'Lowest user level can post',
  `levelposthi` tinyint(2) NOT NULL default '1' COMMENT 'Highest user level can post',
  `deletetag` tinyint(2) NOT NULL default '0' COMMENT 'Deletion Tag',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=latin1 COMMENT='Forum Areas';
INSERT INTO `bbs`.`forum` VALUES  (1,'Bulletins','BBS News Bulletins',1,1,9,0);
CREATE TABLE  `bbs`.`forum_messages` (
  `mid` int(11) NOT NULL auto_increment COMMENT 'Post ID',
  `uid` tinyint(11) NOT NULL default '0' COMMENT 'User ID',
  `threadactive` tinyint(1) unsigned NOT NULL default '1' COMMENT 'Active in the last 30 days',
  `username` varchar(33) NOT NULL COMMENT 'Post username',
  `date` text NOT NULL COMMENT 'Short date  dd/mm/yy 00:00:00',
  `title` varchar(40) NOT NULL COMMENT 'Post title',
  `content` text NOT NULL COMMENT 'Message content',
  `views` tinyint(11) default '0' COMMENT 'Number of views',
  `replies` tinyint(11) default '0' COMMENT 'Number of replies',
  `locked` tinyint(1) NOT NULL default '0' COMMENT 'Replies allowed ',
  `fid` tinyint(11) NOT NULL default '1' COMMENT 'Forum ID',
  `time` int(14) unsigned NOT NULL default '0' COMMENT 'Creation timestamp',
  `expire` int(14) unsigned NOT NULL default '0' COMMENT 'Post exipre datestamp 0 = no expire',
  `deletetag` tinyint(1) unsigned NOT NULL default '0' COMMENT 'Post deletion tag',
  `remotehost` varchar(255) default NULL,
  `remoteip` varchar(255) default NULL,
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=118 DEFAULT CHARSET=latin1;
CREATE TABLE  `bbs`.`forum_replies` (
  `rid` int(11) NOT NULL auto_increment COMMENT 'Post reply ID',
  `mid` int(11) NOT NULL default '0' COMMENT 'Post ID',
  `time` int(14) unsigned NOT NULL default '0' COMMENT 'Datestamp',
  `date` varchar(20) NOT NULL COMMENT 'Shortdate dd/mm/yyyy 00:00:00',
  `uid` int(11) NOT NULL default '0' COMMENT 'User UID',
  `title` varchar(40) NOT NULL COMMENT 'Reply Title',
  `content` text NOT NULL COMMENT 'Reply message',
  `fid` tinyint(11) unsigned NOT NULL default '1' COMMENT 'Forum ID',
  `username` varchar(33) NOT NULL default '0' COMMENT 'Username',
  `remotehost` varchar(255) default NULL,
  `remoteip` varchar(255) default NULL,
  `deletetag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;
CREATE TABLE  `bbs`.`user_data` (
  `uid` int(11) NOT NULL COMMENT 'User Linux UID',
  `account` varchar(3) NOT NULL COMMENT 'BBS Account Number (Legacy)',
  `ansi` tinyint(1) NOT NULL default '1' COMMENT '1 = Ansi or  0 = Avatar',
  `colour` tinyint(1) NOT NULL default '1' COMMENT 'Colour 0=off 1=on',
  `level` tinyint(2) NOT NULL default '1' COMMENT 'User Account Level',
  `time` int(14) NOT NULL default '0' COMMENT 'Epoch date of user account creation',
  `timestamp` int(14) NOT NULL default '0' COMMENT 'User timestamp for call/time allowance',
  `logon` int(14) NOT NULL default '0' COMMENT 'Time/Date of users last login (set on logoff)',
  `reg` tinyint(1) NOT NULL default '0' COMMENT 'User registration flag (used for guest accounts)',
  `name` varchar(30) NOT NULL COMMENT 'Username',
  `namefull` varchar(30) NOT NULL COMMENT 'Users fullname',
  `pass` varchar(30) NOT NULL COMMENT 'User encyrpted pw (legacy)',
  `town` varchar(30) NOT NULL COMMENT 'Users location',
  `email` varchar(30) NOT NULL COMMENT 'Users email address',
  `info1` varchar(30) NOT NULL COMMENT 'User info 1',
  `info2` varchar(30) NOT NULL COMMENT 'User info 2',
  `info3` varchar(30) NOT NULL COMMENT 'User info 3',
  `info4` varchar(30) NOT NULL COMMENT 'User info 4',
  `info5` varchar(30) NOT NULL COMMENT 'User info 5',
  `info6` varchar(30) NOT NULL COMMENT 'User info 6',
  `info7` varchar(30) NOT NULL COMMENT 'User info 7',
  `info8` varchar(30) NOT NULL COMMENT 'User info 8',
  `cls` tinyint(1) NOT NULL default '1' COMMENT 'Screen clear code',
  `lines` int(3) NOT NULL default '24' COMMENT 'Line of users terminal',
  `bulletin` tinyint(4) NOT NULL default '0' COMMENT 'Users current bulletin number',
  `mailcount` tinyint(4) NOT NULL default '0' COMMENT 'User mail',
  `lastmsgnum` int(11) NOT NULL default '0' COMMENT 'Users last post number',
  `calls` int(11) NOT NULL default '0' COMMENT 'User calls to the BBS',
  `callstoday` int(11) NOT NULL default '0' COMMENT 'Number of calls to BBS in last 24hrs',
  `lcalldate` varchar(10) NOT NULL,
  `lastcall` varchar(30) NOT NULL,
  `callnumber` int(11) NOT NULL default '0' COMMENT 'Last call number',
  `timeonline` int(11) NOT NULL default '0' COMMENT 'User total time online in last 24 hrs',
  `downloads` int(11) NOT NULL default '0' COMMENT 'Number of downloads',
  `uploads` int(11) NOT NULL default '0' COMMENT 'Number of uploads',
  `bytesdl` int(11) NOT NULL default '0' COMMENT 'Bytes Downloaded',
  `bytesul` int(11) NOT NULL default '0' COMMENT 'Bytes Uploaded',
  `guest` varchar(255) NOT NULL COMMENT 'Guest Account 1 = yes 0 =no',
  `guestip` varchar(255) NOT NULL COMMENT 'IP Address of guest user'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='BBS Users';
INSERT INTO `bbs`.`user_data` VALUES(0,'0',1,1,9,0,1216827890,1218456648,1,'root','The System Master','***','The BBS','foo@bar','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL',1,24,8,0,0,10,2,'23/7/2008','Monday 11 Aug 2008, 1:10pm',935,1,0,0,0,0,'no','0.0.0.0');
CREATE TABLE  `bbs`.`user_mail` (
  `eid` int(11) unsigned NOT NULL auto_increment COMMENT 'Mail ID',
  `uid` int(11) NOT NULL COMMENT 'User Linux UID',
  `subject` varchar(100) NOT NULL default '0' COMMENT 'Mail Subject',
  `content` text NOT NULL COMMENT 'Mail Message',
  `date` int(14) NOT NULL COMMENT 'Mail Date',
  `from` varchar(30) NOT NULL default '' COMMENT 'Mail From',
  `view` tinyint(1) unsigned default '0' COMMENT 'Mail Read Flag',
  `replied` tinyint(1) unsigned default '0' COMMENT 'Mail Replied',
  PRIMARY KEY  (`eid`),
  KEY `eid` (`eid`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;
CREATE TABLE  `bbs`.`user_signup` (
  `account` varchar(3) NOT NULL COMMENT 'BBS Account Number (Legacy)',
  `ansi` tinyint(1) NOT NULL default '1' COMMENT '1 = Ansi or  0 = Avatar',
  `colour` tinyint(1) NOT NULL default '1' COMMENT 'Colour 0=off 1=on',
  `name` varchar(30) NOT NULL COMMENT 'Username',
  `namefull` varchar(30) NOT NULL COMMENT 'Users fullname',
  `pass` varchar(30) NOT NULL COMMENT 'User encyrpted pw (legacy)',
  `town` varchar(30) NOT NULL COMMENT 'Users location',
  `email` varchar(30) NOT NULL COMMENT 'Users email address',
  `info1` varchar(30) NOT NULL COMMENT 'User info 1',
  `info2` varchar(30) NOT NULL COMMENT 'User info 2',
  `info3` varchar(30) NOT NULL COMMENT 'User info 3',
  `info4` varchar(30) NOT NULL COMMENT 'User info 4',
  `info5` varchar(30) NOT NULL COMMENT 'User info 5',
  `info6` varchar(30) NOT NULL COMMENT 'User info 6',
  `info7` varchar(30) NOT NULL COMMENT 'User info 7',
  `info8` varchar(30) NOT NULL COMMENT 'User info 8',
  `cls` tinyint(1) NOT NULL default '1' COMMENT 'Screen clear code',
  `lines` int(3) NOT NULL default '24' COMMENT 'Line of users terminal',
  `guesthost` varchar(255) NOT NULL COMMENT 'IP Address of guest user',
  `time` int(11) NOT NULL COMMENT 'Epoch time of user signup',
  `sid` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COMMENT='BBS Users';



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
