(*..........................................................................*)
(*                                                                          *)
(* MODULE       :   SQLDB.PP                                                *)
(*                                                                          *)
(* DESCRIPTION  :   MYSQL version 5.0 unit                                  *)
(*                                                                          *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 2.2.0 LINUX KERNEL 2.6+               *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 2008                                       *)
(*                                                                          *)
(*..........................................................................*)
unit sqldb;

interface

uses mysql50, strutils;

procedure sql_info;
function sql_connect(host, user, pass : pchar) : boolean;
procedure sql_close;
function sql_select_db(database : pchar) : boolean;
function sql_query(query : pchar) : boolean;
function sql_store_results : PMYSQL_RES;
function sql_affected_rows : integer;
function sql_fetch_row(resbuf : PMYSQL_RES) : MYSQL_ROW;
function sql_num_rows(resbuf : PMYSQL_RES) : integer;
procedure sql_free_results(resbuf : PMYSQL_RES);
function sql_addslashes(strdata : ansistring) : ansistring;

var
  sqlerror,
  query    : pchar;
  querystr,
  qstr     : ansistring;
type
  recbuf   = PMYSQL_RES;
  rowbuf   = MYSQL_ROW;

implementation

var
  sock   : PMYSQL;
  qmysql : st_mysql;
  qbuf   : string [160];
  dummy  : string;

(*..........................................................................*)

procedure sql_info;
begin
  writeln ('Mysql_port      : ',mysql_port);
  writeln ('Mysql_unix_port : ',mysql_unix_port);
  writeln ('Host info       : ',mysql_get_host_info(sock));
  writeln ('Server info     : ',mysql_stat(sock));
  writeln ('Client info     : ',mysql_get_client_info);
end;

(*..........................................................................*)

function sql_connect(host, user, pass : pchar) : boolean;
begin
  { Connect to SQL server }
  mysql_init(PMySQL(@qmysql));
  sock := mysql_real_connect(PMysql(@qmysql),host,user,pass,nil,3306,nil,0);
  { if there is an error, return false }
  if sock = Nil then
    begin
      sqlerror := mysql_error(@qmysql);
      sql_connect := false;
      exit;
    end;
  { All OK }
  sql_connect := true;
end;

(*..........................................................................*)

procedure sql_close;
begin
  { Close connection to SQL server }
  mysql_close(sock);
end;

(*..........................................................................*)

function sql_select_db(database : pchar) : boolean;
begin
  { Connect to database }
  if mysql_select_db(sock,database) < 0 then
    begin
      { on error return false }
      sql_select_db := false;
      sqlerror := mysql_error(sock);
      exit;
    end;
  { All OK }
  sql_select_db := true;
end;

(*..........................................................................*)

function sql_query(query : pchar) : boolean;
begin
  { Execute query  }
  if (mysql_query(sock, query) <> 0 ) then
   begin
     { on error return false }
     sql_query := false;
     sqlerror := mysql_error(sock);
     exit;
   end;
  { all OK }
  sql_query := true;
end;

(*..........................................................................*)

function sql_store_results : PMYSQL_RES;
begin
  { grab results }
  sql_store_results := mysql_store_result(sock);
end;

(*..........................................................................*)

function sql_affected_rows : integer;
begin
  sql_affected_rows := mysql_affected_rows(sock);
end;

(*..........................................................................*)

function sql_fetch_row(resbuf : PMYSQL_RES) : MYSQL_ROW;
begin
  { grab data  }
  sql_fetch_row := mysql_fetch_row(resbuf);
end;

(*..........................................................................*)

function sql_num_rows(resbuf : PMYSQL_RES) : integer;
begin
  sql_num_rows := mysql_num_rows(resbuf);
end;

(*..........................................................................*)

procedure sql_free_results(resbuf : PMYSQL_RES);
begin
  mysql_free_result(resbuf);
end;

(*..........................................................................*)
{ Returns a string with backslashes before characters that need to be quoted }
{ in database queries etc. These characters are single quote ('),            }
{ double quote ("), backslash (\) and NUL (the NULL byte).                   }
function sql_addslashes(strdata : ansistring) : ansistring;
var
  SlashesTemp : ansistring;
begin
  { \ }
  strdata := AnsiReplaceStr(strdata, chr(92), '\' + chr(92));
  { / }
  strdata := AnsiReplaceStr(strdata, chr(47), '\' + chr(47));
  { ' }
  strdata := AnsiReplaceStr(strdata, chr(39), '\' + chr(39));
  { " }
  strdata := AnsiReplaceStr(strdata, chr(34), '\' + chr(34));
  { NULL }
  strdata := AnsiReplaceStr(strdata, chr(0), '\' + chr(0));
  sql_addslashes := strdata;
end;

(*..........................................................................*)
{ Removes the backsalashes }
function sql_removeslashes(strdata : ansistring) : ansistring;
var
  SlashesTemp : ansistring;
begin
  { \ }
  strdata := AnsiReplaceStr(strdata, '\' + chr(92), chr(92));
  { / }
  strdata := AnsiReplaceStr(strdata, '\' + chr(47), chr(47));
  { ' }
  strdata := AnsiReplaceStr(strdata, '\' + chr(39), chr(39));
  { " }
  strdata := AnsiReplaceStr(strdata, '\' + chr(34), chr(34));
  { NULL }
  strdata := AnsiReplaceStr(strdata, '\' + chr(0), chr(0));
  sql_removeslashes := strdata;
end;

(*..........................................................................*)

end.

