{ $Id: sadduser.pas,v 1.2 2008-03-15 10:01:34 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* PROGRAM	:   SADDUSER.PP (Sauron Add User)	                    *)
(*									    *)
(* DESCRIPTION	:   Adds New Users to Linux System                          *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 2.2.0                                 *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1999 - 2008                                *)
(*									    *)
(* LICENSE	:   GPL (See COPYING.DOC for more information)              *)
(*                                                                          *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* changelog.txt                                                            *)
(*..........................................................................*)
Program SaddUser;

uses Dos, Crt, Strings, Linux, Data, INI, Errorlog, Dates, Directory, Creation,
     FileCopy, BaseUnix, SQLDB;
(*..........................................................................*)
procedure Stop_Program(Buffer : string);
begin
  //writeln(Title, ' Version ', Version,' ', Copyright);
  writeln;
  if Output_Verbose then
   begin
     writeln('>> ', Buffer);
     writeln('>> Program End..');
     writeln;
   end
  else
    begin
      writeln(Buffer);
      writeln;
    end;
  Halt(1);
end;
(*..........................................................................*)
procedure Start_System(Config_File : string);
var
  Code_Data   : integer;
  Tmp_String  : string;
begin
  UIDCount := 0; { Reset userid counter }
  Success := 0;
  { Check for CONFIG file }
  if Output_Verbose then writeln('> Checking for ini configuration file..');
  if not FileExist(Config_file + '.ini') then
   begin
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] Check for INI file : [',Config_File, '.ini] Errors = [', ErrorString(DosError), ']');
    {$ENDIF}
    if not Display_Users then Stop_Program('Configuration file missing.. ' + Config_File + '.ini');
   end;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Check for INI file : [',Config_File, '.ini] Errors = [', ErrorString(DosError), ']');
  {$ENDIF}
  { Read CONFIG FILE }
  if Output_Verbose then writeln('> Reading configuration file..');
  { SQL }
  Success := GetProfile(Config_File, 'SQL' , 'SQLSERVER', Tmp_String, '127.0.0.1');
  Config.sql_server :=  StrAlloc (length(Tmp_String) + 1);
  StrpCopy(Config.sql_server, Tmp_String);
  Success := GetProfile(Config_File, 'SQL' , 'SQLDB', Tmp_String, 'bbs');
  Config.sql_db := StrAlloc (length(Tmp_String) + 1);
  StrpCopy(Config.sql_db, Tmp_String);
  Success := GetProfile(Config_File, 'SQL' , 'SQLUSER', Tmp_String, 'sauron');
  Config.sql_user := StrAlloc (length(Tmp_String) + 1);
  StrpCopy(Config.sql_user, Tmp_String);
  Success := GetProfile(Config_File, 'SQL' , 'SQLPW', Tmp_String, 'sauronbbs');
  Config.sql_pw := StrAlloc (length(Tmp_String) + 1);
  StrpCopy(Config.sql_pw, Tmp_String);
  { CONFIG }
  Success := GetProfile(Config_File, 'CONFIG' , 'BBS_FILES', Config.bbs_files, '/usr/local/sauron/');
  Success := GetProfile(Config_File, 'CONFIG' , 'NEW_USER_FILES', Config.new_user_files, '/usr/local/sauron/newuser');
  Success := GetProfile(Config_File, 'CONFIG' , 'LOG_FILE_LOCATION', Config.log_file_location, '/usr/local/sauron/');
  Success := GetProfile(Config_File, 'CONFIG' , 'LOG_FILE_NAME', Config.log_file_name, 'user.log');

  Success := GetProfile(Config_File, 'CONFIG' , 'SHADOW_TOKEN', Shadowtoken, '*');
  Success := GetProfile(Config_File, 'CONFIG' , 'PASSWD_FILE', PasswdFile, '/etc/passwd');
  Success := GetProfile(Config_File, 'CONFIG' , 'SHADOW_FILE', ShadowFile, '/etc/shadow');
  Success := GetProfile(Config_File, 'CONFIG' , 'SKEL_DIR', SkelDir, '/etc/skel');
  Success := GetProfile(Config_File, 'CONFIG' , 'MAIL_DIR', MailDir, '/var/spool/mail');
  Success := GetProfile(Config_File, 'CONFIG' , 'SHELL', DefaultShell, '/usr/local/sauron/sauron.sh');
  Success := GetProfile(Config_File, 'CONFIG' , 'HOME_DIR', HomeDir, '/local/home');
  Success := GetProfile(Config_File, 'CONFIG' , 'USE_SKEL', Data_String, '0');
  val(Data_String, UseSkel, Code_Data);
  Success := GetProfile(Config_File, 'CONFIG' , 'HOME_DIR_PERMS', Data_String, '0775');
  val(Data_String, HomeDirPerms, Code_Data);
  Success := GetProfile(Config_File, 'CONFIG' , 'USERGRP', Data_String, '500');
  val(Data_String, UserGrp, Code_Data);
  Success := GetProfile(Config_File, 'CONFIG' , 'USER', Data_String, '2000');
  val(Data_String, UserNo, Code_Data);
   Success := GetProfile(Config_File, 'CONFIG' , 'MAIL_GRP', Data_String, '12');
  val(Data_String, MailGrp, Code_Data);
   Success := GetProfile(Config_File, 'CONFIG' , 'USER_LEVEL', Data_String, '2');
  val(Data_String, UserLevel, Code_Data);
   Success := GetProfile(Config_File, 'CONFIG' , 'USER_BULLETIN', NewUser_Data.Bulletin, '0');
  //val(Data_String, NewUser_Data.Bulletin, Code_Data);
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_USER', Data_String, '1');
  if Data_String = '1' then Config.mail_USER := true
   else Config.mail_user := false;
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_USER_SUBJECT', Config.mail_user_subject, '');
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_USER_MESSAGE', Config.mail_template_location, '/usr/local/sauron/temp/newusermail.txt');
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_ADMIN', Data_String, '1');
  if Data_String = '1' then Config.mail_admin := true
   else Config.mail_admin := false;
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_ADMIN_SUBJECT', Config.mail_admin_subject, '');
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_ADMIN_ADDRESS', Config.mail_admin_address, '');
  Success := GetProfile(Config_File, 'MAIL' , 'MAIL_ADMIN_MESSAGE', Config.mail_admin_message, '');
  DisposeINICollection;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] sql_server         = [', Config.sql_server,']');
     writeln(' [DEBUG] sql_db             = [', Config.sql_db,']');
     writeln(' [DEBUG] sql_user           = [', Config.sql_user,']');
     writeln(' [DEBUG] sql_pw             = [', Config.sql_pw,']');

     writeln(' [DEBUG] bbs_files          = [', Config.bbs_files,']');
     writeln(' [DEBUG] new_user_files     = [', Config.new_user_files,']');
     writeln(' [DEBUG] log_file_location  = [', Config.log_file_location,']');
     writeln(' [DEBUG] log_file_name      = [', Config.log_file_name,']');

     writeln(' [DEBUG] ShadowToken        = [', ShadowToken,']');
     writeln(' [DEBUG] PasswdFile         = [', PasswdFile,']');
     writeln(' [DEBUG] ShadowFile         = [', ShadowFile,']');
     writeln(' [DEBUG] DefaultShell       = [', DefaultShell,']');
     writeln(' [DEBUG] HomeDir		  = [', HomeDir,']');
     writeln(' [DEBUG] SkelDir		  = [', SkelDir,']');
     writeln(' [DEBUG] MailDir		  = [', MailDir,']');
     writeln(' [DEBUG] HomePerms          = [', HomeDirPerms,']');
     writeln(' [DEBUG] UserGrp            = [', UserGrp,']');
     writeln(' [DEBUG] UseSkel            = [', UseSkel,']');
     writeln(' [DEBUG] User ID            = [', UserNo,']');
     writeln(' [DEBUG] User Level         = [', NewUser_Data.UserLevel,']');
     writeln(' [DEBUG] User Bulletin      = [', NewUser_Data.Bulletin,']');
    { writeln(' [DEBUG] MailGrp            = [', MailGrp,']');  }
     writeln(' [DEBUG] User Mail Subject  = [', Config.mail_user_subject,']');
     writeln(' [DEBUG] User Mail Message  = [', Config.mail_template_location,']');
     writeln(' [DEBUG] Admin Mail Subject = [', Config.mail_admin_subject,']');
     writeln(' [DEBUG] Admin Mail Address = [', Config.mail_admin_address,']');
     writeln(' [DEBUG] Admin Mail Message = [', Config.mail_admin_message,']');
  {$ENDIF}
  if Success <= 0 then
   begin
     writeln('>> Error reading ini configuration file..(',Success,')');
     writeln('>> Program End..');
     Halt(1);
   end;
  { Connect to SQL Server }
  if Output_Verbose then writeln('> Connecting to SQL server...');
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Connecting to SQL server [', Config.sql_server,']');
  {$ENDIF}
  if not sql_connect(Config.sql_server, Config.sql_user, Config.sql_pw) then
   begin
     LogError('Error connecting SQL server - ' + SQLError);
     LogError('Program stopped..');
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] SQL connection error [', SQLError,']');
     {$ENDIF}
     Stop_Program('Error connecting to SQL server, see log file');
   end
  else
   begin
     { Connect database }
     if Output_Verbose then writeln('> Connecting to SQL database...');
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] Connecting to SQL database [', Config.sql_db,']');
     {$ENDIF}
     if not sql_select_db(Config.sql_db) then
      begin
        LogError('Error connecting SQL database - ' + SQLError);
        LogError('Program stopped..');
        {$IFDEF _DEBUG_}
          writeln(' [DEBUG] SQL database connection error [', SQLError,']');
        {$ENDIF}
        Stop_Program('Error connecting to SQL database, see log file');
      end;
   end;
  { Check directories }
  if Output_Verbose then writeln('> Checking file paths..');
  if not Display_Users then
   begin
    Check_Directory(Config.bbs_files);
    Check_Directory(Config.new_user_files);
    Check_Directory(Config.log_file_location);
    Check_Directory(HomeDir);
    Check_Directory(SkelDir);
    Check_Directory(MailDir);
   end;
  { Check for Log File }
  if not Check_For_Log then LogError('LOG FILE CREATED ');
  LogError('*************************************************************');
  { Check for required files }
  if Output_Verbose then writeln('> Checking for required files...');
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for passwd file [', PasswdFile,']');
  {$ENDIF}
  if not FileExist(PasswdFile) then
   begin
    LogError('Password file missing ' + PasswdFile + ' - Program Stopped');
    Stop_Program('Password file missing.. ' + PasswdFile );
   end;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for shadow file [', ShadowFile,']');
  {$ENDIF}
  if not FileExist(ShadowFile) then
   begin
    LogError('Shadow file missing ' + ShadowFile);
    LogError('Adding encrypted password in ' + PasswdFile);
    NoShadowFile := TRUE;
   end;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Checking for Default Shell [', DefaultShell,']');
  {$ENDIF}
  if not FileExist(DefaultShell) then
   begin
     LogError('Shell file missing ' + DefaultShell + ' - Program Stopped');
     if not Display_Users then Stop_Program('Shell file missing.. ' + DefaultShell );
   end;
(*
  Data_String := Config.new_user_files;
  if Data_String[Length(Data_String)] = '/' then
    Data_String := Data_String + 'adduser.dat'
  else Data_String := Data_String + '/' + 'adduser.dat';
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for user creation database [', Data_String, ']');
  {$ENDIF}
  if not FileExist(Data_String) then
   begin
     LogError('No users to create... User creation database not found [' + Data_String + ']');
     Stop_Program('No users to create..');
   end;
*)

end;
(*..........................................................................*)
{ Main Program}
var
  Creation_No,
  Creation_Count,
  YPos           : integer;
  New_User,
  Paramms	 : PChar;
  Params	 : Param;
  DelFile        : text;
begin
   if (Paramcount = 0) or (Paramstr(1) = '--help')  then
    begin
      ClrScr;
      writeln(Title,' Version ', Version, ' ', Copyright);
      writeln(License);
      writeln;
      writeln('Usage : sadduser <options> [ini file]');
      writeln;
      writeln('Options - ');
      writeln;
      writeln('  --users                Display list of users waiting creation');
      writeln('  --verbose              Explain whats being done');
      writeln('  --nolog                Do not write to log file *disabled*');
      writeln('  --help                 This screen');
      writeln;
      writeln('INI file - ');
      writeln;
      writeln('Name of configuration file needed by sadduser, the configuration file needs the');
      writeln('extension of <.ini> but is not need on the command line. ');
      writeln;
      writeln('Example: sadduser -verbose sadduser');
      writeln;
      writeln('Please read the SADDUSER.DOC for information on using sadduser.');
      writeln('Email: simon@sauron.org.uk with questions or bug reports.');
      writeln;
      writeln(WebSite);
      writeln(BBS);
      writeln;
      Halt(0);
    end
   else
    begin
      NoShadowFile := FALSE;
      Output_Verbose := FALSE;
      Display_Users := FALSE;
      { Get command line params }
      for Loop := 1 to paramcount do
       begin
         if paramstr(Loop) = '--verbose' then Output_Verbose := TRUE
          else if paramstr(Loop) = '--nolog' then S1 := ''
           else if paramstr(Loop) = '--help' then S1 := ''
            else if paramstr(Loop) = '--users' then Display_Users := TRUE
             else Params.inifile := paramstr(Loop);
       end;
      {$IFDEF _DEBUG_}
        clrscr;
        writeln(Title,' Version ', Version, ' ', Copyright);
        writeln('DEBUG MODE   = ON');
        writeln('VERBOSE MODE = ON');
        writeln;
        Output_Verbose := TRUE;
      {$ELSE}
        if Output_Verbose then
         begin
          writeln(Title, ' Version ', Version,' ', Copyright);
          writeln;
         end;
      {$ENDIF}
      { Ensure user is root }
      if fpgetuid <> 0 then
        begin
          Stop_Program('You must be root to run this program..');
        end;
      { Intaililise software }
      Start_System(params.inifile);
      { Get number of users to create }
      Creation_No := Get_User_Size;
      case Creation_No of
            -1:  begin
                 Stop_Program('Error whilst reading SQL user_table..');
                 LogError('Error whilst reading SQL user_table..');
                 end;
             0:  begin
                 Stop_Program('No users to create..');
                 LogError('No users to create.. Stoppping');
                 end;
      end; { Case end }
      {$IFDEF _DEBUG_}
        writeln(' [DEBUG] Number of users to create = [', Creation_No,']');
      {$ENDIF}
      for Loop := 1 to Creation_No do
       begin
         if not Get_User_Info(Loop) then
          begin
            {$IFDEF _DEBUG_}
               writeln(' [DEBUG] Unable to get new user info for  = [', NewUser[Loop].SID ,']');
            {$ENDIF}
          end
         else
          begin
            if not Display_Users then
             begin
              { Convert username to a pchar so we can check against existing Linux users }
              New_User := StrAlloc(Length(User_Data.UserName) + 1);
              StrPCopy(New_User, User_Data.UserName);
              { Check for existing users, if OK carry on }
              if Check_For_Existing_User(New_User) then
               begin
                if Create_User then inc(Creation_Count);
               end;
             end
            else
             begin
               { Displaying users waiting for creation }
               YPos := whereY;
               gotoxy(1,YPos);
               write('Username : ', User_Data.UserName);
               gotoxy(25,YPos);
               write('Fullname : ', User_Data.UserNameFull);
               gotoxy(50,YPos);
               write('Location : ', User_Data.UserTown);
               gotoxy(80,YPos);
               write('E-mail : ', User_Data.UserEmail);
               writeln;
             end;
          end;
       end;
    end;
   if not Display_Users then
    begin
      //Success := Copy_File(Config.new_user_files, Config.new_user_files, './.', TRUE);
      //LogError('Backed up database to adduser.' + CallDate);
      {$IFDEF _DEBUG_}
        // writeln(' [DEBUG] Backed up database to adduser.', CallDate ,' [', Success,']');
      {$ENDIF}
      { Add data deletion }
      {$I-}
(*
	assign(DelFile,Data_String);
	close(DelFile);
        fSuccess := IOResult;
	if fSuccess <> 0 then writeln('IORESULT = ',IOResult);
        erase(DelFile);
*)
      {$I+}
    end;
   { Remove SQL config & Close Connection }
   if Output_Verbose then writeln('> Closing connection to SQL server...');
   {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Closing connection to SQL server [', Config.sql_server,']');
   {$ENDIF}
   Dispose(Config.sql_server);
   Dispose(Config.sql_db);
   Dispose(Config.sql_user);
   Dispose(Config.sql_pw);
   sql_close;

   Str(Creation_No, S1);
   Str(Creation_Count, S2);
   LogError('Number of Users to create (' + S1 + '), Actual users created (' + S2 + ')');
   if Output_Verbose then writeln('> Number of Users to create (', S1,'), Actual users created (', S2,')');
   if Output_Verbose then writeln;
end.
