{ $Id: }
(* ........................................................................ *)
(*        								    *)
(* PROGRAM	:   MAIL.PAS  (Sadduser Mail Unit)                          *)
(*									    *)
(* DESCRIPTION	:   Sends a e-mail the new user and sends a mail to the     *)
(*              :   BBS sysops, that a new user has been created            *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 2.2.0                                 *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1999 - 2008                                *)
(*									    *)
(* LICENSE	:   GPL (See COPYING.DOC for more information)              *)
(*                                                                          *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* changelog.txt                                                            *)
(*..........................................................................*)
(* Unit user mail.sh script in sauron/bin                                   *)
(*..........................................................................*)

unit mail;

interface

uses crt, dos, unix, baseunix, strutils, data, dates, errorlog;

function Send_Mail(Username, FullName, UserEmail, Location, RemoteHost : string) : boolean;
function Send_Admin_Mail(Username, FullName, UserEmail, Location, RemoteHost : string) : boolean;

implementation

function Send_Mail(Username, FullName, UserEmail, Location, RemoteHost : string) : boolean;
var
  MailText,
  MailTemplateText : Text;
  MailTemplateLine,
  MailFile,
  ShellCommand,
  ShellSwitches : ansistring;
begin
  { Open New-UserMail.txt }
  if Output_Verbose then writeln('> Opening Mail Template...');
  LogError('Opening Mail Template...');
  {$IFDEF _DEBUG_} 
     writeln(' [DEBUG] Opening - ' + Config.mail_template_location);
  {$ENDIF}
  Assign(MailTemplateText, Config.mail_template_location);
  {$I-} Reset(MailTemplateText); {$I+}
  fSuccess := IOResult;
  if fSuccess <> 0 then
   begin
     { Error Opening File }
     if Output_Verbose then writeln('> Error Opening Mail Template, Check Log...');
     LogError('Unable to open - ' + Config.mail_template_location + ' Error - ' + ErrorString(fSuccess));
     {$IFDEF _DEBUG_} 
        writeln(' [DEBUG] Unable to open - ' + Config.mail_template_location + ' Error - ' + ErrorString(fSuccess));
     {$ENDIF}
     Send_Mail := false;
     exit;
   end;
  { Create the a tempory mail file }
  if Output_Verbose then writeln('> Creating Temporary Mail File...');
  LogError('Creating Temporary Mail File...');
  If Config.bbs_files[Length(Config.bbs_files)] = '/' then MailFile := Config.bbs_files + 'temp/newmail.tmp'
    Else MailFile := Config.bbs_files + '/temp/newmail.tmp';
  {$IFDEF _DEBUG_} 
     writeln(' [DEBUG] Creating - ' + MailFile);
  {$ENDIF}
  Assign(MailText, MailFile);
  {$I-} Rewrite(MailText); {$I+}
  fSuccess := IOResult;
  if fSuccess = 0 then
    begin
      if Output_Verbose then writeln('> Reading Mail Template and Saving Temp Mail File...');
      LogError('Reading Mail Template and Saving Temp Mail File...');
      while not eof(MailTemplateText) do
       begin
         { Read template File }
         Readln(MailTemplateText, MailTemplateLine);
         { Convert Vars  }
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%FULLNAME%', fullname);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%USERNAME%', username);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%LOCATION%', location);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%EMAIL%', useremail);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%REMOTEHOST%', remotehost);
         { Save to Temp Mail File }
         WriteLn(MailText, MailTemplateLine);
       end;   
      WriteLn(MailText, chr(13));
      WriteLn(MailText, chr(13));
      {$I-}
      if Output_Verbose then writeln('> Closing Temp Mail Files...');
      Close(MailText);
      Close(MailTemplateText);
      //Erase(MailText);
      fSuccess := IOResult;
      {$I+}
      if Output_Verbose then writeln('> Sending User Mail..');
      LogError('Sending User Mail..');
      shellCommand := '/usr/local/sauron/bin/mail.sh ''' + Config.mail_user_subject + ''' ' + UserEmail + ' ' + MailFile;
      {$IFDEF _DEBUG_} 
         writeln(' [DEBUG] Executing Shell Command - ' + ShellCommand + ' ' + ShellSwitches);
      {$ENDIF}
      fpsystem(shellcommand);
      Send_Mail := True;
    end
  else
    begin
      { Cannot create temp mail file }
      if Output_Verbose then writeln('> Error Creating Temp Mail File, Check Log...');
      LogError('Unable to create Temp Mail File - ' + MailFile + ' Error - ' + ErrorString(fSuccess));
      {$IFDEF _DEBUG_} 
         writeln(' [DEBUG] Unable to create temp mail file - ' + MailFile + ' Error - ' + ErrorString(fSuccess));
      {$ENDIF}
      Send_Mail := false;
    end;
end;

function Send_Admin_Mail(Username, FullName, UserEmail, Location, RemoteHost : string) : boolean;
var
  MailText,
  MailTemplateText : Text;
  MailTemplateLine,
  MailFile,
  ShellCommand : ansistring;
begin
  { Open Admin-Mail.txt }
  if Output_Verbose then writeln('> Opening Admin Mail Template...');
  LogError('Opening Admin Mail Template...');
  {$IFDEF _DEBUG_} 
     writeln(' [DEBUG] Opening - ' + Config.mail_template_location);
  {$ENDIF}
  Assign(MailTemplateText, Config.mail_admin_message);
  {$I-} Reset(MailTemplateText); {$I+}
  fSuccess := IOResult;
  if fSuccess <> 0 then
   begin
     { Error Opening File }
     if Output_Verbose then writeln('> Error Opening Admin Mail Template, Check Log...');
     LogError('Unable to open - ' + Config.mail_admin_message + ' Error - ' + ErrorString(fSuccess));
     {$IFDEF _DEBUG_} 
        writeln(' [DEBUG] Unable to open - ' + Config.mail_admin_message + ' Error - ' + ErrorString(fSuccess));
     {$ENDIF}
     Send_Admin_Mail := false;
     exit;
   end;
  { Create the a tempory mail file }
  if Output_Verbose then writeln('> Creating Admin Temporary Mail File...');
  LogError('Creating Admin Temporary Mail File...');
  If Config.bbs_files[Length(Config.bbs_files)] = '/' then MailFile := Config.bbs_files + 'temp/adminmail.tmp'
    Else MailFile := Config.bbs_files + '/temp/adminmail.tmp';
  {$IFDEF _DEBUG_} 
     writeln(' [DEBUG] Creating - ' + MailFile);
  {$ENDIF}
  Assign(MailText, MailFile);
  {$I-} Rewrite(MailText); {$I+}
  fSuccess := IOResult;
  if fSuccess = 0 then
    begin
      if Output_Verbose then writeln('> Reading Admin Mail Template and Saving Admin Temp Mail File...');
      LogError('Reading Admin Mail Template and Saving Admin Temp Mail File...');
      while not eof(MailTemplateText) do
       begin
         { Read template File }
         Readln(MailTemplateText, MailTemplateLine);
         { Convert Vars  }
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%FULLNAME%', fullname);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%USERNAME%', username);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%LOCATION%', location);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%EMAIL%', useremail);
         MailTemplateLine :=  AnsiReplaceText(MailTemplateLine, '%REMOTEHOST%', remotehost);
         { Save to Temp Mail File }
         WriteLn(MailText, MailTemplateLine);
       end;   
      WriteLn(MailText, chr(13));
      WriteLn(MailText, chr(13));
      {$I-}
      { Files must be closed before calling the shell script }
      if Output_Verbose then writeln('> Closing Admin Mail Files...');
      LogError('Closing Admin Mail Files...');
      Close(MailText);
      Close(MailTemplateText);
      //Erase(MailText);
      fSuccess := IOResult;
      {$I+}
      if Output_Verbose then writeln('> Sending Admin Mail..');
      LogError('Sending Admin Mail..');
      shellCommand := '/usr/local/sauron/bin/mail.sh ''' + Config.mail_admin_subject  + ''' ' + Config.mail_admin_address + ' ' + MailFile;
      {$IFDEF _DEBUG_} 
         writeln(' [DEBUG] Executing Shell Command - ' + ShellCommand);
      {$ENDIF}
      fpsystem(ShellCommand);
      Send_Admin_Mail := True;
    end
  else
    begin
      { Cannot create temp mail file }
      if Output_Verbose then writeln('> Error Creating Temp Mail File, Check Log...');
      LogError('Unable to create Temp Mail File - ' + MailFile + ' Error - ' + ErrorString(fSuccess));
      {$IFDEF _DEBUG_} 
         writeln(' [DEBUG] Unable to create temp mail file - ' + MailFile + ' Error - ' + ErrorString(fSuccess));
      {$ENDIF}
      Send_Admin_Mail := false;
    end;
end;

end.
