(* ........................................................................ *)
(*        								    *)
(* MODULE	:   FILECOPY.PP      			                    *)
(*									    *)
(* DESCRIPTION	:   File copy routinue                                      *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 0.99.5 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON C HORTON  1999 - 2000                             *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit FileCopy;

interface

uses Dos, Linux, Strings, Errorlog, Dates, BaseUnix;

function Copy_File(FPath, TPath, fMask : string; DAT : Boolean) : integer;

implementation

function Copy_File(FPath, TPath, fMask : string; DAT : Boolean) : integer;
Var 
 Fin, FOut  : File;
 NumRead,
 NumWritten : word;
 Buffer	    : array[1..2048] of byte;
 TheDir     : PDir;
 ADirent    : PDirent;
 fSuccess   : integer;
 Entry,
 Total      : Longint;
 FileName, 
 FFrom, FTo,
 S1, S2     :string;

begin
  Total := 0; { Reset total files copied to 0 }
  if FPath[Length(FPath)] <> '/' then FFrom := FPath + '/';
  if TPath[Length(TPath)] <> '/' then FTo := TPath + '/';
  {$I-}
  writeln('DIR - ', FFrom + fMask);
  TheDir:=fpOpenDir(FFrom + fMask);
  repeat
    ADirent:=fpReadDir (TheDir^);
    If ADirent<>Nil then
      With ADirent^ do
        begin
         FileName := StrPas(pchar(@d_name[0]));
         Writeln('FIleName = ', FileName);
         S1 := FFrom + FileName;
         if DAT then S2 := FTo + 'adduser.' + CallDate
           else S2 := FTo + FileName;
           assign(Fin, S1); { Open file to copy }
           reset(Fin, 1);
           fSuccess := IOResult;
           if fSuccess <> 0 then
            begin
              LogError('Unable to open ' + FFrom + FileName + ' for reading - file skipped');
              {$IFDEF _DEBUG_}
                writeln(' [DEBUG] Error reading ', FFrom, FileName, '[', ErrorString(fSuccess),']');
              {$ENDIF}
              //close(FOut);
              //close(FIn);
            end
           else
            begin
             assign(FOut, S2);
             rewrite(FOut, 1);
             fSuccess := IOResult;
             if fSuccess <> 0 then
              begin
                LogError('Unable to open ' + FFrom + FileName + ' for writing - file skipped');
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Error writing ', FFrom, FileName, '[', ErrorString(fSuccess),']');
                {$ENDIF}
                close(Fin);
              end
             else
              begin
                { Copy file }
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Coping File [', S1, '] to [',S2,']');
                {$ENDIF}
                repeat
                  BlockRead(Fin, Buffer, Sizeof(Buffer), NumRead);
                  BlockWrite(Fout, Buffer, NumRead, NumWritten);
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Buffer Size [',Sizeof(Buffer),']');
                {$ENDIF}
                until (NumRead = 0) or (NumWritten <> NumRead);
                LogError('Copied File [' + S1 + '] to [' + S2 + ']');
                inc(total);
                close(Fin);
                close(FOut);
             end;
           end;
         {$I+}
       end;
     Until ADirent=Nil;
   fpCloseDir (TheDir^);
end;

(*..........................................................................*)
(*
function Copy_File(FPath, TPath, fMask : string; DAT : Boolean) : integer;
var
 G1, G2	    : PGlob;
 Fin, FOut  : File;
 NumRead,
 NumWritten : word;
 Buffer	    : array[1..2048] of byte;
 Total      : longint;
 fSuccess   : integer;
 FFrom, FTo,
 FileName,
 S1, S2,
 ReadDirectory : string;
begin
  Total := 0; { Reset total files copied to 0 }
  if FPath[Length(FPath)] <> '/' then FFrom := FPath + '/';
  if TPath[Length(TPath)] <> '/' then FTo := TPath + '/';
  ReadDirectory := FFrom + fMask;
  G1 := Glob(ReadDirectory);
  if LinuxError = 0 then
    begin
      G2 := G1;
      while G2 <> NIL do
       begin
         FileName := StrPas(G2^.Name);
         S1 := FFrom + FileName;
         if DAT then S2 := FTo + 'adduser.' + CallDate
           else S2 := FTo + FileName;
         {$I-}
           assign(Fin, S1); { Open file to copy }
           reset(Fin, 1);
           fSuccess := IOResult;
           if fSuccess <> 0 then
            begin
              LogError('Unable to open ' + FFrom + FileName + ' for reading - file skipped');
              {$IFDEF _DEBUG_}
                writeln(' [DEBUG] Error reading ', FFrom, FileName, '[', ErrorString(fSuccess),']');
              {$ENDIF} 
              close(FOut);
              close(FIn); 
            end
           else
            begin
             assign(FOut, S2);
             rewrite(FOut, 1);
             fSuccess := IOResult;
             if fSuccess <> 0 then
              begin
                LogError('Unable to open ' + FFrom + FileName + ' for writing - file skipped');
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Error writing ', FFrom, FileName, '[', ErrorString(fSuccess),']');
                {$ENDIF}
                close(Fin);                
              end
             else
              begin 
                { Copy file }
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Coping File [', S1, '] to [',S2,']');
                {$ENDIF}  
                repeat
                  BlockRead(Fin, Buffer, Sizeof(Buffer), NumRead);
                  BlockWrite(Fout, Buffer, NumRead, NumWritten);
                {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Buffer Size [',Sizeof(Buffer),']');
                {$ENDIF}  
                until (NumRead = 0) or (NumWritten <> NumRead);
                LogError('Copied File [' + S1 + '] to [' + S2 + ']');
                inc(total);
                close(Fin);
                close(FOut);   
             end;   
           end;  
         {$I+}
         G2 := G2^.Next;  
       end;   
    end;
   GlobFree(G1);  
   GlobFree(G2);  
   Copy_File := Total;
end;
  *)
end.
