(* ........................................................................ *)
(*        								    *)
(* MODULE	:   ERRORLOG.PAS    			                    *)
(*									    *)
(* DESCRIPTION	:   WRITES ERRORS TO THE ERROR LOG FILE                     *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)               
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2000                                *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit ErrorLog;

Interface

Uses Dos, Dates, Linux, Data;

function ErrorString(ErrorNumber : Byte) : String;
procedure LogError(Buffer : String);
function Check_For_log : boolean;

Implementation
(*..........................................................................*)
function ErrorString(ErrorNumber : Byte) : String;
var
  Strgs : string;
begin
  Str(ErrorNumber, Strgs);
  Case ErrorNumber of
   $00 : ErrorString := 'OK';
   $02 : ErrorString := 'File not found';
   $03 : ErrorString := 'Path not found';
   $04 : ErrorString := 'To many open Files';
   $05 : ErrorString := 'Access denied';
   $06 : ErrorString := 'Invalid file handle';
   $07 : ErrorString := 'Memory blocks invalid';
   $08 : ErrorString := 'Not enough memory';
   $09 : ErrorString := 'Memory blocks invalid';
   $0A : ErrorString := 'Invalid environment';
   $0B : ErrorString := 'Invalid format';
   $0C : ErrorString := 'Invalid file Access code';
   $0F : ErrorString := 'Invalid drive number';
   $10 : ErrorString := 'Cannot remove current directory';
   $11 : ErrorString := 'Cannot rename across drives';
   $12 : ErrorString := 'No more files';
   $13 : ErrorString := 'Disk write protected';
   $15 : ErrorString := 'Drive not ready';
   $16 : ErrorString := 'Bad command';
   $17 : ErrorString := 'Data error on disk';
   $19 : ErrorString := 'Seek error';
   $1A : ErrorString := 'Bad media';
   $1B : ErrorString := 'Sector not found';
   $1D : ErrorString := 'Unable to write to disk';
   $1E : ErrorString := 'Unable to read from disk';
   $20 : ErrorString := 'File sharing error';
   $21 : ErrorString := 'File locking error';
   $23 : ErrorString := 'No free FCBs';
   $24 : ErrorString := 'File sharing buffer full';
   $35 : ErrorString := 'Bad network patch';
   $36 : ErrorString := 'Network busy';
   $37 : ErrorString := 'Device does not exist';
   $39 : ErrorString := 'Hardware error';
   $64 : ErrorString := 'Disk read error';
   $65 : ErrorString := 'Disk write error';
   $66 : ErrorString := 'File not assigned';
   $67 : ErrorString := 'File not open';
   $68 : ErrorString := 'File not open for input';
   $69 : ErrorString := 'File not open for output';
  Else
    ErrorString := ' ('+ Strgs + ')unKown Error';
  end; { Case End }
end;
(*..........................................................................*)
procedure LogError(Buffer : String);
Var
  Log      : Text;
  Log_File : string;
begin
  { Check for directory separator at end of file path }
  Log_File := Config.log_file_location;
  if Log_File[Length(Log_File)] <> '/' then 
   begin
     Log_File := Log_File + '/' + Config.log_file_name;
   end 
  else
   begin
     Log_File := Log_File + Config.log_file_name;
   end;  
  Assign(Log, Log_File);
  {$I-} 
  append(Log);
  fSuccess := IOResult;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Opening log file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
  {$ENDIF}  
  Writeln(log,Today, ' ', Buffer);
  Close(Log);
  {$I+}
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Writing to log file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
  {$ENDIF}   
end;
(*..........................................................................*)
function Check_For_Log : boolean;
Var
  Log : Text;
  Log_File : String;
begin
  Check_For_Log := TRUE;
  if Output_Verbose then writeln('> Checking for log file.. ');
  { Check for directory separator at end of file path }
  Log_File := Config.log_file_location;
  if Log_File[Length(Log_File)] <> '/' then 
   begin
     Log_File := Log_File + '/' + Config.log_file_name;
   end  
  else
   begin
     Log_File := Log_File + Config.log_file_name;
   end;  
  Assign(Log, Log_File);
  {$I-} append(Log); {$I+}
  fSuccess := IOResult;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
  {$ENDIF}  
  if fSuccess <> 0 then
   begin
     if Output_Verbose then writeln('> Log file not found, Creating.. (', Log_File,')');
     {$I-} rewrite(log); {$I+}
     fSuccess := IOResult;
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
     {$ENDIF}  
      if fSuccess <> 0  then
       begin
         if fSuccess <> 6 then
          begin
            {$IFDEF _DEBUG_}
              writeln(' [DEBUG] Whilst creating log file : fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
            {$ENDIF}    
            Writeln('>> Ending Program..');
            Writeln;
            Close(log);
            Halt(1);
         end;  
      end;
     Check_For_Log := FALSE; 
   end;
  Close(Log);
end;

end.
