{ $Id: data.pas,v 1.2 2008-03-15 10:01:28 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   DATA.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   Data Unit For SADDUSER.PAS                              *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 2.2.0                                 *)
(*									    *)
(* COPYRIGHT	:   SIMON C HORTON  1999 - 2008                             *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* changelog.txt                                                            *)
(*..........................................................................*)
Unit Data;

Interface

uses  BaseUnix;

type
  param = record
    nolog,
    verbose : boolean;
    inifile : string[30];
end;

type
 System_Config = record
   sql_server,
   sql_db,
   sql_user,
   sql_pw               : pchar;
   bbs_files,
   new_user_files,
   log_file_location,
   log_file_name,
   message_location,
   admin_email	        : string;
   use_log_file,
   mail_user,
   mail_admin		: boolean;
   mail_user_subject    : string[60];
   mail_template_location : string;
   mail_admin_subject    : string[60];
   mail_admin_address    : string[60];
   mail_admin_message    : string;
end;

{ User Information  USERDAT.DAT}
type
  User = record
    Full_Name,
    User_Name,
    User_Pass,
    User_Address1,
    User_Address2,
    User_Address3,
    User_Address4,
    User_Telephone,
    User_Email     : string[30];
end;

(*
{ User database - userinfo.dat }
type
  UserAccDB = Record
    UserUID    : integer;       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserTime   : time_t;       { Date user account Created }
    UserTimestamp : time_t;    { epochtime of user login, used to reset daily call/time allowance }
    UserLogon  : time_t;       { epoch time of users last logon }
    UserReg    : boolean;      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;
*)

{ User database - userinfo.dat }
type
  UserAccDB = Record
    UserUID    : String[6];       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : String[1];          { Ansi or Avatar }
    UserColour : String[1];        { Colour ON or OFF }
    Userlevel  : String[1];
    UserTime   : String[14];    { Date user account Created }
    UserTimestamp : String[14];    { epochtime of user login, used to reset daily call/time allowance }
    UserLogon  : String[14];       { epoch time of users last logon }
    UserReg    : String[1];      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : String[1];      { Screen clear code to be sent }
    UserLines  : String[3];        { Lines of user terminal }
    Bulletin   : String[6];      { Current Bulletin Number Read }
    MailCount  : String[1];      { User Mail }
    LastMsgNum : String[1];
    Calls      : String[1];      { Calls to system }
    CallsToday : String[1];      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : string[6];
    TimeOnLine : String[14];
    FileArea   : String[14];      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : String[14];      { Number of downloads }
    Uploads    : String[14];      { Number of uploads }
    BytesDL    : String[14];      { Bytes downloaded }
    BytesUL    : String[14];      { Bytes uploaded }
    RemoteHost : String[255];
    SignUpTime : String[14];
end;


{ Data structure require for external procedure calls }
type
  UserPasswd = record
    pw_name,
    pw_passwd : pchar;
    pw_uid,
    pw_gid    : word;
    pw_gecos,
    pw_dir,
    pw_shell  : pchar;
end;
TUserPasswd = ^UserPasswd;

{ SQL SID store }
type
  SignUpSID = record
    sid : string[6];
end;

const

 Version	= '0.4.0.2-SQL';
 {$IFDEF _DEBUG_}
 	Title	= 'Sauron Adduser (DEBUG ENABLED)';
 {$ELSE}
 	Title	= 'Sauron Adduser';
 {$ENDIF}
 Copyright	= '(C)opyright Simon C Horton 1999 - 2008';
 License	= 'This Software is released Under GPL, See COPYING.DOC For More Details';
 WebSite	= 'For the lastest version and the source visit: http://www.sauron.org.uk';
 BBS		= 'or Sauron Linux BBS telnet://sbbs.ath.cx';

 Adduserdb	= 'adduser.dat';
 NewUserDB      = 'userinfo.data';

var

 fSuccess,
 Success,
 Loop,
 UIDCount   	: integer;
 Output_Verbose,
 Display_Users,
 NoShadowFile	: boolean;

 Config		 : System_Config;

 ShadowToken,
 PasswdFile,
 ShadowFile,
 DefaultShell,
 HomeDir,
 SkelDir,
 MailDir       : string;
 HomedirPerms,
 UserGrp,
 UserNo       : longint;
 UserLevel,
 MailGrp,
 UseSkel      : integer;

 User_Data     : UserAccDB;
 Userdb	       : file of UserAccDB;

 { User DB - userinfo.dat }
 NewUser_Data : UserAccDB;
 NewUser_DB   : file of UserAccDB;

 { SID pointer of upto 500 new users }
 NewUser  : array[0..500] of SignUpSID;

 UserID   : longint;
 TUserID  : TUserPasswd;

 S1,
 S2,
 Command  : string;

 Data_String : String;

Implementation

end.
