(* ........................................................................ *)
(*        								    *)
(* MODULE	:  CREATION.PP      			                    *)
(*									    *)
(* DESCRIPTION	:  Creates all new users stored in the adduser.dat database *)
(*									    *)
(* ENVIRONMENT  :  PPC386 PASCAL Ver 2.2.0                                  *)
(*									    *)
(* COPYRIGHT	:  SIMON C HORTON  1999 - 2008                              *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* changelog.txt                                                            *)
(*..........................................................................*)
Unit Creation;

interface

{$Linklib c}
{$Linklib crypt}

uses Dos, Crt, Linux, Errorlog, Data, FileCopy, Strings,BaseUnix, SQLDB, Mail;

function Get_User_Size : integer;
function Check_For_Existing_User(AUname : pchar) : Boolean;
function Get_User_Info(RecNo : integer) : boolean;
function Create_User : Boolean;

implementation

{var}
  { Get functions from external library }
  function getpwnam(UName : PChar) : TUserPasswd ; cdecl; external;
  function getpwuid(ID : integer) : TUserPasswd ; cdecl; external;
  function crypt(Pass : PChar; Salt : PChar) : PChar ; cdecl;  external;
  {unction putpwent(Pass : PChar; Salt : PChar) : PChar ; cdecl;  external;}

(*..........................................................................*)
{ Removes the created user from SQL table user_signup }
function Remove_User_SQL(UserName : string) : boolean;
begin
  { Setup Query }
  querystr := 'delete from user_signup where name=''' + UserName +'''';
  query := pchar(querystr);
  { delete guest users from database }
  if sql_query(query) then
    begin
      if sql_affected_rows > 0 then
        begin
          LogError('Removed user from  user_signup table (' + UserName +') - ' + sqlerror );
          {$IFDEF _DEBUG_}
             writeln(' [DEBUG] Removed user from  user_signup table (' + UserName +') - ' + sqlerror );
          {$ENDIF}
          Remove_User_SQL := true;
        end
      else
        begin
          LogError('Unable to remove user from  user_signup table (' + UserName +') - ' + sqlerror );
          {$IFDEF _DEBUG_}
            writeln(' [DEBUG] Unable to remove user from  user_signup table (' + UserName +') - ' + sqlerror );
          {$ENDIF}
          Remove_User_SQL := False;
        end;
   end
  else
   begin
     { SQL Error }
     LogError('Unable to remove user from  user_signup table, username (' + UserName +') - ' + sqlerror );
     {$IFDEF _DEBUG_}
        writeln(' [DEBUG] Unable to remove user from  user_signup table, username (' + UserName +') - ' + sqlerror );
     {$ENDIF}
     Remove_User_SQL := False;
   end;
end;
(*..........................................................................*)
{ Create USER SQL Entry in table user }
function Create_User_DB(UID : integer) : boolean;
var
  q1, q2, q3,
  q4, q5, q6, q7 : ansistring;
begin
   { Setup New User Data }
   str(UID, NewUser_Data.UserUID);
   NewUser_Data.UserAcc    := '0';     { Account Number }
   NewUser_Data.UserAnsi   := User_Data.UserAnsi;     { Ansi or Avatar }
   NewUser_Data.UserColour := User_Data.UserColour;          { Colour ON or OFF }
   str(fptime, NewUser_Data.UserTime);
   str(fptime, NewUser_Data.UserTimeStamp);
   str(fptime, NewUser_Data.UserLogon);
   str(UserLevel, NewUser_Data.Userlevel);
   NewUser_Data.UserReg    := '1';
   NewUser_Data.UserName   := User_Data.UserName;
   NewUser_Data.UserNameFull := User_Data.UserNameFull;
   NewUser_Data.UserPass   := User_Data.UserPass;
   NewUser_Data.UserTown   := User_Data.UserTown;
   NewUser_Data.UserEmail  := User_Data.UserEmail; { Put domain into linux.ini }
   NewUser_Data.UserInfo1  := User_Data.UserInfo1;
   NewUser_Data.UserInfo2  := User_Data.UserInfo2;
   NewUser_Data.UserInfo3  := User_Data.UserInfo3;
   NewUser_Data.Userinfo4  := User_Data.UserInfo4;
   NewUser_Data.Userinfo5  := User_Data.UserInfo5;
   NewUser_Data.Userinfo6  := User_Data.UserInfo6;
   NewUser_Data.Userinfo7  := User_Data.UserInfo7;
   NewUser_Data.Userinfo8  := User_Data.UserInfo8;
   NewUser_Data.UserCls    := User_Data.UserCls;      { Screen clear code to be sent }
   NewUser_Data.UserLines  := User_Data.UserLines;         { Lines of user terminal }
   NewUser_Data.Bulletin   := '0';         { Current Bulletin Number Read }
   NewUser_Data.MailCount  := '0';      { User Mail }
   NewUser_Data.LastMsgNum := '0';
   NewUser_Data.Calls      := '0';      { Calls to system }
   NewUser_Data.CallsToday := '0';      { Calls today }
   NewUser_Data.LCallDate  := '00/00/0000';   { Last call date }
   NewUser_Data.LastCall   := '00/00/0000';
   NewUser_Data.CallNumber := '0';
   NewUser_Data.TimeOnLine := '0';
   NewUser_Data.FileArea   := '0';      { Last file area visited - Will return user to this file area on next logon }
   NewUser_Data.DownLoads  := '0';      { Number of downloads }
   NewUser_Data.Uploads    := '0';      { Number of uploads }
   NewUser_Data.BytesDL    := '0';      { Bytes downloaded }
   NewUser_Data.BytesUL    := '0';      { Bytes uploaded }
   NewUser_Data.RemoteHost :=  User_Data.RemoteHost;
   { Setup query }
   q1 := 'insert into user_data values('+NewUser_Data.useruid+','''+NewUser_Data.useracc+''','+NewUser_Data.useransi+','+NewUser_Data.usercolour+','+NewUser_Data.userlevel+','+NewUser_Data.usertime+','+NewUser_Data.usertimestamp;
   q2 := ','+NewUser_Data.userlogon+','+NewUser_Data.userreg+','''+NewUser_Data.username+''','''+NewUser_Data.usernamefull+''','''+NewUser_Data.userpass+''','''+NewUser_Data.usertown+''',';
   q3 := ''''+NewUser_Data.useremail+''','''+NewUser_Data.userinfo1+''','''+NewUser_Data.userinfo2+''','''+NewUser_Data.userinfo3+''',';
   q4 := ''''+NewUser_Data.userinfo4+''','''+NewUser_Data.userinfo5+''','''+NewUser_Data.userinfo6+''','''+NewUser_Data.userinfo7+''','''+NewUser_Data.userinfo8+''',';
   q5 := ''+NewUser_Data.usercls+','+NewUser_Data.userlines+','+NewUser_Data.bulletin+','+NewUser_Data.mailcount+','+NewUser_Data.lastmsgnum+','+NewUser_Data.calls+','+NewUser_Data.callstoday+','''+NewUser_Data.lcalldate+''',';
   q6 := ''''+NewUser_Data.lastcall+''','+NewUser_Data.callnumber+','+NewUser_Data.timeonline+','+NewUser_Data.downloads+','+NewUser_Data.uploads+','+NewUser_Data.bytesdl;
   q7 := ','+NewUser_Data.bytesul+',''no'','''+NewUser_Data.RemoteHost+''')';
   querystr := q1 + q2 + q3 + q4 + q5 + q6 + q7;
   {$IFDEF _DEBUG_}
      writeln(' [DEBUG] SQL - ' + querystr);
   {$ENDIF}
   query := pchar(querystr);
   if not sql_query(query) then
     begin
       { SQL ERROR }
       LogError('Unable to create entry in user_signup table, username(' + NewUser_Data.UserName +') - ' + sqlerror + ' - ' + querystr );
       {$IFDEF _DEBUG_}
          writeln('[DEBUG] Unable to create entry in user_signup table, username(' + NewUser_Data.UserName +') - ', sqlerror + ' - ' + querystr);
       {$ENDIF}
       Create_User_DB := False;
     end
   else
     begin
       Create_User_DB := True;
     end;
end;
(*..........................................................................*)
function Check_For_Existing_User(AUname : pchar) : Boolean;
var
  results : recbuf;
  rows    : rowbuf;
begin
  Check_For_Existing_User := TRUE;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Checking for any existing user called [', AUname,']');
  {$ENDIF}
  if getpwnam(AUname) <> NIL then
   begin
     if Output_Verbose then writeln('> User ',AUname,' Already Exists..');
     LogError('User ' + StrPas(AUname) + ' already exists..');
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] User [', AUname,'] already exists.. This should not happen');
     {$ENDIF}
     Check_For_Existing_User := FALSE;
   end
  else
   begin
     { Check SQL database of users }
     { Setup Query }
     querystr := 'select name from user_data where name=''' + strpas(AUName) + '''';
     query := pchar(querystr);
     if sql_query(query) then
      begin
        results := sql_store_results;
        if sql_affected_rows > 0 then
         begin
           LogError('User ' + strpas(AUName) + ' already exists in SQL user_data..');
           {$IFDEF _DEBUG_}
             writeln(' [DEBUG] User [', AUname,'] already exists in SQL user_data. This should not happen..!');
           {$ENDIF}
           Check_For_Existing_User := False;
         end;
        { clear memory }
        sql_free_results(results);
      end
     else
      begin
        { SQL Error }
        LogError('SQL Error checking user_data - ' + sqlerror + ' : ' + querystr);
      end;
   end;
end;
(*..........................................................................*)
function Get_User_Info(RecNo : integer) : boolean;
var
  results : recbuf;
  rows    : rowbuf;
  NewVal,
  ValCode : integer;
begin
  if Output_Verbose then writeln('> Reading user information from user creation database..');
  Get_User_Info := TRUE;
  { Setup SQL }
  querystr := 'select * from user_signup where sid=' + NewUser[RecNo].SID;
  query := pchar(querystr);
  if sql_query(query) then
   begin
     results := sql_store_results;
     if sql_affected_rows > 0 then
      begin
        rows := sql_fetch_row(results);
        while rows <> nil do
          begin
            //val(strpas(rows[1]), User_Data.UserAnsi, ValCode);
            User_Data.UserAnsi := strpas(rows[1]);
            //val(strpas(rows[2]), User_Data.UserColour, ValCode);
            User_Data.UserColour := strpas(rows[2]);
            User_Data.UserName := strpas(rows[3]);
            User_Data.UserNameFull := strpas(rows[4]);
            User_Data.UserPass := strpas(rows[5]);
            User_Data.UserTown := strpas(rows[6]);
            User_Data.UserEmail := strpas(rows[7]);
            User_Data.UserInfo1 := strpas(rows[8]);
            User_Data.UserInfo2 := strpas(rows[9]);
            User_Data.UserInfo3 := strpas(rows[10]);
            User_Data.UserInfo4 := strpas(rows[11]);
            User_Data.UserInfo5 := strpas(rows[12]);
            User_Data.UserInfo6 := strpas(rows[13]);
            User_Data.UserInfo7 := strpas(rows[14]);
            User_Data.UserInfo8 := strpas(rows[15]);
           (*
            val(strpas(rows[2]), NewVal, ValCode);
            if NewVal = 1 then User_Data.UserCls := true
             else User_Data.UserCls := false;
            val(strpas(rows[17]), User_Data.UserLines, ValCode);
            *)
            User_Data.UserCls := strpas(rows[16]);
            User_Data.UserLines := strpas(rows[17]);
            User_Data.RemoteHost := strpas(rows[18]);
            User_Data.SignUpTime := strpas(rows[19]);

            rows := sql_fetch_row(results);
         end;
         { clear memory }
         sql_free_results(results);;
        {$IFDEF _DEBUG_}
          writeln(' [DEBUG] UserName  : ', User_Data.UserName);
          writeln(' [DEBUG] UserPass  : ', User_Data.UserPass);
          writeln(' [DEBUG] UserFull  : ', User_Data.UserNameFull);
          writeln(' [DEBUG] UserTown  : ', User_Data.UserTown);
          writeln(' [DEBUG] UserLines : ', User_Data.UserLines);
        {$ENDIF}
      end
     else
      begin
        Get_User_Info := False;
      end;
   end
  else
   begin
     { SQL ERROR }
     LogError('Unable to read user_signup table, record No.(' + NewUser[RecNo].SID +') - ' + sqlerror );
     {$IFDEF _DEBUG_}
        writeln(' [DEBUG] Unable to read user_signup , record No.(', NewUser[RecNo].SID,') ' + sqlerror);
     {$ENDIF}
     Get_User_Info := False;
   end;
end;
(*..........................................................................*)
{ Get number of users to create, returns -1 if an error occurred }
function Get_User_Size : integer;
var
  results : recbuf;
  rows    : rowbuf;
  users   : integer;
begin
   users := 0;
   query := 'select sid from user_signup';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if sql_affected_rows > 0 then
        begin
          rows := sql_fetch_row(results);
          while rows <> nil do
            begin
              inc(users);
              NewUser[users].SID := strpas(rows[0]);
              rows := sql_fetch_row(results);
            end;
           { clear memory }
           sql_free_results(results);
           Get_User_Size := users;
	end
       else
        begin
          Get_User_Size := 0;
        end;
     end
   else
     begin
       Get_User_Size := -1;
     end;
end;
(*..........................................................................*)
function Create_User : Boolean;
var
  Uid,
  UUid,
  Gid        : integer;
  Crypt_Pass,
  Password,
  Sal        : pchar;
  St,
  Dir_Home,
  Db_Path,
  Mail_Dir,
  PCrypt     : string;
  t,
  Tt	     : longint;
  Salts	     : array[1..2] of string;
  Open_File  : text;
  TheDir : PDir;
  ADirent : PDirent;
  Entry : Longint;
begin
  if Output_Verbose then writeln('> Creating user..', User_Data.UserName);
  LogError('Creating user ' + User_Data.UserName);
  { Setup }
  if HomeDir[Length(HomeDir)] = '/' then Dir_Home := HomeDir + User_Data.UserName
   else Dir_Home := HomeDir + '/' + User_Data.UserName;
  { Set Group ID }
  Gid := UserGrp;
  { if creating more than one user, the linux system, does not update quickly enough }
  { for getpwuid to retrive the next UID number, so we store the last used number in UIDCount }
  if UIDCount = 0 then
   begin
     { Get UID squence: stored in sadduser.ini }
     Uid := UserNo;
     repeat
       inc(Uid);
     until getpwuid(Uid) = NIL;
     UUid := Uid;
     UIDCount := Uid;
   end
  else
   begin
     inc(UIDCount);
     UUid := UIDCount;
   end;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Next available UID = [', UUid,']');
  {$ENDIF}
  { Encrypt Password }
  t := fptime;
  tt := ( t and $0F );
  Str(tt, St);
  Salts[1] := St + 'A';
  tt := ( t and $F0 ) >> 4;
  Str(tt, St);
  Salts[2] := St + 'a';
  St := Salts[1] + Salts[2];
  Password := StrAlloc(Length(User_Data.UserPass) + 1);
  StrPCopy(Password, User_Data.UserPass);
  Sal := StrAlloc(Length(St) + 1);
  StrPCopy(Sal, St);
  Crypt_Pass := crypt(Password, Sal);
{  Crypt_Pass := crypt(Password, Password); }

  PCrypt := StrPas(Crypt_Pass);
  User_Data.UserPass := PCrypt;

  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Encrypted Password = [', PCrypt,']');
  {$ENDIF}

  { Create user in SQL before we do anything else.. }
  if Output_Verbose then writeln('> Creating user entry in SQL ' + NewUser_Data.UserName);	
  if not Create_User_DB(UUid) then
    begin
      { Lets exit as we have an SQL problem, we don't want to continue... }
      LogError('Unable to create user entry in SQL  [' + NewUser_Data.UserName + ']');
      Create_User := false;
      exit;
    end
  else
    begin
      LogError('Created user entry in SQL  [' + NewUser_Data.UserName + ']');
      {$IFDEF _DEBUG_}
        writeln('[DEBUG] Created user entry in SQL  [', NewUser_Data.UserName, ']');
      {$ENDIF}
    end;

  { Add user information to passwd file }
  {$I-}
   assign(Open_File, PasswdFile);
   append(Open_File);
  {$I+}
  fSuccess := IOResult;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Opening passwrd file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
  {$ENDIF}
  if fSuccess <> 0 then
   begin
     LogError('Unable to open passwd file : ' + ErrorString(DosError));
     Create_User := False;
   end
  else
   begin
     if not NoShadowFile then writeln(Open_File,User_Data.UserName,':',ShadowToken,':',UUid,':',Gid,':',User_Data.UserNameFull,':',Dir_Home,':', DefaultShell)
      else writeln(Open_File,User_Data.UserName,':', PCrypt,':',UUid,':',Gid,':',User_Data.UserNameFull,':',Dir_Home,':', DefaultShell);
     Close(Open_File);
    {$IFDEF _DEBUG_}
      if NoShadowFile then writeln(' [DEBUG] ',      User_Data.UserName,':',ShadowToken,':',UUid,':',Gid,':',User_Data.UserNameFull,':',Dir_Home,':',DefaultShell)
        else writeln(' [DEBUG] ',      User_Data.UserName,':', PCrypt,':',UUid,':',Gid,':',User_Data.UserNameFull,':',Dir_Home,':',DefaultShell);
    {$ENDIF}
    if not NoShadowFile then
     begin
      {$I-}
        assign(Open_File, ShadowFile);
        append(Open_File);
      {$I+}
        fSuccess := IOResult;
         {$IFDEF _DEBUG_}
           writeln(' [DEBUG] Opening shadow file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
         {$ENDIF}
      end
     else fSuccess := 0;
     if fSuccess <> 0 then
      begin
        LogError('Unable to open shadow file : ' + ErrorString(DosError));
        Create_User := False;
      end
     else
      begin
        if not NoShadowFile then
          begin
            writeln(Open_File, User_Data.UserName,':', PCrypt,':', t, ':0:9999:7:::');
            Close(Open_File);
          {$IFDEF _DEBUG_}
            writeln(' [DEBUG] ', User_Data.UserName,':', PCrypt, ':', t,':0:9999:7::::');
          {$ENDIF}
         end;
        { Create user mail file }
        if Output_Verbose then writeln('> Creating user mail file..');
        if MailDir[Length(MailDir)] = '/' then Mail_Dir := MailDir + User_Data.UserName
          else Mail_Dir := MailDir + '/' + User_Data.UserName;
      {$I-}
       assign(Open_File, Mail_Dir);
       rewrite(Open_File);
       {$I+}
       Success := IOResult;
       if Success <> 0 then LogError('Unable to create - ' + Mail_Dir + 'Error = ' + ErrorString(DosError))
        else
         begin
           Close(Open_File);
           LogError('Created user mail file - ' + Mail_Dir);
          { Make sure file permission and ownership are correct }
          if Output_Verbose then writeln('> Changing permissions on user mail file..');
          if  fpChmod(Mail_Dir, &0660) <> 0  then LogError('Unable to change permissions on - ' + Mail_Dir)
           else LogError('Changed permissions on - ' + Mail_Dir);
          if fpChown(Mail_Dir, UUid, MailGrp) <> 0 then LogError('Unable to change ownership on - ' + Dir_Home)
           else LogError('Changed ownership of mail directory - ' + Mail_Dir);
        end;
       { Create home directory }
       if Output_Verbose then writeln('> Creating user home directory - ' + Dir_Home);
       {$I+} MkDir(Dir_Home); {$I+}
       Success := IOResult;
       if Success <> 0 then LogError('Unable to create - ' + Dir_Home)
        else LogError('Created home directory - ' + Dir_Home);

       { Make sure file permission and ownership are correct }
       if Output_Verbose then writeln('> Changing permissions on user home directory..');
       if  fpChmod(Dir_Home, &0766) <> 0 then LogError('Unable to change permissions on - ' + Dir_Home)
        else LogError('Changed permissions on - ' + Dir_Home);
       if fpChown(Dir_HOME, UUid, Gid) <> 0 then LogError('Unable to change ownership on directory - ' + Dir_Home)
        else LogError('Changed ownership of home directory - ' + Dir_Home);

      (*
       { Create user database in home directory }
       if Output_Verbose then writeln('> Creating user database ' + NewUserDB + ' in ' + Dir_Home);	
       if not Create_User_DB(UUid) then LogError('Unable to create user database [' + NewUserDB + '] in ' + Dir_Home)
        else LogError('Created user database [' + NewUserDB + '] in ' + Dir_Home);
      *)

       (* !!!Not sure why this is commented out!!!!
        { Make sure file permission and ownership are correct }
       if Output_Verbose then writeln('> Changing permissions on user database ' + NewUserDB);
       if Home_Dir[Length(Home_Dir)] = '/' then Db_Path := Db_Path + NewUserDB
          else Db_Path := Db_Path + '/' + NewUserDB;
       if not Chmod(Dir_Home, octal(HomeDirPerms)) then LogError('Unable to change permissions on - ' + NewUserDB)
        else LogError('Changed permissions on - ' + Dir_Home);
       *)

       { Copy form skel directory }
       if UseSkel <> 1 then
        begin
          if Output_Verbose then writeln('> Copy from Skel Directory disabled..');
          LogError('Copy form ' + SkelDir + ' disabled');
        end
       else
        begin
          if Output_Verbose then writeln('> Copyng files from ', SkelDir,' to user home directory..');
          LogError('Copying files from ' + SkelDir);
          Success := Copy_File(SkelDir, Dir_Home, './.', FALSE);
          {$IFDEF _DEBUG_}
            writeln(' [DEBUG] No of files copied [', Success,']');
          {$ENDIF}
       end;
       { Changing file permissions on files in user home directory }
       if Output_Verbose then writeln('> Changing file permmisions on files in user home directory..');
       LogError('Changing ownership permissions on user files in home directory..');
       TheDir:=fpOpenDir(Dir_Home + '/./.');
       // S2 := Dir_Home + '/*??.';
       Repeat
         ADirent:=fpReadDir (TheDir^);
         If ADirent<>Nil then
          With ADirent^ do
            begin
             S1 := StrPas(pchar(@d_name[0]));
             if (S1 = '.') or (S1 = '..') then
              begin
	        {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Skipping permissions on [', Dir_Home,'/',S1,']');
                {$ENDIF}
                LogError('Skipping permissions on [' + Dir_Home + '/' + S1 + ']');
              end
             else
              begin
	        fpChmod(Dir_Home + '/' +  S1, &0644);
                fpChown(Dir_Home + '/' +  S1, UUid, Gid);
	        {$IFDEF _DEBUG_}
                  writeln(' [DEBUG] Changed permissions on [', Dir_Home,'/',S1,']');
                {$ENDIF}
                LogError('Changed permissions on [' + Dir_Home + '/' + S1 + ']');
             end;
           end;
       Until ADirent=Nil;
      { Send User A Welcome email }
      if (length(User_Data.UserEmail) > 3) and (Config.mail_user) then
       begin
         if Output_Verbose then writeln('> Sending user welcome mail..', User_Data.UserEmail);
         Send_Mail(User_Data.username, user_data.userNamefull, user_data.UserEmail, user_data.usertown, user_data.remotehost);
       end;
      { Send Admin a user creation email  }
      if (length(Config.mail_admin_address) > 3) and (Config.mail_admin) then
       begin
         if Output_Verbose then writeln('> Sending Admin creation mail..', User_Data.UserEmail);
         Send_Admin_Mail(User_Data.username, user_data.userNamefull, user_data.UserEmail, user_data.usertown, user_data.remotehost);
       end;
       Create_User := True;
       { Remove the created user from the SQL table user_signup }
       if Output_Verbose then writeln('> Removing user entry in SQL user_signup ' + NewUser_Data.UserName);
       if not Remove_User_SQL(NewUser_Data.UserName) then
         begin
           LogError('Unable to remove user entry in SQL user_signup [' + NewUser_Data.UserName + ']');
         end
      else
         begin
           LogError('Removed user entry in SQL user_signup [' + NewUser_Data.UserName + ']');
         end;
   end;
 end;
end;

end.
