(* $Id: msgs.pp,v 1.6 2008-02-25 23:13:18 simon Exp $                       *)
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   MSGS.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   MESSAGE UNIT                                            *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2008                                *)
(*									    *)
(*..........................................................................*)

Unit Msgs;

Interface

{$IFDEF _LINUX_}
  Uses Dos, Crt, Lib, Data, Dates,Colours, ErrorLog,FullEditor,baseunix;
{$ELSE}
  Uses Dos, Crt, Lib, Data, Colours, ErrorLog, WaitTix;
{$ENDIF}

function UserReadFlag(MSGID : integer) : boolean;
procedure UserMsgRead(MSGID : integer);
function OpenUserReadMsgDB : boolean;
procedure PostToForum(PostSubject, PostFileName : string);
procedure ListMessageAreas;
function MessageCount : integer;
procedure ListMessages;
procedure AddMessageArea;
procedure DeleteMessageArea;
procedure ExpireOldMessages(NumberOfMessages : integer; MessageArea : string);

Implementation

var
  MsgData : lineptr;

(*..........................................................................*)
{ Checks that whether the msg has already been read by the user }
function UserReadFlag(MSGID : integer) : boolean;
begin
  UserReadFlag := false;
  for Loop := 0 to 2048 do
   begin
     if ReadMsgs[Loop] = MSGID then UserReadFlag := true;
   end;
end;
(*..........................................................................*)
{ Writes MSG ID to user readmsg.dat database }
{ Need to purge old message numbers }
procedure UserMsgRead(MSGID : integer);
var
  Loop     : integer;
  MsgFound : boolean; { Has the MSG ID already been stored }
  MsgDB    : string;
begin
  { if user is a guest, then lock on the remote host }
  if UserInfo.UserName = 'guest' then
    begin
      MsgDB := Home_Directory + '/readmsg.dat.' + remotehost;
    end
   else
    begin
      MsgDB := Home_Directory + '/readmsg.dat';
    end;
  MsgFound := false;
  { Scan Read Msg array to see if we already have the number stored }
  for Loop := 0 to 2048 do
   begin
     if ReadMsgs[Loop] = MSGID then MsgFound := true;
   end;
   { If MSG is not ready stored, then store MSG ID }
   if not MsgFound then
    begin
      {delay(2000);}
      Assign(UReadMsg, MsgDB);
      Print(UserInfo.UserName);
      {$I+}
        Reset(UReadMsg);
      {$I-}
      if IOResult <> 0 then
       begin
         LogError('Unable to open USER readmsg.dat for writing in [ ' + MsgDB + ' ]');
       end
      else
       begin
         UserReadMsg.ReadMsgNo := MSGID;
         if filesize(UReadMsg) <> 0 then
	  begin
	    {$I+}
	      Seek(UReadMsg, FileSize(UReadMsg));
	      Write(UReadMsg, UserReadMsg);
	    {$I-}
	    if IOResult <> 0 then  LogError('Unable to write to USER readmsg.dat for writing in [ ' + MsgDB + ' ]');
	  end
	 else
	  begin
	    {$I+}
	      Write(UReadMsg, UserReadMsg);
            {$I-}
	    if IOResult <> 0 then  LogError('Unable to write to USER readmsg.dat for writing in [ ' + MsgDB + ' ]');
	  end;
       end;
     Close(UReadMsg);
    end;
end;
(*..........................................................................*)
{ Reads User Read Message Database and stores into ReadMsgs Array }
function OpenUserReadMsgDB : boolean;
var
  Loop    : integer;
  MsgDB   : string;
begin
  { Open User Read Msg Database }
  { if user is a guest, then lock on the remote host }
  if UserInfo.UserName = 'guest' then
    begin
      MsgDB := Home_Directory + '/readmsg.dat.' + remotehost;
    end
   else
    begin
      MsgDB := Home_Directory + '/readmsg.dat';
    end;
  {$I-}
  Assign(UReadMsg, MsgDB);
  reset(UReadMsg);
  {$I+}
  if IOResult <> 0 then
   begin
     {$I-}
       Rewrite(UReadMsg);
     {$I+}
     if IOResult <> 0 then
      begin
        LogError('Unable to created USER readmsg.dat in [ ' + Home_Directory + ' ]');
	LineFeed;
	Print('There was an error reading a message database - The fault has been logged with the sysop');
	delay(2000);
	OpenUserReadMsgDB := false
      end
     else
      begin
        LogError('Created USER readmsg.dat in [ ' + MsgDB + ' ]');
	OpenUserReadMsgDB := true;
      end;
   end
  else
   begin
     if IOResult <> 0 then
      begin
        LogError('Unable to read USER readmsg.dat in [ ' + Home_Directory + ' ]');
        OpenUserReadMsgDB := false;
	Print('There was an error reading a message database - The fault has been logged with the sysop');
	delay(2000);
      end
     else
      begin
        for Loop :=0 to FileSize(UReadMsg) - 1 do
	 begin
	   {$I+}
             Seek(UReadMsg, Loop);
	     Read(UReadMsg, UserReadMsg);
           {$I-}
	     ReadMsgs[Loop] := UserReadMsg.ReadMsgNo;
	 end;
	 OpenUserReadMsgDB := true;
      end;
   end;
   Close(UReadMsg);
end;
(*..........................................................................*)
function MessageCount : integer;
var
  IndexPath,
  DirSeperator : string;
begin
  {$IFDEF _LINUX_}
    DirSeperator := '/';
  {$ELSE}
    DirSeperator := '\';
  {$ENDIF}
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = DirSeperator then
    begin
      IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + DirSeperator;
    end
   Else
    begin
      IndexPath := BBSCfg.MsgDir + DirSeperator + Msg.MsgNumber + DirSeperator;
    end;
  Assign(IdxFile, IndexPath + 'message.idx');
  {$I-} Reset(IdxFile); {$I+}
  If IOResult <> 0 then
    begin
      MessageCount := 0;
    end
  Else
    begin
      MessageCount := FileSize(IdxFile);
      Close(IdxFile);
    end;
end;
(*..........................................................................*)
procedure PostToForum(PostSubject, PostFileName : string);
var
  ForumArea,
  CurrentArea,
  IndexPath,
  Directory,
  MsgFileName,
  Strgs         : String;
  MessageNumber,
  Step,
  Max,
  PostFileError : Integer;
  MsgTFile      : Text;
begin
  Print(' Area        : ');
  Colour(FCyan);
  ForumArea := Msg.AreaName;
  Print(ForumArea);
  Colour(FGreen);
  LineFeed;
  if length(PostSubject) = 0 then
   begin
     Print(' Subject     : ');
     NoUpper := True;
     Promptquote := true;
     Colour(BBLue);
     Colour(FWhite);
     Response := ReadKB(30);
     NoUpper := False;
     Promptquote := False;
     Colour(BBlack);
     PostSubject := 'Post Subject:  ' + Response;
   end
  else
   begin
     PostSubject := 'Post Subject:  RE:' + PostSubject;
   end;
  LineFeed;
  { Create new data pointer }
  new(MsgData);
  { Start Full Editor }
  MsgData := Fulledit(MsgData,'[1;32mFORUM : [33m' + ForumArea, PostFileName,1000);
  { Check to see if there is any data in the returned data pointer }
  if MsgData^.next <> nil then
   begin
     If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '/' then IndexPath := BBSCfg.MsgDir + Msg.MsgNumber
      else IndexPath := BBSCfg.MsgDir + '/' + Msg.MsgNumber;
     Assign(IdxFile, IndexPath + '/' + 'message.idx');
     {$I-}
     Reset(IdxFile);
     PostFileError := IOResult;
     if PostFileError <> 0 then
      begin
        { Error 2 means that the forum message directory does not exist }
        { so we shall create a new one - SMT should have created it OOPS}
        if PostFileError = 2 then
         begin
           LogError('Not Found - ' + BBSCfg.MsgDir + Msg.MsgNumber + ' Creating..');
           If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '/' then directory := BBSCfg.MsgDir + Msg.MsgNumber
            else directory := BBSCfg.MsgDir + '/' + Msg.MsgNumber;
           MkDir(Directory);
           FileError := IOResult;
           If FileError <> 0 then
            begin
              LogError('Unable To Create ' + Directory + ' - ' + ErrorString(FileError));
              Print('Sorry post cannot be saved, there was an error which has been logged.');
              delay(2000);
              dispose(MsgData);
              {$I+}
              exit;
            end
           else
            begin
              LogError('Created - ' + BBSCfg.MsgDir + Msg.MsgNumber);
              { Change file params to full access by everyone }
              if fpchmod(Directory, &0777) = 0 then LogError('Unable to change file params (777) on ' + Directory);
           end;
         end;
      end;
      { If we had to create a message directory we need to create a idx file also }
      { or this is the first post to the forum }
      if PostFileError = 2 then
       begin
         Rewrite(IdxFile);
         FileError := IOResult;
         If FileError <> 0 then
          begin
            LogError('Unable To Create MESSAGE.IDX In ' + Msg.AreaName + ErrorString(FileError));
            Print('Sorry post cannot be saved, there was an error which has been logged.');
            delay(2000);
            dispose(MsgData);
            {$I+}
            exit;
          end
        else
          begin
            { Change file params to full access by everyone }
            if fpchmod(IndexPath + 'message.idx', &0666) = 0 then LogError('Unable to change file params on ' + indexpath + 'message.idx');
            LogError('Created MESSAGE.IDX In ' + IndexPath);
          end;
      end;
      { OK, lets create post }
      CurrentArea := Msg.MsgNumber;   { Store Current Message Area }
      Inc(MsIndex.MsgNumber);
      MessageNumber := MsIndex.MsgNumber;
      Str(MessageNumber, Strgs);
      MsgFileName := IndexPath + '/' + Strgs + '.msg';
      Assign(MsgTFile, MsgFileName);
      Rewrite(MsgTFile);
      FileError := IOResult;
      If FileError <> 0 then
       begin
         LogError('Unable To Create forum message In ' + Msg.AreaName + ErrorString(FileError));
         Print('Sorry post cannot be saved, there was an error which has been logged.');
         delay(2000);
         dispose(MsgData);
         close(idxfile);
         {$I+}
         exit;
       end
      else
       begin
         { Write the header information }
         Writeln(MsgTFile, ' ');
         Writeln(MsgTFile, 'Host : ', RemoteHost,' (', RemoteIP,')');
         Writeln(MsgTFile, 'Full Name   : ', UserInfo.UserNameFull);
         Writeln(MsgTFile, 'Message No  : ', MessageNumber);
         Writeln(MsgTFile, 'Forum       : ', ForumArea);
         WriteLn(MsgTFile, 'Date        : ', CallDate);
         Writeln(MsgTFile, 'Posted By   : ', UserInfo.UserName);
         Writeln(MsgTFile, PostSubject);
         Writeln(MsgTFile, ' ');
         { Write the post data }
         while MsgData <> nil do
          begin
            writeln(MsgTFile, MsgData^.data );
            MsgData := MsgData^.next ;
          end; { end while }
        close(MsgTfile);
        dispose(MsgData);
        { Change file params to full access by everyone }
        if  fpchmod(MsgFileName, &666) = 0 then LogError('Unable to change file params 0666 on ' + MsgFileName);
        Idx.MsgNumber := MessageNumber;
        If FileSize(IdxFile) <> 0 then
          begin
            Seek(IdxFile, FileSize(IdxFile));
            Write(IdxFile, Idx);
          end
        else
          begin
            Write(IdxFile, Idx);
          end;
        { write the new post data to the forum message database }
        Val(CurrentArea, Step, Max);
        Seek(MsgFile, 0);
        Read(MsgFile, Msg);
        Seek(MsgFile, 0);
        MsIndex.MsgNumber := MessageNumber;
        Write(MsgFile, Msg);
        Seek(MsgFile, Step - 1);
        Read(MsgFile, Msg);
        Seek(MsgNum, 0);
        Write(MsgNum, MsIndex);
        AreaSize := FileSize(IdxFile);
        {$I+}
       end;
   end;
end;
(*..........................................................................*)
procedure ViewPost(MSGPath : string);
Label ViewMsg;
var
  PostFileName,
  PostSubject,
  Line,
  strgs : string;
  MFile : text;
  Num,
  Code,
  Loop,
  Postid,
  MsgSize  : integer;
begin
  MsgSize := FileSize(IdxFile);
  LineFeed;
  Print(MsgViewPost);
  Response := ReadKB(3);
  LineFeed;
  Val(Response, Num, Code);
  Postid := Num;
  dec(Num);
  ViewMsg:
  If (Num < 0) or (Num > (MsgSize - 1)) then
    begin
      LineFeed;
      Print('Not Found..');
      LineFeed;
    end
  else
    begin
      {$I-}
       Seek(IdxFile, Num);
       Read(IdxFile, Idx);
       FileError := IOResult;
       If FileError <> 0 then
        begin
	  LogError('Error Reading : ' + MSGPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
          LineFeed;
          Print('Sorry, there was an error which has been logged..');
          delay(1500);
	  //Close(IdxFile);
          Exit;
        end;
       //Close(IdxFile);
      Str(Idx.MsgNumber, Strgs);
      PostFileName := MSGPath + Strgs + '.msg';
      {$I+}
      Assign(MFile, PostFileName);
      {$I-}
         Reset(MFile);
      {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
         { Error Message }
         LogError('Unable To Access ' + MsgPath + ' - ' + ErrorString(FileError));
         Print('An error has occured which has been logged...');
         delay(3000);
         exit;
        end;
        Loop := 1;
	Code := 1;
        Colour(FCyan);
        While not Eof(MFile) do
         begin
	 inc(Code);
          if Loop = 10 then colour(fwhite);
          Readln(MFile, Line);
          if Loop = 8 then PostSubject := Copy(Line, 15, 30);
          if Loop > 3 then
           begin
             Print(Line);
	     LineFeed;
           end
          else
           begin
             if Loop = 2 then Linefeed;
             if userinfo.userlevel = 9 then
              begin
                Print(Line);
                Linefeed;
              end;
           end;
	  if Code = UserInfo.UserLines then
             begin
               Code := 1;
               HoldPage;
             end;
          inc(loop);
         end; { While end }
   end;
   UserMsgRead(Idx.MsgNumber);
   Linefeed;
   str(Postid,strgs);
   Print(MsgRMsg1 + ' ');
   Print(Strgs);
   Print(MsgRMsg2);
   str(MsgSize,strgs);
   Print(Strgs);
   Repeat
   Linefeed;
   print(MsgRPrompt1);
   if UserInfo.Userlevel = 9 then
    begin
      Colour(Fred);
      Print(' [D]elete');
    end;
    Response := ReadKB(1);
    print(chr(08));
    { Reply to post }
    (*
    if Response = 'R' then
     begin
       PostToForum(PostSubject, PostFileName);
       goto viewmsg;
     end;
     *)
    if (Response = 'D') and (UserInfo.UserLevel = 9) and (Idx.MsgNumber <> 0) then
     begin
       {$I-}
        str(num,strgs);
        Idx.MsgNumber := 0;
        Seek(IdxFile, Num);
        write(IdxFile, Idx);
        FileError := IOResult;
        If FileError <> 0 then
         begin
           LogError('Unable to tag msg for deletion '+  MSGPath + Strgs + '.msg - ' + ErrorString(FileError));
           Linefeed;
           Print('Sysop, unable to tag msg for deletion, see error.log for more info..');
           linefeed;
           delay(2000);
         end
        else
         begin
           LogError('Tagged Post for deletion ' + MSGPath + Strgs + '.msg');
           linefeed;
           Print('Post tagged for deletion..');
           linefeed;
           delay(1500);
         end;
        {$I+}
     end;
   if Response = MsgRNext then
     begin
       if Postid >= MsgSize then
        begin
	  LineFeed;
	  Print(MsgRNo);
	  //LineFeed;
	  //print(MsgRPrompt1);
        end
       else
        begin
	  Num := (Num + 1);
          inc(Postid);
	  LineFeed;
	  Linefeed;
	  goto ViewMsg;
	end;
     end
   else
      begin
        if Response = MsgRPrev then
         begin
	   if Postid <= 1 then
            begin
	     LineFeed;
	     Print(MsgRNo);;
	     //LineFeed;
	     //print(MsgRPrompt1);
           end
         else
           begin
	    Num := (Num - 1);
            dec(Postid);
	    LineFeed;
	    LineFeed;
	    goto ViewMsg;
	   end;
	 end;
      end;
   until Response = MsgRExit;
end;
(*..........................................................................*)
procedure MsgListHeader;
begin
  ClearDispLay(True);
  Print(MsgLHead1);
  LineFeed;
  Print(MsgLHead2);
  LineFeed;
  Print(MsgLHead3);
  LineFeed;
end;
(*..........................................................................*)
procedure ListMessages;
Label Relist, Stops;
Var
  Counter  : Integer;
  Counts   : String;
  FSize    : LongInt;
  Step,
  Loop     : Integer;
  Strgs,
  Line,
  MsgPath : String;
  MFile  : text;
begin
  OpenUserReadMsgDB;
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = Directory_Seperator then
    begin
      MsgPath := BBSCfg.MsgDir + Msg.MsgNumber + Directory_Seperator;
    end
   Else
    begin
      MsgPath := BBSCfg.MsgDir + Directory_Seperator + Msg.MsgNumber + Directory_Seperator;
    end;
  NoUpper := False;
  ReList:
  Assign(IdxFile, MSGPath + 'message.idx');
  {$I-} Reset(IdxFile); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Error Opening ' + MSGPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
      LineFeed;
      Print('Sorry, This Message Area Is Empty..');
      LineFeed;
      {$IFDEF _LINUX_}
	Delay(3000);
      {$ELSE}
	Wait(30);
      {$ENDIF}
    //  Close(Files);
      Exit;
   end
  Else
    begin
      FSize := FileSize(IdxFile);
      If UserInfo.UserAnsi = 1 then
        begin
          Counter := 2;
        end
      Else
        begin
          Counter := 0;
        end;
      if FSize - 1 <= 0 then Step := 1
       else Step := FSize;
      MsgListHeader;
      Repeat
           if Step <> 0 then Dec(Step);
          {$I-}
           Seek(IdxFile, Step);
           Read(IdxFile, Idx);
          {$I+}
          FileError := IOResult;
          If FileError <> 0 then
           begin
             Writeln('STEp ', step);
	     LogError('Error Reading : ' + MSGPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
             LineFeed;
             Print('Sorry, there was an error which has been logged..');
             LineFeed;
             delay(3000);
	     Close(IdxFile);
             Exit;
           end;
          if Idx.MsgNumber <> 0 then
           begin
          Str(Idx.MsgNumber, Strgs);
	  Assign(MFile, MSGPath + Strgs + '.msg');
      	  {$I-}
	    Reset(MFile);
          {$I+}
          If IOResult <> 0 then
            begin
             { Error Message }
              LogError('Unable To Access ' + MsgPath + strgs +'.msg  - ' + ErrorString(IOResult));
	      Close(IdxFile);
	      Print('An error has occured which has been logged...');
	      delay(3000);
	      exit;
            end;
	  Loop := 1;
	  inc(counter);
	  While not Eof(MFile) do
            begin
	      Str(Idx.MsgNumber, Strgs);
     	      Readln(MFile, Line);
	      Str((Step + 1), Strgs);
	      SetX('1');
	      Colour(FRED);
	      Print(Strgs);
	      case Loop of
		6: begin
		    SetX('47');
		    Colour(FGreen);
		    Print(Copy(Line, 15, 25));
		   end;
		7: begin
		    SetX('5');
		    Colour(FMagenta);
                    Print(Copy(Line, 15, 30));
		   end;
		8: begin
		     SetX('15');
		     Colour(FWhite);
                     Print(Copy(Line, 15, 30));
		     SetX('71');
	             if UserReadFlag(Idx.MsgNumber) then
		       begin
		         Colour(FWhite);
		         Print('READ')
		       end
	             else
		      begin
		        Colour(FRed);
			Print('UNREAD');
		     end;
	            end;
               end;
	        inc(loop);
              end; { While end }
	  LineFeed;

          end;
            If Counter = 17 then
              begin
                Repeat
                  //LineFeed;
                  //Print(MsgPrompt1);
                  LineFeed;
                  Print(MsgPrompt2);
                  NoUpper := False;
                  Response := ReadKB(1);
		  (*
                  If Response = TagFile then
                    begin
                      Tag(-1);
                    end;
		  *)
                  If Response = MsgListStop then goto Stops;
		  If Response = MsgRelist then
      		    begin
                      Close(IdxFile);
                      Goto Relist;
                    end;
                  If Response = MsgView then
                    begin
                      ViewPost(MSGPath);
		      Response := '';
                      Step := Step + 15;
                    end;
                Until Response = '';
                MsgListHeader;
                Counter := 2;
              end;
        Until Step = 0;
	Close(Mfile);
      end;
  //Repeat
    //LineFeed;
    //Print(MsgPrompt1);
    LineFeed;
    Print(MsgPrompt2);
    NoUpper := False;
  Repeat
    echo := false;
    Response := ReadKB(1);
    echo := true;
    (*
    If Response = TagFile then
     begin
       Tag(-1);
     end;
     *)
    If Response = MsgView then
      begin
        ViewPost(MSGPath);
        goto relist;
      end;
    If Response = MsgRelist then
      begin
        Close(IdxFile);
        Goto Relist;
     end;
  //goto relist;
  Until Response = '';
  Stops:
  Close(IdxFile);
end;
(*..........................................................................*)
procedure ListMessageAreas;
var
  Step        : Integer;
  Strgs       : string;
begin
  ClearDisplay(True);
  Colour(FYellow);
  Print('  Message Areas Available                    No. Of Messages ');
  LineFeed;
  LineFeed;
  for Step := 0 to FileSize(MsgFile) - 1 do
    begin
      Strgs := '';
      {$I+}
        Seek(MsgFile, Step);
	Read(MsgFile, Msg);
      {$I-}
      If Step < 9 then
      SetX('4')
      Else SetX('3');
      Colour(FGreen);
      Print(Msg.MsgNumber);
      Colour(FWhite);
      Print('. ');
      Colour(FMagenta);
      Print(Msg.AreaName);
      SetX('52');
      Colour(FWhite);
      Str(MessageCount, Strgs);
      Print(Strgs);
      LineFeed;
      Colour(FWhite);
    end;
  LineFeed;
end;
(*..........................................................................*)
procedure DisplayMessageAreas;
begin
  AreaSize := Filesize(MsgFile);
  ClearDisplay(True);
  ListMessageAreas;
end;
(*..........................................................................*)
procedure AddMessageArea;
var
  NewMsgArea : string[30];
begin
  AreaSize := Filesize(MsgFile);
  DisplayMessageAreas;
  Print(' [A] Add Message Area / [Enter] Continue ');
  Response := ReadKB(2);
  if (Response = 'a') or (Response = 'A') then
   begin
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Enter New Message Area Name [Max 30 Chars] : ');
     Colour(FWhite);
     Response := ReadKB(31);
     NewMsgArea := Response;
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Create New Area ');
     Colour(FMagenta);
     Print(NewMsgArea);
     Colour(FYellow);
     Print(' Yes / No ');
     Colour(FWhite);
     Response := ReadKB(2);
     if (Response = 'y') or (Response = 'Y') then
      begin
        Str(AreaSize + 1, Msg.MsgNumber);
        Msg.AreaName := NewMsgArea;
        {$I-}
          Write(MsgFile, Msg);
        {$I+}
        FileError := IOResult;
        if FileError <> 0 then
         begin
           LineFeed;
           Colour(FRed);
           Print(' Unable To Create New File Area In MESSAGE.DAT');
	   Colour(FWhite);
	   {$IFDEF _LINUX_}
             Delay(4000);
           {$ELSE}
	     Wait(40);
           {$ENDIF}
          LogError('Unable To Write New Message Area To Message.dat ' + Msg.AreaName + ' - ' + ErrorString(FileError));
         end
        else
         begin
           LineFeed;
           LineFeed;
           Colour(FCyan);
           Print(' New File Area Created In MESSAGE.DAT');
           Colour(FWhite);
	   LogError('Created New Message Area In Message.dat ' + Msg.AreaName + ' - ' + ErrorString(FileError));
	   {$IFDEF _LINUX_}
             Delay(3000);
           {$ELSE}
	     Wait(30);
           {$ENDIF}
	 end;
      end;
   end;
end;
(*..........................................................................*)
procedure DeleteMessageArea;
var
   MsgAreaNumber : integer;
   CurrentArea   : string;
begin
  AreaSize := Filesize(MsgFile); { Message Area Size }
  CurrentArea := Msg.MsgNumber;  { Save Message Area }
  DisplayMessageAreas;
  Print(' [D] Delete Message Area / [Enter] Continue ');
  Response := ReadKB(2);
  if (Response = 'd') or (Response = 'D') then
   begin
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Enter Message Area To Be Removed ');
     Colour(FWhite);
     Response := ReadKB(5);
     Val(Response, MsgAreaNumber, Code);
     if MsgAreaNumber <= AreaSize then
      begin
        {$I-}
          Seek(MsgFile, MsgAreaNumber - 1);
          Read(MsgFile, Msg);
        {$I+}
        LineFeed;
        LineFeed;
        Colour(FYellow);
        Print(' Remove Message Area ');
        Colour(FMagenta);
        Print(Msg.AreaName);
        Colour(FYellow);
        Print(' Yes / No ');
        Colour(FWhite);
        Response := ReadKB(2);
        if (Response = 'y') or (Response = 'Y') then
         begin
         end;
         Val(CurrentArea, MsgAreaNumber, Code);
         {$I-}
           Seek(MsgFile, MsgAreaNumber - 1);
           Read(MsgFile, Msg);
         {$I+}
       end;
     end
  else
     begin
       LineFeed;
       Colour(FRed);
       Print(' Invalid Message Area');
       Colour(FWhite);
       {$IFDEF _LINUX_}
	 Delay(4000);
       {$ELSE}
         Wait(40);
       {$ENDIF}
     end;
end;
(*..........................................................................*)
procedure DeleteMessage;
begin
end;
(*..........................................................................*)
{If Number of Messages Are More Than Max Messages, Then Remove the Eldest Message }
{Later Versions of Sauron, Messages Will Expire After XX Amount Of Time }
procedure ExpireOldMessages(NumberOfMessages : integer; MessageArea : string);
var
   TIdxFile        : file of Index;
   IndexPath,
   TempPath,
   DeleteFile,
   Strgs,
   DirSeperator    : string;
   DeleteMsgNumber : integer;
   DeleteMessage   : file;
begin
  {$IFDEF _LINUX_}
    DirSeperator := '/';
  {$ELSE}
    DirSeperator := '\';
  {$ENDIF}
  if NumberOfMessages > BBSCfg.MaxMsg then
   begin
     { Current Message Directory }
     If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = DirSeperator then
       begin
	 IndexPath := BBSCfg.MsgDir + MessageArea + DirSeperator;
       end
     Else
       begin
	 IndexPath := BBSCfg.MsgDir + DirSeperator + MessageArea + DirSeperator;
       end;
     { Get Sauron Temp Directory }
     If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = DirSeperator then
       begin
	 TempPath := BBSCfg.TempDir + 'idxtemp.tmp';
       end
     Else
       begin
	 TempPath := BBSCfg.TempDir + DirSeperator + 'idxdat.tmp';
       end;
    {$I-}
      Assign(IdxFile, IndexPath + 'message.idx');
      Reset(IdxFile);
    {$I+}
    FileError := IOResult;
    if FileError <> 0 then
      begin
        LogError('Unable To Read MESSAGE.IDX In ' + IndexPath + ' - ' + ErrorString(FileError));
      end
    else
      begin
        {$I-}
          Assign(TIdxFile, TempPath); { Create Temp File }
          Rewrite(TIdxFile);
        {$I+}
        FileError := IOResult;
        if FileError <> 0 then
          begin
            LogError('Unable To Create IDXDAT.TMP  - ' + ErrorString(FileError));
          end
        else
          begin
           {$I-}
             Seek(IdxFile, 0);    { Retrive First Message Number      }
             Read(IdxFile, Idx);  { This is the Message To Be Deleted }
            {$I+}
            DeleteMsgNumber := Idx.MsgNumber;
            { Retrive Current Message Numbers }
            { And Store In Temp File          }
            for Loop := 1 to (FileSize(IdxFile) - 1) do
              begin
                {$I-}
                  SeeK(IdxFile, Loop);
                  Read(IdxFile, Idx);
                  Write(TIdxFile, Idx);
                {$I+}
              end;
            Close(IdxFile);
            { Rewrite New Index File }
            {$I-}
              Assign(IdxFile, IndexPath + 'message.idx');
              Rewrite(IdxFile);
            {$I+}
            FileError := IOResult;
            if FileError <> 0 then
              begin
                 LogError('Unable To Create MESSAGE.IDX In ' + IndexPath + ' - ' + ErrorString(FileError));
              end
            else
              begin
                for Loop := 0 to (FileSize(TIdxFile) - 1) do
                  begin
                    {$I-}
                      SeeK(TIdxFile, Loop);
                      Read(TIdxFile, Idx);
                      Write(IdxFile, Idx);
                   {$I+}
                  end;
                Close(IdxFile);
               { Delete Old Message }
                Str(DeleteMsgNumber, Strgs);
                DeleteFile := IndexPath + Strgs + '.msg';
                {$I-}
                  Assign(DeleteMessage, DeleteFile);
                  Reset(DeleteMessage);
                  Close(DeleteMessage);
                  Erase(DeleteMessage);
                {$I+}
                FileError := IOResult;
                if FileError <> 0 then
                  begin
                    LogError('Unable To Delete Message  ' + DeleteFile + ' - ' + ErrorString(FileError));
                  end
                else
                  begin
                    LogError('Message ' + DeleteFile + ' Removed : Max Messages Reached');
                  end;
              end;
            { Erase TMP File }
            {$I-}
              Close(TIdxFile);
              Erase(TIdxFile);
            {$I+}
            FileError := IOResult;
            if FileError <> 0 then LogError('Unable To Delete ' + TempPath + ' - ' + ErrorString(FileError));
         end;
      end;
   end;
end;
end.
