(* ........................................................................ *)
(*        								    *)
(* MODULE	:   MAINFILE.PAS    			                    *)
(*									    *)
(* DESCRIPTION	:   FILE AREA DESCRIPTIONS, DATABASE                        *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit MainFile;

interface

{$IFDEF _LINUX_}
  Uses Crt, Data, Lib, Colours, ErrorLog;
{$ELSE}
  Uses Crt, Data, Lib, Colours, ErrorLog, WaitTix;
{$ENDIF}

procedure SysopOpenCloseMainAreas;
procedure SelectMainFileArea(Area : Word);

implementation
(*..........................................................................*)
procedure Header;
begin
   Print(MFileHead1);
   LineFeed;
   Print(MFileHead2);
   LineFeed;
   Print(MFileHead3);
end;
(*..........................................................................*)
procedure SysopOpenCloseMainAreas;
Var
  Step,
  Code    : word;
  AreaNum : longInt;
  Done    : Boolean;
begin
  Done := False;
  Val(SAreas.AreaNumber, AreaNum, Code);
  Repeat
    ClearDisplay(True);
    Colour(FCyan);
    LineFeed;
    Header;
    LineFeed;
    LineFeed;
    for step := 0 to FileSize(CatArea) - 1 do
      begin
        {$I-} Seek(CatArea, Step);
              Read(CatArea, SAreas); {$I+}
        FileError := IOResult;
        If FileError <> 0 then
          begin
            LogError('Unable To read Area File - ' + ErrorString(FileError));
          end;
        Colour(FYellow);
        Print('  ' + SAreas.AreaNumber + '. ');
        Colour(FWhite);
        Print(SAreas.Description);
        SetX('48');
        If SAreas.OpenClosed then
          begin
            Colour(FGreen);
            Print('OPEN');
          end
        Else
          begin
            BlinkOn;
            Colour(FGreen);
            Print('CLOSED');
            BlinkOff;
          end;
        LineFeed;
      end;
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print('Sysop Press File Number To Toggle Open/Closed - Blank To Exit ');
     Response := ReadKB(5);
     Val(Response, Step, Code);
     if (Step <= 0) or (Step > FileSize(CatArea)) then
       begin
         {$I-} Seek(CatArea, AreaNum - 1);
               Read(CatArea, SAreas); {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File Category Area File - ' + ErrorString(FileError));
         Done := True;
      end
    Else
      begin
        {$I-} Seek(CatArea, Step - 1);
              Read(CatArea, SAreas); {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File Category Area File - ' + ErrorString(FileError));
         If SAreas.OpenClosed then
           begin
            SAreas.OpenClosed := False;
            Seek(CatArea, Step - 1);
            Write(CatArea, SAreas);
          end
       Else
         begin
            SAreas.OpenClosed := True;
            {$I-} Seek(CatArea, Step - 1);
                 Write(CatArea, SAreas); {$I+}
            FileError := IOResult;
         If FileError <> 0 then LogError('Error Writing To File Category Area File - ' + ErrorString(FileError));
         end;
       Seek(CatArea, AreaNum - 1);
       Read(CatArea, SAreas);
     end;
  Until Done;
  LineFeed;
  LineFeed;
end;

(*..........................................................................*)
function ListAreas: Integer;
Var
  PageInc       : Byte;
  Step,
  Code          : word;
  TFile,
  TSub,
  AreaNum       : longInt;
  Strgs,
  CurrentArea,
  Data_Area      : string;
begin
   If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_Area := BBSCfg.DataDir
   Else Data_Area := BBSCfg.DataDir + directory_Seperator;
  TSub  := 0;
  TFile := 0;
  CurrentArea := SAreas.Description;
  Val(SAreas.AreaNumber, AreaNum, Code);
  ClearDisplay(True);
  Colour(FCyan);
 // LineFeed;
  Header;
  LineFeed;
  LineFeed;
  PageInc := 0;
  for step := 0 to FileSize(CatArea) - 1 do
    begin
      {$I-} Seek(CatArea, Step);
            Read(CatArea, SAreas); {I+}
      FileError := IOResult;
      If FileError <> 0 then LogError('Error Reading File Categorys File - ' + ErrorString(FileError));
        Colour(FYellow);
        Print('  ' + SAreas.AreaNumber + '. ');
        Colour(FWhite);
        Print(SAreas.Description);
        Colour(FMagenta);
        SetX('42');
        Strgs := '';
        str(SAreas.CatNumber, strgs);
        Print(Strgs);
        TSub := TSub + SAreas.CatNumber;
        SetX('57');
        Strgs := '';
        Str(SAreas.FileNumber, Strgs);
        Print(Strgs);
        Tfile := TFile + SAreas.FileNumber;
        SetX('68');
        If SAreas.OpenClosed then
          begin
            Print(MOpen);
          end
        Else
          begin
            BlinkOn;
            Print(MClosed);
            BlinkOff;
          end;
        inc(PageInc);
        LineFeed;
        if (PageInc = (UserInfo.UserLines - 3)) then
          begin
            PageInc := 0;
            HoldPage;
          end;
    end; { for end }
   LineFeed;
   SetX('32');
   Write('Totals');
   SetX('42');
   Colour(FCyan);
   Str(TSub, Strgs);
   Print(Strgs);
   SetX('57');
   Strgs := '';
   Str(TFile,Strgs);
   Print(Strgs);
   LineFeed;
   LineFeed;
   Print(MCurrentArea);
   Colour(FCyan);
   Print(CurrentArea);
   LineFeed;
   LineFeed;
   Print(MFilePrompt);
   NoUpper  := False;
   Response := ReadKB(30);
   if Response <> MQuit then
    begin
      Val(Response, Step, Code);
      if (Step <= 0) or (Step > FileSize(CatArea)) then
        begin
          {$I-}
          Seek(CatArea, AreaNum - 1);
          Read(CatArea, SAreas);
          {$I+}
          FileError := IOResult;
          If FileError <> 0 then LogError('Error Reading File - ' + ErrorString(FileError));
       end
     Else
      begin
         {$I-} Seek(CatArea, Step - 1);
               Read(CatArea, SAreas);  {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError));

         If SAreas.OpenClosed then
           begin
             {$I-} Close(FileArea); {$I+}
             If IOResult <> 0 Then LogError('Unable To Close File Area - ' + ErrorString(IOResult));
             {$I-} Assign(FileArea, Data_Area + 'area.' + Response);
                   Reset(FileArea); {$I+}
             FileError := IOResult;
             If FileError <> 0 then
               begin
                 LogError('Error Opening : area.' + Response + ' - ' + ErrorString(FileError));
               end
             Else
               begin
                 {$I-} Seek(FileArea, 0);
                       Read(FileArea, Areas); {$I+}
                 FileError := IOResult;
                 If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError))
                  Else AreaSize := FileSize(FileArea);
              end;
          end
        Else
          begin
            LineFeed;
            LineFeed;
            Print('Sorry, File Area Closed');
            {$I-} Seek(CatArea, AreaNum - 1);
                  Read(CatArea, SAreas); {$I+}
            FileError := IOResult;
    	    If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError));
  	    {$IFDEF _LINUX_}
  	       Delay(3000);
    	    {$ELSE}
  	       Wait(30);
              {$ENDIF}
            end;
      end;
      ListAreas := 0;
    end
  Else
    begin
      ListAreas := 1;
      {$I-} Seek(CatArea, AreaNum - 1);
            Read(CatArea, SAreas); {$I+}
      FileError := IOResult;
      If FileError <> 0 then LogError('Error Reading File - ' + ErrorString(FileError));
    end;
end;

(*..........................................................................*)
procedure SelectMainFileArea(Area : Word);
Var
  AreaCat : String;
begin
  If Area <= 0 then
    begin
       while ListAreas <> 1 do
    end
  Else
    begin
      If Area <= FileSize(CatArea) then
        begin
          Str(Area, AreaCat);
{          OpenFileArea('Area.' + AreaCat); }
        end
      Else
        begin
          { Invalid Area }
        end;
    end;
end;

end.
