{ $Id: $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   MAIL.PP         			                    *)
(*									    *)
(* DESCRIPTION	:   MAIL UNIT                                               *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 2008                                       *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Mail;

interface

{$Linklib c}

Uses Crt,linux, Dos, Lib, Data, Dates, Msgs, ErrorLog, Colours, Unix,  BaseUnix, fulleditor, SQLDB;

//procedure EditMail;
procedure ListMail;
procedure ReadEmail(Eid : integer; Viewed, Replied : byte; MailFrom, MailSubject, MailDate : string);
function CountMail : byte;
function InternetMail : byte;
function MailCountTotal: integer;
function MailCountNew: integer;
procedure MailUser(User, Subject, MailFile : string);

implementation

function getpwuid(ID : integer) : TUserPasswd ; cdecl; external;

type
  MailRec = record
      FileName : string;
      FileTime : longint;
end;

type
  MailHeader = record
      Eid     : integer;
      From    : string[14];
      Subject,
      Date    : string[30];
      Viewed,
      Replied : byte;
end;

Var
   { Full Editor }
   MailData   : LinePtr;

   Line       : array [1..100] of string[80];
   Show,
   All,
   Exits,
   EndEditor,
   MailDeleteID,            { Mail Removed Flag }
   NewMail,                 { NewMail Flag }
   EMail      : Boolean;
   MailCount,
   Max,
   Hello,
   MailSize,                { Mail size in lines }
   MailNo,
   Num         : Integer;
   MailPath,
   MailTo,                  { Send Mail To   }
   MailFrom,                { Mail Sent From }
   CurrentUser,
   CurrentArea,
   DirSeperator,
   Wildcard,
   SUID        : String;
   DirInfo     : SearchRec;
   MailHdr  : array[1..500] of MailHeader;
   MailSort,
   tmp      : array[1..500] of MailRec;

(*..........................................................................*)
procedure EmailHeader;
begin
  ClearDisplay(True);
  Print('[0;25;37;40m[27C[33m[25C[0m [1;33mEnter Username or User ID [0m');
  LineFeed;
  Print('[36m___[1;37;46m Send Mail [0;36;40m__________________________________________________________________');
  LineFeed;
end;
(*..........................................................................*)
{ Set the mail as replied }
procedure MailMarkReply(MailID : integer);
var
  EID : string;
begin
  str(MailID, EID);
  querystr := 'update user_mail set replied=1 where eid=' + EID;
  query := pchar(querystr);
  { Update EID as read}
  if not sql_query(query) then
   begin
     LogSQLError('Unable to set EID[' + EID + '] as read - ' + sqlerror + ' - ' + querystr);
   end;
end;
(*..........................................................................*)
procedure MailUser(User, Subject, MailFile: string);
var
  Step,
  StartUID     : Integer;
  Found        : Boolean;
  MailPath,
  MailToName,
  MailSubject  : string[30];
  User_Data    : TUserPasswd;
  MailDataTemp : ansistring;
  Mail,
  MailNumber   : String;
  Mails        : Text;
begin
  error := 0;
  StartUID := BBSCfg.LinuxUID;
  str(UserInfo.UserUID, SUID);
  Case Length(SUID) of
     1 : MailFrom := '000' + SUID;
     2 : MailFrom := '00' + SUID;
     3 : MailFrom := '0' + SUID;
   Else
     MailFrom := SUID;
  end; { Case End }
  // CurrentUser := SUID;
  Found       := False;
  Exits       := False;
  MailCount   := 0;
  if length(subject) = 0 then
    begin
      EmailHeader;
      LineFeed;
      Colour(FGreen);
      Print(' From    : ');
      Colour(FWhite);
      Print(UserInfo.UserName);
      Colour(FGreen);
      LineFeed;
    end;
  if User <> '0' then
    begin
      Colour(FWhite);
      Response := User;
      Colour(FGreen);
    end
  else
    begin  { If No User Number Then Ask For User ID }
      Print(' To      : ');
      Colour(FWhite);
      NoUpper := False;
      Response  := ReadKB(15);
      NoUpper := True;
      Colour(Green);
   end;
  If Response = 'ALL' then All := True
   Else
     begin
       {CurrentUser := UserInfo.UserUID;}
        repeat
          User_Data := getpwuid(StartUID);
	  if User_Data <> NIL then
           begin
	     str(StartUID, SUID);
             if (lowercase(Response) = User_Data^.pw_name) or (Response = SUID) then
                begin
                  MailToName := User_Data^.pw_name;
                  if StartUID = UserInfo.UserUID then
                   begin
                     LineFeed;
                     LineFeed;
                     Print(' Sending mail to yourself, OK..');
                     Colour(FGreen);
                   end;
                  Case Length(SUID) of
                       1 : MailTo := '000' + SUID;
                       2 : MailTo := '00' + SUID;
                       3 : MailTo := '0' + SUID;
                       4 : MailTo := SUID;
                  end; { Case }
                  (*
                  { Check For Existing Mail }
	          DirSeperator := '/';
	          WildCard     := '*';
	          If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
                    begin
                      MailPath := BBSCfg.BBSMailDir + MailTo + WildCard;
                    end
                  Else
                    begin
		      MailPath := BBSCfg.BBSMailDir + DirSeperator + MailTo + WildCard;
                    end;
                  FindFirst(MailPath, Archive, DirInfo);
                  While DosError = 0 do
                   begin
                     Inc(MailCount);
                     FindNext(DirInfo);
                   end;
                  *)
                  Found := True;
               end;
            end;
            inc(StartUID);
         until getpwuid(StartUid) = NIL;
     end;
  If Found = False then
    begin
      LineFeed;
      LineFeed;
      Print('User Not Found..');
      //Print(MailUserError);
      Delay(1500);
      NoUpper := False;
      Exit;
    end
  Else
    begin
      LineFeed;
      LineFeed;
      Print(' Sending Mail To ');
      Colour(FWhite);
      Print(MailToName);
      LineFeed;
      LineFeed;
      Colour(FGreen);
      if Subject <> '' then
       begin
         MailSubject := 'RE:' + Subject;
// Print(' ' + Line[27]);
         Colour(FWhite);
       end
      else
       begin
         Print(' Subject : ');
         Colour(FWhite);
         Response := ReadKB(30);
         MailSubject := Response;
       end;
    end;
   { Create new Data pointer }
   new(maildata);
   { Start Full Editor }
   MailData := Fulledit(MailData,'[1;32mEMAIL : [33m' + MailToName,MailFile,1000);
   { Check to see if there is any data in the returned data pointer }
   if MailData^.next <> nil then
   begin
     { Create a mail ID from from a timestamp }
     { and generate a filename for mail file  }
     Str(fptime,MailNumber);
     { store forum post into a temp string * maybe better to store this in a memory block }
      while MailData <> nil do
        begin
           MailDataTemp := MailDataTemp + MailData^.data + chr(13) + chr(10);
           MailData := MailData^.next ;
        end; { end while }
      { Setup SQL string }
      MailDataTemp := sql_addslashes(MailDataTemp);
      MailSubject  := sql_addslashes(MailSubject);
      querystr := 'insert into user_mail values(NULL,'+ MailTo +',''' + MailSubject + ''',''' + MailDataTemp + ''',' + MailNumber + ',''' + UserInfo.UserName+ ''',0,0)';
      query := pchar(querystr);
      if not sql_query(query) then
       begin
         if UserInfo.UserLevel = 9 then
          begin
            LineFeed;
            Print('Error: ' + SqlError);
          end;
         LogSQLError(SqlError);
       end
      else
       begin
         Linefeed;
         Print('Mail Sent...');
         Linefeed;
         delay(2000);
       end;



     (*
     Case Length(MailNumber) of
        0..1 : MailNumber := '00' + MailNumber;
           2 : MailNumber := '0' + MailNumber;
     end;
     Step := Length(BBSCfg.BBSMailDir);
     If BBSCfg.BBSMailDir[Step] = '/' then  Mail := BBSCfg.BBSMailDir + MailTo + MailFrom + '.' + MailNumber
      Else  Mail := BBSCfg.BBSMailDir + '/' + MailTo + MailFrom + '.' + MailNumber;
     Assign(Mails, Mail);
     {$I-}
     Rewrite(Mails);
     If IOResult <> 0 then
      begin
        LineFeed;
        Print(MailError);
        Delay(3000);
        Exit;
      end
     Else
      begin
        { Save mail to mail file }
        Writeln(Mails, 'Mail No : ', MailNumber);
        WriteLn(Mails, 'Date    : ', Today);
        //Writeln(Mails, 'From    : ', UserInfo.UserName, ' (', Userinfo.UserNameFull,')');
        Writeln(Mails, 'From    : ', UserInfo.UserName);
        writeln(Mails, MailSubject);
        Writeln(Mails);
        while MailData <> nil do
        begin
          writeln(Mails, MailData^.data );
          MailData := MailData^.next ;
        end; { end while }
        Close(Mails);
        {$I+}

        LineFeed;
        Print(MailSaved);
        // if fpChmod(Mail, &0666) <> 0 then LogError('Unable to change permissions on - ' + Mail);
        Delay(1500);
      end;
        *)
     { Dispose of the mail data pointer }
     dispose(maildata);
   end
  else
   begin
     error := 1;
   end;
  NoUpper := false;
end;
(*..........................................................................*)
function InternetMail : byte;
var
   MailPath : string;
   FileInfo : stat;
begin
 MailPath := GetEnv('MAIL');
 if fpStat(MailPath, FileInfo) = 0 then
  begin
    InternetMail := 0;
  end
 else
  begin
    if FileInfo.Size <> 0 then InternetMail := 1
      else InternetMail := 0;
  end;
end;
(*..........................................................................*)
function CountMail : byte;
begin
  MailCount := 0;
  str(UserInfo.UserUID, SUID);
  Case Length(SUID) of
     1 : MailFrom := '000' +  SUID;
     2 : MailFrom := '00' + SUID;
     3 : MailFrom := '0' + SUID;
   Else
     MailFrom := SUID;
  end; { Case End }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '/' then MailPath := BBSCfg.BBSMailDir + MailFrom + '*'
    Else MailPath := BBSCfg.BBSMailDir + '/' + MailFrom + '*';
  FindFirst(MailPath, AnyFile, DirInfo);
  While DosError = 0 do
      begin
        Inc(MailCount);
        FindNext(DirInfo);
      end;
  FindClose(DirInfo);
  CountMail := MailCount;
end;
(*..........................................................................*)
{ Set the mail to read }
procedure MailMarkRead(MailID : integer);
var
  EID : string;
begin
  str(MailID, EID);
  querystr := 'update user_mail set view=1 where eid=' + EID;
  query := pchar(querystr);
  { Update EID as read}
  if not sql_query(query) then
   begin
     LogSQLError('Unable to set EID[' + EID + '] as read - ' + sqlerror + ' - ' + querystr);
   end;
end;
(*..........................................................................*)
{ Returns the number of user mail }
function MailCountTotal: integer;
var
  results : recbuf;
  UID     : string;
begin
   str(UserInfo.UserUID, UID);
   querystr := 'select * from user_mail where uid=' + UID;
   query := pchar(querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then MailCountTotal :=  sql_num_rows(results)
         else MailCountTotal := 0;
     end
   else
     begin
       MailCountTotal := 0;
     end;
end;
(*..........................................................................*)
{ Returns the number of user mail not read }
function MailCountNew: integer;
var
  results : recbuf;
  UID     : String;
begin
   str(UserInfo.UserUID, UID);
   querystr := 'select * from user_mail where view=0 and uid=' + UID;
   query := pchar(querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then MailCountNew :=  sql_num_rows(results)
         else MailCountNew := 0;
     end
   else
     begin
       LogSQLError('%MailCountNew% ' + sqlerror + ' - ' + querystr);
       MailCountNew := 0;
     end;
end;
(*..........................................................................*)
procedure MailListHeader;
begin
  ClearDispLay(True);
  Colour(FWhite);
  Print('                                            [<-- / Q] Quit [33m[[32m--> [33m/ [32mENTER[33m] [36mView  ');
  LineFeed;
  Colour(FCyan);
  Print('___');
  Colour(FWhite);
  Colour(BCyan);
  Print(' BBS Mail ');
  Colour(FCyan);
  Colour(BBLack);
  Print('__________________________________________________________________');
  LineFeed;
  Colour(FYellow);
  Print(' ID  From           Subject                      Date                          ');
  LineFeed;
end;
(*..........................................................................*)
procedure MailListFooter;
var
  Strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(MailCountTotal, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Messages ');
  Colour(BBLack);
  SetY('24');
  Colour(FCyan);
  Print('Index : ');
  Colour(FYellow);
  Print('(');
  Colour(FWhite);
  Print('N');
  Colour(FYellow);
  Print(') New / Unread Mail (');
  Colour(FWhite);
  Print('R');
  Colour(FYellow);
  Print(') Replied to sender');
  SetY('4');
end;
(*..........................................................................*)
procedure DisplayMailHeader(Eid : integer; Viewed, Replied : byte; From, Subject, Date : string);
var
  Strgs : string;
begin
  ClearDispLay(True);
  Colour(FWhite);
//  Print('           [1;36mARROWS [33m[[32mR[33m][36m Reply [33m[[32mU[33m][36m Unquoted Reply [33m[[32mD[33m][36m Delete Mail [33m[[32m<-- [33m/[32m Q[33m] [36mQuit  ');
  Colour(FGreen);
  Print('Date    :                                                  Mail ID : ');
  Colour(FYellow);
  SetX('69');
  str(Eid, Strgs);
  Print(Strgs);
  SetX('10');
  Print(Date);
  Linefeed;
  Colour(FGreen);
  Print('From    :                                                  Replied : ');
  Colour(FYellow);
  SetX('10');
  Print(From);
  SetX('69');
  if Replied = 1 then Print('Yes')
   else Print('No');
  LineFeed;
  Colour(FGreen);
  Print('Subject : ');
  Colour(FYellow);
  SetX('10');
  Print(Subject);
  Linefeed;
  Colour(FCyan);
  Print('___');
  Colour(FWhite);
  Colour(BCyan);
  Print(' Message ');
  Colour(FCyan);
  Colour(BBLack);
  Print('___________________________________________________________________');
  Colour(FWhite);
  LineFeed;
end;
(*..........................................................................*)
procedure DisplayMailFooter;
var
  strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(MailSize, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Lines ');
  Colour(BBLack);
  Colour(FWhite);
  SetY('24');
  Colour(FWhite);
  Print(' [1;36mARROWS [33m[[32mR[33m][36m Reply [33m[[32mU[33m][36m Unquoted Reply [33m[[32mD[33m][36m Delete Mail [33m[[32m<-- [33m/[32m Q[33m] [36mQuit  ');
  SetY('4');
end;
(*..........................................................................*)
procedure DisplayMailList(counter, mailno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 4;
  sety('4');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= MailNo then
     begin
       SetX('1');
       Colour(FGreen);
       Str(Counter, Strgs);
       Print(Strgs);
       SetX('5');
       Colour(FMagenta);
       Print(MailHdr[Counter].From);
       SetX('20');
       Colour(FWhite);
       Print(MailHdr[Counter].Subject);
       Colour(FGreen);
       SetX('49');
       Print(MailHdr[Counter].Date);
       if MailHdr[Counter].Viewed = 0 then
        begin
          SetX('77');
          Colour(FRed);
          Print('N');
        end;
      if MailHdr[Counter].Replied = 1 then
        begin
          SetX('78');
          Colour(FRed);
          Print('R');
        end;
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
  //until (Counter > MailNo) or (LineNo = 23);
end;
(*..........................................................................*)
procedure DisplayMail(counter, mailno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 5;
  sety('5');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= Mailno then
     begin
       //if counter <= 4 then Colour(FGreen)
       // else Colour(FWhite);
       print(Line[Counter]);
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
//  until (Counter > MailNo) or (LineNo = 23);
end;
(*..........................................................................*)
function RetrieveMailHeaders : boolean;
var
  results  : recbuf;
  rows     : rowbuf;
  ValCode  : integer;
  UID      : string;
  MailTime : time_t;
begin
  { if there is no mail then Exit }
  if MailCountTotal = 0 then
   begin
     RetrieveMailHeaders := false;
     exit;
   end;
  MailNo := 0;
  { Setup SQL }
  str(UserInfo.UserUID, UID);
  querystr := 'select * from user_mail where uid=' + UID + ' order by eid Desc';
  query := pchar(querystr);
  if sql_query(query) then
   begin
     results := sql_store_results;
     if results <> nil then
      begin
        rows := sql_fetch_row(results);
        while rows <> nil do
         begin
           Inc(MailNo);
           val(strpas(rows[0]), MailHdr[MailNo].Eid, ValCode);
           val(strpas(rows[4]), MailTime, ValCode);
           MailHdr[MailNo].Date := EpochToDateString(MailTime);
           MailHdr[MailNo].From := strpas(rows[5]);
           MailHdr[MailNo].Subject := strpas(rows[2]);
           val(strpas(rows[6]), MailHdr[MailNo].Viewed, ValCode);
           val(strpas(rows[7]), MailHdr[MailNo].Replied, ValCode);
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
        RetrieveMailHeaders := true;
      end
     else
      begin
        { No Results }
        RetrieveMailHeaders := false;
      end;
   end
  else
   begin
     { SQL Error }
     RetrieveMailHeaders := false;
   end;
end;
(*
function RetrieveMailHeaders : boolean;
var
  Files  : text;
  Line   : string;
  i, j,
  Loop,
  Step   : Integer;
begin
  MailNo := 0;
  Loop   := 1;
  Step   := 0;
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '/' then  MailPath := BBSCfg.BBSMailDir
   else MailPath := BBSCfg.BBSMailDir + '/';
  str(UserInfo.UserUID, SUID);
  FindFirst(MailPath + SUID + '*' , AnyFile, DirInfo);
  while DosError = 0 do
   begin
     inc(MailNo);
     MailSort[MailNo].FileTime := DirInfo.Time;
     MailSort[MailNo].FileName := DirInfo.Name;
     FindNext(DirInfo);
   end;
   FindClose(DirInfo);
   { If there is no mail, then exit }
   if MailNo = 0 then
    begin
      RetrieveMailHeaders := false;
      exit;
    end;
   { Sort the mail into date order (Bubble Sort) }
   for i := (MailNo - 1)  downto 1 do
    begin
      for j := 1 to i do
       begin
         if MailSort[j].FileTime > MailSort[j + 1].FileTime then
          begin
            tmp[0].FileTime := MailSort[j].FileTime;
            tmp[0].FileName := MailSort[j].FileName;
            MailSort[j].FileTime := MailSort[j + 1].FileTime;
            MailSort[j].FileName := MailSort[j + 1].FileName;
            MailSort[j + 1].FileTime := tmp[0].FileTime;
            MailSort[j + 1].FileName := tmp[0].FileName;
          end;
       end;
    end;
   { Read in all the mail headers and store into the mailhdr array }
    for  Loop := 1 to  MailNo do
      begin
        Assign(Files, MailPath + MailSort[Loop].FileName);
        {I$-}
        Reset(Files);
        FileError := IOResult;
        {$I+}
        If FileError <> 0 then
         begin
           { Error Message }
           LogError('Unable To Access user mail file - ' + MailPath + DirInfo.Name + ' - ' + ErrorString(FileError));
         end
        else
         begin
           While not Eof(Files) do
             begin
               Readln(Files, Line);
               if (Step <= 4) and (Step >=1) then
                begin
                   case Step of
                     1: MailHdr[Loop].Date := Copy(Line, 10, 40);
                     2: MailHdr[Loop].From := Copy(Line, 10, 24);
                     3: MailHdr[Loop].Subject := Copy(Line, 10, 30);
                   end;
                end;
               inc(Step);
            end;
           Close(Files);
           Step := 0;
         end;
      end;
   RetrieveMailHeaders := true;
end;
*)
(*..........................................................................*)
function RetrieveMail(MailID : integer) : boolean;
var
  results  : recbuf;
  rows     : rowbuf;
  msgline  : string[80];
  EID      : string;
  Col,
  Loop     : integer;
begin
  Col := 1;
  MailSize := 0;
  MsgLine := '';
  str(MailID, EID);
  { Setup SQL  }
  querystr := 'select content from user_mail where eid=' + EID;
  query := pchar(querystr);
  if sql_query(query) then
   begin
     results := sql_store_results;
     if results <> nil then
      begin
        rows := sql_fetch_row(results);
        while rows <> nil do
         begin
           querystr := ansistring(rows[0]);
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);

        { convert the pchar in line strings for the BBS }
        for Loop := 1 to length(querystr) do
         begin
           if (querystr[Loop] = chr(13)) or (col = 80) then
            begin
              inc(MailSize);
              Line[MailSize] := MsgLine;
              msgline := '';
              col := 1;
            end
           else
            begin
              if (querystr[Loop] <> chr(10)) then
               begin
                 insert(querystr[Loop], msgline, col);
                 inc(col);
               end;
            end;
         end;

        RetrieveMail := true;;
      end
     else
      begin
        { No Results }
        RetrieveMail := false;
      end;
   end
  else
   begin
     { SQL ERROR  }
     RetrieveMail := false;
   end;
end;
(*
function RetrieveMail(mailfile : string) : boolean;
var
  Files : text;
begin
  MailSize := 0;
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '/' then  MailPath := BBSCfg.BBSMailDir
   else MailPath := BBSCfg.BBSMailDir + '/';
  Assign(Files, MailPath + MailFile);
  {I$-}
  Reset(Files);
  FileError := IOResult;
  If FileError <> 0 then
   begin
     { Error Message }
     LogError('Unable To Access ' + MailPath + MailFile + ' - ' + ErrorString(FileError));
     RetrieveMail := false;
     exit;
   end
 else
   begin
     while not eof(Files) do
      begin
        inc(MailSize);
        readln(Files, Line[MailSize]);
      end;
     close(Files);
     {$I+}
     RetrieveMail := true;
   end;
end;
*)
(*..........................................................................*)
function DeleteMail(MailId : integer) : boolean;
var
  EID : string;
begin
  str(MailID, EID);
  { Setup SQL  }
  querystr := 'delete from user_mail where eid= ' + EID;
  query := pchar(querystr);
  if sql_query(query) then
   begin
     if sql_affected_rows > 0 then
      begin
        DeleteMail := true;
      end
     else
      begin
        DeleteMail := false;
        LogError('Unable to remove user mail [' + EID + ']');
      end;
   end
  else
   begin
      { SQL ERROR }
      LogSQLError('DeleteMail - ' + sqlerror + ' - ' + querystr);
      DeleteMail := false;
   end;
end;

(*
function DeleteMail(mailfile : string) : boolean;
var
  Files : text;
begin
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '/' then  MailPath := BBSCfg.BBSMailDir
   else MailPath := BBSCfg.BBSMailDir + '/';
  Assign(Files, MailPath + MailFile);
  {I$-}
  erase(Files);
  FileError := IOResult;
  If FileError <> 0 then
   begin
     { Error Message }
     LogError('Unable To Delete - ' + MailPath + MailFile + ' - ' + ErrorString(FileError));
     DeleteMail := false;
     exit;
   end;
 {$I+}
 DeleteMail := true;
end;
*)
(*..........................................................................*)
procedure ListMail;
label relist;
var
  files	   : text;
  Line,
  Strgs    : string;
  Step,
  Mail,
  Mail1,   { First mail number to display }
  Counter,
  Loop,
  CYPos,
  CYPos1,
  MailNoID : integer;
  MailID   : array[1..500] of string;
  //MailHdr  : array[1..500] of MailHeader;
  DisplayPrompt : boolean;
  i, j : Integer;
begin
  relist:
  Step    := 0;
  Mail	  := 1;
  Mail1   := 1;
  Counter := 4;
  Loop    := 1;
  MailDeleteID := false;
  { If there is no mail, then display msg and exit }
  if not RetrieveMailHeaders then
    begin
      { Are we using a list box }
      if ListBox.Display then
       begin
         { Yes display a alert box }
         SetY('11');
         SetX('26');
         Colour(BRed);
         Colour(FWhite);
         Print('Ŀ');
         SetY('12');
         SetX('26');
         Print(' Your Mail Box is Empty ');
         SetY('13');
         SetX('26');
         Print('');
         colour(bblack);
         delay(1500);
	 exit;
       end
      else
       begin
         LineFeed;
         Print('Your MailBox Empty..');
         delay(1500);
         exit;
       end;
    end;
    { Display mail list header/footer }
    MailListHeader;
    MailListFooter;
    Step := 1;
    { Display first page of the mails}
    DisplayMailList(1, MailNo);

    Step   := 0;
    CYPos  := 4;
    CYPos1 := 3;
    { Highlight the first message }
    SetY('4');
    SetX('1');
    colour(bcyan);
    Print(#27+'0K');
    SetX('1');
    Colour(FGreen);
    Str(mail, Strgs);
    Print(Strgs);
    SetX('5');
    Colour(FMagenta);
    Print(MailHdr[1].From);
    SetX('20');
    Colour(FWhite);
    Print(MailHdr[1].Subject);
    Colour(FGreen);
    SetX('49');
    Print(MailHdr[1].Date);
    if MailHdr[1].Viewed = 0 then
     begin
       SetX('77');
       Colour(FRed);
       Print('N');
     end;
    if MailHdr[1].Replied = 1 then
     begin
       SetX('78');
       Colour(FRed);
       Print('R');
     end;
    colour(bblack);
         Repeat
	   NoUpper := False;
           Echo := false;
           Response := ReadKB(1);
           Echo := true;
	   if (Response = 'E') or (Response = chr(91)) then exit;
           { down arrow }
           if (Response = chr(62)) and (Mail < MailNo)  then
            begin
              if mail < mailno then
               begin
                 if counter = 22 then
                  begin
                    //MailListHeader;
                    //MailListFooter;
                    Mail1 := (mail - 17);
                    DisplayMailList(mail1,mailno);
                    str(counter,strgs);
                    sety(strgs);
                    colour(bcyan);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str((mail + 1), Strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail + 1].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail + 1].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail + 1].Date);
	            if MailHdr[mail + 1].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail + 1].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    colour(bblack);
                  end
                 else
                  begin
                    str(counter,strgs);
                    sety(strgs);
                    colour(bblack);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str(mail, Strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail].Date);
                    if MailHdr[mail].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    inc(counter);
                    str(counter,strgs);
                    sety(strgs);
                    colour(bcyan);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str(mail + 1,strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail + 1].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail + 1].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail + 1].Date);
                    if MailHdr[mail + 1].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail + 1].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    colour(bblack);
                  end;
                 inc(mail);
               end;
            end;
           { arrow up }
           if (Response = chr(60)) and (Mail > 1)  then
            begin
              if mail > 1 then
               begin
                 if counter = 4 then
                  begin
                    Mail1 := (mail - 1);
                    DisplayMailList(mail1,mailno);
                    str(counter,strgs);
                    sety(strgs);
                    colour(bcyan);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str((mail - 1), Strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail - 1].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail - 1].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail - 1].Date);
                    if MailHdr[mail - 1].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail - 1].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    colour(bblack);
                  end
                 else
                  begin
                    str(counter,strgs);
                    sety(strgs);
                    colour(bblack);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str(mail, Strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail].Date);
                    if MailHdr[mail].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    dec(counter);
                    str(counter,strgs);
                    sety(strgs);
                    colour(bcyan);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str(mail - 1,strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail - 1].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail - 1].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail - 1].Date);
                    if MailHdr[mail - 1].Viewed = 0 then
                      begin
                        SetX('77');
                        Colour(FRed);
                        Print('N');
                      end;
                   if MailHdr[mail - 1].Replied = 1 then
                      begin
                        SetX('78');
                        Colour(FRed);
                        Print('R');
                      end;
                    colour(bblack);
                  end;
                 if mail <> 1 then dec(mail);
               end;
            end;
           if (Response = 'DISABLED') then
            begin
             SetY('11');
             SetX('14');
             Colour(BRed);
             Colour(FWhite);
             Print('Ŀ');
             SetY('12');
             SetX('14');
             Print(' Are you sure you want to delete this mail (y/n) ');
             SetY('13');
             SetX('14');
             Print('');
             colour(bblack);
             echo := false;
             response := readkb(1);
             echo := true;
             if Response = 'Y' then
                begin
                  if DeleteMail(MailHdr[mail].eid) then
                    begin
                      MailDeleteID := true;
                      SetY('11');
                      SetX('14');
                      Colour(BRed);
                      Colour(FWhite);
                      Print('Ŀ');
                      SetY('12');
                      SetX('14');
                      Print('            The Mail Has Been Deleted            ');
                      SetY('13');
                      SetX('14');
                      Print('');
                      colour(bblack);
                      delay(1500);
                      if not RetrieveMailHeaders then
                       begin
                         LineFeed;
                         Print('Your MailBox Empty..');
                         delay(1500);
                         exit;
                       end;
                      MailListHeader;
                      MailListFooter;
                   end;
                end;
             if Mail > MailNo then
              begin
                Mail1 := MailNo;
                dec(counter);
                dec(mail);
              end;
             DisplayMailList(mail1,mailno);
             str(counter,strgs);
             sety(strgs);
             colour(bcyan);
             Print(#27+'0K');
             SetX('1');
             Colour(FGreen);
             Str((mail), Strgs);
             Print(Strgs);
             SetX('4');
             Colour(FMagenta);
             Print(MailHdr[mail].From);
             SetX('19');
             Colour(FWhite);
             Print(MailHdr[mail].Subject);
             Colour(FGreen);
             SetX('48');
             Print(MailHdr[mail].Date);
             colour(bblack);
            end;
           if (Response = '') and (Response <> chr(62)) and (Response <> Chr(60)) or (Response = chr(93)) then
	     begin
	       //val(Response, MailNoID, CodeData);
               MailNoID := Mail;
	       if (MailNoID >=1) and (MailNoID <= MailNo) then
	        begin
		  //dec(loop);
                  //ReadEMail(MailSort[MailNoID].FileName);
                  ReadEMail(MailHdr[mail].eid, MailHdr[mail].viewed,MailHdr[mail].replied, MailHdr[mail].from, MailHdr[mail].subject, MailHdr[mail].date);
                  { Set as read  }
                  MailHdr[Mail].viewed := 1;
                  { Reload mail messages incase a msg has been deleted}
                  if (MailDeleteID) or (CountMail > Mail) then
                   begin
                     if not RetrieveMailHeaders then
                      begin
                        { error }
                        exit;
                      end;
                     MailDeleteID := false;
                     if Mail > Mailno then
                       begin
                         Mail := MailNo;
                         dec(counter);
                       end;
                   end;

                  MailListHeader;
                  MailListFooter;
                  DisplayMailList(mail1,mailno);

                    str(counter,strgs);
                    sety(strgs);
                    colour(bcyan);
                    Print(#27+'0K');
                    SetX('1');
                    Colour(FGreen);
                    Str((mail), Strgs);
                    Print(Strgs);
                    SetX('5');
                    Colour(FMagenta);
                    Print(MailHdr[mail].From);
                    SetX('20');
                    Colour(FWhite);
                    Print(MailHdr[mail].Subject);
                    Colour(FGreen);
                    SetX('49');
                    Print(MailHdr[mail].Date);
                    colour(bblack);

		  //Counter := 1;
		  //if (Loop > 1) and (not DisplayPrompt) then Loop := Loop - 1;
           	  //if Loop < 11 then Loop := 1;
                  (*
		  MailNo := 0;
		  str(UserInfo.UserUID, SUID);
		  FindFirst(MailPath + SUID + WildCard , AnyFile, DirInfo);
		  while DosError = 0 do
   		   begin
		     inc(MailNo);
                     MailSort[MailNo].FileTime := DirInfo.Time;
                     MailSort[MailNo].FileName := DirInfo.Name;
      	        //     MailID[MailNo] := DirInfo.Name;
                     FindNext(DirInfo);
                   end;
                   *)
		   Response := '';
		   if MailNo = 0 then
		    begin
		      LineFeed;
		      Print('Mailbox empty...');
		      delay(2000);
		      exit;
		    end;
		  //goto relist;
		end
             else
	        begin
		  Linefeed;
		  Print('Invalid Mail ID..');
		  Delay(2000);
		  LineFeed;
		end;
	     end;
         Until Response = 'Q';
	 Counter := 1;
	 ClearDispLay(True);
	 Str(MailNo, Strgs);
  	 if Loop <= MailNo then MailListHeader;
     {  end; }
   { end;}
   //delay(6000);
end;
(*..........................................................................*)
//procedure ReadEMail(MSG : string);
procedure ReadEMail(Eid : integer; Viewed, Replied : byte; MailFrom, MailSubject, MailDate : string);
Label ExitProc;
Var
  Files     : Text;
  Step,
  Count     : Integer;
  Strgs,
  Subject,
  ReplyMail : string;
  ReadMails : Boolean;
begin
  str(UserInfo.UserUID, SUID);
  Case Length(SUID) of
     1 : MailTo := '000' + SUID;
     2 : MailTo := '00' + SUID;
     3 : MailTo := '0' + SUID;
   Else
     MailTo := SUID;
  end; { Case End }

  { Retrieve the mail }
  if not RetrieveMail(EID) then
   begin
     SetY('11');
     SetX('13');
     Colour(BRed);
     Colour(FWhite);
     Print('Ŀ');
     SetY('12');
     SetX('13');
     Print(' Sorry, there was an error accessing the mail file ');
     SetY('13');
     SetX('13');
     Print('');
     colour(bblack);
     delay(1500);
     exit;
   end;
  { Set mail as read  }
  MailMarkRead(EID);
  Step := 22;
  DisplayMailHeader(Eid, Viewed, Replied, MailFrom, MailSubject, MailDate);
  DisplayMailFooter;
  DisplayMail(1,MailSize);
  Subject := Copy(Line[4], 11, 30);
  repeat
    echo := false;
    Response := readKB(1);
    echo := true;
    { Arrow down }
    if Response = chr(62) then
     begin
       if Step < MailSize then
        begin
          inc(step);
          DisplayMail((Step - 21), MailSize);
        end;
     end;
    { Arrow up }
    if Response = chr(60) then
     begin
       if Step > 22 then
        begin
          dec(step);
          DisplayMail((Step - 21), MailSize);
        end;
     end;
    { Unquoted reply to mail  }
    if (Response = 'U') or (Response = 'R') then
      begin
        { Reply To EMail }
        Step := 1;
        {Strgs := Copy(ReplyMail, 5, 4); }
        //ReplyMail := Copy(Msg, 5, 4);
        MailUser(MailFrom, MailSubject, '');
        if error = 0 then MailMarkReply(EID);
        exit;
        //DisplayMailHeader;
        //DisplayMailFooter;
        //DisplayMail((Step - 21), MailSize);
      end;
    { Quoted reply to mail }
    (*
    if Response = MailReply then
      begin
        { Reply To EMail }
        Step := 1;
        {Strgs := Copy(ReplyMail, 5, 4); }
        //ReplyMail := Copy(Msg, 5, 4);
        //MailUser(ReplyMail, Subject, MailPath + Msg);
        exit;
       // DisplayMailHeader;
        //DisplayMailFooter;
        //DisplayMail((Step - 21), MailSize);
      end;
    *)
    { Delete mail }
    if Response = 'D' then
      begin
        SetY('11');
        SetX('14');
        Colour(BRed);
        Colour(FWhite);
        Print('Ŀ');
        SetY('12');
        SetX('14');
        Print(' Are you sure you want to delete this mail (y/n) ');
        SetY('13');
        SetX('14');
        Print('');
        colour(bblack);
        echo := false;
        response := readkb(1);
        echo := true;
        if Response = 'Y' then
         begin
           //if DeleteMail(Msg) then
           if DeleteMail(eid) then
            begin
              MailDeleteID := true;
              SetY('11');
              SetX('14');
              Colour(BRed);
              Colour(FWhite);
              Print('Ŀ');
              SetY('12');
              SetX('14');
              Print('            The Mail Has Been Deleted            ');
              SetY('13');
              SetX('14');
              Print('');
              colour(bblack);
              delay(1500);
              exit;
            end;
         end
        else
         begin
           DisplayMail((Step - 21), MailSize);
         end;
      end;
  until (Response = 'Q') or (Response = chr(91));
end;
(*..........................................................................*)
(*
procedure EditMail;
Label View;
var
  Step,
  PageInc,
  UserNo    : Integer;
  MailPath,
  Strgs,
  User      : String;
  Mail      : Text;
  Filenames : array[1..12] of string[12];
begin
  {$IFDEF _LINUX_}
     DirSeperator := '/';
     WildCard	  := '*';
  {$ELSE}
     DirSeperator := '\';
     WildCard	  := '*.*';
  {$ENDIF}
  str(UserInfo.UserUID, SUID);
  CurrentUser := SUID;
  Case Length(SUID) of
     1 : MailFrom := '000' + SUID;
     2 : MailFrom := '00' + SUID;
     3 : MailFrom := '0' + SUID;
   Else
     MailFrom := SUID;
  end; { Case End }
  MailCount := 0;
  Strgs     := '';
  User      := '';
  PageInc   := 0;
  { Check For Mail Sent By User }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
    begin
      MailPath := BBSCfg.BBSMailDir + WildCard;
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + DirSeperator + WildCard;
    end;
  ClearDisplay(True);
  { Needs to be changed with UserInfo.UserColour }
  Colour(FYellow);
  Print('Searching..');
  Colour(FWhite);
  LineFeed;
  LineFeed; {mailpath}
  FindFirst(MailPath, Archive, DirInfo);
  While DosError = 0 do
    begin
      If MailCount <= 100 then { Store Up to 100 Mails }
        begin
          IF Pos(MailFrom, DirInfo.Name) > 0 then    { Search File Name For }
            begin                                    { User Number          }
              Inc(MailCount);
              FileNames[MailCount] := DirInfo.Name;
            end;
        end;
      FindNext(DirInfo);
    end;
  If MailCount > 0 then
    begin
      Colour(FYellow);
      Print(' Users You Have Sent Mail To And Are Unread..');
      LineFeed;
      LineFeed;
      for Step := 1 to MailCount do
        begin
          Str(Step, Strgs);
          SetX('2');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
           Print(Strgs);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;37m');
            end;
          Print(' : ');
          Strgs := Copy(FileNames[Step], 1, 4); { Get User Name }
          Val(Strgs, UserNo, MAx);
          Seek(DataFile, UserNo);
          Read(DataFile, UserInfo);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;32m');
            end;
          Print(UserInfo.UserName);
          SetX('45');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
         Print('UserNo # ');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;35m');
            end;
	  Print(SUID);
          LineFeed;
          UserNo := 0;
          User   := '';
          Strgs  := '';
          inc(PageInc);
          if (PageInc = (UserInfo.UserLines - 3)) then
            begin
              PageInc := 0;
              HoldPage;
            end;
        end;
     Val(CurrentUser, UserNo, Max);
     Seek(DataFile, UserNo);     { Restore Current User }
     Read(DataFile, UserInfo);
     If UserInfo.UserAnsi = 1 then
       begin
         Print(#27 + '[34m');
       end;
     LineFeed;
     Print('Please Select Mail To Edit : ');
     Response := ReadKB(90);
     If Response <> #13 then
       begin
         Val(Response, UserNo, Max);
         If UserNo <= Step then
           begin
            If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
               begin
                 MailPath := BBSCfg.BBSMailDir + FileNames[UserNo];
               end
             Else
               begin
		 MailPath := BBSCfg.BBSMailDir + DirSeperator + FileNames[UserNo];
               end;
             NoUpper := True;
             UserNo := 1;
             Assign(Mail,MailPath);
             {$I-} Reset(Mail); {$I+}
             If IOResult = 0 then
               begin
                 While not eof(Mail) do
                  begin
                    Readln(Mail, Strgs);
                    Line[UserNo] := Strgs;
                    Inc(UserNo);
                  end;
                 View:
                 Num := 0;
                 Header;
                 Repeat
                   Temp := '';
                   Inc(Num);
                   If UserInfo.UserANSi = 1 then
                     Print('[32m Line ')
                   Else
                     Print(' Line ');
                   Str(Num, Temp);
                   If UserInfo.UserANSI = 1 then Print('[33m');
                   Print(Temp);
                   If UserInfo.UserANSI = 1 then
                     Print('[32m >[37m ')
                   Else
                     Print(' > ');
                   Print(Line[Num]);
                   LineFeed;
                   If Num = 23 then
                     begin
                       Print('Press Any Key To Continue');
                       Response := ReadKB(1);
                       Print(#13);
                       Print('                         ');
                       Print(#13);
                     end;
                   Until Num = UserNo - 1;
                   LineFeed;
                   EndEditor := False;
                   Repeat
                   LineFeed;
                   If UserInfo.UserANSI = 1 then
                     begin
                       Print('[31m [[33mS[31m] [36mSave Message  [31m[[33mA[31m] [36mAbort Message  ');
                       Print('[31m[[33mE[31m] [36mEdit Line  [31m[[33mV[31m] [36mView Message');
                    end
                   Else
                    Print(' [S] Save Message  [A] Abort Message  [E] Edit Line  [V] View Message');
                   LineFeed;
                   If UserInfo.UserAnsi = 1 then
                     Print(' [37mPlease Select Option  [32m:  [33m')
                   Else
                     Print(' Please Select Option : ');
                   Response := '';
                    Response := ReadKB(2);
                   If (Response = 'v') or (Response = 'V') then Goto View;
                   If (Response = 's') or (Response = 'S') then
                     begin
                       {I$-} Rewrite(Mail); {$I+}
                       If IOResult = 0 then
                         begin
                           For Step := 1 to UserNo -1 do
                            begin
                              Writeln(Mail, Line[Step]);
                            end;
                           Print('*Mail Saved');
                           EndEditor := True;
                         end
                       Else
                         begin
                           { IO Error }
                         end;
                     end;
                   If (Response = 'e') or (Response = 'E') then EditLine;
                   If (Response = 'a') or (Response = 'A') then
                    begin
                     LineFeed;
                     Print('*Abort (Y/n) : ');
                     Response := ReadKB(1);
                     If (Response = 'y') or (Response = 'Y') then EndEditor := True;
                   end;
                 Until EndEditor = True;
                 Close(Mail);
               end
             Else
               begin
                 { IO Error }
               end;
           end
         Else
           begin
             LineFeed;
             Print('Invalid Number');
	     LineFeed;
	     {$IFDEF _LINUX_}
               Delay(3000);
             {$ELSE}
               Wait(30);
             {$ENDIF}
           end;
       end;
    end
 Else
    begin
      { There Is No Mail By User }
    end;
  NoUpper := False;
end;
*)
(*..........................................................................*)
end.
