(* ........................................................................ *)
(*        								    *)
(* MODULE	:   LINUXNEW.PP      			                    *)
(*									    *)
(* DESCRIPTION	:   CREATES NEW USER ON SAURON LINUX BBS                    *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 2.2.0                                 *)
(*									    *)
(* COPYRIGHT	:   SAURON BBS & SAURON LINUX BBS SIMON HORTON 1995 - 2007  *)      
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* changelog.txt                                                            *)
(*..........................................................................*)
(* 10/10/07	SCH	Fixed userdb file creation bug			    *)
(*		SCH	added chmod 666 to creation userdb		    *) 
(*..........................................................................*)
(* TODO:                                                                    *)
(* 16/01/00        Check for LOCK file                                      *)
(*..........................................................................*)

Unit LinuxNew;

interface

uses Dos, Crt, Linux, Strings, Lib, Data, Dates, Errorlog, Unix, BaseUnix, sqldb, user;
  
function Check_For_Existing_User(AUname : pchar) : Boolean;
function Create_User : boolean;

implementation

{ var }
  { Get functions from external library }
  function getpwnam(UName : PChar) : TUserPasswd ; cdecl; external;

(*..........................................................................*)
function Check_For_Existing_User(AUname : pchar) : Boolean;
var
  results : recbuf;

  NewUser      : string;
  //UserNew      : user;
begin   
  NewUser := StrPas(AUname);
  Check_For_Existing_User := FALSE;
  { Check linux system to if requested user name exists }
  if getpwnam(AUname) <> NIL then
   begin
     LogError('User ' + NewUser + ' already exists..');
     Check_For_Existing_User := TRUE; 
   end
  else
   begin
     { Check SQL database of users waiting creation  }
     { Setup Query }
     querystr := 'select name from user_signup where name=''' + NewUser+''''; 
     query := pchar(querystr);
     if sql_query(query) then
      begin
        results := sql_store_results;
        if sql_affected_rows = 0 then
         begin
           { No user with requested name exists }  
           logerror(querystr);
         end
        else
         begin
           LogError('User ' + NewUser + ' already exists..');
           Check_For_Existing_User := TRUE; 
         end;
        { clear memory }
        sql_free_results(results);
      end
     else
      begin
        { SQL Error }
        LogSQLError('Error checking user_signup - ' + sqlerror + ' : ' + querystr);
      end;
   end;  
end;
(*..........................................................................*)
{ Add new user to adduser.dat }
function Create_User : boolean;
var
  UserSize : integer;
  MailNumber,
  Strgs,
  Mail     : string;
  Mails    : text;
begin
  { Setup SQL Query  }
  Str(fptime, Strgs);
  querystr := 'insert into user_signup values(0,1,1,'''+AddUser.UserName+''','''+AddUser.UserNameFull+''','''+AddUser.UserPass+''','''+AddUser.UserTown+''','''+AddUser.UserEmail+''',''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',1,24,'''+remotehost+''','+strgs+',NULL)';
  query := pchar(querystr);
  if not sql_query(query) then
   begin
     Create_User := false;
     exit;
   end;
  { Flag that the user has registered}
  UserInfo.UserReg := true;
  UpdateUserReg;
  { Send a mail to the sysop if defined in linux.ini  }
  if BBSCfg.SysopNew = 1 then
   begin
     Str(fptime,MailNumber);
     str(BBSCfg.SysopUID,strgs);
     If BBSCfg.BBSMailDir[length(BBSCfg.BBSMailDir)] = '/' then
        begin
          Mail := BBSCfg.BBSMailDir + strgs + '0000.' + MailNumber;
        end
      Else
        begin
          Mail := BBSCfg.BBSMailDir + '/' + strgs + '0000.' + MailNumber;
        end;
      Assign(Mails, Mail);
      {$I-} Rewrite(Mails); {$I+}
      If IOResult <> 0 then
       begin
         LineFeed;
         Print(MailError);
         {$IFDEF _LINUX_}
           Delay(3000);
         {$ELSE}
           Wait(30);
         {$ENDIF}
         Exit;
       end
      Else
       begin
         Writeln(Mails, 'Mail No : ', MailNumber);
         WriteLn(Mails, 'Date    : ', Today);
         Writeln(Mails, 'Who     : ', Adduser.UserName, ' (', Userinfo.UserNameFull,')');
         Writeln(Mails, 'Subject : New User Sign UP..');
         Writeln(Mails);
         Writeln(Mails, 'User Name  : ', adduser.username);
         Writeln(Mails, 'User Full  : ', adduser.usernamefull);
         Writeln(Mails, 'User Town  : ', adduser.usertown);
         Writeln(Mails, 'User Email : ', adduser.useremail);
         Writeln(Mails);
         Writeln(Mails, 'User Host  : ', RemoteHost);
         Writeln(Mails, 'User IP    : ', RemoteIP);
         Writeln(Mails);
         Close(Mails);
         if fpChmod(Mail, &0770) <> 0 then LogError('Unable to change permissions on - ' + Mail);
         Create_User := true
       end;
    end;

end;
  
end.
