(* ........................................................................ *)
(*        								    *)
(* MODULE	:   LIB2.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   FUNCTION LIBRARY                                        *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   UNIT NOT REQUIRED ON LINUX VERSION                      *)               
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)      
(*									    *)
(* VERSION      :   DOS version 1.06A                                       *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(*..........................................................................*)
Unit Lib2;

interface

{$IFDEF _LINUX_}
  uses Crt, Dos, Lib, Linux, Data, ErrorLog, Colours; 
{$ELSE}
  uses Crt, Dos, Lib, Data, Dates, Msgs, ErrorLog, CDrop, Colours;
{$ENDIF}  

function CheckUserName(Name : string): boolean;

implementation

(*..........................................................................*)

function CheckUserName(Name : string): boolean;
Var
  FilePath,
  Line,
  UsersName : string;
  UserOk    : Boolean;
  ColourTag,
  Step      : integer;
begin
  {$IFDEF _LINUX_}
   { ConVERT Name to upper case }
   For Loop := 1 to length(Name) do
     begin  
       Name[Loop] := UpCase(Name[Loop]);
     end;
   {$ENDIF}  
  UserOK := True;
  ColourTag := UserInfo.UserColour;
  { Check For Banned Names & Text }
  If BBSCfg.SysDir[Length(BBSCfg.SysDir)] = Directory_Seperator then
    begin
      FilePath := BBSCfg.SysDir + 'banned.txt';
    end
  Else
    begin
      FilePath := BBSCfg.SysDir + Directory_Seperator + 'banned.txt';
    end;
  Assign(Input, FilePath);
  {$I-} Reset(Input); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To open ' + FilePath);
    end
  Else
    begin
      While (not eof(Input)) and (UserOK = true) do
       begin
         Readln(Input, Line);
         If line[1] <> ';' then { Ignore Rem }
           begin
             If Pos(Line, Name) > 0 then
               begin
                 LineFeed;
                 Colour(fwhite);
                 colour(bblack);;
                 Print('Sorry The Use Of That Name Is not acceptable..');
                 LineFeed;
                 UserOk := False;
               end;
           end;
       end;
      Close(Input)
    end;
{$IFDEF _LINUX_}
{$ELSE}
  if UserOk then
    begin
      { Check For Duplicate Logon Names }
      if UserSize <> 0 then
        begin
          for step := 1 to UserSize - 1 do
            begin
              Seek(DataFile, Step);
              Read(DataFile, UserInfo);
              if UserOk then
                begin
                  If Pos(Name, UserInfo.UserName) > 0 then
                    begin
                      Colour(FWhite);
                      Print('Sorry That Name Is Being Used By Another User, Please Choose Another.');
                      LineFeed;
                      UserOk := False;
                    end;
                end;
            end;
          Seek(DataFile, UserNumber);  { Restore Last User Number }
          Read(DataFile, UserInfo);
        end;
    end;
  UserInfo.UserColour := ColourTag;   { Restore Colour Option }
{$ENDIF}
  CheckUserName := UserOk;
end;

end.

