Program FilesBBS;

uses crt, dos;

{ Sauron BBS File Areas }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[30];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[30];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName  : String[12];
    Size      : LongInt;      { FileSize }
    FDate     : String[8];    { FileDate }
    Des1,
    Des2,
    Des3,
    Des4,
    Des5,
    Des6,
    Des7,
    Des8,
    Des9,
    Des10,
    Des11,
    Des12,
    Des13,
    Des14,
    Des15     : String[60];   { File Description }
    DLTimes   : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser    : String[30];   { User Who Uploaded File }
end;

var
   FileRec  : FileInfo;
   FileData : file of FileInfo;

   AreaRec  : FileAreas;
   AreaData : file of FileAreas;

procedure OpenDataFiles(AreaFile : string; BBSFiles : string);
begin
  {$I-}
    Assign(AreaData, AreaFile);
    Reset(AreaData);
  {$I+}
  if IOResult <> 0 then
   begin
     Writeln('Error Opening ', AreaFile);
     Halt(1);
   end;
end;

procedure CloseDataFiles;
begin
  Close(AreaData);
end;

procedure MakeDataBaseList(BBS : string);
var
   Loop,
   LineCount,
   Space     : integer;

   PositionStart  : array[1..4] of integer;
   PositionStop   : array[1..4] of integer;

   LineInput : string;
   LineFile  : text;

   LineDone  : boolean;

begin
  {$I-} { Open FILES.BBS File }
    Assign(LineFile, BBS);
    Reset(LineFile);
  {$I+}
  if IOResult <> 0 then
   begin
   end
  else
   begin { Read FILES.BBS File and Process Each Line }
     LineCount := 0; { Reset LineCount }
     Linedone  := false;
     while not eof(LineFile) do
      begin
        Readln(LineFile, LineInput);
        if (LineInput[1] = ' ') and (Length(LineInput) > 30) then
         begin
         end
       else
        begin
          if Length(LineInput) > 60 then
            begin
              PositionStart[1] := 1;
              Loop := 0;
              Space := 1;
              while Space < 4  do
                begin
                  Loop := Loop + Pos(' ', LineInput);
                  if LineInput[Loop - 1] <> ' ' then
                   begin
                     PosistionStop[Loop - 1];
                     inc(Space);
                   end
                  else
                   begin
                   end;
                end;
            end;
        end;
      end;
     Close(FileData); { Close FILES.BBS Now We Have Finished }
   end;
end;

var
  Loop    : integer;
  BBSFile : string;
begin
  if Paramcount < 2 then
   begin
     ClrScr;
     Writeln('FILES.BBS To Sauron File List DataBase v2.00 (C) Simon Horton & ');
     Writeln;
     Writeln('Usage : FILESBBS < Area File > < Files.bbs file >');
     Writeln('   EG : FILESBBS AREA.1 LFILES.BBS');
     Writeln;
     Halt(1);
   end
  else
   begin
     OpenDataFiles(Paramstr(1), ParamStr(2));
     For Loop := 0 to Filesize(AreaData) - 1 do
      begin
        {$I-}
          Seek(AreaData, Loop);
          Read(AreaData, AreaRec);
        {$I+}
        if IOResult <> 0 then
         begin
           Writeln;
           Writeln('ERROR READING :- ', Paramstr(1));
           Writeln;
         end
        else
         begin
           BBSFile := AreaRec.Dir + Paramstr(2);
           MakeDataBaseList(BBSFile);
         end;
      end;
   end;
  CloseDataFiles;
end.
