{ $Id: errorlog.pp,v 1.4 2008-02-25 20:33:12 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   ERRORLOG.PAS    			                    *)
(*									    *)
(* DESCRIPTION	:   WRITES ERRORS TO THE ERROR LOG FILE                     *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
(*

$Log: errorlog.pp,v $
Revision 1.4  2008-02-25 20:33:12  simon
Added User Node Number to Log File


*)
Unit ErrorLog;

Interface

Uses Dos, Dates, Data, linux, BaseUnix;

function ErrorString(ErrorNumber : Byte) : String;
procedure LogError(Buffer : String);
procedure LogSQLError(Buffer : String);

Implementation
(*..........................................................................*)
function ErrorString(ErrorNumber : Byte) : String;
var
  Strgs : string;
begin
  Str(ErrorNumber, Strgs);
  Case ErrorNumber of
(*
{$IFDEF _LINUX_ }
   Sys_EPERM	: ErrorString := 'Operation not permitted';
   Sys_ENOENT	: ErrorString := 'No such file or directory';
   Sys_ESRCH	: ErrorString := 'No such process';
   Sys_EINTR	: ErrorString := 'Interrupted system call';
   Sys_EIO	: ErrorString := 'I/O error';
   Sys_ENXIO	: ErrorString := 'No such device or address';
   Sys_E2BIG	: ErrorString := 'Arg list too long';
   Sys_ENOEXEC	: ErrorString := 'Exec format error';
   Sys_EBADF	: ErrorString := 'Bad file number';
   Sys_ECHILD	: ErrorString := 'No child processes';
   Sys_EAGAIN	: ErrorString := 'Try again';
   Sys_ENOMEM	: ErrorString := 'Out of memory';
   Sys_EACCES	: ErrorString := 'Permission denied';
   Sys_EFAULT	: ErrorString := 	{ Bad address }
   Sys_ENOTBLK	= 15;	{ Block device required }
   Sys_EBUSY	= 16;	{ Device or resource busy }
   Sys_EEXIST	= 17;	{ File exists }
   Sys_EXDEV	= 18;	{ Cross-device link }
   Sys_ENODEV	= 19;	{ No such device }
   Sys_ENOTDIR	= 20;	{ Not a directory }
   Sys_EISDIR	= 21;	{ Is a directory }
   Sys_EINVAL	= 22;	{ Invalid argument }
   Sys_ENFILE	= 23;	{ File table overflow }
   Sys_EMFILE	= 24;	{ Too many open files }
   Sys_ENOTTY	= 25;	{ Not a typewriter }
   Sys_ETXTBSY	= 26;	{ Text file busy }
   Sys_EFBIG	= 27;	{ File too large }
   Sys_ENOSPC	= 28;	{ No space left on device }
   Sys_ESPIPE	= 29;	{ Illegal seek }
   Sys_EROFS	= 30;	{ Read-only file system }
   Sys_EMLINK	= 31;	{ Too many links }
   Sys_EPIPE	= 32;	{ Broken pipe }
   Sys_EDOM	= 33;	{ Math argument out of domain of func }
   Sys_ERANGE	= 34;	{ Math result not representable }
   Sys_EDEADLK	= 35;	{ Resource deadlock would occur }
   Sys_ENAMETOOLONG= 36;	{ File name too long }
   Sys_ENOLCK	= 37;	{ No record locks available }
   Sys_ENOSYS	= 38;	{ Function not implemented }
   Sys_ENOTEMPTY= 39;	{ Directory not empty }
   Sys_ELOOP	= 40;	{ Too many symbolic links encountered }
   Sys_EWOULDBLOCK	= Sys_EAGAIN;	{ Operation would block }
   Sys_ENOMSG	= 42;	{ No message of desired type }
   Sys_EIDRM	= 43;	{ Identifier removed }
   Sys_ECHRNG	= 44;	{ Channel number out of range }
   Sys_EL2NSYNC= 45;	{ Level 2 not synchronized }
   Sys_EL3HLT	= 46;	{ Level 3 halted }
   Sys_EL3RST	= 47;	{ Level 3 reset }
   Sys_ELNRNG	= 48;	{ Link number out of range }
   Sys_EUNATCH	= 49;	{ Protocol driver not attached }
   Sys_ENOCSI	= 50;	{ No CSI structure available }
   Sys_EL2HLT	= 51;	{ Level 2 halted }
   Sys_EBADE	= 52;	{ Invalid exchange }
   Sys_EBADR	= 53;	{ Invalid request descriptor }
   Sys_EXFULL	= 54;	{ Exchange full }
   Sys_ENOANO	= 55;	{ No anode }
   Sys_EBADRQC	= 56;	{ Invalid request code }
   Sys_EBADSLT	= 57;	{ Invalid slot }
   Sys_EDEADLOCK= 58;	{ File locking deadlock error }
   Sys_EBFONT	= 59;	{ Bad font file format }
   Sys_ENOSTR	= 60;	{ Device not a stream }
   Sys_ENODATA	= 61;	{ No data available }
   Sys_ETIME	= 62;	{ Timer expired }
   Sys_ENOSR	= 63;	{ Out of streams resources }
   Sys_ENONET	= 64;	{ Machine is not on the network }
   Sys_ENOPKG	= 65;	{ Package not installed }
   Sys_EREMOTE	= 66;	{ Object is remote }
   Sys_ENOLINK	= 67;	{ Link has been severed }
   Sys_EADV	= 68;	{ Advertise error }
   Sys_ESRMNT	= 69;	{ Srmount error }
   Sys_ECOMM	= 70;	{ Communication error on send }
   Sys_EPROTO	= 71;	{ Protocol error }
   Sys_EMULTIHOP= 72;	{ Multihop attempted }
   Sys_EDOTDOT	= 73;	{ RFS specific error }
   Sys_EBADMSG	= 74;	{ Not a data message }
   Sys_EOVERFLOW= 75;	{ Value too large for defined data type }
   Sys_ENOTUNIQ= 76;	{ Name not unique on network }
   Sys_EBADFD	= 77;	{ File descriptor in bad state }
   Sys_EREMCHG	= 78;	{ Remote address changed }
   Sys_ELIBACC	= 79;	{ Can not access a needed shared library }
   Sys_ELIBBAD	= 80;	{ Accessing a corrupted shared library }
   Sys_ELIBSCN	= 81;	{ .lib section in a.out corrupted }
   Sys_ELIBMAX	= 82;	{ Attempting to link in too many shared libraries }
   Sys_ELIBEXEC= 83;	{ Cannot exec a shared library directly }
   Sys_EILSEQ	= 84;	{ Illegal byte sequence }
   Sys_ERESTART= 85;	{ Interrupted system call should be restarted }
   Sys_ESTRPIPE= 86;	{ Streams pipe error }
   Sys_EUSERS	= 87;	{ Too many users }
   Sys_ENOTSOCK= 88;	{ Socket operation on non-socket }
   Sys_EDESTADDRREQ= 89;	{ Destination address required }
   Sys_EMSGSIZE= 90;	{ Message too long }
   Sys_EPROTOTYPE= 91;	{ Protocol wrong type for socket }
   Sys_ENOPROTOOPT= 92;	{ Protocol not available }
   Sys_EPROTONOSUPPORT= 93;	{ Protocol not supported }
   Sys_ESOCKTNOSUPPORT= 94;	{ Socket type not supported }
   Sys_EOPNOTSUPP= 95;	{ Operation not supported on transport endpoint }
   Sys_EPFNOSUPPORT= 96;	{ Protocol family not supported }
   Sys_EAFNOSUPPORT= 97;	{ Address family not supported by protocol }
   Sys_EADDRINUSE= 98;	{ Address already in use }
   Sys_EADDRNOTAVAIL= 99;	{ Cannot assign requested address }
   Sys_ENETDOWN= 100;	{ Network is down }
   Sys_ENETUNREACH= 101;	{ Network is unreachable }
   Sys_ENETRESET= 102;	{ Network dropped connection because of reset }
   Sys_ECONNABORTED= 103;	{ Software caused connection abort }
   Sys_ECONNRESET= 104;	{ Connection reset by peer }
   Sys_ENOBUFS	= 105;	{ No buffer space available }
   Sys_EISCONN	= 106;	{ Transport endpoint is already connected }
   Sys_ENOTCONN= 107;	{ Transport endpoint is not connected }
   Sys_ESHUTDOWN= 108;	{ Cannot send after transport endpoint shutdown }
   Sys_ETOOMANYREFS= 109;	{ Too many references: cannot splice }
   Sys_ETIMEDOUT= 110;	{ Connection timed out }
   Sys_ECONNREFUSED= 111;	{ Connection refused }
   Sys_EHOSTDOWN= 112;	{ Host is down }
   Sys_EHOSTUNREACH= 113;	{ No route to host }
   Sys_EALREADY= 114;	{ Operation already in progress }
   Sys_EINPROGRESS= 115;	{ Operation now in progress }
   Sys_ESTALE	= 116;	{ Stale NFS file handle }
   Sys_EUCLEAN	= 117;	{ Structure needs cleaning }
   Sys_ENOTNAM	= 118;	{ Not a XENIX named type file }
   Sys_ENAVAIL	= 119;	{ No XENIX semaphores available }
   Sys_EISNAM	= 120;	{ Is a named type file }
   Sys_EREMOTEIO= 121;	{ Remote I/O error }
   Sys_EDQUOT	= 122;	{ Quota exceeded }
{$ELSE}
 *)
   $00 : ErrorString := 'OK';
   $02 : ErrorString := 'File not found';
   $03 : ErrorString := 'Path not found';
   $04 : ErrorString := 'To many open Files';
   $05 : ErrorString := 'Access denied';
   $06 : ErrorString := 'Invalid file handle';
   $07 : ErrorString := 'Memory blocks invalid';
   $08 : ErrorString := 'Not enough memory';
   $09 : ErrorString := 'Memory blocks invalid';
   $0A : ErrorString := 'Invalid environment';
   $0B : ErrorString := 'Invalid format';
   $0C : ErrorString := 'Invalid file Access code';
   $0F : ErrorString := 'Invalid drive number';
   $10 : ErrorString := 'Cannot remove current directory';
   $11 : ErrorString := 'Cannot rename across drives';
   $12 : ErrorString := 'No more files';
   $13 : ErrorString := 'Disk write protected';
   $15 : ErrorString := 'Drive not ready';
   $16 : ErrorString := 'Bad command';
   $17 : ErrorString := 'Data error on disk';
   $19 : ErrorString := 'Seek error';
   $1A : ErrorString := 'Bad media';
   $1B : ErrorString := 'Sector not found';
   $1D : ErrorString := 'Unable to write to disk';
   $1E : ErrorString := 'Unable to read from disk';
   $20 : ErrorString := 'File sharing error';
   $21 : ErrorString := 'File locking error';
   $23 : ErrorString := 'No free FCBs';
   $24 : ErrorString := 'File sharing buffer full';
   $35 : ErrorString := 'Bad network patch';
   $36 : ErrorString := 'Network busy';
   $37 : ErrorString := 'Device does not exist';
   $39 : ErrorString := 'Hardware error';
   $64 : ErrorString := 'Disk read error';
   $65 : ErrorString := 'Disk write error';
   $66 : ErrorString := 'File not assigned';
   $67 : ErrorString := 'File not open';
   $68 : ErrorString := 'File not open for input';
   $69 : ErrorString := 'File not open for output';
  Else
    ErrorString := ' ('+ Strgs + ')unKown Error';
  end; { Case End }
end;
(*..........................................................................*)
procedure LogError(Buffer : String);
Var
  Log : Text;
  LogFile : string;
begin
   If BBSCfg.LogDir[Length(BBSCfg.LogDir)] = directory_Seperator then
        LogFile := BBSCfg.LogDir + BBSCfg.ErrFile
   Else LogFile := BBSCfg.LogDir + directory_Seperator + BBSCfg.ErrFile;
  Assign(Log, LogFile);
  {$I-} append(Log); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      {$I-} Rewrite(Log); {$I+}
      FileError := IOResult;
      if FileError = 0 then
       begin
        WriteLn(Log,'LOG CREATED ', Today);
        Writeln(Log);
      end
     else
      begin
        { The Log File Cannot be opened/created, carry on all the same }
        exit;
      end;
    end;
  Writeln(Log, todayshort,':',userinfo.username,'[',NodeNo,']:',Buffer);
  Close(Log);
  fpchmod (LogFile, &0666);
end;
(*..........................................................................*)
procedure LogSQLError(Buffer : String);
Var
  Log : Text;
  LogFile : string;
begin
   If BBSCfg.LogDir[Length(BBSCfg.LogDir)] = directory_Seperator then
        LogFile := BBSCfg.LogDir + 'sqlerror.log'
   Else LogFile := BBSCfg.LogDir + directory_Seperator + 'sqlerror.log';
  Assign(Log, LogFile);
  {$I-} append(Log); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      {$I-} Rewrite(Log); {$I+}
      FileError := IOResult;
      if FileError = 0 then
       begin
        WriteLn(Log,'LOG CREATED ', Today);
        Writeln(Log);
      end;
    end;
  Writeln(Log, todayshort,':',userinfo.username,'[',NodeNo,']:',Buffer);
  Close(Log);
  fpchmod (LogFile, &0666);
end;

end.
