{ $Id: door.pp,v 1.2 2008-02-20 00:09:07 simon Exp $ }
(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   DOOR.PP                                                 *)
(*                                                                          *)
(* DESCRIPTION  :   DOOR UNIT                                               *)
(*                                                                          *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 2.0.4  LINUX KERNEL 2.2.30+           *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 1995 - 2007                                *)
(*                                                                          *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.2-2                *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
(* NOTES:                                                                   *)
(*..........................................................................*)

(*

 Revision 1.2  2008-02-20 00:09:07  simon
 Added: dorinfo.def.<hostname> for guest accounts
 BUG: door time not being removed from bbs online time


*)
{ Door Unit v0.01 }

{ Date 30/08/95    }
{ Date 21/02/96  Added GetDoorTime - Returns the time caller was in a Door }
{ Date 06/07/96  Fixed Bug In GetDoorTime - Was not reading the DEF file   }
{                Probley  was returning wrong time                         }

{ OCT 97 - Release Notes                                         }
{ Creates DORDEF00.DEF file and adjust users time when returning }
{ from door program                                              }

Unit Door;

interface
{$IFDEF _LINUX_}
	Uses Crt, Data, Lib, ErrorLog, baseunix;
{$ELSE}
	Uses Crt, Data, Lib, ErrorLog, WaitTix;
{$ENDIF}

procedure MakeDorInfo(NODE : BYTE);
procedure MakeDoorSYS(NODE : BYTE);
procedure MakeDoorSYS32(NODE : BYTE);
procedure GetDoorTime(NODE : BYTE);

implementation

procedure MakeDorInfo(NODE : BYTE);
Var
  OutFile : Text;
  Strgs,
  Fname   : String;
begin
  Str(NODE, Strgs);
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      Fname := Home_Directory + '/dorinfo' + Strgs + '.def.' + RemoteHost;
    end
   else
    begin
      Fname := Home_Directory + '/dorinfo' + Strgs + '.def'
    end;
  Assign(OutFile, Fname);
  {$I-} Rewrite(OutFile);
  If IOResult <> 0 then
    begin
      LogError('Unable To Create Door File : ' + Fname + ':' + ErrorString(IOResult));
      If Local then
        begin
          Writeln('Unable To Create Door File : ',Fname);
          {$IFDEF _LINUX_}
    	    Delay(100);
          {$ELSE}
            Wait(10);
	  {$ENDIF}
        end;
    end
  Else
    begin
      Writeln(OutFile, BBSCfg.BBSName);
      Writeln(OutFile, BBSCfg.SysopFirst);
      Writeln(OutFile, BBSCfg.SysopSec);
      If Local then
        begin
          Writeln(OutFile,'COM0');
        end
      Else
        begin
          Writeln(OutFile,'COM0');
        end;
      If Local then
        begin
          Writeln(OutFile, '38400 BAUD,N,8,1');
        end
      Else
        begin
          Writeln(OutFile, '38400 BAUD,N,8,1');
        end;
      If Local then
        begin
          Writeln(OutFile,0);
        end
      Else
        begin
          Writeln(OutFile,ActualBaud);
        end;
      Writeln(OutFile, UserInfo.UserName);
      Writeln(OutFile, ' ');
      Writeln(OutFile, UserInfo.UserTown);
      Writeln(OutFile, UserInfo.UserANSI);
      Writeln(OutFile, UserInfo.UserLevel);
      Writeln(OutFile, TimeLeft);
      Writeln(OutFile, 0);
      Close(OutFile);
      {$I+}
    end;
end;

procedure MakeDoorSYS(NODE : BYTE);
Var
  OutFile : Text;
  Strgs,
  Fname   : String;
begin
  Str(NODE, Strgs);
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      Fname := Home_Directory + '/door.sys.' + RemoteHost;
    end
   else
    begin
      Fname := Home_Directory + '/door.sys'
    end;
  Assign(OutFile, Fname);
  {$I-} Rewrite(OutFile);
  If IOResult <> 0 then
    begin
      LogError('Unable To Create Door File : ' + Fname + ':' + ErrorString(IOResult));
      If Local then
        begin
          Writeln('Unable To Create Door File : ',Fname);
          {$IFDEF _LINUX_}
    	    Delay(100);
          {$ELSE}
            Wait(10);
	  {$ENDIF}
        end;
    end
  Else
    begin
      Writeln(OutFile, 'COM', NodeNo ,':');
      Writeln(OutFile, '115000');
      Writeln(OutFile, '8');
      Writeln(OutFile, Node);
      Writeln(OutFile, '115000');
      Writeln(OutFile, 'Y');
      Writeln(OutFile, 'Y');
      Writeln(OutFile, 'N');
      Writeln(OutFile, 'N');
      Writeln(OutFile, UserInfo.UserName);
      Writeln(OutFile, UserInfo.UserTown);
      Writeln(OutFile, '000-000-000');
      Writeln(OutFile, '000-000-000');
      Writeln(OutFile, '***********');
      Writeln(OutFile, UserInfo.UserLevel);
      Writeln(OutFile, UserInfo.Calls);
      Writeln(OutFile, '');
      Writeln(OutFile, '');
      Writeln(OutFile, Timeleft);
      Writeln(OutFile, 'GR');
      Writeln(OutFile, '23');
      Writeln(OutFile, 'N');
      Writeln(OutFile, '');
      Writeln(OutFile, '');
      Writeln(OutFile, '');
      Writeln(OutFile, '');
      Writeln(OutFile, 'Z');
      Writeln(OutFile, UserInfo.Uploads);
      Writeln(OutFile, UserInfo.Downloads);
      Writeln(OutFile, UserInfo.BytesDL);
      Writeln(OutFile, '9999');
      Writeln(OutFile, '00/00/00');
      Writeln(OutFile, '');
      Writeln(OutFile, '');
      Writeln(OutFile, BBSCfg.SysopFirst);
      Writeln(OutFile, 'sysop');
      Writeln(OutFile, '00:00');
      Writeln(OutFile, 'Y');
      Writeln(OutFile, 'Y');
      Writeln(OutFile, 'Y');
      Writeln(OutFile, '14');
      Writeln(OutFile, '0');
      Writeln(OutFile, '00/00/00');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Close(OutFile);
      {$I+}
    end;
end;

procedure MakeDoorSYS32(NODE : BYTE);
Var
  OutFile : Text;
  Strgs,
  Fname   : String;
begin
  Str(NODE, Strgs);
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      Fname := Home_Directory + '/door32.sys.' + RemoteHost;
    end
   else
    begin
      Fname := Home_Directory + '/door32.sys'
    end;
  Assign(OutFile, Fname);
  {$I-} Rewrite(OutFile);
  If IOResult <> 0 then
    begin
      LogError('Unable To Create Door File : ' + Fname + ':' + ErrorString(IOResult));
      If Local then
        begin
          Writeln('Unable To Create Door File : ',Fname);
          {$IFDEF _LINUX_}
            Delay(100);
          {$ELSE}
            Wait(10);
          {$ENDIF}
        end;
    end
  Else
    begin
      Writeln(OutFile, '0');
      Writeln(OutFile, '0');
      Writeln(OutFile, '115000');
      Writeln(OutFile, 'Sauron Linux');
      Writeln(OutFile, '1');
      Writeln(OutFile, UserInfo.Username);
      Writeln(OutFile, UserInfo.UserName);
      Writeln(OutFile, UserInfo.UserLevel);
      Writeln(OutFile, TimeLeft);
      Writeln(OutFile, UserInfo.UserANSI);
      Writeln(OutFile, Node);
      close(OutFile);
    end;
end;

procedure GetDoorTime(NODE : BYTE);
Var
  OutFile    : Text;
  Strgs,
  Fname,
  GetInfo    : String;
  TimeOnDoor,
  TimeDoor   : integer;
begin
  Str(NODE, Strgs);
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      Fname := Home_Directory + '/dorinfo' + Strgs + '.def.' + RemoteHost;
    end
   else
    begin
      Fname := Home_Directory + '/dorinfo' + Strgs + '.def'
    end;
  Assign(OutFile, Fname);
  {$I-} Reset(OutFile); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Read Door File : ' + Fname + ':' + errorstring(IOResult));
      If Local then
        begin
          Writeln('Unable To Read Door File : ',Fname);
          {$IFDEF _LINUX_}
	    Delay(100);
	  {$ELSE}
    	    Wait(10);
	  {$ENDIF}
        end;
    end
  Else
    begin
      For Loop := 1 to 12 do
        begin
          GetInfo := '';
          Readln(OutFile, GetInfo);
        end;
      Close(OutFile);
      Strgs := '';
      For Loop := 1 to length(GetInfo) do { Clear Spaces }
        begin
          if (ord(Getinfo[Loop]) >= 48) and (ord(GetInfo[Loop]) <= 57) then
            begin
              Strgs := Strgs + GetInfo[Loop];
            end;
        end;
      LogError('Time Left = ' + Strgs + ' Minutes');
      Val(Strgs, TimeDoor, Code);
      TimeOnDoor := TimeLeft - TimeDoor;
      Minutes := Minutes + TimeOnDoor;
    end;
end;

end.
