{ $Id: data.pp,v 1.9 2008-02-26 21:14:18 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   DATA.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   MAIN BBS DATA UNIT                                      *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1998 - 2008                                *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
(*

 $Log: data.pp,v $
 Revision 1.9  2008-02-26 21:14:18  simon
 Improved file library routines, increased string values for filelist storeage

 Revision 1.8  2008-02-25 23:13:18  simon
 Enchaned Read Forum Procedures

 Revision 1.7  2008-02-22 22:27:45  simon
 bug fixes

 Revision 1.6  2008-02-20 23:50:51  simon
 update

 Revision 1.5  2008-02-20 16:37:48  simon
 FIXED: daily session time not being subtracted from user level session time.
     { added new user tag userinfo.timestamp in userdata/data.pp }
     { Update createus & sadduser & smt with new user variable }
     { check for 24 hrs pass in data.pp }
     { added %maxtime% to check for time exceeded }
     { use in logon.sfi if %maxtime% = %true% then TIMEBYE }

 Revision 1.4  2008-02-19 22:02:46  simon
 Fixed cvs log comment

 Revision 1.3  2008-02-19 21:58:07  simon
 see todo.txt

*)

Unit Data;

Interface

{$IFDEF _LINUX_}
  Uses Dos, Crt, Strings, Dates, Ini, baseunix, sqldb;
{$ELSE}
  Uses Dos, Crt, Strings, Dates, Wins,  Node, Ini;
{$ENDIF}


procedure OpenDataFiles;
procedure CloseDataFiles;
procedure OpenUserTemp;
procedure CloseUserTemp;
procedure SQLConnect;
procedure ReadINIFile;
function ReadBBSConfig : boolean;

type  strA = string[255];
     strB = string[80];
     strC = string[255];
     lineptr = ^linerec;
     linerec = record
                 prev, next : lineptr ;
                 data       : StrB  ;
               end;


(*..........................................................................*)
{$IFDEF _LINUX_}
{ User Information  USERDAT.DAT}
type
  AddUser_Data = record
    Full_Name,
    User_Name,
    User_Pass,
    User_Address1,
    User_Address2,
    User_Address3,
    User_Address4,
    User_Telephone,
    User_Email     : string[30];
end;

type
  LockNode = record
       Node     : smallint;
       door,
       Guest    : boolean;
       Who,
       From,
       ipaddr,
       page     : String[30];
       hostname : string[255];
       timestamp,
       logontime : time_t;
end;

{ Stores the last 10 logins }
type
  Logins = record
      Node      : smallint;
      Who,
      From      : string[30];
      TimeStamp : time_t;
end;

type
  UserPasswd = record
    pw_name,
    pw_passwd : pchar;
    pw_uid,
    pw_gid    : word;
    pw_gecos,
    pw_dir,
    pw_shell  : pchar;
end;
  TUserPasswd = ^UserPasswd;
{$ENDIF}
{ Modem data }
type
  Cfg = record
     ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[50];
     InitString2 : String[50];
     InitString3 : String[50];
     InitAnswear : String[20];
     LockBaud    : Boolean;
     BBSNodes    : smallint;
     Node	 : byte;
     MultiNode   : Boolean;
     GuestsAllowed : smallint;
     GuestNo     : smallint;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;   { Level Time }
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;   { Level Calls Per Day }
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     textdir,
     TempDir,
   {$IFDEF _LINUX_}
     BinDir,
     NewDir,
     DataDir,
     LogDir,
     HomeDir,
     MailDir,
   {$ENDIF}
     filesDir,
     upload,
     NodeDir    : String[80];  { Node Directory Is Where All nodes Share Info }
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[40];
     LinuxUID,
     SysopUID,
     SysopNew,
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg,
     MaxTags    : Word;
     ShowIP     : Byte;
     ShowIPMsg  : string[15];
     LogFile,
     ErrFile       : String[12];
     BulletinForum : integer;
     Bulletin      : word;
     { SQL }
     SQLServer  : pchar;
     SQLUser    : pchar;
     SQLPass    : pchar;
     SQLDb      : pchar;
end;
(*..........................................................................*)
{ Sauron BBS File Areas  AREAS.DAT }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;
(*..........................................................................*)
{ Sauron BBS File Areas  AREA.* }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[255];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[255];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;
(*..........................................................................*)
{ Tag File }
type
  FileTags = record
    FileName  : String[30];
    Dir       : String[80];
    DirLst    : String[80];
    Des       : String[40];
    Tagged    : Byte;
    Size      : LongInt;
    DLTimes   : Integer;
    ULUser    : String[30];
    Date      : String[8];
    RecNumber : integer;
end;
(*..........................................................................*)
{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName  : String[60];
    Size      : LongInt;      { FileSize }
    FDate     : String[10];    { FileDate }
    Des1,
    Des2,
    Des3,
    Des4,
    Des5,
    Des6,
    Des7,
    Des8,
    Des9,
    Des10,
    Des11,
    Des12,
    Des13,
    Des14,
    Des15     : String[60];   { File Description }
    DLTimes   : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser    : String[30];   { User Who Uploaded File }
    DLAllowed : boolean;      { Download enabled }
    Delete    : boolean;      { Deletion tag }
end;
(*..........................................................................*)
{ File Deletion - Stores files to be removed using SMT }
type
  FileRemove = record
    FilePath  : string[255]; { Path and FileName to be removed }
    FileLst   : string[255]; { File List DB path and name }
    FileID    : integer;     { File List DB record Number }
    FileDes   : string[60];  { First Line of Description }
end;
(*..........................................................................*)
{ Sauron BBS Data Information  SIMPBBS.DAT }
{ DELETEME }
type
  bbs = record
    NextUser   : integer;
    Line       : string;
    From       : string;
    Date       : string;
    Time       : Word;
    Fax        : integer;
    FaxTime    : string;
end;
(*..........................................................................*)
{ Sauron Message Index File - msgno = 0 tagged for deletion }
type
  Index = Record
     MsgNumber : Integer;
end;
(*..........................................................................*)
{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;		{MSG AREA NUMBER}
    AreaName  : String[30];     {MSG AREA DESCRIPTION}
end;
(*..........................................................................*)
{ Sauron Message Number }
{ NOT SURE WHAT THIS DOES AGAIN...! 23/10/07 }
type
  MS = record
    MsgNumber : integer;
end;
(*..........................................................................*)
{ User Read Message Numbers }
{ Database stored in user home directory readmsg.dat - added 23/10/07 }
type
  ReadMsg = record
    ReadMsgNo : integer;
end;
(*..........................................................................*)
{ User Information  USERINFO.DATA}
type
  User = record
    UserUID    : integer;       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserTime   : time_t;       { Date user account Created }
    UserTimestamp : time_t;    { epochtime of user login, used to reset daily call/time allowance }
    UserLogon  : time_t;       { epochtime of user login }
    UserReg    : boolean;      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;

type
   SelectBox = record
      PosX,              { X pos of box }
      PosY   : string[3];              { Y pos of box }
      Depth,             { Depth of box }
      Width  : byte;     { Width of box }
      C1,                { C1 + ---- L1 ---- + C2 }
      C2,                { }
      C3,                { D1 |              | D2 }
      C4,                { }
      D1,                { C3 + ---- L2 ---- + C4 }
      D2,                { }
      L1,                { }
      L2     : byte;      { }
      TextColour,
      TextBgColour      : integer;
      ItemNo : integer;  { No of list items max 20 }
      LineItem : array[1..20] of string[15];
(*
      Item02,
      Item03,
      Item04,
      Item05,
      Item06,
      Item07,
      Item08,
      Item09,
      Item10,
      Item11,
      Item12,
      Item13,
      Item14,
      Item15,
      Item16,
      Item17,
      Item18,
      Item19,
      Item20  : string[15];
*)
      Key     : array[1..20] of string;
      Display : boolean;
end;

(*..........................................................................*)
const
  { Sauron Colour Codes }
  { Foreground }
    FBlack   = 224;
    FRed     = 225;
    FGreen   = 226;
    FYellow  = 227;
    FBlue    = 228;
    FMagenta = 229;
    FCyan    = 230;
    FWhite   = 231;
  { Background }
    BBlack   = 232;
    BRed     = 233;
    BGreen   = 234;
    BYellow  = 235;
    BBlue    = 236;
    BMagenta = 237;
    BCyan    = 238;
    BWhite   = 239;
    Directory_Seperator = '/';
var
  {$IFDEF _LINUX_}
     Home_Directory : string;
     NewUserName    : pchar;
     { File Structure for adduser.dat }
     AddUser	  : User;
     UserDatabase : file of User;
     LockFile	  : boolean;
     { BBS Variables } { These Can Be Set In The Script Files }
     Download_Script,
     File_Viewer,
     RemoteHost,
     RemoteIP,
     timestamp   : string;
     ThisUser    : string[30]; { Name of User }
     GuestName   : string[30]; { Name of Guest User }
     GuestUID    : integer;  { Guest Linux UID number }
     NodeNo      : smallint; { node number of connected host }
     MaxNodes    : boolean;  { true if max nodes has been reached }
  {$ENDIF}
  ScriptTitle  : string[30];  { script page title }
  UserNumber : Integer;      { Holds Current UserNumber }
  bbsinfo    : bbs;
  Userinfo,
  UserTemp   : user;          { UserTemp is a tempory file to write and retrive  }
  Areas      : FileAreas;     { Data, as the main file was somehow being corrupt }
  SAreas     : Area;
  BBSCfg     : Cfg;
  FInfo,
  UPInfo     : FileInfo;
  Idx        : Index;
  Msg        : MsgArea;
  MsIndex    : Ms;
  Tags       : FileTags;
  UserReadMsg : ReadMsg;      { Messages read by user }
  FileDel    : FileRemove;    { File Deletion }
  UserSize   : LongInt;
  AreaSize   : LongInt;
  TagSize    : LongInt;
  InFile     : Text;
  DataFile,
  DataTemp   : File of user;       { UserFile & User Temp File}
  BBSini     : File of bbs;        { BBS Data File }
  FileArea   : File of FileAreas;  { File Directorys }
  CatArea    : File of Area;
  SBBSCfg    : File of Cfg;
  Files      : File of FileInfo;
  TagInfo    : File of FileTags;
  IdxFile    : File of Index;
  MsgFile    : File of MsgArea;    { MESSAGE AREAS }
  MsgNum     : File of MS;
  UReadMsg   : File of ReadMsg;    { Read Messages }
  FileDelDB  : File of FileRemove; { File Deletion }

  ReadMsgs   : array[0..2048] of integer; { Read Messages }

  Temp       : String;
  Loop       : Integer;
  FileNumber : byte;     { Record Number Of File DownLoaded }
  StatsBox   : Byte;     { Holds Whats To Displayed In Stats Box }
  SOnOff     : Boolean;  { Status Bar On / Off Flag              }
  Tagged,                { True if files are tagged }
  Local,                 { True if local logon }
  OnLine,
  PromptQuote : Boolean;
  { Regs        : Registers;} { DOS registers }
  Response    : string;    { Command & char responses from users }
  LineCount,                { Keeps Count On Lines Scrolled In PrintFile }
  BBSlines,                 { Keeps Count of BBS Screen Lines }
  CurrentLine : Integer;
  ScriptFile  : String;          { Holds ScriptFile Name }
  FinScript   : Boolean;         { True if script file is finished }
  Portini,                   { Name Of Modem INI File }
  ConfigFile  : String;      { Name of Node Configuration File }
  Error       : Integer;{ Error Holds The Error Number Returned In %error% }
  Errored     : Boolean;{ This Sets To True On Every Logon, Used In LogError }
  FileError   : Byte;   { Main File Errors }
  DlFile,                    { Dload Filename      }
  ULFile,                    { File to be uploaded }
  selFile     : string;      { Name of File being downloaded }
  YN          : Byte;        { Used for %YN% in script I think }
  Echo,
  PassEcho,
  NewUserKB,                 { only allow 0 - 9, a - z, used for adduser }
  NoUpper     : Boolean;
  NewUser,
  Finish      : Boolean;
  LastCall,
  CallAway    : Integer;
  LastCalls,
  LastCaller,
  LastCallerTown : String;
  SessionTime,
  SessionLength,
  StartTimes,
  Minutes,
  Times,
  Time,
  LastOnTime     : Word;  { Reset Time Procedure }
  Carrier,                 { Line Speed }
  LineBaud       : Word;
  ActualBaud     : String;
  ConnectString  : String;
  ColourSelect   : Byte;
  ColourCode     : String;
  {AVATAR}
  AvatarChar,
  AvatarCode,
  AvatarCol      : byte;
  {ANSI}
  AnsiCode       : Byte;
  AnsiDetect     : Boolean;  { True Ansi Detected }
  SaveCurX,
  SaveCurY       : integer;
  CurSaved       : Boolean;
  CaseKey,
  CaseKey2,
  Back,
  Fore,
  Flash,
  High          : integer;
  Delimiter     : Boolean;
  AnsiCommand,
  UserOldPassword,
  Fst,
  Snd,
  Command       : String;
  temps,
  I,
  Code,
  Pntr,
  Fval,
  Sval,
  Cval          : integer;
  ValCode,
  ValWord	: word;
  ProfileStatus,
  CodeData : integer;
  DataString,
  LastScript : string; { Last script ran }
  { ASYNC.PAS }
  ModemTimeOut : integer;
  PortStatus   : Boolean; { Current Port Status - True = OK }
  ModemChar    : char;    { Char Return From Modem }
  ModemIntChar : integer;
  { PORT.INI VALUES NOT NEEDED BY LINUX VERSION }
  { [COMPORT] }
  ComPort,
  Irq,
  DataBits,
  StopBits    : byte;
  PortAddress : word;
  Baudrate    : longint;
  Parity      : char;
  { Sauron.ini & Linux.ini Data Values }
  { [MISC] }
  PausePage,
  SysopMenu,
  CommandNotFound,
  ShowTime1,
  ShowTime2,
  ShowTime3,
  InvalidPassword : string;
   { [SENDMAIL] }
   MailAbort,
   MailSave,
   MailEdit,
   MailView,
   MailAbortYes,
   MailAbortNo,
   MailPrompt1,
   MailPrompt2,
   MailHead1,
   MailHead2,
   MailSaved,
   MailAborted,
   MailError,
   MailUserError : string;
   { [READMAIL] }
   MailContinue,
   MailRead,
   MailDelete,
   MailReply,
   RMailPrompt1,
   RMailPrompt2,
   MailDeleted   : string;
   { [FORUMMSGLIST] }
   MsgView,
   MsgReList,
   MsgListStop,
   MsgViewPost,
   MsgPrompt1,
   MsgPrompt2,
   MsgLHead1,
   MsgLHead2,
   MsgLHead3    : string;
   { [FORUMMSGREAD] }
   MsgRReply,
   MsgRNext,
   MsgRPrev,
   MsgRExit,
   MsgRMsg1,
   MsgRMsg2,
   MsgRNo,
   MsgRPrompt1  : string;
   { [DIRECTORYLIST] }
   DNext,
   DUp,
   DDown,
   DAction,
   DStop,
   DDownload,
   DFileView,
   DContinue,
   DLFilePrompt1,
   DLFilePrompt2,
   ActionPrompt1,
   ActionPrompt2,
   DFileHead1,
   DFileHead2,
   DFileHead3   : string;
   { [LISTFILES] }
   TagFile,
   FileView,
   FileRelist,
   FileListStop,
   LFilePrompt1,
   LFilePrompt2,
   ViewFile,
   FileHead1,
   FileHead2,
   FileHead3   : string;
   { [FILEVIEW] }
   VTagFile,
   VFilePrompt1,
   VFilePrompt2,
   UpLoadBy,
   DownTime,
   DownMinutes   : string;
   { [MAINFILEAREA] }
   MQuit,
   MFilePrompt,
   MFileHead1,
   MFileHead2,
   MFileHead3,
   MOpen,
   MClosed,
   MCurrentArea  : string;
   { [SUBFILEAREA] }
   SArea,
   SFilePrompt,
   SFileHead1,
   SFileHead2,
   SFileHead3,
   NoAccess,
   InvalidArea   : string;

   { Selection Box }
   ListBox   : SelectBox;
   ListItems : array[1..20] of string[50];

Implementation

function CheckINIKeys(Key : String) : String;
begin
  CheckINIKeys := '';
  if Pos('#ENTER', key) > 0 then
   begin
     CheckINIKeys := '';
   end
  else
   if Pos('#SPACE', key) > 0 then
    begin
     CheckINIKeys := ' ';
    end
   else
    begin
      CheckINIKeys := Key;
   end;
end;

{ Connect to the SQL server }
procedure SQLConnect;
begin
  { Connect to SQL Server }
  if not sql_connect(BBSCfg.SQLServer,BBSCfg.SQLUser,BBSCfg.SQLPass) then
   begin
    writeln('Oops, mysql connection error...[',sqlerror,']');
    // Need to add dispose(pchar) for BBSCfg.SQLxx
    halt(1);
   end
  else
   begin
     { Connect database }
     if not sql_select_db(BBSCfg.SQLDb) then
      begin
        writeln('Opps, mysql db error...[',sqlerror,']');
        // Need to add dispose(pchar) for BBSCfg.SQLxx
        halt(1);
      end;
   end;
end;
{ Retrive BBS settings from the SQL server  }
function ReadBBSConfig : boolean;
var
  results    : recbuf;
  rows       : rowbuf;
begin
  { Setup SQL }
  query := 'select * from bbs_config';
  if sql_query(query) then
   begin
     results := sql_store_results;
     if results <> nil then
      begin
        rows := sql_fetch_row(results);
        if results <> nil then
         begin
           BBSCfg.SysopFirst := strpas(rows[0]);
           BBSCfg.SysopSec   := strpas(rows[1]);
           BBSCfg.BBSName    := strpas(rows[2]);
           BBSCfg.BBSTele    := strpas(rows[3]);
           val(strpas(rows[4]), BBSCfg.LinuxUID, ValCode);
           val(strpas(rows[5]), BBSCfg.SysopUID, ValCode);
           val(strpas(rows[6]), GuestUID, ValCode);
           val(strpas(rows[7]), BBSCfg.BBSNodes, ValCode);
           val(strpas(rows[8]), BBSCfg.SysopNew, ValCode);
           val(strpas(rows[9]), BBSCfg.GuestNo, ValCode);
           val(strpas(rows[10]), BBSCfg.GuestsAllowed, ValCode);
           val(strpas(rows[11]), BBSCfg.Calls, ValCode);
           val(strpas(rows[12]), BBSCfg.IdleTime, Valcode);
           BBSCfg.LogFile    := strpas(rows[13]);
           BBSCfg.ErrFile    := strpas(rows[14]);
           val(strpas(rows[15]), BBSCfg.BulletinForum, Valcode);
           val(strpas(rows[16]), BBSCfg.ShowIP, Valcode);
           val(strpas(rows[17]), BBSCfg.L1T, Valcode);
           val(strpas(rows[18]), BBSCfg.L2T, Valcode);
           val(strpas(rows[19]), BBSCfg.L3T, Valcode);
           val(strpas(rows[20]), BBSCfg.L4T, Valcode);
           val(strpas(rows[21]), BBSCfg.L5T, Valcode);
           val(strpas(rows[22]), BBSCfg.L6T, Valcode);
           val(strpas(rows[23]), BBSCfg.L7T, Valcode);
           val(strpas(rows[24]), BBSCfg.L8T, Valcode);
           val(strpas(rows[25]), BBSCfg.L9T, Valcode);
           val(strpas(rows[26]), BBSCfg.L1C, Valcode);
           val(strpas(rows[27]), BBSCfg.L2C, Valcode);
           val(strpas(rows[28]), BBSCfg.L3C, Valcode);
           val(strpas(rows[29]), BBSCfg.L4C, Valcode);
           val(strpas(rows[30]), BBSCfg.L5C, Valcode);
           val(strpas(rows[31]), BBSCfg.L6C, Valcode);
           val(strpas(rows[32]), BBSCfg.L7C, Valcode);
           val(strpas(rows[33]), BBSCfg.L8C, Valcode);
           val(strpas(rows[34]), BBSCfg.L9C, Valcode);
         end;
        { Clear Memory }
        sql_free_results(results);
      end
     else
      begin
        { Error getting Config Data }
        ReadBBSConfig := false;
      end;
   end
  else
   begin
     ReadBBSConfig := false;
   end;
end;
{ Retrive Profile Settings From Sauron.ini, Linux.ini, sql}
procedure ReadINIFile;
begin
  DataString := '';
  {$IFDEF _LINUX_}
      { Get SQL Data }
      { LINUX.INI }
      { [SQL] }
      // (todo: use StrDispose(Pchar);)
      ProfileStatus := GetProfileString('linux', 'SQL' , 'SERVER', DataString, '127.0.0.1');
      BBSCfg.SQLServer := StrAlloc (length(DataString)+1);
      strpcopy(BBSCfg.SQLServer, DataString);
      ProfileStatus := GetProfileString('linux', 'SQL' , 'USER', DataString, 'nobody');
      BBSCfg.SQLUser := StrAlloc (length(DataString)+1);
      strpcopy(BBSCfg.SQLUser, DataString);
      ProfileStatus := GetProfileString('linux', 'SQL' , 'PASS', DataString, '');
      BBSCfg.SQLPass := StrAlloc (length(DataString)+1);
      strpcopy(BBSCfg.SQLPass, DataString);
      ProfileStatus := GetProfileString('linux', 'SQL' , 'DB', DataString, 'sauron');
      BBSCfg.SQLDb := StrAlloc (length(DataString)+1);
      strpcopy(BBSCfg.SQLDb, DataString);
      { [CONFIG] }
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BINDIR', BBSCfg.BinDir, '/sauron/bin/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'DATADIR', BBSCfg.DataDir, '/sauron/data/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSDIR', BBSCfg.SysDir, '/sauron/sys/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SCRIPTDIR', BBSCfg.ScriptDir, '/sauron/script/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MENUDIR', BBSCfg.MenuDir, '/sauron/menu/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'NODEDIR', BBSCfg.NodeDir, '/sauron/node/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MSGDIR', BBSCfg.MsgDir, '/sauron/message/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'TEXTDIR', BBSCfg.TextDir, '/sauron/text/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'TEMPDIR', BBSCfg.TempDir, '/sauron/temp/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'LOGDIR', BBSCfg.LogDir, '/sauron/log/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'ADDUSER', BBSCfg.NewDir, '/sauron/newuser/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'HOMEDIR', BBSCfg.HomeDir, '/sauron/home/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAILDIR', BBSCfg.BBSMailDir, '/var/spool/mail/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'FILESDIR', BBSCfg.FilesDir, '/sauron/files/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'UPLOAD', BBSCfg.Upload, '/sauron/upload/');
      (*
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOPFIRST', BBSCfg.SysopFirst, 'System');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOPSEC', BBSCfg.SysopSec, 'Operator');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BBSNAME', BBSCfg.BBSName, 'Sauron BBS');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BBSTEL', BBSCfg.BBSTele, '555-8989');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOP', DataString, '2000');
      val(DataString, BBSCfg.SysopUID, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'LINUXUID', DataString, '2000');
      val(DataString, BBSCfg.LinuxUID, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOPNEW', DataString, '1');
      val(DataString, BBSCfg.SysopNew, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BBSNODES', DataString, '10');
      val(DataString, BBSCfg.BBSNodes, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'GUESTUID', DataString, '2000');
      val(DataString, GuestUID, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'GUESTSALLOWED', DataString, '5');
      val(DataString, BBSCfg.GuestsAllowed, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'GUESTNO', DataString, '0');
      val(DataString, BBSCfg.GuestNo, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'CALLS', DataString, '0');
      val(DataString, BBSCfg.Calls, CodeData);
      *)
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'NEWLEVEL', DataString, '1');
      val(DataString, BBSCfg.NuLevel, CodeData);
      { ProfileStatus := GetProfileString('linux', 'CONFIG' , 'IDLETIME', DataString, '5'); }
      val(DataString, BBSCfg.IdleTime, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAXUSERS', DataString, '100');
      val(DataString, BBSCfg.MaxUsers, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAXMSG', DataString, '100');
      val(DataString, BBSCfg.MaxMsg, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAXTAGS', DataString, '5');
      val(DataString, BBSCfg.MaxTags, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BULLETIN', DataString, '1');
      val(DataString, BBSCfg.Bulletin, CodeData);
      (*
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BULLETINFORUM', DataString, '1');
      val(DataString, BBSCfg.BulletinForum, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'USERLOG', BBSCfg.LogFile, 'user.log');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'ERRORLOG', BBSCfg.ErrFile, 'error.log');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L1TIME', DataString, '999');
      val(DataString, BBSCfg.L1T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L2TIME', DataString, '999');
      val(DataString, BBSCfg.L2T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L3TIME', DataString, '999');
      val(DataString, BBSCfg.L3T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L4TIME', DataString, '999');
      val(DataString, BBSCfg.L4T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L5TIME', DataString, '999');
      val(DataString, BBSCfg.L5T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L6TIME', DataString, '999');
      val(DataString, BBSCfg.L6T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L7TIME', DataString, '999');
      val(DataString, BBSCfg.L7T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L8TIME', DataString, '999');
      val(DataString, BBSCfg.L8T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L9TIME', DataString, '999');
      val(DataString, BBSCfg.L9T, CodeData);

      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L1CALLS', DataString, '1');
      val(DataString, BBSCfg.L1C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L2CALLS', DataString, '1');
      val(DataString, BBSCfg.L2C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L3CALLS', DataString, '1');
      val(DataString, BBSCfg.L3C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L4CALLS', DataString, '1');
      val(DataString, BBSCfg.L4C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L5CALLS', DataString, '1');
      val(DataString, BBSCfg.L5C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L6CALLS', DataString, '1');
      val(DataString, BBSCfg.L6C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L7CALLS', DataString, '1');
      val(DataString, BBSCfg.L7C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L8CALLS', DataString, '1');
      val(DataString, BBSCfg.L8C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L9CALLS', DataString, '1');
      val(DataString, BBSCfg.L9C, CodeData);
      *)
      { [MISC] }
       ProfileStatus := GetProfileString('linux', 'MISC' , 'PAUSEPAGE', PausePage, '[PAUSED]');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SYSOPMENU', SysopMenu, '[!] Sysop Menu');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'COMMANDNOTFOUND', CommandNotFound, 'Command Not Found');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME1', ShowTime1, 'Online Time ');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME2', ShowTime2, ' Minutes, With ');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME3', ShowTime3, ' Left');
       (*
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWWHO', DataString, '2');
       val(DataString, BBSCfg.ShowIP, CodeData);
       *)
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWIPMSG', BBSCfg.ShowIPMsg, '0.0.0.0');
       { [DIRECTORYLIST] }
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'NEXT', DataString, 'N');
       DNext := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'UP', DataString, '8');
       DUp := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'FIRECTORYLIST' , 'DOWN', DataString, '2');
       DDown := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTION', DataString, 'A');
       DAction := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'STOP', DataString, 'S');
       DStop := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'DOWNLOAD', DataString, 'D');
       DDownload := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'VIEW', DataString, 'V');
       DFileView := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'DContinue', DataString, '');
       DContinue := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'LFILEPROMPT1', DLFilePrompt1, '[N] Next [8] Up [2] Down [A] Action [S] Stop');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTIONPROMPT1', ActionPrompt1, '[D] Downloaf [V]View File [ENTER] Continue');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'LFILEPROMPT2', DLFilePrompt2, 'Select :');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTIONPROMPT2', ActionPrompt2, 'Select :');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD1', DFileHead1, ' ');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD2', DFileHead2, 'File List..');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD3', DFileHead3, ' ');
     { [LISTFILES] }
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'FILETAG', TagFile, 'T');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'FILEVIEW', FileView, 'V');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'FILERELIST', FileRelist, 'R');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'FILELISTSTOP', FilelistStop, 'S');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'LFILEPROMPT1', LFilePrompt1, 'T - V - R');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'LFILEPROMPT2', LFilePrompt2, 'Select :');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'VIEWFILE', ViewFile, 'Enter Number To View : ');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'LFILEHEAD1', FileHead1, ' ');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'LFILEHEAD2', FileHead2, 'File List..');
       ProfileStatus := GetProfileString('linux', 'LISTFILES' , 'LFILEHEAD3', FileHead3, ' ');
     { [FILEVIEW] }
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'VTAGFILE', VTagFile, 'T');
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'VFILEPROMPT1', VFilePrompt1, 'T - ENTER ');
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'VFILEPROMPT2', VFilePrompt2, 'Select : ');
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'UPLOADBY', UpLoadBy, 'Uploaded By');
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'DOWNTIME', DownTime, 'Download Time');
       ProfileStatus := GetProfileString('linux', 'FILEVIEW' , 'DOWNMINUTES', DownMinutes, 'Minutes');
     { [MAINFILEAREA] }
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MQUIT', MQuit, 'Q');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MFILEPROMPT', MFilePrompt, 'Number or Q - Quit : ');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MFILEHEAD1', MFileHead1, ' ');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MFILEHEAD2', MFileHead2, ' Current Main File Areas');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MFILEHEAD3', MFileHead3, ' ');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MOPEN', MOpen, 'OPEN');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MCLOSED', MClosed, 'CLOSED');
       ProfileStatus := GetProfileString('linux', 'MAINFILEAREA' , 'MCURRENTAREA', MCurrentArea, 'Current Area : ');
     { [SUBFILEAREA] }
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'SAREA', SAREA, '?');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'SFILEPROMPT', SFilePrompt, 'Enter Number or ? List Areas : ');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'SFILEHEAD1', SFileHead1, ' ');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'SFILEHEAD2', SFileHead2, ' Current File Areas ');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'SFILEHEAD3', SFileHead3, ' ');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'NOACCESS', NoAccess, 'Access Denied');
       ProfileStatus := GetProfileString('linux', 'SUBFILEAREA' , 'INVALIDAREA', InvalidArea, 'Area Not Found');
       { [SENDMAIL] }
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORT', MailAbort, 'A');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILSAVE', MailSave, 'S');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILEDIT', MailEdit, 'E');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILVIEW', MailView, 'V');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTYES', MailAbortYes, 'Y');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTNO', MailAbortNo, 'N');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILPROMPT1', MailPrompt1, 'A - S - E - V');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILPROMPT2', MailPrompt2, 'Select : ');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILHEAD1', MailHead1, 'Press Enter On A Empty Line Finish');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILHEAD2', MailHead2, 'Max 25 Lines 65 Chars Per Line');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILSAVED', MailSaved, 'Mail Saved');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTED', MailAborted, 'Abort Mail (Y / N) : ');
       { [READMAIL] }
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'MAILCONTINUE', MailContinue, 'C');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'MAILREAD', MailRead, 'A');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'MAILDELETE', MailDelete, 'D');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'MAILREPLY', MailReply, 'R');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'RMAILPROMPT1', RMailPrompt1, 'C - A - D - R');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'RMAILPROMPT2', RMailPrompt2, 'Select : ');
       ProfileStatus := GetProfileString('linux', 'READMAIL' , 'MAILDELETED', MailDeleted, 'Mail Deleted');
       { [FORUMMSGLIST] }
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGVIEW', MsgView, 'V');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGRELIST', MsgReList, 'R');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGLISTSTOP', MsgListStop, 'S');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGPROMPT1', MsgPrompt1, 'NO PROMPT - SEE LINUX.INI');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGPROMPT2', MsgPrompt2, 'NO PROMPT - SEE LINUX.INI');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGVIEWPOST', MsgViewPost, 'Enter Post No : ');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGLHEAD1', MsgLHead1, 'Forum Messages');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGLHEAD2', MsgLHead2, 'ID POST');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGLIST' , 'MSGLHEAD3', MsgLHead3, '------------------->');
       { [FORUMMSGREAD] }
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRREPLY', MsgRReply, 'R');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRNEXT', MsgRNext, 'N');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRRPREV', MsgRPrev, 'P');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGREXIT', MsgRExit, 'R');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRMSG1', MsgRMsg1, 'Message');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRMSG2', MsgRMsg2, '/');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRNO', MsgRNo, 'There are no more messages');
       ProfileStatus := GetProfileString('linux', 'FORUMMSGREAD' , 'MSGRPROMPT1', MsgRPrompt1, '[R] Reply to post [N] Read next msg [P] Previous msg [E] Exit');
      {$ELSE}
      { PORT.INI }
      { [COMPORT] }
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'PORT', DataString, '1');
       val(DataString, ComPort, CodeData);
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'ADDRESS', DataString, '$2F8');
       val(DataString, PortAddress, CodeData);
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'IRQ', DataString, '3');
       val(DataString, Irq, CodeData);
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'BAUDRATE', DataString, '9600');
       val(DataString, BaudRate, CodeData);
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'PARITY', DataString, 'N');
       Parity := DataString[1];
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'DATABITS', DataString, '8');
       val(DataString, DataBits, CodeData);
       ProfileStatus := GetProfileString(Portini, 'COMPORT' , 'STOPBITS', DataString, '1');
       val(DataString, StopBits, CodeData);
      { SAURON.INI }
      { [MISC] }
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'PAUSEPAGE', PausePage, '[PAUSED]');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'SYSOPMENU', SysopMenu, '[!] Sysop Menu');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'COMMANDNOTFOUND', CommandNotFound, 'Command Not Found');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'SHOWTIME1', ShowTime1, 'Online Time ');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'SHOWTIME2', ShowTime2, ' Minutes, With ');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'SHOWTIME3', ShowTime3, ' Left');
       ProfileStatus := GetProfileString('SAURON', 'MISC' , 'INVALIDPASSWORD', InvalidPassword, 'Incorrect Password');
      { [SENDMAIL] }
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILABORT', MailAbort, 'A');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILSAVE', MailSave, 'S');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILEDIT', MailEdit, 'E');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILVIEW', MailView, 'V');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILABORTYES', MailAbortYes, 'Y');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILABORTNO', MailAbortNo, 'N');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILPROMPT1', MailPrompt1, 'A - S - E - V');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILPROMPT2', MailPrompt2, 'Select : ');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILHEAD1', MailHead1, 'Press Enter On A Empty Line Finish');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILHEAD2', MailHead2, 'Max 25 Lines 65 Chars Per Line');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILSAVED', MailSaved, 'Mail Saved');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILABORTED', MailAborted, 'Abort Mail (Y / N) : ');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILERROR', MailError, 'Sorry Mail Box Full');
       ProfileStatus := GetProfileString('SAURON', 'SENDMAIL' , 'MAILUSERERROR', MailUserError, 'Invalid User Number');
     { [READMAIL] }
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'MAILCONTINUE', MailContinue, 'C');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'MAILREAD', MailRead, 'A');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'MAILDELETE', MailDelete, 'D');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'MAILREPLY', MailReply, 'R');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'RMAILPROMPT1', RMailPrompt1, 'C - A - D - R');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'RMAILPROMPT2', RMailPrompt2, 'Select : ');
       ProfileStatus := GetProfileString('SAURON', 'READMAIL' , 'MAILDELETED', MailDeleted, 'Mail Deleted');
     { [LISTFILES] }
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILETAG', TagFile, 'T');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILEVIEW', FileView, 'V');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILERELIST', FileRelist, 'R');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILELISTSTOP', FilelistStop, 'S');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'LFILEPROMPT1', LFilePrompt1, 'T - V - R');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'LFILEPROMPT2', LFilePrompt2, 'Select :');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'VIEWFILE', ViewFile, 'Enter Number To View : ');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILEHEAD1', FileHead1, ' ');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILEHEAD2', FileHead2, 'File List..');
       ProfileStatus := GetProfileString('SAURON', 'LISTFILES' , 'FILEHEAD3', FileHead3, ' ');
     { [FILEVIEW] }
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'VTAGFILE', VTagFile, 'T');
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'VFILEPROMPT1', VFilePrompt1, 'T - ENTER ');
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'VFILEPROMPT2', VFilePrompt2, 'Select : ');
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'UPLOADBY', UpLoadBy, 'Uploaded By');
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'DOWNTIME', DownTime, 'Download Time');
       ProfileStatus := GetProfileString('SAURON', 'FILEVIEW' , 'DOWNMINUTES', DownMinutes, 'Minutes');
     { [MAINFILEAREA] }
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MQUIT', MQuit, 'Q');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MFILEPROMPT', MFilePrompt, 'Number or Q - Quit : ');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MFILEHEAD1', MFileHead1, ' ');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MFILEHEAD2', MFileHead2, ' Current Main File Areas');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MFILEHEAD3', MFileHead3, ' ');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MOPEN', MOpen, 'OPEN');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MCLOSED', MClosed, 'CLOSED');
       ProfileStatus := GetProfileString('SAURON', 'MAINFILEAREA' , 'MCURRENTAREA', MCurrentArea, 'Current Area : ');
     { [SUBFILEAREA] }
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'SAREA', SAREA, '?');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'SFILEPROMPT', SFilePrompt, 'Enter Number or ? List Areas : ');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'SFILEHEAD1', SFileHead1, ' ');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'SFILEHEAD2', SFileHead2, ' Current File Areas ');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'SFILEHEAD3', SFileHead3, ' ');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'NOACCESS', NoAccess, 'Access Denied');
       ProfileStatus := GetProfileString('SAURON', 'SUBFILEAREA' , 'INVALIDAREA', InvalidArea, 'Area Not Found');
  {$ENDIF}
  DisposeINICollection;
end;
(*..........................................................................*)
{ OCT 97 - Release Notes                                         }
{ This was added because I had a trouble linking in error.pas    }
procedure ErrorString(ErrorNumber : Byte);
var
  Strgs,
  ErrorStrings : string;
begin
  Str(ErrorNumber, Strgs);
  Case ErrorNumber of
  $02 : ErrorStrings := 'File not found';
  $03 : ErrorStrings := 'Path not found';
  $04 : ErrorStrings := 'To many open Files';
  $05 : ErrorStrings := 'Access denied';
  $06 : ErrorStrings := 'Invalid file handle';
  $07 : ErrorStrings := 'Memory blocks invalid';
  $08 : ErrorStrings := 'Not enough memory';
  $09 : ErrorStrings := 'Memory blocks invalid';
  $0A : ErrorStrings := 'Invalid environment';
  $0B : ErrorStrings := 'Invalid format';
  $0C : ErrorStrings := 'Invalid file Access code';
  $0F : ErrorStrings := 'Invalid drive number';
  $10 : ErrorStrings := 'Cannot remove current directory';
  $11 : ErrorStrings := 'Cannot rename across drives';
  $12 : ErrorStrings := 'No more files';
  $13 : ErrorStrings := 'Disk write protected';
  $15 : ErrorStrings := 'Drive not ready';
  $16 : ErrorStrings := 'Bad command';
  $17 : ErrorStrings := 'Data error on disk';
  $19 : ErrorStrings := 'Seek error';
  $1A : ErrorStrings := 'Bad media';
  $1B : ErrorStrings := 'Sector not found';
  $1D : ErrorStrings := 'Unable to write to disk';
  $1E : ErrorStrings := 'Unable to read from disk';
  $20 : ErrorStrings := 'File sharing error';
  $21 : ErrorStrings := 'File locking error';
  $23 : ErrorStrings := 'No free FCBs';
  $24 : ErrorStrings := 'File sharing buffer full';
  $35 : ErrorStrings := 'Bad network patch';
  $36 : ErrorStrings := 'Network busy';
  $37 : ErrorStrings := 'Device does not exist';
  $39 : ErrorStrings := 'Hardware error';
  $64 : ErrorStrings := 'Disk read error';
  $65 : ErrorStrings := 'Disk write error';
  $66 : ErrorStrings := 'File not assigned';
  $67 : ErrorStrings := 'File not open';
  $68 : ErrorStrings := 'File not open for input';
  $69 : ErrorStrings := 'File not open for output';
  Else
    ErrorStrings := ' ('+ Strgs + ')unKown Error';
  end; { Case End }
  writeln('(',Strgs,') ', ErrorStrings);
  writeln;
end;
(*..........................................................................*)
{ Open All Data Files needed To Run Sauron BBS }
{ Not used by the linux version }
procedure OpenUserTemp;
begin
  Assign(DataTemp,'USERLOG.TMP');
  {$I-} Reset(DataTemp); {$I+}
  FileError := IOResult;
  if FileError <> 0 then
      begin
        Writeln('Unable To Open USERLOG.TMP');
        ErrorString(FileError);
        Halt(1);
      end;
end;
(*..........................................................................*)
{ Not used by the linux version }
procedure CloseUserTemp;
begin
  Close(DataTemp);
end;
(*..........................................................................*)
{ Return next guest number }
function GetNextGuestNumber : integer;
var
  results : recbuf;
  rows    : rowbuf;
  strgs   : string;
begin
   query := 'select guestno from bbs_config';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then
        begin
          rows := sql_fetch_row(results);
          while rows <> nil do
           begin
            val(strpas(rows[0]), GetNextGuestNumber, valcode);
            rows := sql_fetch_row(results);
           end;
          if results <> nil then
           begin
             inc(GetNextGuestNumber);
             { if our guest limit reaches 999, then reset the clock }
             { hopefully, old users would have been removed         }
             if GetNextGuestNumber = 1000 then GetNextGuestNumber := 1;
           end
          else
           begin
             GetNextGuestNumber := 0;
           end;
          { clear memory }
          sql_free_results(results);
          { Update the SQL table with the new number }
          str(GetNextGuestNumber, Strgs);
          querystr := 'update bbs_config set guestno=' + strgs;
          query := pchar(querystr);
          if sql_query(query) then
           begin
             { Check the table updated }
             if sql_affected_rows = 0 then
              begin
                //LogError('Error updating next guest number - see sql error log');
                //writeln(querystr + ' - ' + sqlerror);
              end;
           end
          else
           begin
             { SQL Error }
             //writeln(querystr + ' - ' + sqlerror);
           end;
        end;
     end
   else
     begin
       GetNextGuestNumber := 0;
     end;
end;
(*..........................................................................*)
function OpenUserData(UID : integer; Guest : boolean) : boolean;
var
  results : recbuf;
  rows    : rowbuf;
  suid    : string;
  valnum  : integer;
begin
  if Guest then
   begin
     str(GuestUID, suid);
     querystr := 'select * from user_data where guestip='''+remotehost+''' and uid=' + suid;
   end
  else
   begin
    str(uid,suid);
    querystr := 'select * from user_data where uid=' + suid;
   end;
  query := pchar(querystr);
  if sql_query(query) then
   begin
     results := sql_store_results;
     if sql_affected_rows > 0 then
      begin
        rows := sql_fetch_row(results);
        while rows <> nil do
         begin
           //val(strpas(rows[0]), UserInfo.UserUID, valcode);
           UserInfo.UserUID := UID;
           UserInfo.UserAcc := strpas(rows[1]);
           val(rows[2], Userinfo.UserAnsi, valcode);
           val(rows[3], Userinfo.UserColour, valcode);
           val(rows[4], Userinfo.UserLevel, valcode);
           val(rows[5], Userinfo.UserTime, valcode);
           val(rows[6], Userinfo.UserTimeStamp, valcode);
           //writeln('TIME ', rows[6]);
           //writeln(querystr);
           //delay(1500);
           val(rows[7], Userinfo.UserLogon, valcode);
           val(rows[8], valnum, valcode);
           if valnum = 1 then UserInfo.UserReg := true
            else UserInfo.UserReg := false;
           UserInfo.UserName := strpas(rows[9]);
           UserInfo.UserNameFull := strpas(rows[10]);
           UserInfo.UserPass := strpas(rows[11]);
           UserInfo.UserTown := strpas(rows[12]);
           UserInfo.UserEmail := strpas(rows[13]);
           UserInfo.UserInfo1 := strpas(rows[14]);
           UserInfo.UserInfo2 := strpas(rows[15]);
           UserInfo.UserInfo3 := strpas(rows[16]);
           UserInfo.UserInfo4 := strpas(rows[17]);
           UserInfo.UserInfo5 := strpas(rows[18]);
           UserInfo.UserInfo6 := strpas(rows[19]);
           UserInfo.UserInfo7 := strpas(rows[20]);
           UserInfo.UserInfo8 := strpas(rows[21]);
           val(rows[22], valnum, valcode);
           if valnum = 1 then UserInfo.UserCls := true
            else UserInfo.UserCls := false;
           val(rows[23], Userinfo.UserLines, valcode);
           val(rows[24], Userinfo.Bulletin, valcode);
           val(rows[25], Userinfo.MailCount, valcode);
           val(rows[26], Userinfo.LastMsgNum, valcode);
           val(strpas(rows[27]), Userinfo.Calls, valcode);
           val(strpas(rows[28]), Userinfo.CallsToday, valcode);
           //write('CALLS = ', rows[28], 'USER = ',Userinfo.CallsToday);
           //delay(1500);
           UserInfo.LCallDate := strpas(rows[29]);
           UserInfo.LastCall := strpas(rows[30]);
           val(rows[31], Userinfo.CallNumber, valcode);
           val(rows[32], Userinfo.TimeOnline, valcode);
           UserInfo.FileArea := 0;
           val(rows[33], Userinfo.Downloads, valcode);
           val(rows[34], Userinfo.Uploads, valcode);
           val(rows[35], Userinfo.BytesDl, valcode);
           val(rows[36], Userinfo.BytesUl, valcode);
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
        OpenUserData := true;
      end
     else
      begin
        { sql result error  }
        OpenUserData := false;
      end;
   end
  else
   begin
     { sql error }
     OpenUserData := false;
   end;
end;
(*..........................................................................*)
procedure OpenDataFiles;
var
  Data_File,
  GuestNo   : string;
  { New Guest Data  }
  GuestUser : boolean;
  uid,
  ansi,
  colour,
  level,
  time,
  timestamp,
  logon,
  reg,
  cls,
  lines,
  bulletin,
  mailcount,
  lastmsgnum,
  calls,
  callstoday,
  callnumber,
  timeonline,
  downloads,
  uploads,
  bytesdl,
  bytesul    : string;
  q1, q2, q3,
  q4, q5, q6, q7 : ansistring;

begin
  GuestUser   := false;
  {$IFDEF _LINUX_ }
    Download_Script := '';
    File_Viewer	    := '';
  {$ENDIF}
  ScriptTitle := '';
  LastOnTime  := 0;
  StatsBox    := 1;
  FileNumber  := 0;
  LineCount   := 0;
  BBSLines    := 0;
  CurrentLine := 24;
  Carrier     := 0;
  LineBaud    := 38400;
  LastCall    := 0;
  CallAway    := 0;
  Echo        := True;
  NewUserKB   := false;
  Tagged      := True;
  PassEcho    := False;
  NoUpper     := False;
  FileError   := 0;
  ColourSelect := 1;
  AvatarChar  := 0;
  AvatarCode  := 0;
  AvatarCol   := 0;
  AnsiCode    := 0;
  AnsiDetect  := False;
  PromptQuote := True;
  ModemTimeOut := 5;
  Back := 0;
  Fore := White;
  Flash := 0;
  High := 0;
  UserNumber := 0;
  UserInfo.UserAnsi := 1; { Default User To ANSI }
  ConnectString := 'LOCAL';
  {$IFDEF _LINUX_}
    { If we are using guest accounts then open the data file }
    { based on the connecting host name }
    if fpGetUid = GuestUID then GuestUser := True;
    { Get User Records  }
    if OpenUserData(fpGetUID, GuestUser) then
      begin
        //writeln('oops..', guestuid, ' -  ',fpgetuid);
        //delay(2500);
      end
    else
      begin
        //writeln('GUESTUID SET IN LINUX.INI [', guestuid, '] -  CURRENT USER UID [',fpgetuid,']');
        //delay(2000);
        if fpGetUID = GuestUID then
          begin
             { As this is a new host, lets create a guest data file }
             UserInfo.UserUID    := GuestUID;
             UserInfo.UserAcc    := '0';     { Account Number }
    	     UserInfo.UserAnsi   := 1;     { Ansi or Avatar }
    	     UserInfo.UserColour := 1;          { Colour ON or OFF }
             UserInfo.UserTime   := fptime;
             UserInfo.UserTimeStamp  := fptime;
             UserInfo.UserLogon  := fptime;
    	     UserInfo.Userlevel  := BBSCfg.NuLevel ;
                UserInfo.UserReg    := False;
                (*
                inc(BBSCfg.GuestNo);
                str(BBSCfg.GuestNo, GuestNo);
                WriteProfileString('linux', 'CONFIG' , 'GUESTNO', GuestNo);
                *)
                str(GetNextGuestNumber, GuestNo);
    		UserInfo.UserName   := ThisUser + ' #' + GuestNo;
                UserInfo.UserNameFull := 'not set';
	        UserInfo.UserPass   := '';
		UserInfo.UserTown   := 'somewhere';
                UserInfo.UserEmail  := 'guest@foo.bar'; { Put domain into linux.ini }
    		UserInfo.UserInfo1  := 'null';
    		UserInfo.UserInfo2  := 'null';
    		UserInfo.UserInfo3  := 'null';
    		UserInfo.Userinfo4  := 'null';
    		UserInfo.Userinfo5  := 'null';
    		UserInfo.Userinfo6  := 'null';
    		UserInfo.Userinfo7  := 'null';
    		UserInfo.Userinfo8  := 'null';
    		UserInfo.UserCls    := true;      { Screen clear code to be sent }
    		UserInfo.UserLines  := 25;         { Lines of user terminal }
    		UserInfo.Bulletin   := 0;         { Current Bulletin Number Read }
    		UserInfo.MailCount  := 0;      { User Mail }
    		UserInfo.LastMsgNum := 0;
    		UserInfo.Calls      := 1;      { Calls to system }
    		UserInfo.CallsToday := 1;      { Calls today }
    		UserInfo.LCallDate  := 'First Call';   { Last call date }
    		UserInfo.LastCall   := 'First Call';
    		UserInfo.CallNumber := 0;
    		UserInfo.TimeOnLine := 0;
    		UserInfo.FileArea   := 0;      { Last file area visited - Will return user to this file area on next logon }
    		UserInfo.DownLoads  := 0;      { Number of downloads }
    		UserInfo.Uploads    := 0;      { Number of uploads }
    		UserInfo.BytesDL    := 0;      { Bytes downloaded }
    		UserInfo.BytesUL    := 0;      { Bytes uploaded }

                { convert ints to str }
                str(userinfo.useruid,uid);
                str(userinfo.useransi,ansi);
                str(userinfo.usercolour,colour);
                str(userinfo.userlevel,level);
                str(userinfo.usertime,time);
                str(userinfo.usertimestamp,timestamp);
                str(userinfo.userlogon,logon);
                if  userinfo.userreg then reg := '1'
                 else reg := '0';
                if userinfo.usercls then cls := '1'
                 else cls := '0';
                str(userinfo.userlines,lines);
                str(userinfo.bulletin,bulletin);
                str(userinfo.mailcount,mailcount);
                str(userinfo.lastmsgnum,lastmsgnum);
                str(userinfo.calls,calls);
                str(userinfo.callstoday,callstoday);
                str(userinfo.callnumber,callnumber);
                str(userinfo.timeonline,timeonline);
                str(userinfo.downloads,downloads);
                str(userinfo.uploads,uploads);
                str(userinfo.bytesdl,bytesdl);
                str(userinfo.bytesul,bytesul);
                { Setup SQL query for the new guest  }
                q1 := 'insert into user_data values('+uid+','''+userinfo.useracc+''','+ansi+','+colour+','+level+','+time+','+timestamp;
                q2 := ','+logon+','+reg+','''+userinfo.username+''','''+userinfo.usernamefull+''','''+userinfo.userpass+''','''+userinfo.usertown+''',';
                q3 := ''''+userinfo.useremail+''','''+userinfo.userinfo1+''','''+userinfo.userinfo2+''','''+userinfo.userinfo3+''',';
                q4 := ''''+userinfo.userinfo4+''','''+userinfo.userinfo5+''','''+userinfo.userinfo6+''','''+userinfo.userinfo7+''','''+userinfo.userinfo8+''',';
                q5 := ''+cls+','+lines+','+bulletin+','+mailcount+','+lastmsgnum+','+calls+','+callstoday+','''+userinfo.lcalldate+''',';
                q6 := ''''+userinfo.lastcall+''','+callnumber+','+timeonline+','+downloads+','+uploads+','+bytesdl;
                q7 := ','+bytesul+','''+GuestNo+''','''+remotehost+''')';
                querystr := q1 + q2 + q3 + q4 + q5 + q6 + q7;
                query := pchar(querystr);
                if not sql_query(query) then
                  begin
                    writeln('SQL error..');
                    writeln(sqlerror);
                    writeln;
                    writeln(query);
                    halt;
                  end;
          end
        else
          begin
            writeln('ERROR - user data is either not found in the SQL DB, or the GUESTUID is not set in Linux.ini');
            Writeln;
           {$I+}
           Halt(1);
         end;
      end;
  {$ELSE}
    Assign(DataFile, BBSCfg.DataDir + 'userlog.dat');
    {$I-} Reset(DataFile); {$I+}
    FileError := IOResult;
    if FileError = 0 then
        begin
           UserSize := FileSize(DataFile);
            If UserSize <> 0 then
             begin
               Seek(DataFile, 0);
               Read(DataFile, UserInfo);
             end;
           end
        else
           begin
             OnCursor;
             OffCursor;
             Box(15, 10, 65, 16, 78, 1, True);
             TextBackground(Red);
             Textcolor(White);
             ClrScr;
             Write('   ERROR : ');
             ErrorString(FileError);
             Writeln('                    USERLOG.DAT');
             Writeln('               PRESS ANY KEY TO EXIT');
             Repeat Until Keypressed;
             Halt(1);
           end;
    Assign(DataTemp,BBSCfg.DataDir + 'userlog.tmp');
    {$I-} Rewrite(DataTemp); {$I+}
    FileError := IOResult;
    if FileError <> 0 then
        begin
          OnCursor;
          OffCursor;
          Box(15, 10, 65, 16, 78, 1, True);
          TextBackground(Red);
          Textcolor(White);
          ClrScr;
          Write('   ERROR : ');
          ErrorString(FileError);
          Writeln('                    USERLOG.TMP');
          Writeln('               PRESS ANY KEY TO EXIT');
          Repeat Until Keypressed;
          Halt(1);
	end;
 {$ENDIF}


  (* --> TO BE REMOVED
   If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'simpbbs.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'simpbbs.dat';
  Assign(BBSini, Data_File);
  {$I-} Reset(BBSini);
  FileError := IOResult;
  if FileError = 0 then
    begin
      Seek(BBSINI, 0);
      Read(BBSINI, BBSInfo);
      {$I+}
    end
  else
    begin
      {$IFDEF _LINUX_}
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      ClrScr;
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                     SIMPBBS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;
   <--- *)


  { ---------------------------------------------------------------------------}
  { May not need to open this DB here, check file code }
  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'areas.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'areas.dat';
  Assign(CatArea, Data_File);
  {$I-} Reset(CatArea);
  FileError := IOResult;
  if FileError = 0 then
    begin
      if FileSize(CatArea) <> 0 then
       begin
         Seek(CatArea, 0);
         Read(CatArea, SAreas);
         {$I+}
       end;
    end
  else
    begin
      {$IFDEF _LINUX_}
        Window(15,10, 64, 15);
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                     AREAS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;
  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'area.1'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'area.1';
  Assign(FileArea, Data_File);   { Open Default File Area }
  {$I-} Reset(FileArea);
  FileError := IOResult;
  if FileError = 0 then
    begin
      AreaSize := FileSize(FileArea);
      if AreaSize <> 0 then
       begin
         Seek(FileArea, 0);
         Read(FileArea, Areas);
         {$I+}
       end;
    end
  else
    begin
      {$IFDEF _LINUX_}
        Window(15,10, 64, 15);
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln;
      Writeln('                       AREA.1');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;
  { ---------------------------------------------------------------------------}
(* NOT NEEDED...
  Assign(SBBSCfg, 'sauron.cfg');
  {$I-} Reset(sbbscfg); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      If FileSize(SBBSCfg) <> 0 then
        begin
          Seek(sbbscfg, 0);
          Read(sbbscfg, bbscfg);
        end;
    end
  else
    begin
      {$IFDEF _LINUX_}
        Window(15,10, 64, 15);
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                     sauron.cfg');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
 *)

  
  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'message.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'message.dat';
  Assign(MsgFile, Data_File);
  {$I-} Reset(MsgFile);
  FileError := IOResult;
  if FileError = 0 then
    begin
      If FileSize(MsgFile) <> 0 then
        begin
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
          {$I+}
        end;
    end
  else
    begin
      {$IFDEF _LINUX_}
        Window(15,10, 64, 15);
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                    MESSAGE.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'msindex.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'msindex.dat';
  Assign(MsgNum, Data_File);
  {$I-} Reset(MsgNum);
  FileError := IOResult;
  if IOResult = 0 then
    begin
      If FileSize(MsgNum) <> 0 then
        begin
          Seek(MsgNum, 0);
          Read(MsgNum, MsIndex);
          {$I+}
        end;
    end
  else
    begin
      {$IFDEF _LINUX_}
        Window(15,10, 64, 15);
      {$ELSE}
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
      {$ENDIF}
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR ACCESSING [', Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                    MSINDEX.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  (*
  UserInfo.UserInfo1  := 'NULL';
  UserInfo.UserInfo2  := 'NULL';
  serInfo.UserInfo3  := 'NULL';
  UserInfo.Userinfo4  := 'NULL';
  UserInfo.Userinfo5  := 'NULL';
  UserInfo.Userinfo6  := 'NULL';
  UserInfo.Userinfo7  := 'NULL';
  UserInfo.Userinfo8  := 'NULL';
  if UserSize <> 0 then { BackUp UserFile }
    begin
      for Loop := 0 to UserSize - 1 do
        begin
          {$I-}
          Seek(DataFile, Loop);
          Read(DataFile, UserInfo);
          Seek(DataTemp, Loop);
          Write(DataTemp, UserInfo);
          {$I+}
        end;
    end;
   {$I-} Close(DataTemp); {$I+}
    *)
  {$IFDEF _LINUX_ }

      { Check to see if 24 hours has passed since last login }
      { if so, reset call allowances }
      if  (UserInfo.UserTimestamp + 86400) >= fptime then
       begin
         LastOnTime  := UserInfo.TimeOnLine;
       end
      else
       begin
         LastOnTime := 0;
         UserInfo.UserTimeStamp := fptime;
         UserInfo.Callstoday := 1;
       end;

      CallAway            := BBSCfg.Calls;
      //BBSCfg.Calls        := BBSCfg.Calls + 1;
      //ProfileStatus := WriteProfileInt('linux', 'CONFIG' , 'CALLS', BBSCfg.Calls);

//      val(DataString, BBSCfg.Calls, CodeData);
      LastCaller          := BBSInfo.Line;
      LastCallerTown      := BBSInfo.From;
      LastCall            := UserInfo.CallNumber;
      LastCalls           := UserInfo.LastCall;
(*
      UserInfo.CallNumber := BBSCfg.Calls;
      UpdateUserData(CALLNUMBER, UserInfo.CallNumber, '');

*)
  {$ENDIF}
end;
(*..........................................................................*)
function MinutesPast: word;
Var
  M  : Word;
begin
  M := 0;
  { GetTime(H,M,S,Hund); }
  If M <> StartTimes then
    begin
      Inc(Minutes);
      StartTimes := M;
    end;
  MinutesPast := Minutes;
end;
(*..........................................................................*)
procedure CloseDataFiles;
var
  Code : Integer;
begin
//writeln('USERINFO ', userinfo.useruid);

(*
  { dispose of PCHAR Vars }
  StrDispose(BBSCfg.SQLServer);
  StrDispose(BBSCfg.SQLUser);
  StrDispose(BBSCfg.SQLPass);
  StrDispose(BBSCfg.SQLDb);
  { Close Connection to SQL server }
  sql_close;
*)
  {$IFDEF _LINUX_}
    Code := MinutesPast;
    BBSInfo.Time := Code;
    BBSInfo.Line := UserInfo.UserName;
    BBSInfo.From := UserInfo.UserTown;
    BBSInfo.Date := Today;
(*
    UserInfo.Lastcall := today;
    UserInfo.Calls := UserInfo.Calls + 1;
    UserInfo.CallsToday := UserInfo.CallsToday + 1;
    //UserInfo.LastMsgNum := MsIndex.MsgNumber;
    UserInfo.FileArea   := Areas.DirNo - 1;
    UserInfo.TimeOnline := LastOnTime + Code;
    UserInfo.UserLogon  := fptime;
*)
    {$I-}
(*
      Seek(BBSini, 0);
      Write(BBSINI, BBSInfo);
      Seek(DataFile, 0);
      Write(DataFile, UserInfo);
*)
    {$I+}
   { Close(BBSINI); }
    Close(FileArea);
    Close(CatArea);
    Close(MsgNum);
    Close(MsgFile);
   { Close(SBBSCfg); }
   { Close(DataFile);}
  {$ELSE}
   Code := MinutesPast;

   UserInfo.LastMsgNum := MsIndex.MsgNumber;
   UserInfo.FileArea   := Areas.DirNo - 1;
   UserInfo.TimeOnline := LastOnTime + Code;
   if UserNumber <> 0 then
     begin
       BBSInfo.Time := Code;
       BBSInfo.Line := UserInfo.UserName;
       BBSInfo.From := UserInfo.UserTown;
       BBSInfo.Date := Today;
       {$I-}
       Seek(BBSini, 0);
       Write(BBSINI, BBSInfo);
       Seek(DataFile, UserNumber);
       Write(DataFile, UserInfo);
       {$I+}
     end;
   for Loop := 1 to UserSize - 1 do
      begin
        OpenUserTemp;
        if Loop <> UserNumber then
          begin
            {$I-}
            Seek(DataTemp, Loop);
            If FilePos(DataTemp) = Loop Then Read(DataTemp, UserTemp);
            Seek(DataFile, Loop);
            If FilePos(DataFile) = Loop Then Write(DataFile, UserTemp);
            {$I+}
          end;
       CloseUserTemp;
     end;
   UserInfo.UserAcc    := '0';
   UserInfo.UserAnsi   := 1;
   UserInfo.UserColour := 0;
   UserInfo.Userlevel  := 0;
   UserInfo.UserName   := 'SYSTEM';
   UserInfo.UserPass   := 'SAURON';
   UserInfo.UserTown   := '    ';
   UserInfo.UserInfo1  := 'NULL';
   UserInfo.UserInfo2  := 'NULL';
   UserInfo.UserInfo3  := 'NULL';
   UserInfo.Userinfo4  := 'NULL';
   UserInfo.Userinfo5  := 'NULL';
   UserInfo.Userinfo6  := 'NULL';
   UserInfo.Userinfo7  := 'NULL';
   UserInfo.Userinfo8  := 'NULL';
   UserInfo.UserCls    := True;
   UserInfo.Bulletin   := 0;
   UserInfo.UserLines  := 24;
   UserInfo.MailCount  := 0;      { User Mail }
   UserInfo.LastMsgNum := 0;
   UserInfo.Calls      := 0;
   UserInfo.CallsToday := 0;
   UserInfo. LCallDate  := '1/1/95';
   UserInfo.LastCall   := '1st January 1995';
   UserInfo.CallNumber := 0;
   UserInfo.TimeOnLine := 0;
   UserInfo.FileArea   := 0;
   UserInfo.DownLoads  := 0;
   UserInfo.Uploads    := 0;
   UserInfo.BytesDL    := 0;
   UserInfo.BytesUL   ~ := 0;
   {$I-}
       Seek(DataFile, 0);
       If FilePos(DataFile) = 0 Then Write(DataFile, UserInfo);
       Close(BBSINI);
       Close(FileArea);
       Close(CatArea);
       Close(MsgNum);
       Close(MsgFile);
       Close(SBBSCfg);
       Close(DataFile);
   {$I+}
  {$ENDIF}
end;
end.

