(* $Id: createus.pp,v 1.6 2008-02-20 23:50:51 simon Exp $                       *)
(*..........................................................................*)
(*        								    *)
(* MODULE	:   CREATEUSER.PP      			                    *)
(*									    *)
(* DESCRIPTION	:   CREATES USERS DATA FILE IN HOME DIRECTORY               *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 2.0.4                                 *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1998 - 2007                                *)
(*									    *)
(*..........................................................................*)
(* History                                                                  *)
(* 1 May 1998 - First Version                                               *)
(*..........................................................................*)
(*

  $Log: createus.pp,v $
  Revision 1.6  2008-02-20 23:50:51  simon
  update

  Revision 1.5  2008-02-19 21:58:07  simon
  see todo.txt

  Revision 1.3  2008/02/11 23:23:20  simon
  Added mail options

  Revision 1.2  2008-02-11 23:20:29  simon
  Removed old unit file


*)

Program CREATEUSR;

uses linux, strings, dos, crt, dates, baseunix;

type
  User = record
 UserUID    : integer;       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserTime   : time_t;       { Date user account Created }
    UserTimestamp : time_t;    { epochtime of user login, used to reset daily call/time allowance }
    //UserLogon  : time_t;       { epochtime of user login }
    UserReg    : boolean;      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;

type
  UserPasswd = record
    pw_name,
    pw_passwd : pchar;
    pw_uid,
    pw_gid    : word;
    pw_gecos,
    pw_dir,
    pw_shell  : pchar;
end;
TUserPasswd = ^UserPasswd;

function getpwuid(user_id : longint) : TUserPasswd; cdecl; external;
function getpwnam(UName : PChar) : TUserPasswd ; cdecl; external;


var
  UserInfo  : User;
  DataFile  : file of User;

(*..........................................................................*)
procedure Header;
begin
  Clrscr();
  TextBackground(7);
  TextColor(0);
  writeln(' Sauron Linux BBS Createuser                      (C)opyright Simon C Horton 1998 - 2007 ');
  TextBackground(0);
  TextColor(7);
  writeln;
  writeln(' Will create Maxx BBS user data file in user home directory, if file already');
  writeln(' exists then the file will be overwritten..');
  writeln;
end;
(*..........................................................................*)
procedure Show_User(User: string);
var
  User_Data : TUserPasswd;
  UserFile  : string;
  AUname  : pchar;
  Uid	  : integer;

begin
{  User_Data := getpwuid(User); }
  AUname := StrAlloc(Length(User) + 1);
  StrPCopy(AUname, User);
  if getpwnam(AUname) = NIL then
    begin
      Header;
      writeln('User [',User,'] not found..!');
	 { Get next available UID }
         Uid := 1000;
	 repeat
	  inc(Uid);
	  write('UID =', Uid);
          User_Data := getpwuid(Uid);
          writeln('Username   := ', User_Data^.pw_name);

	 until getpwuid(Uid) = NIL;

    end
  else
    begin
      User_Data := getpwnam(AUname);
      writeln('..[',User_Data^.pw_shell,']');
      {UserFile =  StrPas(User_Data^.pw_shell) + '/userinfo.data';}
      Assign(DataFile, User_Data^.pw_shell + '/userinfo.data');
      {$I-}
        reset(DataFile);
	read(DataFile, UserInfo);
      {$I+}
      if IOResult = 0 then
       begin
         writeln('Username   := ', UserInfo.UserName);
	 writeln('User Level := ', UserInfo.Userlevel);
	 writeln('Username := ', UserInfo.UserName);
       end
      else
       begin
         Writeln('Error reading userinfo.data');
       end;
   Close(DataFile);

    end;
end;
(*..........................................................................*)
procedure Create_User;
var
  User_Data : TUserPasswd;
  UserFile  : string;
  UserName  : pchar;
begin
  User_Data := getpwuid(fpGetUID);
  UserFile  := StrPas(User_Data^.pw_shell) + '/userinfo.data';
  Assign(DataFile, UserFile);
  {$I-} Rewrite(DataFile); {$I+}
     if IOResult = 0 then
      begin
        UserInfo.UserUID    := fpGetUID;
        UserInfo.UserAcc    := '0';
        UserInfo.UserAnsi   := 1;
        UserInfo.UserColour := 1;
        UserInfo.Userlevel  := 2;
        UserInfo.UserReg    := true;
        UserInfo.UserEmail  := 'foo@bar';
        UserInfo.UserName   := StrPas(User_Data^.pw_name);
        UserInfo.UserTimeStamp  := fptime;
        //UserInfo.UserLogon  := fptime;
        UserInfo.UserPass   := '***';
        UserInfo.UserTown   := 'NULL';
        UserInfo.UserInfo1  := 'NULL';
        UserInfo.UserInfo2  := 'NULL';
        UserInfo.UserInfo3  := 'NULL';
        UserInfo.Userinfo4  := 'NULL';
        UserInfo.Userinfo5  := 'NULL';
        UserInfo.Userinfo6  := 'NULL';
        UserInfo.Userinfo7  := 'NULL';
        UserInfo.Userinfo8  := 'NULL';
        UserInfo.UserCls    := True;
        UserInfo.Bulletin   := 0;
        UserInfo.UserLines  := 24;
        UserInfo.MailCount  := 0;      { User Mail }
        UserInfo.LastMsgNum := 0;
        UserInfo.Calls      := 0;
        UserInfo.CallsToday := 0;
        UserInfo. LCallDate  := CallDate;
        UserInfo.LastCall   := Today;
        UserInfo.CallNumber := 0;
        UserInfo.TimeOnLine := 0;
        UserInfo.FileArea   := 0;
        UserInfo.DownLoads  := 0;
        UserInfo.Uploads    := 0;
        UserInfo.BytesDL    := 0;
        UserInfo.BytesUL    := 0;
        write(DataFile, UserInfo);
        close(DataFile);
     end;
end;
(*..........................................................................*)
begin
  if (paramstr(1) = '--help') then Header
   else if (paramstr(1) = '--show') then Show_User(paramstr(2))
     else Create_User;
end.
