(* $Id: colours.pp,v 1.4 2008-02-19 21:58:07 simon Exp $                       *)
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   COLOURS.PAS     			                    *)
(*									    *)
(* DESCRIPTION	:   CONVERTS SAURON COLOUR CODES TO ANSI & AVT COLOUR CODES *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2008                                *)      
(*									    *)
(*..........................................................................*)
(*
  $Log: colours.pp,v $
  Revision 1.4  2008-02-19 21:58:07  simon
  see todo.txt

  Revision 1.2  2008/02/11 23:23:20  simon
  Added mail options

*)

Unit Colours;

Interface

{$IFDEF _LINUX_}
  Uses Data, Display;
{$ELSE}
  Uses Data, PIBAsync, CDrop, Display;
{$ENDIF}

procedure BlinkOn;
procedure BlinkOff;
procedure Colour(ChrCode : Byte);

implementation

var
  St : Byte;
(*..........................................................................*)
procedure Out(buffer : String);
Var
  Stringlen : Integer;
begin
  If Local Then
     begin
       Disp(Buffer);
     end
  Else
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Loop  := 1 to Stringlen do
          begin
	    {$IFDEF _LINUX_}
	      write(Buffer[Loop]);
            {$ELSE}
              If Async_Carrier_Drop then NoCarrier;
              Async_Send(Buffer[Loop]);
              { SendFChar(Ord(Buffer[Loop])); }
	      Disp(Buffer[Loop]);
            {$ENDIF}
          end;
      end;
end;
(*..........................................................................*)
procedure BlinkOn;
begin
  case UserInfo.UserAnsi of
    1 : begin
          Out(#27 + '[5m');
        end;
    2 : begin
        end;
  end; { Case end }
end;
(*..........................................................................*)
procedure BlinkOff;
begin
  case UserInfo.UserAnsi of
    1 : begin
          Out(#27 + '[0m');
        end;
    2 : begin
        end;
  end; { Case end }
end;
(*..........................................................................*)
procedure Colour(ChrCode : Byte);
begin
  If UserInfo.UserColour = 1 then
    begin
     If UserInfo.UserAnsi = 1 then { Display ANSI Colour }
        begin
          Case ChrCode of
            { Foreground Colour }
            224 : Out(#27 + '[1;30m'); { Black   }
            225 : Out(#27 + '[1;31m'); { Red     }
            226 : Out(#27 + '[1;32m'); { Green   }
            227 : Out(#27 + '[1;33m'); { Yellow  }
            228 : Out(#27 + '[1;34m'); { Blue    }
            229 : Out(#27 + '[1;35m'); { Magenta }
            230 : Out(#27 + '[1;36m'); { Cyan    }
            231 : Out(#27 + '[1;37m'); { White   }
            { Background Colour }
            232 : Out(#27 + '[1;40m'); { Black   }
            233 : Out(#27 + '[1;41m'); { Red     }
            234 : Out(#27 + '[1;42m'); { Green   }
            235 : Out(#27 + '[1;43m'); { Brown   }
            236 : Out(#27 + '[1;44m'); { Blue    }
            237 : Out(#27 + '[1;45m'); { Magenta }
            238 : Out(#27 + '[1;46m'); { Cyan    }
            239 : Out(#27 + '[1;47m'); { White   }
         Else
            begin
              { Null If Colour Code Not Found }
            end;
          end; { Case End }
        end
      Else
        begin
          If UserInfo.UserAnsi = 2 then { Display AVATAR Colour }
            begin
              Case ChrCode of
                { Foreground Colour }
                224 : begin
                        St := AvatarCol * 16 + 0;
                        Out(#22 + #1 + Chr(St)); { Black   }
                      end;
                225 : begin
                        St := AvatarCol * 16 + 12;
                        Out(#22 + #1 + Chr(St)); { Red     }
                      end;
                226 : begin
                        St := AvatarCol * 16 + 10;
                        Out(#22 + #1 + Chr(St)); { Green   }
                      end;
                227 : begin
                        St := AvatarCol * 16 + 14;
                        Out(#22 + #1 + Chr(St)); { Yellow  }
		      end;
                228 : begin
                        St := AvatarCol * 16 + 9;
                        Out(#22 + #1 + Chr(St)); { Blue    }
                      end;
                229 : begin
                        St := AvatarCol * 16 + 13;
                        Out(#22 + #1 + Chr(St)); { Magenta }
                      end;
                230 : begin
                        St := AvatarCol * 16 + 11;
                        Out(#22 + #1 + Chr(St)); { Cyan    }
                      end;
                231 : begin
                        St := AvatarCol * 16 + 15;
                        Out(#22 + #1 + Chr(St)); { White   }
                      end;
                { Background Colour }
                232 : begin
                        AvatarCol := 0; { Black   }
                      end;
                233 : begin
                        AvatarCol := 4; { Red     }
                      end;
                234 : begin
                        AvatarCol := 2; { Green   }
                      end;
                235 : begin
                        AvatarCol := 6; { Brown   }
                      end;
                236 : begin
                        AvatarCol := 1; { Blue    }
                     end;
                237 : begin
                        AvatarCol := 5; { Magenta }
                      end;
                238 : begin
                        AvatarCol := 6; { Cyan }
                      end;
                239 : begin
                        AvatarCol := 7; { White   }
                      end;
              Else
                 begin
                   { Null If Colour Code Not Found }
                 end;
              end; {Case end}
            end
          Else
            begin
              { Null If No Colour }
            end;
       end;
    end
  Else
    begin
      { Null If No Colour }
    end;
end;
end.

