(* $Id: cdate.pp,v 1.4 2008-02-19 21:58:06 simon Exp $                       *)
(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   CDATE.PP                                                *)
(*                                                                          *)
(* DESCRIPTION  :   ADDS BUILD DATA DURING COMPILE                          *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 1995 - 2008                                *)
(*                                                                          *)
(*..........................................................................*)
(*
   $Log: cdate.pp,v $
   Revision 1.4  2008-02-19 21:58:06  simon
   see todo.txt

   Revision 1.2  2008/02/11 23:23:20  simon
   Added mail options


*)
program cdate;

uses linux, dos, dates, unix, baseunix, unixutils;

type
  build = record
    build : integer;
end;

var
  BNo   : build;
  BFile : file of build;
  dfile : text;
  uts   : utsname;
begin
 fpuname(uts);
  {$I-}
   assign(BFile, 'build.data');
   reset(BFile);
   if IOResult <> 0 then rewrite(BFile);
   if filesize(BFile) <> 0 then read(bfile, bno)
     else bno.build := 1;
   assign(dfile, 'comdate.pp');
   rewrite(dfile);
  {$I+}
  writeln(dfile,'unit comdate;');
  writeln(dfile);
  writeln(dfile,'interface');
  writeln(dfile);
  writeln(dfile,'const');
  writeln(dfile);
  writeln(dfile,'CDate = ', chr(39), today, ' GMT', chr(39), ';');
  writeln(dfile,'Build = ', chr(39), bno.build, chr(39), ';');
  writeln(dfile,'KernelV = ',chr(39), uts.release, chr(39), ';');
  writeln(dfile,'KernelR = ', chr(39), uts.version, chr(39), ';');
  writeln(dfile,'Machine = ', chr(39), uts.machine, chr(39), ';');
  writeln(dfile);
  writeln(dfile,'implementation');
  writeln(dfile);
  writeln(dfile,'end.');
  inc(bno.build);
  seek(bfile, 0);
  write(bfile, bno);
  close(dfile);
  close(bfile);
end.
