UNIT TpzVideo;

INTERFACE

USES Crt, lib;

PROCEDURE Z_OpenWindow(title: STRING);
(* Setup the area of the screen for transfer status window *)
PROCEDURE Z_ShowName(filename: STRING);
(* Display the file name *)
PROCEDURE Z_ShowSize(l: LONGINT);
(* Display the file size in blocks and bytes *)
PROCEDURE Z_ShowCheck(is32: BOOLEAN);
(* Display CRC16 or CRC32 block checking *)
PROCEDURE Z_ShowTransferTime(fsize, zbaud: LONGINT);
(* Show estimated transfer time in minutes *)
PROCEDURE Z_Message(s: STRING);
(* Show miscelaneous messages *)
PROCEDURE Z_Frame(n: INTEGER);
(* Show current ZMODEM frame type *)
PROCEDURE Z_ShowLoc(l: LONGINT);
(* Show byte position of file in blocks and bytes *)
PROCEDURE Z_Errors(w: WORD);
(* Show total error count *)

IMPLEMENTATION

CONST
   x1: BYTE = 10;
   x2: BYTE = 70;
   y1: BYTE = 5;
   y2: BYTE = 20;
   fore: BYTE = White;
   back: BYTE = Blue;
   bfore: BYTE = Black;
   bback: BYTE = Green;

VAR
   vmode: BYTE absolute $0040:$0049;
   vcols: WORD absolute $0040:$004A;
   oldx, oldy, oldattr: BYTE;
   oldmin, oldmax, cols, rows, size, vseg, vofs: WORD;
{   buffer: POINTER; }

FUNCTION RtoS(r: REAL; width, decimals: WORD): STRING;
VAR
   s: STRING;
BEGIN
   {$I-}
   Str(r:width:decimals,s);
   {$I+}
   IF (IoResult <> 0) THEN
      s := ''
   ELSE
      WHILE (Length(s) > 0) AND (s[1] = ' ') DO
         Delete(s,1,1);
   RtoS := s
END;



FUNCTION ItoS(r: LONGINT; width: WORD): STRING;
VAR
   s: STRING;
BEGIN
   {$I-}
   Str(r:width,s);
   {$I+}
   IF (IoResult <> 0) THEN
      s := ''
   ELSE
      WHILE (Length(s) > 0) AND (s[1] = ' ') DO
         Delete(s,1,1);
   ItoS := s
END;


PROCEDURE Z_OpenWindow(title: STRING);
VAR
   n, pads, bytes: WORD;
BEGIN
   ClearDisplay(True);
   Print ('Prepare For ZModem Download..!');
   LineFeed;
   TCol(Yellow);
   Writeln;
   WRITELN(title);
   Writeln;
   TCol(Green);
   WRITELN(' File name.....:');
   WRITELN(' File size.....:');
   WRITELN(' File blocks...:');
   WRITELN(' Block check...:');
   WRITELN(' Transfer time.:');
   WRITELN(' Current BYTE..:');
   WRITELN(' Current BLOCK.:');
   WRITELN(' Error count...:');
   WRITELN(' Last frame....:');
   title := 'Current ZModem Status';
   Writeln;
   TCol(Yellow);
   Writeln(title);
   title := 'Press ESCape to abort transfer';
   TCol(Red);
   Writeln;
   Writeln;
   Writeln(title);
   TCol(White);
END;

PROCEDURE Z_ShowName(filename: STRING);
BEGIN
   IF (Length(filename) > 14) THEN
      filename[0] := #14;
   GotoXY(18,5);
   WRITE(filename);
   GotoXY(1,18)
END;


PROCEDURE Z_ShowSize(l: LONGINT);
BEGIN
   GotoXY(18,6);
   WRITE(ItoS(l,14));
   IF (l MOD 128 <> 0) THEN
      l := (l DIV 128) + 1
   ELSE
      l := (l DIV 128);
   GotoXY(18,7);
   WRITE(ItoS(l,14));
   GotoXY(1,18);
END;


PROCEDURE Z_ShowCheck(is32: BOOLEAN);
BEGIN
   GotoXY(18,8);
   IF (is32) THEN
      WRITE('CRC32')
   ELSE
      WRITE('CRC16');
   GotoXY(1,18)
END;

PROCEDURE Z_ShowTransferTime(fsize, zbaud: LONGINT);
VAR
   bits: REAL;
BEGIN
   bits := fsize * 10.0;
   GotoXY(18,9);
   IF (bits <> 0.0) THEN
      WRITE(RtoS(((bits / zbaud) / 60),10,2),'min.')
   ELSE
      WRITE('0min.');
   GotoXY(1,18)
END;


PROCEDURE Z_Message(s: STRING);
BEGIN
   GotoXY(2,16);
   Write('                                                ');
   IF (Length(s) > 31) THEN
      s[0] := #31;
   GotoXY(2,16);
   WRITE(s,#13)
END;

PROCEDURE Z_Frame(n: INTEGER);
BEGIN
   IF (n < -3) OR (n > 20) THEN
      n := 20;
   GotoXY(18,13);
   CASE n OF { Changed Case lo(n) to n }
      -3 : WRITE('NOCARRIER');
      -2 : WRITE('TIMEOUT  ');
      -1 : WRITE('ERROR    ');
      0  : WRITE('RQINIT   ');
      1  : WRITE('RINIT    ');
      2  : WRITE('SINIT    ');
      3  : WRITE('ACK      ');
      4  : WRITE('FILE     ');
      5  : WRITE('SKIP     ');
      6  : WRITE('NAK      ');
      7  : WRITE('ABORT    ');
      8  : WRITE('FIN      ');
      9  : WRITE('RPOS     ');
      10 : WRITE('DATA     ');
      11 : WRITE('EOF      ');
      12 : WRITE('FERR     ');
      13 : WRITE('CRC      ');
      14 : WRITE('CHALLENGE');
      15 : WRITE('COMPL    ');
      16 : WRITE('CAN      ');
      17 : WRITE('FREECNT  ');
      18 : WRITE('COMMAND  ');
      19 : WRITE('STDERR   ');
      20 : WRITE('UNKNOWN  ')
   END;
   GotoXY(1,18)
END;

PROCEDURE Z_ShowLoc(l: LONGINT);
BEGIN
   GotoXY(18,10);
   WRITE(ItoS(l,14));
   IF (l MOD 128 <> 0) THEN
      l := (l DIV 128) + 1
   ELSE
      l := (l DIV 128);
   GotoXY(18,11);
   WRITE(ItoS(l,14));
   GotoXY(1,18)
END;

PROCEDURE Z_Errors(w: WORD);
BEGIN
   GotoXY(18,12);
   WRITE(ItoS(w,14));
   GotoXY(1,18)
END;

END.
