(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   SYSOP.PP                                                *)
(*                                                                          *)
(* DESCRIPTION  :   SYSOP TOOLS                                             *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 2008                                       *)
(*                                                                          *)
(*..........................................................................*)
Unit Sysop;

Interface

Uses Dos, Crt, Strings, Dates, Data, Lib, ini, Colours, ErrorLog, BaseUnix, Unix, SQLDB, User;

procedure sysopsignups;
procedure sysopdeleteguests;
procedure sysopedituser(guestedit : boolean);
function sysopdeletedforums : integer;
function sysopdeletedposts : integer;
procedure sysopdeleteforums;
procedure sysopdeleteposts;
procedure sysopaddforum;
procedure sysopeditforum;
procedure sysopnodes;
procedure sysopinfo;
procedure sysopchangeleveltime;
procedure sysopchangelevelcall;
procedure sysopchangebulletin;
procedure sysopuseruid;
procedure sysopuid;
procedure sysopguestuid;
procedure sysopguestsallowed;
procedure sysopbbscalls;
procedure sysopidletime;
procedure sysoperrorlog;
procedure sysopuserlog;
procedure sysopshowip;
procedure sysopbulletinforum;
procedure sysopmanagemainfilearea;

Implementation

(*..........................................................................*)
procedure sysopsignups;
var
  results : recbuf;
  rows     : rowbuf;

  lineno    : integer;
  strgs,
  sid,
  username,
  fullname,
  location,
  response  : string;
begin
  error := 0;
  lineno := 1;
  linefeed;
  { Setup query }
  query := 'select * from user_signup';
  if sql_query(query) then
   begin
     results := sql_store_results;
     if sql_affected_rows > 0  then
      begin
        rows := sql_fetch_row(results);
        linefeed;
        str(usersignupcount, strgs);
        colour(FGreen);
        print(' New Users : ');
        colour(FWhite);
        print(strgs);
        linefeed;
        linefeed;
        colour(FYellow);
        print(' SID   UserName        Full Name                Location');
        while rows <> nil do
         begin
           linefeed;
           setx('2');
           colour(FWhite);
           print(strpas(rows[20]));
           setx('7');
           colour(FGreen);
           print(strpas(rows[3]));
           setx('2333');
           print(strpas(rows[4]));
           setx('48');
           print(strpas(rows[6]));
           inc(lineno);
           if lineno = 20 then
            begin
              LineFeed;
              HoldPage;
              LineNo := 0;
            end;
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
        linefeed;
        linefeed;
        colour(FWhite);
        print('Press [ENTER] to exit - [D] Delete Signup : ');
        colour(FYellow);
        response := readkb(2);
        linefeed;
        if response = 'D' then
         begin
            linefeed;
            colour(FWhite);
            print('Press [ENTER] to exit  - Enter SID of signup to delete : ');
            colour(FYellow);
            response := readkb(5);
            linefeed;
            if response <> '' then
             begin
               sid := response;
               linefeed;
               colour(FRed);
               print('Are you sure you to permently delete the signup request? (Y/n) : ');
               colour(FYellow);
               response :=  readkb(2);
               linefeed;
               if response = 'Y' then 
                begin
                  { Setup Query }
                  querystr := 'delete from user_signup where sid=' + sid;
                  query := pchar(querystr);
                  { delete guest users from database }
                  if sql_query(query) then
                   begin
                     //results := sql_store_results;
                     if sql_affected_rows > 0 then
                      begin
                        linefeed;
                        colour(FYellow);
                        print('Signup removed successfully..');
                        logerror('Signup removed [' + sid + ']');
                        delay(2000);
                        linefeed;
                      end
                     else
                      begin
                        linefeed;
                        colour(FRed);
                        print('Invalid SID[' + sid + '] or there  was an error, please check logs');
                        logsqlerror('Removing signup [' + sid + '] - ' + sqlerror);
                        error := 1;
                        delay(2000);
                        linefeed;
                      end;
                   end
                  else
                   begin
                     linefeed;
                     colour(FRed);
                     print('There was an SQL error, please check logs');
                     logsqlerror('Removing signup [' + sid + '] - ' + sqlerror);
                     error := 1;
                     delay(2000);
                     linefeed;
                   end;
                end;
             end;
         end;
      end
     else
      begin
        linefeed;
        colour(FYellow);
        print(' No users waiting creation..');
        linefeed;
        delay(2000);
      end;
   end
  else
   begin
     { SQL Error  }
     LogSQLError('Sysop SignUps Error - ' + sqlerror);
   end;
end;
(*..........................................................................*)
{ Delete old guest users greater than x days  }
procedure sysopdeleteguests;
var
  results : recbuf;
  response,
  Guest,
  TargetDate,
  Remove     : string;
  ValDays,
  ValCode    : integer;
  PassedDays : time_t;
begin
  error := 0;
  str(GuestUID, Guest);
  Linefeed;
  colour(FYellow);
  print('This will remove all Guest users who have not logged in x days.');
  linefeed;
  linefeed;
  colour(FWhite);
  print('Press [ENTER] to exit - How Many Days? : ');
  colour(FGreen);
  response := readkb(4);
  linefeed;
  if response <> '' then
   begin
     { Work out days from today  }
     val(response, valdays, valcode);
     passeddays := round(fptime - (86400 * valdays));
     linefeed;
     colour(FGreen);
     print('Target Date : ');
     colour(FYellow);
     print(epochtodatestring(passeddays));
     linefeed;
     { Setup Query  }
     str(passeddays, targetdate);
     querystr := 'select uid from user_data where logon<' + targetdate + ' and uid=' + guest;
     query := pchar(querystr);
     { delete post from database }
     if sql_query(query) then
      begin
        results := sql_store_results;
        if sql_affected_rows > 0 then
         begin
           linefeed;
           colour(FGreen);
           print('Guest Accounts to be Removed : ');
           colour(FYellow);
           str(sql_affected_rows, remove);
           print(remove);
           linefeed;
           linefeed;
           colour(FRed);
           print('Are you sure you want to permanently delete Guest accounts (Y/n) ? : ');
           colour(Fwhite);
           response := readkb(2);
           linefeed;
           linefeed;
           if response = 'Y' then
            begin
              { setup query }
              querystr := 'delete from user_data where logon<' + targetdate + ' and uid=' + guest;
              query := pchar(querystr);
              { delete guest users from database }
              if sql_query(query) then
               begin
                 //results := sql_store_results;
                 if sql_affected_rows > 0 then
                   begin
                     colour(FYellow);
                     print('Guest accounts removed successfully..');
                     logerror(remove + ' Guest accounts removed');
                     delay(2000);
                     linefeed;
                     linefeed;
                   end
                 else
                   begin
                     colour(FRed);
                     print('There was an SQL error, please check logs');
                     logsqlerror('Removing Guest Accounts - ' + sqlerror);
                     error := 1;
                     delay(2000);
                     linefeed;
                     linefeed;
                   end;
                end
               else
                begin
                  colour(FRed);
                  print('There was an SQL error, please check logs');
                  logsqlerror('Removing Guest Accounts - ' + sqlerror);
                  error := 1;
                  delay(2000);
                  linefeed;
                  linefeed;
                end;
            end
           else
            begin
              colour(FYellow);
              print('Aborted..');
              linefeed;
              linefeed;
              delay(2000);
            end;
         end
        else
         begin
           linefeed;
           colour(FYellow);
           print('There are no Guest logins older than ');
           colour(FGreen);
           print(response);
           colour(FYellow);
           print(' days.');
           linefeed;
           linefeed;
           delay(2500);
         end;
      end
     else
      begin
        writeln(sqlerror);
        LogSQLError(sqlerror);
      end;
    { clear memory }
    sql_free_results(results);
   end
  else
   begin
     error := 1;
   end;
end;
(*..........................................................................*)
procedure sysopedituser(guestedit : boolean);
var
  results  : recbuf;
  rows     : rowbuf;
  uid,
  ansi,
  colouron,
  level,
  time,
  timestamp,
  logon,
  reg,
  username,
  fullname,
  town,
  email,
  info1,
  info2,
  info3,
  info4,
  info5,
  info6,
  info7,
  info8,
  cls,
  lines,
  bulletin,
  mailcount,
  lastmsgnum,
  calls,
  callstoday,
  callnumber,
  timeonline,
  downloads,
  uploads,
  bytesdl,
  bytesul,
  days,
  Guest,
  GuestHost     : string;
  LineNo,
  ValCode,
  ValLevel,
  UserUID     : integer;
  Save        : boolean;
  valttime    : time_t;
begin
  repeat
    str(GuestUID, Guest);
    LineNo := 0;
    Save   := false;
    LineFeed;
    Colour(FYellow);
    Print('Edit BBS Users');
    LineFeed;
    LineFeed;
    Colour(FWhite);
    if guestedit then Print('Enter Guest ID to Edit or [?] to List Guest Users [ENTER] Exit : ')
     else  Print('Enter User ID to Edit or [?] to List Users [ENTER] Exit : ');
    Colour(FGreen);
    Response := ReadKB(6);
    LineFeed;
    { List Forums }
    if Response = '?' then
     begin
       { Setup Query }
       if guestedit then querystr := 'select * from user_data where uid=' + Guest + ' order by guest desc'
         else  querystr := 'select * from user_data where uid<>' + Guest  + ' order by uid';
       query := pchar(querystr);
       if sql_query(query) then
        begin
          { get query results }
          results := sql_store_results;
          if results <> nil then
           begin
             rows := sql_fetch_row(results);
             LineFeed;
             LineFeed;
             Colour(FYellow);
             if guestedit then Print(' GID   Username         Level   Calls  Last Logon Date         Days')
              else Print(' UID   Username         Level   Calls  Last Logon Date         Days');
             while rows <> nil do
               begin
                 inc(LineNo);
                 LineFeed;
                 SetX('1');
                 Colour(FWhite);
                 if guestedit then Print(StrPas(rows[37]))
                  else Print(StrPas(rows[0]));
                 Colour(FGreen);
                 SetX('7');
                 Print(StrPas(rows[9]));
                 SetX('26');
                 Print(StrPas(rows[4]));
                 SetX('33');
                 Print(StrPas(rows[27]));
                 SetX('39');
                 val(StrPas(rows[7]), Valttime, ValCode);
                 Print(EpochtoDateString(Valttime));
                 SetX('64');
                 Str(DaysPassed(Valttime), days);
                 Print(days);
                 rows := sql_fetch_row(results);
                 if LineNo = 20 then
                  begin
                    LineFeed;
                    HoldPage;
                    LineNo := 0;
                  end;
               end;
             LineFeed;
             { clear memory }
             sql_free_results(results);
           end
         else
           begin
             { No Users }
           end;
       end
      else
       begin
         { SQL Error }
       end;
     end
    else
     begin
       { Edit User }
       if response <> '' then
        begin
          { Setup Query }
          if guestedit then querystr := 'select * from user_data where uid=' + Guest + ' and guest=''' + response + ''''
            else querystr := 'select * from user_data where uid=' + response;
          query := pchar(querystr);
          if sql_query(query) then
           begin
             { get query results }
             results := sql_store_results;
             if sql_affected_rows > 0 then
              begin
                rows := sql_fetch_row(results);
                while rows <> nil do
                 begin
                   uid := strpas(rows[0]);
		   ansi  := strpas(rows[2]);
		   colouron  := strpas(rows[3]);
		   level  := strpas(rows[4]);
                   val(rows[5], Valttime, ValCode);
		   time := EpochtoDateString(Valttime);
                   val(rows[6], Valttime, ValCode);
		   timestamp := EpochtoDateString(Valttime);
                   val(strpas(rows[7]), Valttime, ValCode);
		   logon := EpochtoDateString(Valttime);
		   reg := strpas(rows[8]);
                   username := strpas(rows[9]);
                   fullname := strpas(rows[10]);
                   town := strpas(rows[12]);
                   email := strpas(rows[13]);
                   info1 := strpas(rows[14]);
                   info2 := strpas(rows[15]);
                   info3 := strpas(rows[16]);
                   info4 := strpas(rows[17]);
                   info5 := strpas(rows[18]);
                   info6 := strpas(rows[19]);
                   info7 := strpas(rows[20]);
                   info8 := strpas(rows[21]);
		   cls := strpas(rows[22]);
		   lines := strpas(rows[23]);
		   bulletin := strpas(rows[24]);
		   mailcount := strpas(rows[25]);
		   lastmsgnum := strpas(rows[26]);
		   calls := strpas(rows[27]);
		   callstoday := strpas(rows[28]);
		   callnumber := strpas(rows[31]);
		   timeonline := strpas(rows[32]);
		   downloads := strpas(rows[33]);
		   uploads := strpas(rows[34]);
		   bytesdl := strpas(rows[35]);
		   bytesul := strpas(rows[36]);
                   if guestedit then guesthost := strpas(rows[38]);
                   rows := sql_fetch_row(results);
                 end;
                { clear memory }
                sql_free_results(results);
                repeat
                  linefeed;
                  linefeed;
                  if guestedit then
                   begin
                     Colour(FGreen);
                     Print('Guest Host : ');
                     Colour(FYellow);
                     Print(guesthost);
                     Linefeed;
                     Linefeed;
                   end;
                  Colour(FGreen);
                  Print('User ID  : ');
                  Colour(FWhite);
                  Print(uid);
                  SetX('35');
                  Colour(FGreen);
                  Print('Member Since : ');
                  Colour(FWhite);
                  Print(time);
                  Linefeed;
                  Colour(FGreen);
                  Print('UserName : ');
                  Colour(FWhite);
                  Print(username);
                  SetX('35');
                  Colour(FGreen);
                  Print('Last Logon   : ');
                  Colour(FWhite);
                  Print(logon);
                  Linefeed;
                  Colour(FGreen);
                  Print('Calls    : ');
                  Colour(FWhite);
                  Print(calls);
                  SetX('35');
                  Colour(FGreen);
                  Print('Call Nummber : ');
                  Colour(FWhite);
                  Print(callnumber);
                  Linefeed;
                  Linefeed;
                  Colour(FGreen);
                  Print('Downloads : ');
                  Colour(FWhite);
                  Print(downloads);
                  SetX('35');
                  Colour(FGreen);
                  Print('Download Bytes :  ');
                  Colour(FWhite);
                  Print(bytesdl);
                  Linefeed;
                  Colour(FGreen);
                  Print('Uploads   : ');
                  Colour(FWhite);
                  Print(uploads);
                  SetX('35');
                  Colour(FGreen);
                  Print('Upload Bytes   :  ');
                  Colour(FWhite);
                  Print(bytesul);
                  Linefeed;
                  Linefeed;
                  Colour(FGreen);
                  Print('A. FullName : ');
                  Colour(FWhite);
                  Print(fullname);
                  SetX('50');
                  Colour(FGreen);
                  Print('B. Bulletin No.     : ');
                  Colour(FWhite);
                  Print(bulletin);
                  Linefeed;
                  Colour(FGreen);
                  Print('C. EMail    : ');
                  Colour(FWhite);
                  Print(email);
                  SetX('50');
                  Colour(FGreen);
                  Print('D. Membership Level : ');
                  Colour(FWhite);
                  Print(level);
                  Linefeed;
                  Colour(FGreen);
                  Print('E. Location : ');
                  Colour(FWhite);
                  Print(town);
                  SetX('50');
                  Colour(FGreen);
                  Print('F. 24hr Time Online : ');
                  Colour(FWhite);
                  Print(timeonline);
                  Linefeed;
                  Colour(FGreen);
                  Print('G. Info 1   : ');
                  Colour(FWhite);
                  Print(info1);
                  LineFeed;
                  Colour(FGreen);
                  Print('H. Info 2   : ');
                  Colour(FWhite);
                  Print(info2);
                  LineFeed;
                  Colour(FGreen);
                  Print('I. Info 3   : ');
                  Colour(FWhite);
                  Print(info3);
                  LineFeed;
                  Colour(FGreen);
                  Print('J. Info 4   : ');
                  Colour(FWhite);
                  Print(info4);
                  LineFeed;
                  Colour(FGreen);
                  Print('K. Info 5   : ');
                  Colour(FWhite);
                  Print(info5);
                  LineFeed;
                  Colour(FGreen);
                  Print('L. Info 6   : ');
                  Colour(FWhite);
                  Print(info6);
                  LineFeed;
                  Colour(FGreen);
                  Print('M. Info 7   : ');
                  Colour(FWhite);
                  Print(info7);
                  LineFeed;
                  Colour(FGreen);
                  Print('N. Info 8   : ');
                  Colour(FWhite);
                  Print(info8);
                  LineFeed;
                  LineFeed;
                  Colour(FWhite);
                  if Save then Print('[S] Save - ');
                  Print('[!] Delete User - Select Letter to Edit A - N [Q] Exit : ');
                  Colour(FYellow);
                  response := readkb(2);
                  { Edit Full Name }
                  if response = 'A' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User FullName : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        fullname := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Bulletin Number }
                  if response = 'B' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Bulletin Number : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(4);
                     NoUpper := false;
                     if length(Response) > 0 then
                      begin
                        bulletin := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Email }
                  if response = 'C' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User EMail Address : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(41);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        email := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Email }
                  if response = 'D' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Membership Level 1 - 9 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(2);
                     NoUpper := false;
                     val(Response, ValLevel, ValCode);
                     if (ValLevel >= 1) and (ValLevel <= 9) then
                      begin
                        level := Response;
                        Save := true;
                      end
                     else
                      begin
                        LineFeed;
                        LineFeed;
                        Colour(FRed);
                        Print('Level Must Be Between 1 - 9');
                        delay(1500);
                      end;
                   end;
                  { Edit Location }
                  if response = 'E' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Location : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        town := Response;
                        Save := true;
                      end;
                   end;
                  { Online Time }
                  if response = 'F' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Time Online : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        timeonline := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 1 }
                  if response = 'G' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 1 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info1 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 2 }
                  if response = 'H' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 2 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info2 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 3 }
                  if response = 'I' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 3 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info3 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 4 }
                  if response = 'J' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 4 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info4 := Response;
                        Save := true;
                      end;
                   end;
                 { Edit Info 5 }
                  if response = 'K' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 5 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info5 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 6 }
                  if response = 'L' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 6 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info6 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 7 }
                  if response = 'M' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 7 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info7 := Response;
                        Save := true;
                      end;
                   end;
                  { Edit Info 8 }
                  if response = 'N' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('User Info 8 : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(31);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        info8 := Response;
                        Save := true;
                      end;
                   end;
                { Delete User }
                if Response = '!' then
                 begin
                   linefeed;
                   linefeed;
                   Colour(FYellow);
                   Print('This will only remove the user''s BBS account information and not');
                   linefeed;
                   Print('their Linux user account, and they will not be able use the BBS if you do..');
                   linefeed;
                   linefeed;
                   Colour(FRed);
                   Print('Are you sure you want to permanently delete this user account? (N/y) : ');
                   Colour(FWhite);
                   Response := ReadKB(2);
                   if Response = 'Y' then
                     begin
                       { setup query }
                       querystr := 'delete from user_data where uid=' + uid;
                       query := pchar(querystr);
                       { delete guest users from database }
                       if sql_query(query) then
                        begin
                          //results := sql_store_results;
                          if sql_affected_rows > 0 then
                           begin
                             colour(FYellow);
                             linefeed;
                             linefeed;
                             print('User account [' + username + '] removed successfully..');
                             logerror('User ['+username+'] account removed');
                             delay(2000);
                             linefeed;
                             linefeed;
                             exit;
                           end
                         else
                           begin
                             colour(FRed);
                             linefeed;
                             linefeed;
                             print('There was an SQL error, please check logs');
                             logsqlerror('Removing BBS Account - ' + sqlerror);
                             delay(2000);
                             linefeed;
                             linefeed;
                           end;
                        end
                       else
                        begin
                          colour(FRed);
                          linefeed;
                          linefeed;
                          print('There was an SQL error, please check logs');
                          logsqlerror('Removing BBS Account - ' + sqlerror);
                          delay(2000);
                          linefeed;
                          linefeed;
                        end;
                     end;
                 end;
                until (response = 'Q') or (Response = 'S');
                Linefeed;
                { Save Update }
                if (Response = 'S') and (Save) or (Response = 'Q') and (Save) then
                  begin
                    if Response = 'Q' then
                     begin
                       linefeed;
                       linefeed;
                       Colour(FRed);
                       Print('User Details Have Been Changed, Save (Y/n) : ');
                       Colour(FWhite);
                       Response := ReadKB(1);
                       if response <> 'Y' then Save := false;
                     end;
                 end;
                { Save User Details }
                if (Save) and (not guestedit) then
                 begin
                   val(uid, useruid, ValCode);
                   UpdateUserInfo(info1, 1, UserUID);
                   UpdateUserInfo(info2, 2, UserUID);
                   UpdateUserInfo(info3, 3, UserUID);
                   UpdateUserInfo(info4, 4, UserUID);
                   UpdateUserInfo(info5, 5, UserUID);
                   UpdateUserInfo(info6, 6, UserUID);
                   UpdateUserInfo(info7, 7, UserUID);
                   UpdateUserInfo(info8, 8, UserUID);
                   val(bulletin, ValLevel, ValCode);
                   UpdateUserBulletin(vallevel, UserUID);
                   UpdateUserLocation(town, UserUID);
                   val(timeonline, ValLevel, ValCode);
                   UpdateUserTimeOnLine(ValLevel, UserUID);
                   UpdateUserFullName(fullname, UserUID);
                   UpdateUserEmail(email, UserUID);
                   val(level, ValLevel, ValCode);
                   UpdateUserLevel(ValLevel, UserUID);
                   Linefeed;
                   Print('User Account Updated...');
                   Linefeed;
                   delay(2000);
                 end;
              end
             else
              begin
                { no results }
                LineFeed;
                LineFeed;
                Colour(Fred);
                Print('Invalid User ID..');
                LineFeed;
	      end;
	  end
         else
          begin
            { SQL Error  }
          end;
        end;
    end;
  until response ='';
  LineFeed;
end;
(*..........................................................................*)
{ Returns the number of posts which the deletetag is set to 1  }
function sysopdeletedforums : integer;
var
  results : recbuf;
begin
   query := 'select * from forum where deletetag=1';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then SysopDeletedForums :=  sql_num_rows(results)
         else SysopDeletedForums := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       SysopDeletedForums := 0;
     end;
end;
(*..........................................................................*)
{ Returns the number of posts which the deletetag is set to 1  }
function sysopdeletedposts : integer;
var
  results : recbuf;
begin
   query := 'select * from forum_messages where deletetag=1';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then SysopDeletedPosts :=  sql_num_rows(results)
         else SysopDeletedPosts := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       SysopDeletedPosts := 0;
     end;
end;
(*..........................................................................*)
{ Removes all forums including posts and replies }
procedure sysopdeleteforums;
type
  Forum = record
     ID    : string[3];
     Title : string[40];
end;

var
  ForumDel : array[0..500] of Forum;
  results  : recbuf;
  rows     : rowbuf;
  Number,
  Index,
  Step     : integer;
begin
  LineFeed;
  Colour(FYellow);
  Print('Remove Tagged Forums');
  LineFeed;
  Colour(FWhite);
  Print('Are you sure you want to remove all tagged forums? (y/n) : ');
  Response := ReadKB(1);
  LineFeed;
  LineFeed;
  if Response = 'Y' then
   begin
     query := 'select fid, title from forum where deletetag=1';
     Colour(FGreen);
     Print('Reading Forums : ');
     if sql_query(query) then
      begin
        results := sql_store_results;
        if sql_affected_rows <> 0 then
         begin
           rows := sql_fetch_row(results);
           while rows <> nil do
            begin
              inc(Index);
              ForumDel[Index].ID := rows[0];
              ForumDel[Index].Title := rows[1];
              rows := sql_fetch_row(results);
            end;
           { clear memory }
           sql_free_results(results);
           Colour(FYellow);
           Print('OK');
           repeat
             inc(step);
             LineFeed;
             LineFeed;
             Colour(FGreen);
             Print('Removing Forum - ');
             Colour(FWhite);
             Print(ForumDel[Step].Title + ' : ');
             { Setup Query }
             querystr := 'delete from forum where fid=' + ForumDel[Step].ID;
             query := pchar(querystr);
             { Submit New Forum to SQL }
             if not sql_query(query) then
              begin
                Colour(FRed);
                Print('ERROR');
                LineFeed;
                LineFeed;
                Colour(FWhite);
                Print('See SQLERROR.LOG');
                Linefeed;
                logsqlerror('SQL: Error Removing tagged posts : ' + sqlerror);
                exit;
              end;
             Colour(FYellow);
             Print('OK');
             LineFeed;
             Colour(FGreen);
             Print('Removing Forum Posts : ');
             { Setup Query }
             querystr := 'delete from forum_messages where fid=' + ForumDel[Step].ID;
             query := pchar(querystr);
             { Submit New Forum to SQL }
             if not sql_query(query) then
              begin
                Colour(FRed);
                Print('ERROR');
                LineFeed;
                LineFeed;
                Colour(FWhite);
                Print('See SQLERROR.LOG');
                Linefeed;
                logsqlerror('SQL: Error Removing Forum['+ ForumDel[Step].Title +'] : ' + sqlerror);
                exit;
              end;
             Colour(FYellow);
             Print('OK');
             LineFeed;
             Colour(FGreen);
             Print('Removing Forum Replies : ');
             { Setup Query }
             querystr := 'delete from forum_replies where fid=' + ForumDel[Step].ID;
             query := pchar(querystr);
             { Submit New Forum to SQL }
             if not sql_query(query) then
              begin
                Colour(FRed);
                Print('ERROR');
                LineFeed;
                LineFeed;
                Colour(FWhite);
                Print('See SQLERROR.LOG');
                Linefeed;
                logsqlerror('SQL: Error Removing tagged posts : ' + sqlerror);
                exit;
              end;
             Colour(FYellow);
             Print('OK');
           until step = Index;
           LineFeed;
           LineFeed;
         end
        else
         begin
           Colour(FRed);
           Print('No Forums Have Been Tagged For Deletion');
           LineFeed;
           LineFeed;
         end;
      end
     else
      begin
        Colour(FRed);
        Print('ERROR');
        LineFeed;
        LineFeed;
        Colour(FWhite);
        Print('See SQLERROR.LOG');
        Linefeed;
        logsqlerror('SQL: Error Removing tagged posts : ' + sqlerror);
      end;
   end;
end;
(*..........................................................................*)
{ removes all posts & replies with the deletetag set to 1 }
{ todo: Need to set BBS into maintence mode }
procedure sysopdeleteposts;
var
  results : recbuf;
begin
  LineFeed;
  Colour(FYellow);
  Print('Remove Tagged Posts');
  LineFeed;
  Colour(FWHite);
  Print('Are you sure you want to remove all tagged posts? (y/n) : ');
  Response := ReadKB(1);
  LineFeed;
  LineFeed;
  if Response = 'Y' then
   begin
     query := 'delete from forum_messages where deletetag=1';
     { delete post from database }
     Colour(FGreen);
     Print('Deleting Tagged Posts : ');
     if sql_query(query) then
      begin
        {results := sql_store_results;}
        if sql_affected_rows >= 0 then
         begin
           Colour(FYellow);
           Print('OK');
           Linefeed;
           Linefeed;
           Colour(FGreen);
           Print('Deleting All Post Replies : ');
           { post deleted, now remove any replies }
           query := 'delete from forum_replies where deletetag=1';
           { there might not be any replies, so only log an error }
           if sql_query(query) then results := sql_store_results
            else logsqlerror('SQL : Error Removing tagged replies : ' + sqlerror);
           COlour(FYellow);
           Print('OK');
           Linefeed;
           Linefeed;
           delay(2000);
         end
        else
         begin
           Colour(FRed);
           Print('ERROR');
           LineFeed;
           LineFeed;
           Colour(FWhite);
           Print('See SQLERROR.LOG');
           Linefeed;
           logsqlerror('SQL: Error Removing tagged posts : ' + sqlerror);
         end;
      end
     else
      begin
        Colour(FRed);
        Print('ERROR');
        LineFeed;
        LineFeed;
        Colour(FWhite);
        Print('See SQLERROR.LOG');
        Linefeed;
        logsqlerror('SQL: Error Removing tagged posts : ' + sqlerror);
      end;
   end;
end;
(*..........................................................................*)
procedure sysopaddforum;
var
  Title,
  Desc,
  LevelRead,
  LevelPostHi,
  LevelPostLo,
  Response : string;
  LevelNo,
  ValCode  : integer;
begin
  LineFeed;
  Colour(FWhite);
  Print('Add A New Forum');
  LineFeed;
  LineFeed;
  Colour(FGreen);
  Print('Leave any option blank to exit..');
  LineFeed;
  LineFeed;
  Colour(FYellow);
  Print('Enter Forum Title (40 Chars Max) : ');
  Colour(FGreen);
  NoUpper := True;
  Response := ReadKB(40);
  NoUpper := false;
  if Length(Response) = 0 then exit;
  Title := Response;
  LineFeed;
  Colour(FYellow);
  Print('Enter Forum Description (80 Chars Max) : ');
  Colour(FGreen);
  NoUpper := True;
  Response := ReadKB(80);
  NoUpper := false;
  if Length(Response) = 0 then exit;
  Desc := Response;
  repeat
    LineFeed;
    Colour(FYellow);
    Print('Minimum User Level Which Can Read The Forum (1-9) : ');
    Colour(FGreen);
    Response := ReadKB(2);
    if Length(Response) = 0 then exit;
    val(Response, LevelNo, ValCode);
    if (LevelNo < 1) or (LevelNo > 9) then
     begin
       Linefeed;
       Colour(FWhite);
       Print('User Level Must Be Between 1 -9');
     end;
  until (LevelNo >= 1) and (LevelNo <= 9);
  LevelRead := Response;
  repeat
    LineFeed;
    Colour(FYellow);
    Print('Minimum User Level Which Can Post To The Forum (1-9) : ');
    Colour(FGreen);
    Response := ReadKB(2);
    if Length(Response) = 0 then exit;
    val(Response, LevelNo, ValCode);
    if (LevelNo < 1) or (LevelNo > 9) then
     begin
       Linefeed;
       Colour(FWhite);
       Print('User Level Must Be Between 1 -9');
     end;
  until (LevelNo >= 1) and (LevelNo <= 9);
  LevelPostLo := Response;
  repeat
    LineFeed;
    Colour(FYellow);
    Print('Maximum User Level Which Can Post To The Forum (1-9) : ');
    Colour(FGreen);
    Response := ReadKB(2);
    if Length(Response) = 0 then exit;
    val(Response, LevelNo, ValCode);
    if (LevelNo < 1) or (LevelNo > 9) then
     begin
       Linefeed;
       Colour(FWhite);
       Print('User Level Must Be Between 1 -9');
     end;
  until (LevelNo >= 1) and (LevelNo <= 9);
  LevelPostHi := Response;
  LineFeed;
  LineFeed;
  Colour(FWhite);
  Print('New Forum Details..');
  LineFeed;
  LineFeed;
  Colour(FGreen);
  Print('Forum         : ');
  Colour(FYellow);
  Print(Title);
  LineFeed;
  Colour(FGreen);
  Print('Description   : ');
  Colour(FYellow);
  Print(Desc);
  LineFeed;
  Colour(FGreen);
  Print('Read Level    : ');
  Colour(FYellow);
  Print(LevelRead);
  LineFeed;
  Colour(FGreen);
  Print('Post Lo Level : ');
  Colour(FYellow);
  Print(LevelPostLo);
  LineFeed;
  Colour(FGreen);
  Print('Post Hi Level : ');
  Colour(FYellow);
  Print(LevelPostHi);
  LineFeed;
  LineFeed;
  Colour(FWhite);
  Print('Add Forum (Y/n) ? : ');
  Response := ReadKB(1);
  if Response = 'N' then exit;
  { Add Slashes }
  Title := SQL_AddSlashes(Title);
  Desc := SQL_AddSlashes(Desc);
  { Setup Query }
  querystr := 'insert into forum values(NULL,'''+ Title +''','''+ Desc +''','''+ LevelRead +''','''+ LevelPostLo +''','''+ LevelPostHi +''',0)';
  query := pchar(querystr);
  { Submit New Forum to SQL }
  if not sql_query(query) then
    begin
      LineFeed;
      LineFeed;
      Print('Error: ' + SqlError);
      LineFeed;
      LogSQLError(SqlError);
    end
   else
    begin
      Linefeed;
      LineFeed;
      Print('New Forum Added...');
      Linefeed;
      delay(2000);
    end;
  LineFeed;
end;
(*..........................................................................*)
procedure sysopeditforum;
var
  results  : recbuf;
  rows     : rowbuf;
  Fid,
  Title,
  Desc,
  ReadLevel,
  PostLevelHi,
  PostLevelLo,
  DeleteTag   : string;
  Response    : string;
  LineNo,
  ValCode,
  ValLevel    : integer;
  Save        : boolean;
begin
  repeat
    LineNo := 0;
    Save   := false;
    LineFeed;
    Colour(FYellow);
    Print('Edit Forums');
    LineFeed;
    Colour(FWhite);
    Print('Enter Forum ID to Edit or [?] to List Forums [ENTER] Exit : ');
    Colour(FGreen);
    Response := ReadKB(4);
    { List Forums }
    if Response = '?' then
     begin
       { Setup Query }
       querystr := 'select * from forum order by fid';
       query := pchar(querystr);
       if sql_query(query) then
        begin
          { get query results }
          results := sql_store_results;
          if results <> nil then
           begin
             rows := sql_fetch_row(results);
             LineFeed;
             LineFeed;
             Colour(FYellow);
             Print('Fid     Title                                      Read  Lo  Hi Tag');
             while rows <> nil do
               begin
                 inc(LineNo);
                 LineFeed;
                 SetX('1');
                 Colour(FWhite);
                 Print(StrPas(rows[0]));
                 Colour(FGreen);
                 SetX('8');
                 Print(StrPas(rows[1]));
                 SetX('53');
                 Print(StrPas(rows[3]));
                 SetX('57');
                 Print(StrPas(rows[4]));
                 SetX('61');
                 Print(StrPas(rows[5]));
                 val(StrPas(rows[6]), ValLevel, ValCode);
                 { Deletetag checked }
                 if ValLevel = 1 then
                  begin
                     SetX('64');
                     Colour(FRed);
                     Print('Yes');
                  end;
                 rows := sql_fetch_row(results);
                 if LineNo = 20 then
                  begin
                    LineFeed;
                    HoldPage;
                    LineNo := 0;
                  end;
               end;
             LineFeed;
             { clear memory }
             sql_free_results(results);
           end
          else
           begin
             { error getting forum data to list }
           end;
        end
       else
        begin
          { error with SQL getting forum data to list }
        end;
     end
    else
     begin
       { Edit Forum }
       if Response <> '' then
        begin
          { Setup Query }
          querystr := 'select * from forum where fid=' + response;
          query := pchar(querystr);
          if sql_query(query) then
           begin
             { get query results }
             results := sql_store_results;
             if sql_affected_rows > 0 then
              begin
                rows := sql_fetch_row(results);
                while rows <> nil do
                 begin
                   Fid   := strpas(rows[0]);
                   Title := strpas(rows[1]);
                   Desc  := strpas(rows[2]);
                   ReadLevel   := strpas(rows[3]);
                   PostLevelLo := strpas(rows[4]);
                   PostLevelHi := strpas(rows[5]);
                   DeleteTag   := strpas(rows[6]);
                   rows := sql_fetch_row(results);
                end;
                { clear memory }
                sql_free_results(results);
                repeat
                  LineFeed;
                  LineFeed;
                  Colour(FGreen);
                  Print('Forum ID : ');
                  Colour(FWhite);
                  Print(Fid);
                  LineFeed;
                  LineFeed;
                  Colour(FGreen);
                  Print('A. Title : ');
                  Colour(FYellow);
                  Print(Title);
                  LineFeed;
                  Colour(FGreen);
                  Print('B. Desc  : ');
                  Colour(FYellow);
                  Print(Desc);
                  LineFeed;
                  LineFeed;
                  Colour(FGreen);
                  Print('C. Read Level     : ');
                  Colour(FYellow);
                  Print(ReadLevel);
                  LineFeed;
                  Colour(FGreen);
                  Print('D. Post Level Lo  : ');
                  Colour(FYellow);
                  Print(PostLevelLo);
                  LineFeed;
                  Colour(FGreen);
                  Print('E. Post Level Hi  : ');
                  Colour(FYellow);
                  Print(PostLevelHi);
                  LineFeed;
                  LineFeed;
                  Colour(FGreen);
                  Print('F. Delete Tag     : ');
                  Colour(FRed);
                  if DeleteTag = '1' then Print('Yes')
                   else Print('No');
                  LineFeed;
                  LineFeed;
                  Colour(FWhite);
                  if Save then Print('[S] Save - ');
                  Print('Select Letter to Edit A - F [Q] Exit : ');
                  Colour(FYellow);
                  Response := ReadKB(1);
                  { Edit Title  }
                  if Response = 'A' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Title : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(41);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        Title := Response;
                        Save := true;
                      end;
                  end;
                  { Edit Description  }
                  if Response = 'B' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Description : ');
                     Colour(FYellow);
                     NoUpper := true;
                     Response := ReadKB(81);
                     NoUpper := false;
                     if length(Response) > 1 then
                      begin
                        Desc := Response;
                        Save := true;
                      end;
                  end;
                  { Edit Level Read  }
                  if Response = 'C' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Level Read 1 - 9 : ');
                     Colour(FYellow);
                     Response := ReadKB(1);
                     val(Response, ValLevel, ValCode);
                     if (ValLevel >= 1) and (ValLevel <= 9) then
                      begin
                        ReadLevel := Response;
                        Save := true;
                      end
                     else
                      begin
                        LineFeed;
                        LineFeed;
                        Colour(FRed);
                        Print('Level Must Be Between 1 - 9');
                        delay(1500);
                      end;
                  end;
                  { Edit Level Post Lo  }
                  if Response = 'D' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Post Level Lo  1 - 9 : ');
                     Colour(FYellow);
                     Response := ReadKB(1);
                     val(Response, ValLevel, ValCode);
                     if (ValLevel >= 1) and (ValLevel <= 9) then
                      begin
                        PostLevelLo := Response;
                        Save := true;
                      end
                     else
                      begin
                        LineFeed;
                        LineFeed;
                        Colour(FRed);
                        Print('Level Must Be Between 1 - 9');
                        delay(1500);
                      end;
                   end;
                  { Edit Level Post Lo  }
                  if Response = 'E' then
                   begin
                     LineFeed;
                     LineFeed;
                     Colour(FGreen);
                     Print('New Post Level Hi  1 - 9 : ');
                     Colour(FYellow);
                     Response := ReadKB(1);
                     val(Response, ValLevel, ValCode);
                     if (ValLevel >= 1) and (ValLevel <= 9) then
                      begin
                        PostLevelHi := Response;
                        Save := true;
                      end
                     else
                      begin
                        LineFeed;
                        LineFeed;
                        Colour(FRed);
                        Print('Level Must Be Between 1 - 9');
                        delay(1500);
                      end;
                   end;
                   { Set Delete Tag  }
                   if Response = 'F' then
                    begin
                      LineFeed;
                      LineFeed;
                      if DeleteTag = '1' then DeleteTag := '0'
                        else DeleteTag := '1';
                      Save := true;
                    end;
                until (Response = 'Q') or (Response = 'S');
                { Save Update }
                if (Response = 'S') and (Save) or (Response = 'Q') and (Save) then
                  begin
                    if Response = 'Q' then
                     begin
                       linefeed;
                       linefeed;
                       Colour(FRed);
                       Print('Forum Has Been Changed, Save (Y/n) : ');
                       Colour(FWhite);
                       Response := ReadKB(1);
                       if response <> 'Y' then Save := false;
                     end;
                    if Save then
                     begin
                       Title := SQL_AddSlashes(Title);
                       Desc := SQL_AddSlashes(Desc);
                       { Setup Query }
                       querystr := 'update forum set title='''+ Title +''', description='''+ Desc +''', LevelRead='+ ReadLevel +', Levelpostlo='+ PostLevelLo +', levelposthi='+ PostLevelHi +', deletetag=' + DeleteTag +' where fid=' + fid;
                       query := pchar(querystr);
                       { Submit New Forum to SQL }
                       if not sql_query(query) then
                        begin
                          LineFeed;
                          LineFeed;
                          Print('Error: ' + SqlError);
                          LineFeed;
                          LogSQLError(SqlError);
                        end
                       else
                        begin
                          Linefeed;
                          LineFeed;
                          Print('Forum Updated...');
                          Linefeed;
                          delay(2000);
                        end;
                     end;
                  end;
                LineFeed;
              end
             else
              begin
                { no results }
                LineFeed;
                LineFeed;
                Colour(Fred);
                Print('Invalid Forum ID..');
                LineFeed;
              end;
           end
          else
           begin
             { error SQL edit query }
           end;
        end;
     end;
  until Response = '';
end;
(*..........................................................................*)
procedure  sysopchangebulletin;
var
 NewNodes : integer;
 inifile,
 strgs    : string;
begin
  If BBSCfg.BinDir[Length(BBSCfg.BinDir)] = '/' then
       inifile := BBSCfg.BinDir + 'linux'
  else inifile := BBSCfg.BinDir + '/' + 'linux';
  Linefeed;
  Str(BBSCfg.Bulletin,strgs);
  Print('Current Bulletin Number = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Bulletin Number : ');
    Response := ReadKB(4);
    val(Response, NewNodes, CodeData);
    if (NewNodes >=1) and (NewNodes <= 999) then
     begin
       ProfileStatus := WriteProfileint(inifile, 'CONFIG' , 'BULLETIN', NewNodes);
       if ProfileStatus <> 0 then
         begin
          LogError(' SYSOP:  Error updating Bulletin..' + inifile + ' ' + ErrorString(ProfileStatus));
          DisposeINICollection;
          linefeed;
          Print('Update Failed..');
          delay(1500);
          exit;
        end
      else
        begin
          BBSCfg.Bulletin := NewNodes;
          LineFeed;
          Print('BBS Bulletin Update Success ..');
          DisposeINICollection;
          delay(1500);
          exit;
        end;
   end;
  until Response = '';
end;
(*..........................................................................*)
procedure sysopchangelevelcall;
var
 inifile,
 strgs,
 level     : string;
 Loop,
 LevelCall,
 UserCall : integer;
begin
  (* Don't need this anymore as moved over to SQL
  If BBSCfg.BinDir[Length(BBSCfg.BinDir)] = '/' then
       inifile := BBSCfg.BinDir + 'linux'
  else inifile := BBSCfg.BinDir + '/' + 'linux';
  *)
  { Get Level }
  Repeat
    LineFeed;
    Colour(FYellow);
    Print('Current user level calls allowed per 24hrs...');
    LineFeed;
    LineFeed;
    Colour(FCyan);
    Print('Level               Call Limit');
    Colour(FBlue);
    LineFeed;
    Print('------------------------------');
    LineFeed;
    for Loop := 1 to 9 do
     begin
       SetX('1');
       Str(Loop, Strgs);
       Colour(FRed);
       Print(Strgs);
       case Loop of
         1 : begin
               Str(BBSCfg.L1C, Strgs);
             end;
         2 : begin
               Str(BBSCfg.L2C, Strgs);
             end;
         3 : begin
               Str(BBSCfg.L3C, Strgs);
             end;
         4 : begin
               Str(BBSCfg.L4C, Strgs);
             end;
         5 : begin
               Str(BBSCfg.L5C, Strgs);
             end;
         6 : begin
               Str(BBSCfg.L6C, Strgs);
             end;
         7 : begin
               Str(BBSCfg.L7C, Strgs);
             end;
         8 : begin
               Str(BBSCfg.L8C, Strgs);
             end;
         9 : begin
               Str(BBSCfg.L9C, Strgs);
             end;
       end; {Case end}
       SetX('23');
       Colour(FYellow);
       Print(Strgs);
       LineFeed;
     end;
    LineFeed;
    Print('Enter the level call number you wish to change (ENTER to exit) : ');
    Response := ReadKB(3);
    if Response = '' then exit;
    val(Response,UserCall, CodeData);
    if (UserCall < 1) or (UserCall > 9) then
      begin
        LineFeed;
        LineFeed;
        Colour(FRed);
        Print('Level must be between 1 - 9');
      end;
  until (UserCall >= 1) and (UserCall <= 9);

  case UserCall of
    1 : begin
          strgs := 'l1calls';
          LevelCall := BBSCfg.L1C;
        end;
    2 : begin
          strgs := 'l2calls';
          LevelCall := BBSCfg.L2C;
        end;
    3 : begin
          strgs := 'l3calls';
          LevelCall := BBSCfg.L3C;
        end;
    4 : begin
          strgs := 'l4calls';
          LevelCall := BBSCfg.L4C;
        end;
    5 : begin
          strgs := 'l5calls';
          LevelCall := BBSCfg.L5C;
        end;
    6 : begin
          strgs := 'l6calls';
          LevelCall := BBSCfg.L6C;
        end;
    7 : begin
          strgs := 'l7calls';
          LevelCall := BBSCfg.L7C;
        end;
    8 : begin
          strgs := 'l8calls';
          LevelCall := BBSCfg.L8C;
        end;
    9 : begin
          strgs := 'l9calls';
          LevelCall := BBSCfg.L9C;
        end;
  end;
  str(UserCall, level);
  repeat
    LineFeed;
    LineFeed;
    Print('Enter New Level ' + level + ' CALLS : ');
    Response := ReadKB(5);
    val(Response, LevelCall, CodeData);
    if (LevelCall >= 1) and (levelCall <= 999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set ' + strgs + '=' + response;
       query := pchar(querystr);
       if sql_query(query) then
        begin
           if sql_affected_rows = 0 then
            begin
              LogError(' SYSOP:  Error updating User Call.' + Level + ' - ' + inifile + ' ' + ErrorString(ProfileStatus));
              {DisposeINICollection;}
              linefeed;
              Print('Update Failed..');
              delay(1500);
              exit;
            end
          else
            begin
              LineFeed;
              LineFeed;
              Colour(FYellow);
              Print('User Call  Update Success ..');
              {DisposeINICollection;}
              delay(1500);
               case UserCall of
                   1 : begin
                         BBSCfg.L1C := LevelCall;
                       end;
                   2 : begin
                         BBSCfg.L2C := LevelCall;
                       end;
                   3 : begin
                         BBSCfg.L3C := LevelCall;
                       end;
                   4 : begin
                         BBSCfg.L4C := LevelCall;
                       end;
                   5 : begin
                         BBSCfg.L5C := LevelCall;
                       end;
                   6 : begin
                         BBSCfg.L6C := LevelCall;
                       end;
                   7 : begin
                         BBSCfg.L7C := LevelCall;
                       end;
                   8 : begin
                         BBSCfg.L8C := LevelCall;
                       end;
                   9 : begin
                         BBSCfg.L9C := LevelCall;
                       end;
                end;
              exit;
            end;
           end
         else
           begin
             { SQL ERROR }
           end;
     end
    else
     begin
       Linefeed;
       Linefeed;
       Colour(FRed);
       Print('Calls must be >=1  and <= 999..');
       Colour(FYellow);
       delay(1500);
     end;
  until Response ='';
end;
(*..........................................................................*)
procedure sysopchangeleveltime;
var
 inifile,
 strgs,
 level     : string;
 LevelTime,
 UserLevel : integer;
begin
  (*
  If BBSCfg.BinDir[Length(BBSCfg.BinDir)] = '/' then
       inifile := BBSCfg.BinDir + 'linux'
  else inifile := BBSCfg.BinDir + '/' + 'linux';
  *)
  { Get Level }
  Repeat
    LineFeed;
    LineFeed;
    LineFeed;
    Colour(FYellow);
    Print('Current user level time allowed per 24hrs...');
    LineFeed;
    LineFeed;
    Colour(FCyan);
    Print('Level               Time Limit');
    Colour(FBlue);
    LineFeed;
    Print('------------------------------');
    LineFeed;
    for Loop := 1 to 9 do
     begin
       SetX('1');
       Str(Loop, Strgs);
       Colour(FRed);
       Print(Strgs);
       case Loop of
         1 : begin
               Str(BBSCfg.L1T, Strgs);
             end;
         2 : begin
               Str(BBSCfg.L2T, Strgs);
             end;
         3 : begin
               Str(BBSCfg.L3T, Strgs);
             end;
         4 : begin
               Str(BBSCfg.L4T, Strgs);
             end;
         5 : begin
               Str(BBSCfg.L5T, Strgs);
             end;
         6 : begin
               Str(BBSCfg.L6T, Strgs);
             end;
         7 : begin
               Str(BBSCfg.L7T, Strgs);
             end;
         8 : begin
               Str(BBSCfg.L8T, Strgs);
             end;
         9 : begin
               Str(BBSCfg.L9T, Strgs);
             end;
       end; {Case end}
       SetX('23');
       Colour(FYellow);
       Print(Strgs);
       LineFeed;
    end;
    LineFeed;
    Print('Enter the level number you wish to change : ');
    Response := ReadKB(3);
    if Response = '' then exit;
    val(Response,UserLevel, CodeData);
    if (UserLevel < 1) or (UserLevel > 9) then
      begin
        LineFeed;
        LineFeed;
        Colour(FRed);
        Print('Level must be between 1 - 9');
        Colour(FYellow);
      end;
  until (UserLevel >= 1) and (UserLevel <= 9);

  case UserLevel of
    1 : begin
          strgs := 'l1time';
          LevelTime := BBSCfg.L1T;
        end;
    2 : begin
          strgs := 'l2time';
          LevelTime := BBSCfg.L2T;
        end;
    3 : begin
          strgs := 'l3time';
          LevelTime := BBSCfg.L3T;
        end;
    4 : begin
          strgs := 'l4time';
          LevelTime := BBSCfg.L4T;
        end;
    5 : begin
          strgs := 'l5time';
          LevelTime := BBSCfg.L5T;
        end;
    6 : begin
          strgs := 'l6time';
          LevelTime := BBSCfg.L6T;
        end;
    7 : begin
          strgs := 'l7time';
          LevelTime := BBSCfg.L7T;
        end;
    8 : begin
          strgs := 'l8time';
          LevelTime := BBSCfg.L8T;
        end;
    9 : begin
          strgs := 'l9time';
          LevelTime := BBSCfg.L9T;
        end;
  end;
  str(UserLevel, level);
  repeat
    LineFeed;
    LineFeed;
    Print('Enter New Level ' + level + ' Time : ');
    Response := ReadKB(5);
    val(Response, LevelTime, CodeData);
    if (LevelTime >= 1) and (levelTime <= 999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set ' + strgs + '=' + response;
       query := pchar(querystr);
       if sql_query(query) then
        begin
           if sql_affected_rows = 0 then
            begin
              LogError(' SYSOP:  Error updating UserLevel.' + Level + ' - ' + inifile + ' ' + ErrorString(ProfileStatus));
              {isposeINICollection;}
              linefeed;
              Print('Update Failed..');
              delay(1500);
              exit;
            end
          else
            begin
              LineFeed;
              LineFeed;
              Colour(FWhite);
              Print('User Level Update Success ..');
             { DisposeINICollection;}
              delay(1500);
              case UserLevel of
                   1 : begin
                         BBSCfg.L1T := LevelTime;
                       end;
                   2 : begin
                         BBSCfg.L2T := LevelTime;
                       end;
                   3 : begin
                         BBSCfg.L3T := LevelTime;
                       end;
                   4 : begin
                         BBSCfg.L4T := LevelTime;
                       end;
                   5 : begin
                         BBSCfg.L5T := LevelTime;
                       end;
                   6 : begin
                         BBSCfg.L6T := LevelTime;
                       end;
                   7 : begin
                         BBSCfg.L7T := LevelTime;
                       end;
                   8 : begin
                         BBSCfg.L8T := LevelTime;
                       end;
                   9 : begin
                         BBSCfg.L9T := LevelTime;
                       end;
                end;
              exit;
            end;
          end
        else
          begin
            {SQL ERROR}
          end;
     end
    else
     begin
       Linefeed;
       Linefeed;
       Colour(FRed);
       Print('Time must be >=1  and <= 999..');
       delay(1500);
     end;
  until Response ='';
end;
(*..........................................................................*)
procedure sysopinfo;
var
 NewNodes : integer;
 inifile,
 strgs    : string;
begin
  If BBSCfg.BinDir[Length(BBSCfg.BinDir)] = '/' then
       inifile := BBSCfg.BinDir + 'linux'
  else inifile := BBSCfg.BinDir + '/' + 'linux';
  Linefeed;
  Print('Update SYSOP/BBS Information..');
  Linefeed;
  Linefeed;
  Print('Sysops First Name : ' + BBSCfg.SysopFirst);
  Linefeed;
  Print('Sysops Last Name  : ' + BBSCfg.SysopSec);
  Linefeed;
  Print('BBS Name          : ' + BBSCfg.BBSName);
  Linefeed;
  Print('BBS Host Name     : ' + BBSCfg.BBSTele);
  Linefeed;
  Linefeed;
  Print('Press enter on blank line to user current settings..');
  LineFeed;
  LineFeed;
  Print('Enter Sysop First : ');
  NoUpper := true;
  Response := ReadKB(30);
  if (Response <> '') and (Response <> BBSCfg.SysopFirst) then
   begin
     { Setup SQL }
     querystr := 'update bbs_config set sysopfirst=''' + response + '''';
     query := pchar(querystr);
     { delete post from database }
     if sql_query(query) then
      begin
         if sql_affected_rows = 0 then
          begin
           LogError(' SYSOP:  Error updating SYSOPFIRST.. see sqlerror.log - ' + querystr);
           LogSQLError(sqlerror);
           linefeed;
           Print('Update Failed..');
           delay(1500);
           NoUpper := false;
           exit;
         end
       else
         begin
           BBSCfg.SysopFirst := Response;
           LineFeed;
           Print('BBS Sysop First Update Success ..');
           delay(1000);
         end;
     end
    else
     begin
       LineFeed;
       Print('SQL Error - see log!');
       delay(1500);
       LogSQLError(sqlerror);
     end;
   end;
  LineFeed;
  Print('Enter Sysop Last name : ');
  Response := ReadKB(30);
  if (Response <> '') and (Response <> BBSCfg.SysopSec) then
   begin
     { Setup SQL }
     querystr := 'update bbs_config set sysopsec=''' + response + '''';
     query := pchar(querystr);
     { delete post from database }
     if sql_query(query) then
      begin
         if sql_affected_rows = 0 then
          begin
           LogError(' SYSOP:  Error updating SYSOPSEC.. see sqlerror.log - ' + querystr);
           LogSQLError(sqlerror);
           linefeed;
           Print('Update Failed..');
           delay(1500);
           NoUpper := false;
           exit;
         end
       else
         begin
           BBSCfg.SysopSec := Response;
           LineFeed;
           Print('BBS Sysop Sec Update Success ..');
           delay(1000);
         end;
     end
    else
     begin
       LineFeed;
       Print('SQL Error - see log!');
       delay(1500);
       LogSQLError(sqlerror);
     end;
   end;
  LineFeed;
  Print('Enter BBS Name : ');
  Response := ReadKB(30);
  if (Response <> '') and (Response <> BBSCfg.BBSName) then
   begin
     { Setup SQL }
     querystr := 'update bbs_config set bbsname=''' + response + '''';
     query := pchar(querystr);
     { delete post from database }
     if sql_query(query) then
      begin
         if sql_affected_rows = 0 then
          begin
           LogError(' SYSOP:  Error updating BBSNAME.. see sqlerror.log - ' + querystr);
           LogSQLError(sqlerror);
           linefeed;
           Print('Update Failed..');
           delay(1500);
           NoUpper := false;
           exit;
         end
       else
         begin
           BBSCfg.BBSName := Response;
           LineFeed;
           Print('BBS Name Update Success ..');
           delay(1000);
         end;
     end
    else
     begin
       LineFeed;
       Print('SQL Error - see log!');
       delay(1500);
       LogSQLError(sqlerror);
     end;

   end;
  LineFeed;
  Print('Enter BBS Host Name : ');
  Response := ReadKB(30);
  if (Response <> '')  and (Response <> BBSCFG.BBSTele) then
   begin
     { Setup SQL }
     querystr := 'update bbs_config set bbstel=''' + response + '''';
     query := pchar(querystr);
     { delete post from database }
     if sql_query(query) then
      begin
         if sql_affected_rows = 0 then
          begin
           LogError(' SYSOP:  Error updating BBSTEL.. see sqlerror.log - ' + querystr);
           LogSQLError(sqlerror);
           linefeed;
           Print('Update Failed..');
           delay(1500);
           NoUpper := false;
           exit;
         end
       else
         begin
           BBSCfg.BBSTele := Response;
           LineFeed;
           Print('BBS TEL Update Success ..');
           delay(1000);
         end;
     end
    else
     begin
       LineFeed;
       Print('SQL Error - see log!');
       delay(1500);
       LogSQLError(sqlerror);
     end;
   end;
  Linefeed;
  LineFeed;
  Print('Update Complete..');
  delay(1500);
  NoUpper := false;
end;
(*..........................................................................*)
procedure  sysopnodes;
var
 results    : recbuf;
 rows       : rowbuf;
 NewNodes : integer;
 strgs    : string;
begin
  str(BBSCfg.BBSNodes, strgs);
  Linefeed;
  Linefeed;
  Print('BBS Nodes = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter Nodes (1 -50) : ');
    Response := ReadKB(4);
    val(Response, NewNodes, CodeData);
    if (NewNodes >=1) and (NewNodes <= 50) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set bbsnodes=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBSNODES.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.BBSNodes := NewNodes;
             LineFeed;
             LineFeed;
             Print('BBS Nodes Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*..........................................................................*)
procedure  sysopuseruid;
var
 results    : recbuf;
 rows       : rowbuf;
 NewUid   : integer;
 strgs    : string;
begin
  str(BBSCfg.LinuxUID, strgs);
  Linefeed;
  Linefeed;
  Print('BBS User UID = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New UID  : ');
    Response := ReadKB(6);
    val(Response, NewUID, CodeData);
    if (NewUID >=1) and (NewUID <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set useruid=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating User UID.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.LinuxUID := NewUID;
             LineFeed;
             LineFeed;
             Print('BBS User UID Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopuid;
var
 results    : recbuf;
 rows       : rowbuf;
 NewUid   : integer;
 strgs    : string;
begin
  Str(BBSCfg.SysopUID, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Sysop UID = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Sysop UID  : ');
    Response := ReadKB(6);
    val(Response, NewUID, CodeData);
    if (NewUID >= 1) and (NewUID <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set sysopuid=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating Sysop UID.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.SysopUID := NewUID;
             LineFeed;
             LineFeed;
             Print('BBS Sysop UID Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopguestuid;
var
 results    : recbuf;
 rows       : rowbuf;
 NewUid   : integer;
 strgs    : string;
begin
  Str(GuestUID, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Guest UID = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Guest UID  : ');
    Response := ReadKB(6);
    val(Response, NewUID, CodeData);
    if (NewUID >= 1) and (NewUID <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set guestuid=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating Guest UID.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             GuestUID := NewUID;
             LineFeed;
             LineFeed;
             Print('BBS Guest UID Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopguestsallowed;
var
 results    : recbuf;
 rows       : rowbuf;
 NewUid   : integer;
 strgs    : string;
begin
  Str(BBSCfg.GuestsAllowed, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Total Guests Allowed Online = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Number of Online Guests  : ');
    Response := ReadKB(6);
    val(Response, NewUID, CodeData);
    if (NewUID >= 1) and (NewUID <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set guestsallowed=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating online Guests allowed.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.GuestsAllowed := NewUID;
             LineFeed;
             LineFeed;
             Print('BBS Online Guests Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopbbscalls;
var
 results    : recbuf;
 rows       : rowbuf;
 NewCalls : integer;
 strgs    : string;
begin
  Str(BBSCfg.Calls, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Total Calls = [' + strgs + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New BBS Calls  : ');
    Response := ReadKB(6);
    val(Response, NewCalls, CodeData);
    if (NewCalls >= 1) and (NewCalls <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set calls=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBS calls.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.Calls := NewCalls;
             LineFeed;
             LineFeed;
             Print('BBS Calls Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopidletime;
var
 results    : recbuf;
 rows       : rowbuf;
 NewIdle  : integer;
 strgs    : string;
begin
  Str(BBSCfg.IdleTime, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Idle Time = [' + strgs + '] minutes');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New BBS Idle Time  : ');
    Response := ReadKB(6);
    val(Response, NewIdle, CodeData);
    if (NewIdle >= 1) and (NewIdle <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set idletime=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBS idle time.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.IdleTime := NewIdle;
             LineFeed;
             LineFeed;
             Print('BBS Idle Time Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysoperrorlog;
var
 results    : recbuf;
 rows       : rowbuf;
 strgs    : string;
begin
  Linefeed;
  Linefeed;
  Print('BBS Error Log Filename = [' + BBSCfg.ErrFile + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New BBS Error Log Filename  : ');
    NoUpper := true;
    Response := ReadKB(20);
    NoUpper := false;
    if Response <> '' then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set errorlog=''' + response + '''';
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBS error log filename.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.ErrFile := Response;
             LineFeed;
             Print('BBS Error Log Filename Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopuserlog;
var
 results    : recbuf;
 rows       : rowbuf;
 strgs    : string;
begin
  Linefeed;
  Linefeed;
  Print('BBS User Log Filename = [' + BBSCfg.LogFile + ']');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New BBS User Log Filename  : ');
    NoUpper := true;
    Response := ReadKB(20);
    NoUpper := false;
    if Response <> '' then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set userlog=''' + response + '''';
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBS user log filename.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.LogFile := Response;
             LineFeed;
             Print('BBS User Log Filename Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopshowip;
var
 results    : recbuf;
 rows       : rowbuf;
 NewShowIP  : integer;
 strgs      : string;
begin
  Str(BBSCfg.ShowIP, Strgs);
  Linefeed;
  Linefeed;
  Colour(FGreen);
  Print('BBS ShowWho = [' + strgs +']');
  Linefeed;
  Linefeed;
  Print('0 = Disabled');
  Linefeed;
  Print('1 = User IP Address');
  Linefeed;
  Print('2 = Current Script Page Title');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Value  : ');
    Response := ReadKB(6);
    if response = '' then exit;
    val(Response, NewShowIP, CodeData);
    if (NewShowIP >= 0) and (NewShowIP <= 2) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set showwho=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating BBS showip.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.ShowIP := NewShowIP;
             LineFeed;
             Print('BBS ShowIP Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure  sysopbulletinforum;
var
 results    : recbuf;
 rows       : rowbuf;
 NewFid   : integer;
 strgs    : string;
begin
  Str(BBSCfg.BulletinForum, Strgs);
  Linefeed;
  Linefeed;
  Print('BBS Bulletin Forum FID = [' + strgs + '] minutes');
  Linefeed;
  Linefeed;
  Repeat
    Print('Enter New Forum FID  : ');
    Response := ReadKB(6);
    val(Response, NewFid, CodeData);
    if (NewFid >= 1) and (NewFid <= 9999) then
     begin
       { Setup SQL }
       querystr := 'update bbs_config set bulletinforum=' + response;
       query := pchar(querystr);
        { delete post from database }
       if sql_query(query) then
        begin 
           if sql_affected_rows = 0 then
            begin
             LogError(' SYSOP:  Error updating bulletin forum.. see sqlerror.log - ' + querystr);
             LogSQLError(sqlerror);
             linefeed;
             linefeed;
             Print('Update Failed..');
             delay(1500);
             exit;
           end
         else
           begin
             BBSCfg.BulletinForum := NewFid;
             LineFeed;
             LineFeed;
             Print('BBS Bulletin Forum Update Success ..');
             delay(1500);
             exit;
           end;
       end
      else
       begin
         LineFeed;
         LineFeed;
         Print('SQL Error - see log!');
         delay(1500);
         LogSQLError(sqlerror);
       end;
   end;
  until Response = '';
end;
(*.........................................................................*)
procedure sysoplistfileareas;
var
 AreaNo,
 Loop     : integer;
 DataArea,
 Strgs    : string;
 FileArea : Area;
 AreaFile : file of Area;
begin
  { Get data area DB }
  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then
      DataArea := BBSCfg.DataDir + 'areas.dat'
  Else DataArea := BBSCfg.DataDir + '/' + 'areas.dat';
  ClearDisplay(true);
  Assign(AreaFile, DataArea);
  {$I-}
  Reset(AreaFile);
  FileError := IOResult;
  if FileError <> 0 then
   begin
     Linefeed;
     Linefeed;
     Print('Sysop, there are no file areas defined or there was an error.. see error.log for more info');
     LogError('SYSOP: Error opening areas.dat - ' + ErrorString(FileError));
     delay(1500);
     {$I+}
   end
  else
   begin
     Print('Id   Area  Description                     FileNo  CatNo');
     LineFeed;
     Print('-----------------------------------------------------------------');
     for Loop := 0 to (filesize(AreaFile) - 1) do
      begin
        Seek(AreaFile, Loop);
        read(Areafile, FileArea);
        FileError := IOResult;
        if FileError <> 0 then
         begin
           Linefeed;
           Linefeed;
           Print('Sysop, unable to retrive file area information.. see error.log for more info');
           LogError('SYSOP: Error reading areas.dat - ' + ErrorString(FileError));
           delay(1500);
         end
        else
         begin
           LineFeed;
           SetX('1');
           Str(Loop, Strgs);
           Print(Strgs);
           SetX('6');
           Print(FileArea.AreaNumber);
           SetX('11');
           Print(FileArea.Description);
           SetX('45');
           Str(FileArea.FileNumber, Strgs);
           Print(Strgs);
           SetX('53');
           Str(FileArea.CatNumber, Strgs);
           Print(Strgs);
         end;
      end;
      LineFeed;
      LineFeed;
      Close(AreaFile);
      {$I+}
   end;
end;
(*..........................................................................*)
procedure sysopsubfile(Area : integer);
begin

end;
(*..........................................................................*)
procedure sysopmanagemainfilearea;
begin
  { SysopListFileAreas;
   Print('[E]dit Area [D]elete Area [A]dd Area [M]ange Sub Areas [Q]uit');
   Repeat
    Response := ReadKB(1);
    case Response of
      'E' : begin
            end;
      'D' : begin
            end;
      'A' : begin
            end;
      'M' : begin
            end;
    end;
   Until Response = 'Q';}
end;

end.
