(* ........................................................................ *)
(*        								    *)
(* MODULE	:   SFAERA.PAS      			                    *)
(*									    *)
(* DESCRIPTION	:   FILE AREA SELECTION                                     *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)               
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)      
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit SFAERA;

Interface

{$IFDEF _LINUX_}
  Uses Crt, Dos, Lib, Data, Colours;
{$ELSE}
  Uses Crt, Dos, Lib, Data, Colours, WaitTix;
{$ENDIF}

procedure SelectFileArea(Number : Integer);

Implementation
(*..........................................................................*)
function Selection : Integer;
Var
  Select : Integer;
begin
  Print(SFilePrompt);
  NoUpper := False;
  Response := ReadKB(30);
    Begin
      If Response = SArea then
        begin
          Selection := -2;
        end
       Else
        begin
          Val(Response, Select, Loop);
          If (Select <> 0) or (Select > AreaSize) then
            begin
              Selection := Select;
            end
          Else
            begin
              Selection := -1;
            end;
        end;
    end;
end;
(*..........................................................................*)
procedure ListAreas;
Var
  Codes    : String;
  Step     : Integer;
  X,Y,line,
  Next     : Integer;
  X1, X2   : String;
begin
  ClearDisplay(True);
  Next := 0;
  Step := 0;
  X    := 2;
  Y    := 1;
  Line := 1;
  Print(SFileHead1);
  LineFeed;
  Print(SFileHead2);
  LineFeed;
  Print(SFileHead3);
  LineFeed;
  Print(' ');
  X1 := '5';
  X2 := '43';
  SetX(X1);
  Repeat
      {$I-}
      Seek(FileArea, Step);
      Read(FileArea, Areas);
      {$I+}
      Inc(Step);
      If  UserInfo.UserLevel >= Areas.Access then
       begin
        Str(Areas.DirNo, Codes);
        Colour(FYellow);
        Print(Codes);
        Print('. ');
        if Next = 0 then
          begin
            Colour(FGreen);
          end
        Else
          begin
            Colour(FCyan);
          end;
        Print(Areas.DirDes);
        if Step >= 9 then
          begin
            X1 := '4';
            X2 := '42';
          end;
        if Y = 1 then
          begin
            SetX(X2);
            If Next = 1 then Next := 0
             Else Next := 1;
          end
          Else
            begin
              LineFeed;
              SetX(X1);
            end;
        If Y = 1 then Y := 0
          Else Y := 1;
        if Line = (UserInfo.UserLines * 2) - 6 then
          begin
            HoldPage;
            Line := 1;
            X1   := '6';
          end
        else
          begin
           inc(line);
          end;
        end; 
    Until Step = AreaSize;
  if UserInfo.UserColour = 1 then
        begin
          Colour(FWhite);
        end;
  LineFeed;
  LineFeed;
end;
(*..........................................................................*)
procedure SelectFileArea(Number : Integer);
Var
  Code  : Integer;
  DirNo : Integer;
begin
  DirNo := Areas.DirNo; { Store CurrenT Directory Number }
  If Number = -1 then
    begin
      Repeat
        ListAreas;
        Code := 0;
        Code := Selection;   { Goto Select File Area }
        Case Code of
            -1 : begin
                   Seek(FileArea, DirNo - 1);
                   Read(FileArea, Areas);
                   Exit;
                 end;
            -2 : ListAreas;
        end; { Case End }
      Until Code > -1;
      If Code <= AreaSize then
        begin
          Seek(FileArea, Code - 1);
          Read(FileArea, Areas);
          If Areas.Access > UserInfo.UserLevel then
            begin  { Check Whether User Has Access To File Area }
              Linefeed;
	      Print(NoAccess);
	      {$IFDEF _LINUX_}
		Delay(3000);
              {$ELSE}
		Wait(30);
	      {$ENDIF}
              Exit;
              {$I-}
                Seek(FileArea, DirNo - 1);
                Read(FileArea, Areas);
              {$I+}
              Exit;
           end;
         end
      else
        begin
          LineFeed;
          Print(InvalidArea);
	  Linefeed;
	  {$IFDEF _LINUX_}
	    Delay(3000);
          {$ELSE}
	    Wait(30);
	  {$ENDIF}
        end;
    end
  else
    begin
    end;
end;
end.
