(* $Id: sf2u.pp,v 1.14 2008-02-26 23:07:44 simon Exp $                       *)
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   SF2U.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   SCRIPT FILE INTERPRETER                                 *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2008                                *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.2-2                *)
(*..........................................................................*)
(* NOTES:                                                                   *)
(*..........................................................................*)
(*
   $Log: sf2u.pp,v $
   Revision 1.14  2008-02-26 23:07:44  simon
   Removed some dead chars

   Revision 1.13  2008-02-25 23:13:18  simon
   Enchaned Read Forum Procedures

   Revision 1.12  2008-02-25 20:37:42  simon
   Updated

   Revision 1.11  2008-02-25 00:04:40  simon
   updated

   Revision 1.10  2008-02-22 22:27:46  simon
   bug fixes

   Revision 1.9  2008-02-20 23:50:51  simon
   update

   Revision 1.8  2008-02-20 16:39:51  simon
   added %maxtime% to check for time exceeded
   use in logon.sfi if %maxtime% = %true% then TIMEBYE
   Cleaned up logoff after time expire

   Revision 1.7  2008-02-20 00:10:17  simon
   Cleaned up doorcom code..

   Revision 1.6  2008-02-19 21:58:09  simon
   see todo.txt

   Revision 1.4  2008/02/11 22:40:36  simon
   Removed old units

   Revision 1.3  2008-02-11 22:28:30  simon
   Removed old units no longer required

*)
Unit SF2U;

interface

{$IFDEF _LINUX_}
  Uses linux, Dos, Crt, Data, Lib, Lib2, editor, SFAera, FileList, FileTag,
      GetDL, Dates, Search, ErrorLog, Colours, MainFile, Msgs, LinuxNew,
      Strings,door, Unix, BaseUnix, unixutil,sysop,strutils,mail,linuxlock,
      Forum,bulletin,user,SelectionBox;
{$ELSE}
 Uses Dos, Crt, Data, Lib, Editor, SFAera, FileList, Stats, FileTag, GetDL,
      ChkPas, GetUser, SignUps, PIBAsync, Dates, Search, ErrorLog, Page, Colours,
      Lib2, MainFile, Door, ExecSwap, WaitTix, Msgs, LockUser, Protocol;
{$ENDIF}

procedure SFi(FileName : String);

implementation
(*..........................................................................*)
{ Global Variables }
Var
  Out        : Text;       { Output File }
  InF        : Text;       { Input Script File }
  Line       : String;     { Holds Line Data } { Changed from String[80] }
  Bit        : Integer;    { Line String Number }
  Cmd        : String[80]; { Stores Script Command }
  Name       : String;     { Stores FileName }
  Jump       : Boolean;
  JumpLa     : String;
  Prompt     : String;
  Temp       : String;
  BeginCmd   : Boolean;
  Level,
  Code,
  LineNumber : Integer;
  ShowTime   : Boolean;
  Quotes     : Boolean;
  DirInfo    : SearchRec;
  Select,
  UserVorig   : string;
  MenuDisplay : boolean;  { Sets to true if Script MENU Command used }

const
  SwapLoc : array[Boolean] of String[7] = ('on disk', 'in EMS');
(*..........................................................................*)
procedure WaitKey;
Var
  Key : Char;
begin
  Key := ReadKey;
  Key := Chr(00);
end;
(*..........................................................................*)
function UserVars(OK : Boolean; Variable : string) : string;
Var
  Start,
  ends, i,
  MailCount,
  COMPort   : Integer;
  UserV,
  Strgs,
  MailPath  : String;
  FSize     : LongInt;
  UserVOK   : Boolean;
  {$IFDEF _LINUX_}
    uts : utsname; { uname information }
  {$ENDIF}
  Year,month,day,hour,minute,seconds : Word;
  Y,m,d,h,min,s : string;
begin
  Start    := Bit + 1;
  ends     := 0;
  UserVOK  := True;
  UserV    := '';
  Strgs    := '';
  UserVars := '';
  COMPort  := 0;
  If Ok then
    begin
     Repeat
       If (Line[Bit] <> Chr($25)) and (Bit < length(line)) then
         begin
          Inc(Ends);
         end;
      Inc(Bit);
     Until (Line[Bit] = Chr($25)) or (bit > length(line));
     UserV := Copy(Line, Start, Ends);
     UserVorig := '%' + UserV + '%';
     For Loop := 1 to Length(UserV) do
       UserV[Loop] := UpCase(UserV[Loop]);
    end
  Else
    begin
      UserV := Variable;
    end;
  if UserV = 'EMSGWAITING' then
   begin
     if MailCountNew = 0 then UserVars := ''
      else UserVars := '[YOU HAVE NEW MAIL]';
      UserVOK := False;
   end;
  If UserV = 'LASTERROR' then
     begin
      Str(error, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  {$IFDEF _LINUX_}
  fpuname(uts);
  if (UserV = 'MAILWAITING') or (UserV = 'INTERNETMAIL') then
     begin
       if InternetMail = 0 then
        begin
          UserVars := '';
        end
       else
        begin
          UserVars := '[YOU HAVE EMAIL]';
        end;
       UserVOK := False;
     end;
  if UserV = 'INTERNETADDRESS' then
     begin
       UserVars := GetEnv('USER') + '@' + GetDomainName;
       UserVOK := False;
     end;
  if UserV = 'UTS_SYSNAME' then
    begin
      UserVars := uts.sysname;
      UserVOK  := False;
    end;
  if UserV = 'UTS_NODENAME' then
    begin
      UserVars := uts.nodename;
      UserVOK  := False;
    end;
  if UserV = 'UTS_RELEASE' then
    begin
      UserVars := uts.release;
      UserVOK  := False;
    end;
  if UserV = 'UTS_VERSION' then
    begin
      UserVars := uts.version;
      UserVOK  := False;
    end;
  if UserV = 'UTS_MACHINE' then
    begin
      UserVars := uts.machine;
      UserVOK  := False;
    end;
  if UserV = 'UTS_DOMAINNAME' then
    begin
      UserVars := uts.domain;
      UserVOK  := False;
    end;
  if UserV = 'REMOTEHOST' then
    begin
      UserVars := remotehost;
      UserVOK  := False;
    end;
  if UserV = 'REMOTEIP' then
    begin
      UserVars := remoteip;
      UserVOK  := False;
    end;
  {$ENDIF}
  { SAURON COLOUR CODES }
  { FORGROUND }
  If UserV = 'F:BLACK' then
    begin
      UserVars := Char(224);
      UserVOK  := False;
    end;
  If UserV = 'F:RED' then
    begin
      UserVars := Char(225);
      UserVOK  := False;
    end;
  If UserV = 'F:GREEN' then
    begin
      UserVars := Char(226);
      UserVOK  := False;
    end;
  If UserV = 'F:YELLOW' then
    begin
      UserVars := Char(227);
      UserVOK  := False;
    end;
  If UserV = 'F:BLUE' then
    begin
      UserVars := Char(228);
      UserVOK  := False;
    end;
  If UserV = 'F:MAGENTA' then
    begin
      UserVars := Char(229);
      UserVOK  := False;
    end;
  If UserV = 'F:CYAN' then
    begin
      UserVars := Char(230);
      UserVOK  := False;
    end;
  If UserV = 'F:WHITE' then
    begin
      UserVars := Char(231);
      UserVOK  := False;
    end;
{ BACKGROUND }
  If UserV = 'B:BLACK' then
    begin
      UserVars := Char(232);
      UserVOK  := False;
    end;
  If UserV = 'B:RED' then
    begin
      UserVars := Char(233);
      UserVOK  := False;
    end;
  If UserV = 'B:GREEN' then
    begin
      UserVars := Char(234);
      UserVOK  := False;
    end;
  If UserV = 'B:YELLOW' then
    begin
      UserVars := Char(235);
      UserVOK  := False;
    end;
  If UserV = 'B:BLUE' then
    begin
      UserVars := Char(236);
      UserVOK  := False;
    end;
  If UserV = 'B:MAGENTA' then
    begin
      UserVars := Char(237);
      UserVOK  := False;
    end;
  If UserV = 'B:CYAN' then
    begin
      UserVars := Char(238);
      UserVOK  := False;
    end;
  If UserV = 'B:WHITE' then
    begin
      UserVars := Char(239);
      UserVOK  := False;
    end;
  If UserV = 'SCRIPTTITLE' then
    begin
      UserVars := ScriptTitle;
      UserVOK  := False;
    end;
  If UserV = 'SYSTEMDIR' then
     begin
       I := Length(BBSCfg.SysDir);
       If BBSCfg.SysDir[I] = directory_Seperator then
        UserVars := BBSCfg.SysDir
       Else UserVars := BBSCfg.SysDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'SCRIPTDIR' then
     begin
       I := Length(BBSCfg.ScriptDir);
       If BBSCfg.ScriptDir[I] = directory_Seperator then
        UserVars := BBSCfg.ScriptDir
       Else UserVars := BBSCfg.ScriptDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'BBSMAILDIR' then
     begin
       I := Length(BBSCfg.BBSMailDir);
       If BBSCfg.BBSMailDir[I] = directory_Seperator then
        UserVars := BBSCfg.BBSMailDir
       Else UserVars := BBSCfg.BBSMailDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'MENUDIR' then
     begin
       I := Length(BBSCfg.MenuDir);
       If BBSCfg.MenuDir[I] = directory_Seperator then
        UserVars := BBSCfg.MenuDir
        Else UserVars := BBSCfg.MenuDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'MSGDIR' then
     begin
       I := Length(BBSCfg.MsgDir);
       If BBSCfg.MsgDir[I] = directory_Seperator then
        UserVars := BBSCfg.MsgDir
       Else UserVars := BBSCfg.MsgDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'TEMPDIR' then
     begin
       I := Length(BBSCfg.TempDir);
       If BBSCfg.TempDir[I] = directory_Seperator then
        UserVars := BBSCfg.TempDir
       Else UserVars := BBSCfg.TempDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'BINDIR' then
     begin
       I := Length(BBSCfg.BinDir);
       If BBSCfg.BinDir[I] = directory_Seperator then
        UserVars := BBSCfg.BinDir
       Else UserVars := BBSCfg.BinDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'LOGDIR' then
     begin
       I := Length(BBSCfg.LogDir);
       If BBSCfg.LogDir[I] = directory_Seperator then
        UserVars := BBSCfg.LogDir
       Else UserVars := BBSCfg.LogDir + directory_Seperator;
       UserVOK  := False;
     end;
  If UserV = 'TEXTDIR' then
     begin
       I := Length(BBSCfg.textDir);
       If BBSCfg.TextDir[I] = directory_Seperator then
        UserVars := BBSCfg.textDir
       Else UserVars := BBSCfg.TextDir + directory_Seperator;
       UserVOK  := False;
     end;

  if UserV = 'CALLSLIMIT' then
     begin
       case userinfo.userlevel of
           1: Str(bbscfg.l1c, Strgs);
           2: Str(bbscfg.l2c, Strgs);
           3: Str(bbscfg.l3c, Strgs);
           4: Str(bbscfg.l4c, Strgs);
           5: Str(bbscfg.l5c, Strgs);
           6: Str(bbscfg.l6c, Strgs);
           7: Str(bbscfg.l7c, Strgs);
           8: Str(bbscfg.l8c, Strgs);
           9: Str(bbscfg.l9c, Strgs);
       end;
       UserVars := Strgs;
       UserVOK  := False;
    end;
  if UserV = 'TIMELIMIT' then
     begin
       case userinfo.userlevel of
           1: Str(bbscfg.l1t, Strgs);
           2: Str(bbscfg.l2t, Strgs);
           3: Str(bbscfg.l3t, Strgs);
           4: Str(bbscfg.l4t, Strgs);
           5: Str(bbscfg.l5t, Strgs);
           6: Str(bbscfg.l6t, Strgs);
           7: Str(bbscfg.l7t, Strgs);
           8: Str(bbscfg.l8t, Strgs);
           9: Str(bbscfg.l9t, Strgs);
       end;
       UserVars := Strgs;
       UserVOK  := False;
    end;
    If UserV = 'SESSIONRESET' then
     begin
      EpochToLocal ((UserInfo.UserTimeStamp + 86400),Year,month,day,hour,minute,seconds);
      Str(Year, Y);
      Str(Month, M);
      Str(Day, D);
      Str(Hour, H);
      Str(Minute, Min);
      Str(Seconds, S);
      UserVars := D + '/' + M + '/' + Y + ' @ ' + H + ':' + Min + ':' + S;
      UserVOK  := False;
     end;
  If UserV = 'BBSNAME' then
     begin
       UserVars := BBSCfg.BBSName;
       UserVOK  := false;
     end;
  If UserV = 'BBSHOST' then
     begin
       UserVars := BBSCfg.BBSTele;
       UserVOK  := false;
     end;
  If UserV = 'IDLETIME' then
     begin
      Str(BBSCfg.IdleTime, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'NODE' then
     begin
      Str(NodeNo, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'NODES' then
     begin
      Str(BBSCfg.bbsnodes, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  if UserV = 'TIMESTAMP' then
     begin
       str(fptime, strgs);
       UserVars := strgs;
       UserVOK  := false;
     end;
  If UserV = 'USERCREATION' then
     begin
      EpochToLocal (UserInfo.UserTime,Year,month,day,hour,minute,seconds);
      Str(Year, Y);
      Str(Month, M);
      Str(Day, D);
      Str(Hour, H);
      Str(Minute, Min);
      Str(Seconds, S);
      UserVars := D + '/' + M + '/' + Y + '-' + H + ':' + Min + ':' + S;
      UserVOK  := False;
     end;
    If UserV = 'NEWUSERS' then
     begin
      Str(UserSignUpCount, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'GUESTTOTAL' then
     begin
      Str(GuestUserCount, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'USERTOTAL' then
     begin
      Str(UserCount, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'USERLEVEL' then
     begin
      Str(UserInfo.UserLevel, Strgs);
      UserVars := Strgs;
      UserVOK  := False;
     end;
  If UserV = 'USERFULLNAME' then
    begin
      UserVars := UserInfo.UserNameFull;
      UserVOk  := False;
    end;
  If UserV = 'USERNAME' then
     begin
      UserVars := UserInfo.UserNAME;
      UserVOK  := False;
     end;
  If UserV = 'NEWUSERNAME' then
     begin
      UserVars := AddUser.UserNAME;
      UserVOK  := False;
     end;
  If UserV = 'USERTOWN' then
      begin
       UserVars := UserInfo.UserTOWN;
       UserVOK  := False;
      end;
  If UserV = 'USERPASSWORD' then
      begin
        UserVars := AddUser.UserPass;
        UserVOk  := False;
      end;
  If UserV = 'USEROLDPASSWORD' then
      begin
        UserVars := UserOldPassword;
        UserVOk  := False;
      end;
  If UserV = 'USERNUMBER' then
      begin
        UserVars := UserInfo.UserAcc;
        UserVOk  := False;
      end;
  If UserV = 'USEREMAIL' then
      begin
        UserVars := UserInfo.UserEmail;
        UserVOk  := False;
      end;
  If UserV = 'TODAYSDATE' then
     begin
       UserVars  := Today;  { Todays Date }
       UserVOk   := False;
     end;
  If UserV = 'USERLASTCALL' then
     begin
       If UserInfo.Calls = 1 then
        UserVars := Today
       Else
        UserVars := LastCalls;
       UserVOK  := False;
     end;
  If UserV = 'USERTOTALCALLS' then
     begin
       If UserInfo.Calls = 1 then
        UserVars := 'This Is Your First Call'
       Else
         begin
           Str(UserInfo.Calls, Strgs);
           UserVars := Strgs;
         end;
       UserVOK  := False;
     end;
  If UserV = 'USERCALLSTODAY' then
     begin
       Str(UserInfo.CallsToday, Strgs);
       UserVars := Strgs;
       UserVOk  := False;
     end;
  If UserV = 'TIMELEFT' then
     begin
       i := TimeLeft;
       Str(i, Strgs);
       UserVars := Strgs;
       UserVOk  := False;
     end;
  If UserV = 'CALLSWHILEAWAY' then
     begin
       i := (callaway - 1) - lastcall;
       Str(i, Strgs);
       UserVars := Strgs;
       UserVOk  := False;
     end;
  If UserV = 'MAILCOUNTTOTAL' Then
    begin
      Str(MailCountTotal, Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  If UserV = 'MAILCOUNTNEW' Then
    begin
      Str(MailCountNew, Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  If UserV = 'MAILCOUNT' Then
    begin
      MailCount := CountMail;
      Str(MailCount, Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  If UserV = 'CALLNUMBER' then
      begin
        Str(BBSCfg.Calls, Strgs);
        UserVars := Strgs;
        UserVOk  := False;
      end;
  If UserV = 'USERDOWNLOADS' then
      begin
        Str(UserInfo.DownLoads, Strgs);
        UserVars := Strgs;
        UserVOk  := False;
      end;
  If UserV = 'USERDLBYTES' then
      begin
        Str(UserInfo.BytesDl, Strgs);
        UserVars := Strgs;
        UserVOk  := False;
      end;
  If UserV = 'USEREMAILADDRESS' then
      begin
        UserVars := UserInfo.UserEmail;
        UserVOK  := False;
      end;
  If UserV = 'PORT' then
      begin
        Strgs := '';
        COMPort := BBSCfg.ComPort + 1;
        Str(COMPort, Strgs);
        UserVars := Strgs;
        UserVOk  := False;
      end;
  If UserV = 'BAUD' then
      begin
        FSize := LineBaud;
        Str(FSize, Strgs);
        UserVars := Strgs;
        UserVOK  := False;
      end;
  If UserV = 'LINEBAUD' then
      begin
        FSize := Carrier;
        Str(FSize, Strgs);
        UserVars := Strgs;
        UserVOK  := False;
      end;
  If UserV = 'CONNECTSTRING' then
      begin
        UserVars := ConnectString;
        UserVOK  := False
      end;
  If UserV = 'SCREEN' then
      begin
        Case UserInfo.UserANSI of
            1: UserVars := 'ANSI';
            2: UserVars := 'AVATAR Type 0';
            3: UserVars := 'SAURON';
           Else
               UserVars := 'UNKOWN';
        end; { Case End }
       UserVOK  := False;
      end;
  If UserV = 'COLOUR' then
     begin
       If UserInfo.UserColour = 0 then
         begin
           UserVars := 'NO';
         end
       Else
         begin
           UserVars := 'YES';
         end;
       UserVOk  := False;
     end;
  If UserV = 'MAINFILEAREA' then
     begin
       UserVars := SAreas.Description;
       UserVOK  := False;
     end;
  If UserV = 'FILEAREA' then
     begin
       UserVars := Areas.DirDes;
       UserVOK  := False;
     end;
  (*
  If UserV = 'LASTCALLER' then
     begin
       UserVars := LastCaller;
       UserVOK  := False;
     end;
  If UserV = 'LASTTOWN' then
     begin
       UserVars := LastCallerTown;
       UserVOK  := False;
     end;
  *)
  If UserV = 'FILENAME' then
     begin
       UserVars := DlFile;
       UserVOk  := False;
     end;
  If UserV = 'TIMEONLINE' then
     begin
       Str(SessionLength, Strgs);
       UserVars := Strgs;
       UserVOk  := False;
     end;
  If UserV = 'BULLETINNUMBER' then
     begin
       Str(BulletinNumber(BBSCfg.BulletinForum), Strgs);
       UserVars := Strgs;
       UserVOk  := False;
    end;
  If UserV = 'FILECOUNT' then
     begin
       Assign(Files, Areas.FileLst);
       {$I-} Reset(Files); {$I+}
       If IOResult <> 0 then
         begin
            UserVars := '0';
            UserVOk  := False;
         end
      Else
        begin
          FSize := FileSize(Files);
          Str(FSize, Strgs);
          UserVars := Strgs;
          UserVOk  := False;
          Close(Files);
        end;
     end;
  If UserV = 'USERINFO1' then
    begin
      UserVars := UserInfo.UserInfo1;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO2' then
    begin
      UserVars := UserInfo.UserInfo2;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO3' then
    begin
      UserVars := UserInfo.UserInfo3;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO4' then
    begin
      UserVars := UserInfo.UserInfo4;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO5' then
    begin
      UserVars := UserInfo.UserInfo5;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO6' then
    begin
      UserVars := UserInfo.UserInfo6;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO7' then
    begin
      UserVars := UserInfo.UserInfo7;
      UserVOk  := False;
    end;
  If UserV = 'USERINFO8' then
    begin
      UserVars := UserInfo.UserInfo8;
      UserVOk  := False;
    end;
  If UserV = 'MESSAGEAREA' then
    begin
      UserVars := Msg.AreaName;
      UserVOk  := False;
    end;
  if userv = 'MESSAGESIZE' then
    begin
      Str(MessageCount, Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  if userv = 'FORUMS' then
    begin
      Str(ForumCount, Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  if userv = 'ALLFORUMPOSTS' then
    begin
      Str(ForumTotalPosts(0), Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  if userv = 'ALLFORUMREPLIES' then
    begin
      Str(ForumTotalReplies(0), Strgs);
      UserVars := Strgs;
      UserVOk  := False;
    end;
  If UserV = 'FORUMTITLE' then
    begin
      UserVars := ForumTitle;
      UserVOK  := False;
    end;
  If UserV = 'FORUMDESC' then
    begin
      UserVars := ForumDesc;
      UserVOK  := False;
    end;
  If UserV = 'FORUMPOSTS' then
    begin
      Str(ForumPosts(ForumID), Strgs);
      UserVars := Strgs;
      UserVOK  := False;
    end;
  If UserV = 'NEWFORUMREPLIES' then
    begin
      str(ForumTotalReplies(UserInfo.UserLogon), Strgs);
      UserVars := Strgs;
      UserVOK  := False;
    end;
  If UserV = 'NEWFORUMPOSTS' then
    begin
      str(ForumTotalPosts(UserInfo.UserLogon), Strgs);
      UserVars := Strgs;
      UserVOK  := False;
    end;
  If UserV = 'SYSOPUID' then
    begin
      Str(BBSCfg.SysopUID,Strgs);
      UserVars := Strgs;
      UserVOK  := false;
    end;
 if UserV = 'GUESTUID' then
   begin
     str(GuestUID, Strgs);
     UserVars := Strgs;
     UserVOK  := false;
   end;
 if UserV = 'SYSOPDELETEPOSTS' then
   begin
     str(SysopDeletedPosts, Strgs);
     UserVars := Strgs;
     UserVOK  := false;
   end;
 if UserV = 'SYSOPDELETEFORUMS' then
   begin
     str(SysopDeletedForums, Strgs);
     UserVars := Strgs;
     UserVOK  := false;
   end;

  If UserVOK then
     begin
       WriteLn;
       TCol(White);
       Write('Unknown Variable : ');
       TCol(Yellow);
       Writeln('%',UserV,'% ');
       TCol(White);
       Writeln('In Module ',Name,' Line=[',linenumber,']');
       Writeln('Line=',Line);
       Writeln('Press Any Key To Continue Script');
       LogError('Unkown Variable ' + '%' + UserV + '%' + ' In Module ' + Name);
       If Local then Repeat Until Keypressed;
     end;
end;
(*..........................................................................*)
{ Commands }
procedure Prints;
Var
  Outs : String;
begin
  Outs  := ' ';
  If (Line[Bit] = Chr($22)) and (Length(Line) > 6) then
    begin
     Repeat
       If Line[Bit] <> chr($25) then Inc(Bit);
       If Line[Bit] = Chr($25) then
         begin
           Outs := UserVars(True, '');
           Print(Outs);
           {if Line[Bit] = Chr($25) then Line[bit] := chr(0);}
           {writeln('INCBIT = (', line[bit],line[bit+1],')');}
           Inc(Bit);
         end;
         { Sauron Colour Codes }
         if (Line[Bit] >= Chr(224)) and (Line[Bit] <= Chr(239)) then
           begin
              Colour(Ord(Line[Bit]));
              Inc(Bit);
            end;
          If (Line[Bit] <> Chr($22)) and (Line[Bit] <> chr($25)) then
             begin
               Print(Line[Bit]);
             end;
     Until Line[Bit] = Chr($22);
     Linefeed;
    end
  Else
    begin
      LineFeed;
    end;
end;
(*..........................................................................*)
procedure PrintToLogs;
Var
  Start, ends : Integer;
  uts,
  LogFile,Outs : String;
  Log         : Text;
begin
  Start := Bit + 1;
  ends  := 0;
  If BBSCfg.LogDir[Length(BBSCfg.LogDir)] = directory_Seperator then
        LogFile := BBSCfg.LogDir + BBSCfg.LogFile
  Else LogFile := BBSCfg.LogDir + directory_Seperator + BBSCfg.LogFile;
  Assign(Log, LogFile);
  {$I-} append(Log); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      {$I-} Rewrite(Log); {$I+}
      FileError := IOResult;
      if FileError <> 0 then exit;
      WriteLn(Log,'LOG CREATED ', Today);
      Writeln(Log);
    end;
  Repeat
    If Line[Bit] <> Chr($27) then
      begin
        If Line[Bit] = Chr($25) then
          begin
            Outs := UserVars(True, '');
            Write(Log, Outs);
            Inc(Bit);
          end;
        Write(Log, Line[Bit]);
        Inc(Ends);
      end;
   Inc(Bit);
  Until Line[Bit] = Chr($27);
  WriteLn(Log);
  Close(Log);
  fpchmod (LogFile, &0666);
end;
(*..........................................................................*)
procedure LPrint;
Var
  Outs : String;
begin
  Outs := '';         {"}
  If (Line[Bit] = Chr($22)) or (Line[Bit + 1] = Chr($22)) then
    begin
      If Line[Bit + 1] = Chr($22) then
         begin
           inc(Bit);
         end;
     Repeat
       inc(Bit);
       If Line[Bit] = Chr($25) then
         begin
           Outs := UserVars(True, '');
           Print(Outs);
           Inc(Bit);
         end;
         { Sauron Colour Codes }
         if (Line[Bit] >= Chr(224)) and (Line[Bit] <= Chr(239)) then
            begin
              Colour(Ord(Line[Bit]));
              Inc(Bit);
            end;
          If Line[Bit] <> Chr($22) then
             begin
               Print(Line[Bit]);
             end;
     Until Line[Bit] = Chr($22);
    end
  Else
    begin
      { Print Nothing }
      Print(' ');
      LineFeed;
    end;
end;
(*..........................................................................*)
procedure Printfiles;
Var
  GetLine : Char;
  PFile   : Text;
  Start, ends, i : Integer;
begin
  Start := Bit;
  ends  := Bit + 1;
  Cmd   := Chr(0);
  Repeat
    If Line[Bit] <> Chr($20) then
      begin
        Inc(Ends);
        Inc(Bit);
      end;
  Until Line[Bit] = chr($20);
  Cmd := Copy(Line, Start, Ends);
  If Cmd[1] = ' ' then Cmd := Copy(Line, Start + 1, Ends);
  PrintFile(Cmd);
end;
(*..........................................................................*)
procedure Ifs;
Var
  Start, ends, count,
  MailCount,
  MaxCalls               : Integer;
  Comd                   : array[1..5] of string;
  Exp1, Exp2, Exp3       : integer;
  MailPath, TByte        : String;
begin
  Exp1  := -1;
  Exp2  := -1;
  Start := Bit;
  ends  := 0;
  Count := 0;
  Repeat
    Repeat
      If Line[Bit] <> Chr($20) then
        begin
          Inc(Ends) ;
        end;
    Inc(Bit);
    Until Line[Bit] = Chr($20);
    Inc(Count);
    Comd[count] := Copy(Line, Start, Ends);
    For Loop := 1 to Length(Comd[Count]) do
       Comd[Count, Loop] := UpCase(Comd[Count, Loop]);
    Start := Start + (ends + 1);
    Ends := 0;
  Until Count = 5;
   If Comd[1] = '%ANSIDETECT%' then
     begin
       if (AnsiDetect) then
        begin
          Exp1 := 1
        end
       else
        begin
          Exp1 := 0;
        end;
     end;
   If Comd[1] = '%ANSI%' then Exp1 := UserInfo.UserANSI;
   If Comd[1] = '%ERROR%' then Exp1 := Error;
   If Comd[1] = '%YN%' then Exp1 := YN;
   If Comd[1] = '%BULLETINNUMBER%' then Exp1 := BulletinNumber(BBSCfg.BulletinForum);
   If Comd[1] = '%USERBULLETIN%' then Exp1 := UserInfo.Bulletin;
   If Comd[1] = '%MAXCALLS%' then
                 begin
                   case userinfo.userlevel of
                       1: maxcalls := bbscfg.l1c;
                       2: maxcalls := bbscfg.l2c;
                       3: maxcalls := bbscfg.l3c;
                       4: maxcalls := bbscfg.l4c;
                       5: maxcalls := bbscfg.l5c;
                       6: maxcalls := bbscfg.l6c;
                       7: maxcalls := bbscfg.l7c;
                       8: maxcalls := bbscfg.l8c;
                       9: maxcalls := bbscfg.l9c;
                   end;
                   if UserInfo.Callstoday >= maxcalls then Exp1 :=1
                    else Exp1 := 0;
		 end;
   If Comd[1] = '%MAXTIME%' then
                 begin
	   	   if timeleft <= 0 then Exp1 :=1
	             else Exp1 := 0;
		 end;
   If Comd[1] = '%MAXNODES%' then
                 begin
                   if maxnodes then Exp1 := 1
                    else Exp1 := 0;
                 end;
   if Comd[1] = '%MAXGUESTS%' then
                begin
                  if BBSCfg.GuestsAllowed = GuestsOnline then Exp1 := 1
                   else Exp1 := 0;
                end;
   If Comd[1] = '%REGISTERED%' then
                 begin
                   if UserInfo.UserReg = true then Exp1 :=1
                    else Exp1 := 0;
		 end;
   If Comd[1] = '%FIRSTCALL%' then
                 begin
                   if UserInfo.Calls = 1 then Exp1 :=1
                    else Exp1 := 0;
		 end;
   If Comd[1] = '%MAILCOUNT%' then Exp1 := CountMail;
   If Comd[1] = '%MAILCOUNTNEW%' then Exp1 := MailCountNew;
   If Comd[1] = '%MAILCOUNTTOTAL%' then Exp1 := MailCountTotal;
   If Comd[1] = '%INTERNETMAIL%' then  Exp1 := InternetMail;
   If Comd[1] = '%USERNUMBER%' then Val(UserInfo.UserAcc, Exp1, Code);
   If Comd[1] = '%USERLEVEL%' then Exp1 := UserInfo.UserLevel;
   if Comd[1] = '%LINEBAUD%' then Exp1 := Carrier;
   if Comd[1] = '%CALLSWHILEAWAY%' then Exp1 := CallAway - LastCall;
   if Comd[1] = '%ROOT%' then
                 begin
                   if fpGetUID = 0 then Exp1 := 1
                    else Exp1 := 0;
                 end;
   if Comd[1] = '%GUEST%' then
		begin
		  if UserInfo.UserUID = GuestUID then Exp1 := 1
		   else Exp1 := 0;
		end;
   if Comd[1] = '%SYSOP%' then
		begin
		  if UserInfo.UserLevel = 9 then Exp1 := 1
		   else Exp1 := 0;
		end;
   TByte := Comd[3];
   if TByte[1] = '%' then  { Check For System Variable }
      begin
        If TByte = '%ERROR%' then Exp3 := Error;
        If TByte = '%YN%' then Exp3 := YN;
        If TByte = '%BULLETINNUMBER%' then Exp3 := BulletinNumber(BBSCfg.BulletinForum);
        If TByte = '%USERBULLETIN%' then Exp3 := UserInfo.Bulletin;
        If TByte = '%MAILCOUNT%' then Exp3 := CountMail;
        If TByte = '%TRUE%' then Exp3 := 1;
        If TByte = '%FALSE%' then Exp3 := 0;
      end
   Else
      begin
        Val(Comd[3], Exp3, Count);
      end;
  If Comd[2]  = '=' then
     begin
       If Exp1 = Exp3 then
         begin
           If Comd[4] = 'EXECUTE' then
             begin
               ScriptFile := lowercase(Comd[5]);
               FinScript  := True;
             end;
           If Comd[4] = 'THEN' Then
             begin
               Jump := True;
               JumpLa := ':' + Comd[5];
             end;
           If Comd[4] = 'PRINT' then
             begin
               Bit := 1;
               Line := Comd[5];
               Prints;
            end;
         end;
       Exp2 := 0;
     end;
  If Comd[2]  = '>' then
     begin
       If Exp1 > Exp3 then
         begin
           If Comd[4] = 'EXECUTE' then
             begin
               ScriptFile := Comd[5];
               FinScript  := True;
             end;
           If Comd[4] = 'THEN' Then
             begin
               Jump := True;
               JumpLa := ':' + Comd[5];
             end;
         end;
       Exp2 := 0;
     end;
  If Comd[2]  = '<>' then
     begin
       If Exp1 <> Exp3 then
         begin
           If Comd[4] = 'EXECUTE' then
             begin
               ScriptFile := Comd[5];
               FinScript  := True;
             end;
           If Comd[4] = 'THEN' Then
             begin
               Jump := True;
               JumpLa := ':' + Comd[5];
             end;
         end;
       Exp2 := 0;
     end;
  If Exp1 = -1 then
    begin
      Writeln;
      TCol(WHITE);
      Write('IF ');
      TCol(Yellow);
      Write(Comd[1],' ');
      TCol(WHITE);
      Write(Comd[2],' ',Comd[3],' ',Comd[4],' ',Comd[5]);
      Writeln;
      Writeln('Command Not Supported In Module : ',Name);
      Writeln('Press Anu Key To Continue Script File');
      If Local then WaitKey;
    end;
  If Exp2 = -1 then
    begin
      Writeln;
      Write('IF ', Comd[1],' ');
      TCol(Yellow);
      Write(Comd[2],' ');
      TCol(White);
      Write(Comd[3],' ',Comd[4],' ',Comd[5]);
      Writeln;
      Writeln('Command Not Supported In Module : ',Name);
      Writeln('Press Any Key To Continue Script File');
      If Local then WaitKey;
    end;
end;
(*..........................................................................*)
procedure Jumps;
var
  Start, ends : Integer;
begin
  Start := Bit;
  ends  := Bit + 1;
  Repeat
    If Line[Bit] <> Chr($20) then
      begin
        Inc(Ends);
        Inc(Bit);
      end;
  Until Line[Bit] = chr($20);
  Cmd := Copy(Line, Start, Ends);
  Jump   := True;
  JumpLa := ':' + Cmd;
end;
(*..........................................................................*)
procedure SetPrompt;
var
  Start, ends : Integer;
  Outs : String;
begin
  Start  := Bit + 1;
  ends   := 0;
  Prompt := '';
  Outs   := '';
  Repeat
    if Line[Bit] = #37 then
     begin
        Outs := UserVars(True,'');
        Prompt := Prompt + Outs;
        Inc(Bit);
      end;
     if (Line[Bit] >= #224) and (Line[Bit] <= #239) then
          begin
            Colour(Ord(Line[Bit]));
            Prompt := Prompt + Line[Bit];
            Inc(Bit);
           end;
    Prompt := Prompt + Line[Bit];
    Inc(Ends);
    Inc(Bit);
  Until Bit = length(Line); {Chr($27)}
  LineFeed;
end;
(*..........................................................................*)
procedure DisplayMenu(FileName : String);
Var
  GetLine  : Char;
  PFile    : file of Char;
  TextGrab,
  Grab     : String;
  {Regs     : Registers;}
  Vars     : Boolean;
begin
  Vars := False;
  TextGrab := '';
  Grab     := '';
  Assign(PFile, FileName);
  {$I-} Reset(PFile); {$I+}
  If IOResult <> 0 then
    begin
      LogError(FileName + ' File Not Found');
    end
  Else
    begin
      While not eof(PFile) do
       begin
         Read(PFile, GetLine);
         Grab := Grab + GetLine;
         if GetLine = '%' then
           begin
             If (GetLine = '%') and (Vars = true) then
               begin
                 Vars := False;
                 Response := UserVars(False, TextGrab);
                 Print(Response);
                 GetLine := #17;
               end;
           end;
         if (GetLine = '%') and (Vars = False) then Vars := True;
         If GetLine <> '%' then TextGrab := TextGrab + GetLine;
         if not Vars then
           begin
             If GetLine <> #17 then Print(GetLine);
             TextGrab := '';
           end;
       end;
       Close(PFile);
    end;
end;
(*..........................................................................*)
procedure Menu;
Var
  Start, ends : Integer;
  FileN       : String;
begin
  Start := 1;
  ends  := 1;
  Bit   := 1;
  Repeat
    If Name[Bit] <> Chr($2E) then {.}
      begin
        Inc(Ends);
      end;
   Inc(Bit);
  Until Name[Bit] = Chr($2E);
  if UserInfo.UserCls = True Then ClearDisplay(True);
  {$IFDEF _LINUX_}
  {$ELSE}
    UserStats;
  {$ENDIF}
  FileN := Copy(Name, Start, Ends);
  If BBSCfg.MenuDir[Length(BBSCfg.MenuDir)] = Directory_Seperator then
    begin
      FileN := BBSCfg.MenuDir + FileN;
    end
  Else
    begin
      FileN := BBSCfg.MenuDir + Directory_Seperator + FileN;
    end;
  If (UserInfo.UserANSI = 1) and (UserInfo.UserColour = 1) then
    begin
      FileN := FileN + 'ans' { ANSI Menus }
    end
  Else
    begin
       If (UserInfo.UserANSI = 2) and (UserInfo.UserColour = 1) then
        begin
          FileN := FileN + 'avt'; { AVATAR Menus }
        end
      Else
        begin
          FileN := FileN + 'vt100'; { ASCII Menus }
        end;
    end;
  {Logerror('Displaying' + FileN);}
  DisplayMenu(FileN);
  //LineFeed;
  Cmd := '';
  Colour(FWhite);
  //Blinkoff;
end;
(*..........................................................................*)
procedure Cls;
begin
  ClearDisplay(True);
end;

(*..........................................................................*)
procedure Pauses;
Var
  Outs : String;
begin
  if Bit < Length(Line) then
   begin
     Repeat
     { Sauron Colour Codes }
       if (Line[Bit] >= Chr(224)) and (Line[Bit] <= Chr(239)) then
         begin
           Colour(Ord(Line[Bit]));
           Inc(Bit);
         end
       Else
         begin
           Print(Line[Bit]);
           Inc(Bit);
         end;
     Until Bit = Length(Line) + 1;
   end;
  HoldPage;
(*  Response := '';
  Response := ReadKB(1);
  LineFeed;
*)
end;
(*..........................................................................*)
procedure WaitDelay; { Delay For XX Seconds }
var
  Start, ends, Ms : Integer;
begin
  Start := Bit;
  ends  := Bit + 1;
  Repeat
    If Line[Bit] <> Chr($20) then
      begin
        Inc(Ends);
        Inc(Bit);
      end;
  Until Line[Bit] = chr($20);
  Cmd := Copy(Line, Start, Ends);
  Val(Cmd, Ms, Code); { Convert String To Decimal }
  if Code <> 0 then Print('Error In WAITDELAY')
    else
  {$IFDEF _LINUX_}
    Delay(Ms);
  {$ELSE}
    Wait(Ms);
  {$ENDIF}
end;
(*..........................................................................*)
function ReturnString: string; { Returns Text After Command }
Var
  Start, ends, Ms,
  Vstart, Vend,
  loop : Integer;
  Vars : string;
begin
  Start := Bit;
  ends  := Bit + 1;
  vStart := 0;
  vEnd := 0;
  Repeat
//    write('Line[bit]=[',ord(line[bit]),'] bit=[',bit,'] ');
//    If (Line[Bit] <> Chr($20)) or (Line[Bit] <> chr($13)) or (Line[Bit] <> chr($10)) or (Line[Bit] <> Chr($25)) then
    if (ord(line[bit]) > 32) and (ord(line[bit]) <> 37) then
      begin
  //      write('*');
        Inc(Ends);
        Inc(Bit);
      end;
    if (ord(Line[Bit]) = 37) and (Bit < length(Line)) then
      begin
    //    writeln;
    //    writeln('found %');
     //   writeln('Line[bit]=[',ord(line[bit]),'] bit=[',bit,'] length=',length(line));
        vStart := bit;
        Vars := UserVars(true,'');
        if Vars <> '' then Line := AnsiReplaceText(Line,UserVorig,Vars);
        inc(bit);
        vEnd := bit;
        inc(Ends);
     //   writeln('Vo = ',UserVorig,'Var = ', vars,' Start [',vstart,'] vesnd [',vend,']');
     //   writeln('line-',line);
      end
    else inc(bit);
  // Until (Line[Bit] = chr($20)) or (Line[Bit] = chr($13)) or (Line[Bit] = chr($10)) or (bit >= length(Line));
  until (bit >= length(line));
  (*
  if vStart <> 0 then
   begin
     returnstring := Copy(Line, (start - 1) ,(vStart - (start - 1))) + Vars + Copy(Line,vEnd,(ends -1));
     if ord(returnstring[0]) < 33 then returnstring := Copy(returnstring,2,length(returnstring));
   end
  else
   begin *)
    if ord(Line[Start]) < 33 then returnString := Copy(Line, Start + 1, length(line))
     else returnString := Copy(Line, Start, length(line));
   //end;
  // writeln;
  // writeln('ReturnString = ',returnstring,'START ',start,' vstart ',vstart,'[',ord(returnstring[0]),'] length ', length(line));
  // delay(2000);
end;
(*..........................................................................*)
procedure Gotos;
var
  Start, ends : Integer;
begin
  LastScript := ScriptFile;
  ScriptFile := '';
  if BeginCmd then Start := Bit + 1
    Else Start := Bit;
  ends  := 0;
  Repeat
    If Line[Bit] <> Chr($20) then
      begin
        Inc(Ends);
      end;
   Inc(Bit);
  Until Line[Bit] = Chr($20);
  ScriptFile := Copy(Line, Start, Ends);
end;
(*..........................................................................*)
procedure SetCursor;
Var
  Start, ends, i : Integer;
  X, Y           : String;
begin
  Start := Bit;
  ends  := 0;
  Repeat
    If Line[Bit] <> Chr($2C) then
      begin
        Inc(Ends);
        Inc(Bit);
      end;
  Until Line[Bit] = chr($2C);
  X := Copy(Line, Start, Ends);
  Start := Bit + 1;
  Ends  := 0;
  Repeat
    If Line[Bit] <> Chr($20) then
      begin
        Inc(Ends);
        Inc(Bit);
      end;
  Until Line[Bit] = chr($20);
  Y := Copy(Line, Start, Ends);
  SetCur(X,Y);
end;
(*..........................................................................*)
procedure DisplayQuote;
var
  QuoteFile : text;
  FileLen,
  Step,
  Choose    : Integer;
  Quote,
  QuoteData   : String;
begin
  If BBSCfg.SysDir[Length(BBSCfg.SysDir)] = directory_Seperator then
        QuoteData := BBSCfg.SysDir + 'quote.txt'
  Else QuoteData := BBSCfg.SysDir + directory_Seperator + 'quote.txt';
  Assign(QuoteFile, QuoteData);
  {$I-} Reset(QuoteFile); {$I+}
  If IOResult <> 0 then
    begin
    end
  Else
    begin
      Randomize;
      FileLen := 0;
      Choose  := 0;
      While not Eof(QuoteFile) do
        begin
         ReadLn(QuoteFile, Quote);
         Inc(FileLen);
        end;
      Choose  := 0;
      Dec(FileLen);
      Choose := Random(FileLen) + 1;
      {$I+} Reset(QuoteFile); {$I+}
      For Step := 1 to Choose do
         begin
           Readln(QuoteFile, Quote);
         end;
      If UserInfo.UserColour = 1 then
                 begin
                   If UserInfo.UserANSi = 1 then { ANSI }
                     begin
                       Print('[1;33m');
                     end
                    Else
                     begin
                       if UserInfo.UserAnsi = 2 then  { AVATAR }
                         begin
                           Print(#22 + #1 + #14);
                         end
                       Else
                         begin
                           { SAURON COLOUR }
                         end;
                     end;
                 end;
      Print(Quote);
      If UserInfo.UserColour = 1 then
                 begin
                   If UserInfo.UserANSi = 1 then { ANSI }
                     begin
                       Print('[1;37m');
                     end
                   Else
                     begin
                       if UserInfo.UserAnsi = 2 then  { AVATAR }
                         begin
                           Print(#22 + #1 + #15);
                         end
                       Else
                         begin
                           { SAURON COLOUR }
                        end;
                     end;
                 end;
      LineFeed;
      Close(QuoteFile);
    end;
end;
(*..........................................................................*)
procedure CallDos;
var
  Command: string[255];
  Start, ends : Integer;
  Outs,
  Ins   : String;
  LineL : Integer;
  status : word;
begin
  Start := Bit;
  ends  := 0;
  LineL := Length(Line);
  Cmd   := '';
  (*
  Repeat
    If Line[Bit] <> Chr($27) then
      begin
        If Line[Bit] = Chr($25) then
          begin
            Outs := UserVars(True,'');
            Cmd := Cmd + Outs;
            Inc(Bit);
          end;
        Cmd := Cmd + Line[Bit];
        Inc(Ends);
      end;
   Inc(Bit);
  Until Bit = LineL + 1;
  *)
  Cmd := returnstring;
  {$IFDEF _LINUX_}
    Command := Cmd;
  {$ELSE}
    Command := '/C ' + Cmd;
  {$ENDIF}
  LogError('[' + Command + ']');
  Str(BBSCfg.Node, Outs);
  {$IFDEF _LINUX_}
    Colour(FWhite);
{    Exec(Command, ''); }
    updatelocktime(true);
    error := shell(Command);
    updatelocktime(false);
    LogError('Shell Exit Code :- ' + ErrorString(Error));
  {$ELSE}
    UseEmsIfAvailable := True;
    { If using TP 5.5 then change FreeList^ to FreePtr^ }
    if not InitExecSwap(Ptr(seg(FreeList^)+$1000, 0), 'SWAP.' + Outs) then
       LogError('Unable to allocate swap space')
    else
      begin
        Str(BytesSwapped, Outs);
        LogError('Allocated ' + Outs +  ' bytes');
        SwapVectors;
        Status := ExecWithSwap(GetEnv('COMSPEC'), Command);
        SwapVectors;
        ShutDownExecSwap;
        Str(Status, Ins);
        Logerror('Dos Exec status: ' + Ins + ' - ' + ErrorString(Status));
        Str(DosError, Ins);
        Logerror(' Dos Error Code: ' + Ins + ' - ' + ErrorString(DosError));
    end;
    { If InitFossil then SetBaudRate(BBSCfg.BaudRate); }
  {$ENDIF}
end;
(*..........................................................................*)
procedure GetPassword;
var
  Outs,
  Line1,
  Line2 : String;
begin
  Line1 := '';
  Line2 := '';
  Repeat
    If Line[Bit] <> Chr($22) then
      begin
        { Sauron Colour Codes }
         if (Line[Bit] >= Chr(224)) and (Line[Bit] <= Chr(239)) then
            begin
              Line1 := Line1 + Line[Bit];
            end
          Else
            begin
              Line1 := Line1 + Line[Bit];
            end;
      end;
   Inc(Bit);
  Until Line[Bit] = Chr($22);
  Repeat
    inc(Bit);
  Until Line[Bit] = Chr($22);
  Repeat
    If Line[Bit] <> Chr($22) then
      begin
        { Sauron Colour Codes }
         if (Line[Bit] >= Chr(224)) and (Line[Bit] <= Chr(239)) then
            begin
            {  Colour(Ord(Line[Bit])); }
              Line2 := Line2 + Line[Bit];
            end
          Else
            begin
              Line2 := Line2 + Line[Bit];
            end;
      end;
   Inc(Bit);
  Until Line[Bit] = Chr($22);
  {$IFDEF _LINUX_}
    NoUpper := TRUE;
  {$ENDIF}
  Repeat
    Repeat
      LineFeed;
      Print(Line1);
      { PromptQuotes(10); }
      PassEcho := True;
      NewUserKB := true;
      Response := ReadKB(20);
      {$IFDEF _LINUX_}
        AddUser.UserPass := Response;
      {$ELSE}
        UserInfo.UserPass := Response;
      {$ENDIF}
    Until Length(Response) > 6;
    LineFeed;
    Print(Line2);
    { PromptQuotes(10); }
    Response := ReadKB(20);
    PassEcho := False;
    NewUserKB := false;
  {$IFDEF _LINUX_}
    if  Response <> AddUser.UserPass then
     begin
       Linefeed;
       Print('Passwords do not match.!');
       LineFeed;
     end;
    Until Response = AddUser.UserPass;
    NoUpper := FALSE;
  {$ELSE}
    Until Response = UserInfo.UserPass;
  {$ENDIF}
end;
(*..........................................................................*)
procedure OpenFiles(filename : string);
var
  Outs : String;
begin
{
  Outs := '';
  Repeat
    Outs := Outs + Line[Bit];
    Inc(Bit);
  Until Bit = Length(Line) + 1;
  Assign(Out, Outs);
  }
  outs := filename;
  Assign(Out, Outs);
  {$I-} Append(Out); {$I+}
  If IOResult <> 0 then
    begin
     {$I-} Rewrite(Out); {$I-}
      If IOResult <> 0 then
        begin
          LogError('Unable To Create/Open ' + Outs);
          Error := 1;
        end
      Else
        begin
          LogError('File ' + Outs + ' Created');
          Writeln(Out,'File Created ', Today);
          Writeln(Out,'Date : ', Today);
          Writeln(Out,'UserName ',UserInfo.Username);
          Writeln(Out,'OpenFile  data');
        end;
    end
  else
    begin
      Writeln(Out);
      Writeln(Out,'User Number : ',UserInfo.UserAcc);
      Writeln(Out,'User Handle : ',UserInfo.UserName);
      Writeln(Out,'Date : ', Today);
    end;
end;
(*..........................................................................*)
procedure CmdLine(Cmds : String; S, E: Integer);
Var
  Dude,
  Flag   : Boolean;
  X1, C1,
  S1, E1,
  ValCode : Integer;
  p : lineptr;
begin
   Bit := 0;
   Dude := False;
   textcolor(white);
   { START -------------------------- }
   If Cmds = 'LISTBOXTEXTCOLOUR' then
     begin
       Bit := S + E;
       val(ReturnString, ListBox.TextColour, ValCode);
       Dude := True;
     end;
   If Cmds = 'LISTBOXTEXTBGCOLOUR' then
     begin
       Bit := S + E;
       val(ReturnString, ListBox.TextBgColour, ValCode);
       Dude := True;
     end;
   If Cmds = 'LISTBOXPOSX' then
     begin
       Bit := S + E;
       ListBox.PosX := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXPOSY' then
     begin
       Bit := S + E;
       ListBox.PosY := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXWIDTH' then
     begin
       Bit := S + E;
       val(ReturnString, ListBox.Width, ValCode);
       Dude := True;
     end;
   If Cmds = 'LISTBOXDEPTH' then
     begin
       Bit := S + E;
       val(ReturnString, ListBox.Depth, ValCode);
       Dude := True;
     end;
   If Cmds = 'LISTBOXTOTALITEMS' then
     begin
       Bit := S + E;
       val(ReturnString, ListBox.ItemNo, ValCode);
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM01' then
     begin
       Bit := S + E;
       ListItems[1] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM02' then
     begin
       Bit := S + E;
       ListItems[2] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM03' then
     begin
       Bit := S + E;
       ListItems[3] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM04' then
     begin
       Bit := S + E;
       ListItems[4] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM05' then
     begin
       Bit := S + E;
       ListItems[5] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM06' then
     begin
       Bit := S + E;
       ListItems[6] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM07' then
     begin
       Bit := S + E;
       ListItems[7] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM08' then
     begin
       Bit := S + E;
       ListItems[8] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM09' then
     begin
       Bit := S + E;
       ListItems[9] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM10' then
     begin
       Bit := S + E;
       ListItems[10] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM11' then
     begin
       Bit := S + E;
       ListItems[11] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM12' then
     begin
       Bit := S + E;
       ListItems[12] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM13' then
     begin
       Bit := S + E;
       ListItems[13] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM14' then
     begin
       Bit := S + E;
       ListItems[14] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM15' then
     begin
       Bit := S + E;
       ListItems[15] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM16' then
     begin
       Bit := S + E;
       ListItems[16] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM17' then
     begin
       Bit := S + E;
       ListItems[17] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM18' then
     begin
       Bit := S + E;
       ListItems[18] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM19' then
     begin
       Bit := S + E;
       ListItems[19] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM20' then
     begin
       Bit := S + E;
       ListItems[20] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXITEM20' then
     begin
       Bit := S + E;
       ListItems[20] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY01' then
     begin
       Bit := S + E;
       ListBox.Key[1] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY02' then
     begin
       Bit := S + E;
       ListBox.Key[2] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY03' then
     begin
       Bit := S + E;
       ListBox.Key[3] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY04' then
     begin
       Bit := S + E;
       ListBox.Key[4] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY05' then
     begin
       Bit := S + E;
       ListBox.Key[5] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY06' then
     begin
       Bit := S + E;
       ListBox.Key[6] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY07' then
     begin
       Bit := S + E;
       ListBox.Key[7] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY08' then
     begin
       Bit := S + E;
       ListBox.Key[8] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY09' then
     begin
       Bit := S + E;
       ListBox.Key[9] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY10' then
     begin
       Bit := S + E;
       ListBox.Key[10] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY11' then
     begin
       Bit := S + E;
       ListBox.Key[11] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY12' then
     begin
       Bit := S + E;
       ListBox.Key[12] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY13' then
     begin
       Bit := S + E;
       ListBox.Key[13] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY14' then
     begin
       Bit := S + E;
       ListBox.Key[14] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY15' then
     begin
       Bit := S + E;
       ListBox.Key[15] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY16' then
     begin
       Bit := S + E;
       ListBox.Key[16] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY17' then
     begin
       Bit := S + E;
       ListBox.Key[17] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY18' then
     begin
       Bit := S + E;
       ListBox.Key[18] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY19' then
     begin
       Bit := S + E;
       ListBox.Key[19] := ReturnString;
       Dude := True;
     end;
   If Cmds ='LISTBOXKEY20' then
     begin
       Bit := S + E;
       ListBox.Key[20] := ReturnString;
       Dude := True;
     end;
   If Cmds = 'LISTBOXON' then
     begin
       ListBox.Display := true;
       Dude := True;
     end;
   { END ---------------------------- }
   If Cmds = 'SCRIPTTITLE' then
     begin
       Bit := S + E;
       ScriptTitle := ReturnString;
       Dude := True;
     end;
   If Cmds = 'REM' then           { REM  TEXT (c) Dude }
       Dude := True;
   If (Cmds[1] = chr($3A)) or (Cmds[1] = Chr($3B)) then {: ;}
       Dude := True;
   If Cmds = 'PRINTFILE' then     { Printfile <FileName.EXT> }
     begin
       Bit := S + E;
       cmd := '';
       cmd := returnstring;
       PrintFile(cmd);
       Dude := True;
     end;
    If Cmds = 'PRINT' then        { Print 'Text %uservars%' }
     begin
       Bit := S + E;
       Prints;
       Dude := True;
     end;
    if Cmds = 'PRINTTOLOG' then
     begin
       Bit := S + (E + 1);
       PrintToLogs;
       Dude := True;
     end;
    if Cmds = 'PRINTS' then
     begin
       Bit := S + E;
       LPrint;
       Dude := True;
     end;
    If Cmds = 'IF' then           { If <EXP1> = <EXP2> Then <Label>          }
     begin                       { <> >= <= > <       Goto <FileName.SFI>   }
       Bit := S + E;
       Ifs;
       Dude := True;
     end;
   If Cmds = 'JUMP' then
     begin
       Bit := S + E;
       Jumps;
       Dude := True;
     end;
    If Cmds = 'PROMPT' then
     begin
       Bit := S + E;
       Prompt := ReturnString;
       //SetPrompt;
       Dude := True;
     end;
    If (Cmds = 'PROMPTQUOTESON') or (Cmds = 'PROMPTQUOTESOFF') then
     begin
       If Cmds = 'PROMPTQUOTESON' then PromptQuote := True
        Else PromptQuote := False;
        Dude := True;
     end;
    if cmds = 'EDIT' then
     begin
       MailUser('0','','');
       dude := true;
     end;
    If Cmds = 'MENU' then
     begin
       Menu;
//       MenuDisplay := True;
       Dude := True;
     end;
    If Cmds = 'CLS' then
     begin
       Cls;
       Dude := True;
     end;
    { Lock user to node }
    if Cmds = 'LOCKUSER' then
     begin
       CreateSessionLockFile;
       Dude := true;
     end;
    if Cmds = 'DELETELOCKUSER' then
      begin
        deletesessionlockfile;
        Dude := true;
      end;
    if Cmds = 'ADDTOLOGINLIST' then
     begin
       AddToLoginList;
       Dude := true;
     end;
    if Cmds = 'SELECTSCREENDRIVER' then
     begin
       Echo := False;
       Repeat
         Response := ReadKB(2);
         If Response = '1' then       { ANSI Screen Driver }
           begin
             ColourSelect := 1;
             Dude := True;
           end
         Else
           begin
             if Response = '2' then      { AVATAR Screen Driver }
               begin
                 ColourSelect := 2;
                 Dude := True;
               end
             Else
               begin
                 If Response = '3' then     { SAURON Screen Driver }
                   begin
                     ColourSelect := 3;
                     Dude := True;
                   end;
               end;
           end;
       Until Dude = True;
       Echo := True;
     end;
    if Cmds = 'EMAIL' then         { Email User }
      begin
       Bit := S + E;
       Cmd := '';
       Cmd := ReturnString;
       NoUpper := true;
       If Length(Cmd) = 0 then
         begin
           MailUser('0','','');
           //TextEditStart(True, '0', '');
         end
       else
         begin
           MailUser(cmd,'','');
           //TextEditStart(True, Cmd,'');
         end;
       If UserInfo.UserCls = True Then Menu;
       NoUpper := false;
       Dude := True;
      end;
    if Cmds = 'READMAIL' then      { Read Your Mail }
      begin
        ListMail;
        ScriptFile := Name;
        FinScript  := True;
        Dude := True;
      end;
    if Cmds = 'EDITMAIL' then      { Edit Mail Sent By You }
     begin
        EditMail;
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'PAUSE' then
      begin
        Bit := S + E;
        Flag := False;
        if PromptQuote = False then Flag := True
         else PromptQuote := False;
        {Pauses;}
        HoldPage;
        if Flag then PromptQuote := True;
        Dude := True;
      end;
    if Cmds = 'USERLIST' then
      begin
        UserDisplay;
        Dude := True;
      end;
    if Cmds = 'WHOSBEENONLINE' then
      begin
        WhosBeenOnline;
        Dude := True;
      end;
    if Cmds = 'WHOSONLINE' then
      begin
	SessionWhosOnline;
        {If UserInfo.UserCls = True Then Menu;}
        Dude      := True;
      end;
    if Cmds = 'EXECUTE' then
      begin
        Bit := S + E;
        Gotos;
        FinScript := True;
        Dude      := True;
      end;
    if Cmds = 'LOGOFF' then
      begin
        ScriptFile := 'end';
        FinScript  := True;
        Dude       := True;
       end;
    if Cmds = 'SHOWTIMELEFT' then
       begin
         ShowTime := True;
         Dude     := True;
       end;
    if Cmds = 'SELECTMAINFILEAREA' then
       begin
         SelectMainfileArea(0);
         ScriptFile := Name;
         FinScript  := True;
         Dude       := True;
       end;
    if Cmds = 'SELECTFILEAREA' then
       begin
         SelectfileArea(-1);
         ScriptFile := Name;
         FinScript  := True;
         Dude       := True;
       end;
    If Cmd = 'WAIT' then
       begin
         Bit := S + E;
         WaitDelay;
         Dude := True;
       end;
    if Cmds = 'SETCURSOR' then
       begin
         Bit := S + E;
         SetCursor;
         Dude := True;
       end;
    If Cmds = 'PAGESYSOP' then
       begin
	 {$IFDEF _LINUX_}
	 {$ELSE}
           if (PageSysop) then
            begin
              TextEditStart(True, '1');
	    end;
	 {$ENDIF}
         If UserInfo.UserCls = True Then Menu;
         Dude := True;
       end;
    {$IFDEF _LINUX_ }
    if Cmds = 'DIRECTORYLIST' then
      begin
        Bit := S + E;
        Cmd := '';
        Cmd := ReturnString;
        case (Display_Directory(cmd)) of
          1 : begin  { Download File }
                ScriptFile := Download_Script;
                FinScript := True;
              end;
          else
            If UserInfo.UserCls = True Then Menu;
        end; {Case End }
        Dude := True;
      end;
    if Cmds = 'DOWNLOADSCRIPT' then
      begin
        Bit  := S + E;
        Download_Script := ReturnString;
        Dude := true;
      end;
    if Cmds = 'FILEVIEWER' then
      begin
        Bit  := S + E;
        File_Viewer := ReturnString;
        Dude := True;
      end;
    {$ENDIF}
    If Cmds = 'LISTFILES' then
       begin
         ListFiles;
         If UserInfo.UserCls = True Then Menu;
         Dude := True;
       end;
    if Cmds = 'MANAGETAGS' then
       begin
         ShowTags;
         If UserInfo.UserCls = True Then Menu;
         Dude := True;
       end;
    if Cmds = 'MAKETAGLIST' then
       begin
         MakeTagList;
         Dude := True;
       end;
    if Cmds = 'RETURN' then
       begin
         ScriptFile := LastScript;
         FinScript := True;
         Dude := True;
       end;
    {$IFDEF _LINUX_}
      if Cmds = 'SHELL' then
    {$ELSE}
      if Cmds = 'CALLDOS' then
    {$ENDIF}
      begin
        Bit := S + E;
        CallDos;
        Dude := True;
      end;
    if Cmds = 'DOORCOM' then
      begin
          Bit := S + E;
          LogError('Call To Dos Door : ' + Copy(Line, Bit + 1, Length(Line)));
          MakeDorInfo(NodeNo);
          MakeDoorSys(NodeNo);
          MakeDoorSys32(NodeNo);
          CallDos;
          // Error in get door time..
          // GetDoorTime(BBSCfg.Node);
          LogError('Exit Door OK');
          If UserInfo.UserCls = True Then Menu;
          Dude := True;
      end;
    if Cmds = 'RESETTIME' then
      begin
        ResetTime;
        Dude       := True;
      end;
    if Cmds = 'COLOURTOGGLE' then
      begin
        If UserInfo.UserColour = 0 then
          begin
            UserInfo.UserColour := 1
          end
        Else
          begin
            UserInfo.UserColour := 0;
          end;
        ScriptFile := Name;
        FinScript  := True;
        Dude := True;
      end;
    if Cmds = 'YESNO' then
     begin
       Bit := S + E;
       LPrint;
       Repeat
       Response := ReadKB(1);
       if Response = 'Y' then
          begin
            YN := 1;
            Dude := true;
          end
       else
         if Response = 'N' then
           begin
             YN := 0;
             Dude := true;
           end
         else
            Print(Chr($08));
       (*
       If Response = 'Y' then YN := 1
         Else YN := 0;
         Dude := True;
       *)
       until Dude = true;
     end;
    if Cmds = 'DISPLAYQUOTES' then
      begin
        Quotes := True;
        Dude   := True;
      end;
    if Cmds = 'GETULFILE' then
      begin
	UploadFile;
        Dude   := True;
      end;
    if Cmds = 'GETDLFILE' then
      begin
	{$IFDEF _LINUX_}
	{$ELSE}
	  GetdlFile;
	{$ENDIF}
        Dude := True;
      end;
    if Cmds = 'ZMODEMDOWNLOAD' then
      begin
	{$IFDEF _LINUX_}
	{$ELSE}
	  ZmodemDownload(DLFile);
        {$ENDIF}
        Dude := True;
      end;
    if Cmds = 'DELETETAGFILE' then
      begin
        DeleteTagFile;
        Dude := true;
      end;
    if Cmds = 'UPDATEUPLOAD' then
      begin
	UpDateUpLoadedFile;
        Dude   := True;
      end;
    if Cmds = 'UPDATEFILEDOWNLOAD' then
      begin
        If Tagged then
          begin
	    UpDateDownLoadedTags;
            Tagged := False;
          end
        Else
          begin
	    {$IFDEF _LINUX_}
            {$ELSE}
	      UpDateDownLoadedFile;
	    {$ENDIF}
          end;
        Dude := True;
      end;
    if Cmds = 'COPY&COMMENT' then
     begin
	{$IFDEF _LINUX_}
	{$ELSE}
	  CopyCommentFiles;
	{$ENDIF}
        Dude := True;
      end;
    if Cmds = 'SEARCHFORFILE' then
      begin
        SearchFiles;
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'UPDATEUSERBULLETIN' then
      begin
        UserInfo.Bulletin := BulletinNumber(BBSCfg.BulletinForum);
        UpdateUserBulletin(UserInfo.Bulletin, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'DISPLAYBULLETINS' then
      begin
        DisplayBulletins(BBSCfg.BulletinForum);
        Dude := True;
      end;

    if Cmds = 'GETUSEROLDPASSWORD' then
     begin
       PassEcho := true;
       NoUpper  := true;
       UserOldPassword := readKB(30);
       PassEcho := false;
       NoUpper  := false;
       dude := true;
     end;
   { DOS legacy }
   (* if Cmds = 'GETUSER' then
      begin
        Bit := S + E;
        LPrint;
        { PromptQuotes(30); }
        GetUsers(ReadKB(30));
        Dude := True;
      end; *)
    if Cmds = 'CREATEACCOUNT' then
      begin
        {$IFDEF _LINUX_ }
          if not Create_User then
           begin
             error := 1;
             LogError('Unable to add new user to ' + Adduser.UserName + ' to SQL');
           end;
        {$ELSE}
	  SignUp;
	{$ENDIF}
        Error := 1;
        Dude := True;
      end;
    if Cmds = 'SETCOLOUR' then
      begin
        UserInfo.UserColour := 1;
        Dude := true;
      end;
    if Cmds = 'ASKCOLOUR' then
      begin
        UserInfo.UserAnsi := ColourSelect;
        Bit := S + E;
        LPrint;
        Response := ReadKB(1);
        If (Response = 'y') or (Response = 'Y') then
          begin
            UserInfo.UserColour := 1
          end
        Else
          begin
            UserInfo.UserColour := 0;
          end;
        Dude := True;
        LineFeed;
      end;
    if Cmds = 'ASKSCREENCLEAR' then
      begin
        UserInfo.UserAnsi := ColourSelect;
        Bit := S + E;
        LPrint;
        { PromptQuotes(1); }
        Response := ReadKB(2);
        If (Response = 'y') or (Response = 'Y') then
          begin
            UserInfo.UserCLS := TRUE;
          end
        Else
          begin
            UserInfo.UserCLS := FALSE;
          end;
        Dude := True;
        LineFeed;
      end;
     if (Cmds = 'JOINUSERNAME') or (Cmds = 'CHANGEUSERNAME') then   { Asks For Users Name At Sign Up }
       begin
         Error := 0;
         E1 := E;
         S1 := S;
         Val(UserInfo.UserAcc, UserNumber, Code); { Store User Account Number }
         Repeat                                   { This is used when users chenges }
           Bit := S1 + E1;                        { There Name etc }
           LineFeed;
           LPrint;
           {$IFDEF _LINUX_}
             NoUpper := TRUE; { Do not convert response to upper case }
           {$ENDIF}
           { PromptQuotes(30); }
           NewUserKB := true;
           Response := ReadKb(16);
           NewUserKB := false;
           { If no name is entered assume user wants to exit and make %error% = true }
           if Response = '' then
            begin
              {$IFDEF _LINUX_}
                NoUpper := FALSE;
              {$ENDIF}
              Error := 1;
              exit;
            end;
           //LineFeed;
           { Check For Existing & Banned Names }
           if CheckUserName(Response) then
            begin
             {$IFDEF _LINUX_}
              NoUpper := FALSE;
              NewUserName := StrAlloc(Length(Response) + 1);
              StrPCopy(NewUserName, Response);
              if Check_For_Existing_User(NewUserName) then
               begin
                 Colour(fwhite);
                 colour(bblack);
                 linefeed;
                 Print('Sorry that name is taken, please choose another');
                 Response := '';
               end;
             {$ENDIF}
            end
           else
            begin
              Response := '';
            end;
         Until Length(Response) > 2;
         {$IFDEF _LINUX_}
           Adduser.UserName  := Response;
         {$ELSE}
           UserInfo.UserName := Response;
         {$ENDIF}
         //LineFeed;
         {$IFDEF _LINUX_}
           { Not Used In Linux Version }
         {$ELSE}
         if Cmds = 'CHANGEUSERNAME' then { Update User Database }
           begin
             {$I+}
              write('USERNUMBER ' , UserNumber);
               repeat until keypressed;
               Seek(DataFile, UserNumber);
               Write(DataFile, UserInfo);
            {$I+}
           end;
         {$ENDIF}
         Dude := True;
         colour(bblack);
       end;
     if Cmd = 'CREATEPASSWORDTAG' then
      begin
        if not MakePasswordTag(Useroldpassword, UserInfo.UserPass) then error := 1
         else error := 0;
        dude := true;
      end;
     if (Cmds = 'JOINPASS') or (Cmds = 'CHANGEPASSWORD') then
      begin
        Bit := S + E;
        if Cmds = 'CHANGEPASSWORD' then
          begin
            inc(Bit);
            GetPassword;
            {$I+}
              Seek(DataFile, UserNumber);
              Write(DataFile, UserInfo);
            {$I+}
            LineFeed;
          end
        else
          begin
            GetPassword;
          end;
         Dude := True;
      end;
    if (cmds = 'ASKTOWN') or (Cmds = 'CHANGETOWN') or (Cmds = 'JOINTOWN') then
      begin
        E1 := E;
        S1 := S;
        // Val(UserInfo.UserAcc, UserNumber, Code); { Store User Account Number }
        Repeat
          Colour(bblack);
          Bit := S1 + E1;
          LineFeed;
          LPrint;
          { PromptQuotes(30); }
          NoUpper := true;
          Response := ReadKB(30);
          NoUpper := false;
          { Exit if blank }
          if (response = '') and (Cmds = 'CHANGETOWN') then
            begin
              error := 1;
              exit;
            end;

        Until Length(Response) > 5;
        if Cmds = 'CHANGETOWN' then
          begin
            UserInfo.UserTown := Response;
            AddUser.userTown  := Response;
            if not UpdateUserLocation(UserInfo.UserTown,  UserInfo.UserUID) then
              begin
                error := 1;
                exit;
              end;
          end
         else if Cmds = 'ASKTOWN' then
               begin
                 UserInfo.UserTown := Response;
                 UpdateUserLocation(UserInfo.UserTown,  UserInfo.UserUID);
               end
           else if Cmds =  'JOINTOWN' then
                 begin
                  AddUser.UserTown := Response;
                  if UserInfo.UserLevel < 9 then
                    begin
                      UserInfo.UserTown := Response;
                      UpdateUserLocation(UserInfo.UserTown,  UserInfo.UserUID);
                    end;
                 end;
        if UserInfo.UserUID = guestUID then AddUser.UserTown := Response;
        LineFeed;
        Error := 0;
        Dude := True
      end;
    if (cmds = 'ASKFULLNAME') or (Cmds = 'CHANGEFULLNAME') or (Cmds = 'JOINFULLNAME') then
      begin
        E1 := E;
        S1 := S;
        // Val(UserInfo.UserAcc, UserNumber, Code); { Store User Account Number }
        Repeat
          Bit := S1 + E1;
          LineFeed;
          LPrint;
          { PromptQuotes(30); }
          NoUpper := true;
          Response := ReadKB(30);
          NoUpper := false;
          { Exit if blank }
          if (response = '') and (Cmds = 'CHANGEFULLNAME') then
            begin
              error := 1;
              exit;
            end;
        Until Length(Response) > 5;
          if Cmds = 'CHANGEFULLNAME'  then
            begin
              UserInfo.UserNameFull := Response;
              if not UpdateUserFullName(UserInfo.UserNameFull, UserInfo.UserUID) then
               begin
                 error := 1;
                 exit;
               end;
            end
           else if Cmds = 'ASKFULLNAME' then
                 begin
                    if UserInfo.UserLevel < 9 then UserInfo.UserNameFull := Response;
                    AddUser.UserNameFull := Response;
                    UpdateUserFullName(UserInfo.UserNameFull, UserInfo.UserUID)
                 end
             else if Cmds = 'JOINFULLNAME' then AddUser.UserNameFull := Response;
        if UserInfo.UserName = 'guest' then AddUser.UserNameFull := Response;
        LineFeed;
        Error := 0;
        Dude := True
      end;
    if (cmds = 'JOINEMAIL') or (Cmds = 'CHANGEEMAIL') then
      begin
        E1 := E;
        S1 := S;
        // Val(UserInfo.UserAcc, UserNumber, Code); { Store User Account Number }
        Repeat
          Bit := S1 + E1;
          LineFeed;
          LPrint;
          { PromptQuotes(30); }
          NoUpper := true;
          Response := ReadKB(40);
          NoUpper := false;
          { Exit if blank }
          if (response = '') and (Cmds = 'CHANGEEMAIL') then
            begin
              error := 1;
              exit;
            end;
        Until Length(Response) > 5;
        if Cmds = 'CHANGEEMAIL' then
           begin
             UserInfo.UserEmail := Response;
             if not UpdateUserEmail(UserInfo.UserEmail, UserInfo.UserUID) then
               begin
                 error := 1;
                 exit;
               end;
           end
          else if Cmds = 'JOINEMAIL' then  AddUser.UserEmail := Response;
        LineFeed;
        error := 0;
        Dude := True
      end;
    if Cmds = 'ASKLINES' then
      begin
        Bit := S + E;
        LPrint;
        Val(UserInfo.UserAcc, UserNumber, Code); { Store User Account Number }
        { PromptQuotes(4); }
        Response := ReadKB(4);
        If Length(Response) = 0 then UserInfo.UserLines := 23
         Else
           begin
             YN := 0;
             Val(Response, YN, Error);
             UserInfo.UserLines := YN;
             YN := 0;
           end;
        LineFeed;
        error := 0;
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO1' then
      begin
       { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo1 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo1, 1, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO2' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo2 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo2, 2, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO3' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo3 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo3, 3, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO4' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo4 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo4, 4, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO5' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo5 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo5, 5, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO6' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo6 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo6, 6, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO7' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo7 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo7, 7, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'GETUSERINFO8' then
      begin
        { PromptQuotes(30); }
        Bit := S + E;
        LineFeed;
        LPrint;
        NoUpper := true;
        Response := ReadKB(30);
        NoUpper := false;
        UserInfo.UserInfo8 := Response;
        LineFeed;
        UpdateUserInfo(UserInfo.UserInfo8, 8, UserInfo.UserUID);
        Dude := True;
      end;
    if Cmds = 'CHANGETOMESSAGEAREA' then
      begin
        Bit := S + E;
        cmd := '';
        cmd := ReturnString;
        val(Cmd, ValWord, ValCode);
        if ValWord <> 0 then SelectMessageArea(ValWord)
         else SelectMessageArea(0);
        Dude := True;
      end;
    if Cmds = 'SELECTMESSAGEAREA' then
     begin
        Bit := S + E;
        cmd := '';
        cmd := ReturnString;
        val(Cmd, ValWord, ValCode);
        if ValWord <> 0 then SelectMessageArea(ValWord)
         else SelectMessageArea(0);
        ScriptFile := Name;
        FinScript  := True;
        Dude := True;
      end;
    if Cmds = 'SELECTFORUM' then
     begin
        Bit := S + E;
        cmd := '';
        cmd := ReturnString;
        val(Cmd, ValWord, ValCode);
        if ValWord <> 0 then ForumSelect(ValWord)
         else ForumSelect(0);
        ScriptFile := Name;
        FinScript  := True;
        Dude := True;
      end;
    if Cmds = 'FORUMPOSTMSG' then
      begin
        Bit := S + E;
        cmd := '';
        cmd := ReturnString;
        val(Cmd, ValWord, ValCode);
        if ValWord <> 0 then ForumPostMessage(ValWord)
         else ForumPostMessage(ForumID);
        ScriptFile := Name;
        FinScript  := True;
        Dude := True;
      end;
    if Cmds = 'ENTERMESSAGE' then
      begin
        PostToForum('','');
        //TextEditStart(False, '0', '');
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'READMESSAGES' then
      begin
        //ReadMessage;
        ListMessages;
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'ADDMESSAGEAREA' then
      begin
        AddMessageArea;
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'REMOVEMESSAGEAREA' then
      begin
        DeleteMessageArea;
        If UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'OPENFILE' then { Opens Text File Appending }
      begin
        Bit := S + E;
        cmd := '';
        cmd := returnstring;
        OpenFiles(cmd);
        Dude := True;
      end;
    If Cmds = 'CLOSEFILE' then { Closes Currently Opened File }
      begin
        {$I-} Close(Out); {$I+}
        If IOResult <> 0 then
          begin
            LogError('Unable To Close File using > CLOSEFILE <');
          end
        else
          begin
            LogError('Input File Closed..');
          end;
        Dude := True;
      end;
    if Cmds = 'INPUTTOFILE' then
      begin
        Bit := S + E;
        Cmd := '';
        cmd := returnstring;
        val(Cmd, ValWord, ValCode);
        if (ValWord < 0) or (ValWord > 999) then ValWord := 30;
        Response := ReadKB(ValWord);
        {$I-} Writeln(Out, Response); {$I+}
        If IOResult <> 0 then
          begin
            LogError('Unable To Write To File With INPUTTOFILE In ' + ScriptFile);
            Writeln('Unable To Write To File With INPUTTOFILE In ' + ScriptFile);
            If Local Then Repeat Until Keypressed;
          end;
        Dude := True;
      end;
    if Cmds = 'SYSOPNEWSIGNUPS' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopSignUps;
       Dude := true;
      end;
    if Cmds = 'SYSOPDELETEGUESTS' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopDeleteGuests;
       Dude := true;
      end;
    if Cmds = 'SYSOPEDITUSER' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopEditUser(false);
       Dude := true;
      end;
    if Cmds = 'SYSOPEDITGUESTUSER' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopEditUser(true);
       Dude := true;
      end;
    if Cmds = 'SYSOPDELETEFORUMS' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopDeleteForums;
       Dude := true;
      end;
    if Cmds = 'SYSOPDELETEPOSTS' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopDeletePosts;
       Dude := true;
      end;
    if Cmds = 'SYSOPADDFORUM' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
       SysopAddForum;
       Dude := true;
      end;
    if Cmds = 'SYSOPEDITFORUM' then
      begin
       if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
       SysopEditForum;
       Dude := true;
      end;
    if Cmds = 'SYSOPLISTFILEAREAS' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
        SysopManageMainFileArea;
        Dude := true;
      end;
    if Cmds = 'SYSOPNODES' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
         if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
        SysopNodes;
        If UserInfo.UserCls = True Then Menu;
        Dude := true;
      end;
    if Cmds = 'SYSOPINFO' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
        SysopInfo;
        If UserInfo.UserCls = True Then Menu;
        Dude := true;
      end;
    if Cmds = 'SYSOPLEVELTIME' then         { Email User }
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
         if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopchangeleveltime;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPLEVELCALL' then         { Email User }
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopchangelevelCall;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPUSERUID' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
          begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopuseruid;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPUID' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
         if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopuid;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPGUESTUID' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopguestuid;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPGUESTSALLOWED' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopguestsallowed;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPBBSCALLS' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
	sysopbbscalls;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPIDLETIME' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
        if Name <> 'setup.sfi' then
         begin
           ScriptFile := Name;
           FinScript  := True;
         end;
	sysopidletime;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPOPENCLOSEMAINFILEAREAS' then
      begin
        SysopOpenCloseMainAreas;
        Dude := True;
      end;
    if Cmds = 'SYSOPERRORLOG' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
	sysoperrorlog;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPUSERLOG' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
	sysopuserlog;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPSHOWIP' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
	sysopshowip;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPBULLETINFORUM' then
      begin
        if ListBox.Display then
        begin
          setcur('25','1');
          linefeed;
        end;
       ScriptFile := Name;
       FinScript  := True;
	sysopbulletinforum;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = 'SYSOPCHANGEBULLETINNUMBER' then
       begin
        SysopChangeBulletin;
        if UserInfo.UserCls = True Then Menu;
        Dude := True;
      end;
    if Cmds = '[END]' then Halt(1);
    if Cmds = '[BEGIN]' then
      begin
        BeginCmd := True;
        Dude     := True;
      end;
   If Cmds = 'STOP' then halt(1);
   If Length(Cmds) < 1 then { Donot Report Blank Lines As Unknowns }
       Dude := True;
   If Dude = False then
      begin
        Writeln;
        TCol(LightRed + 128);
        Write('SCRIPT ERROR ');
        TCol(White);
        Write('Unknown Command ');
        TCol(Yellow);
        Write(Cmds);
        TCol(White);
        Write(' In Script File ');
        TCol(Yellow);
        Writeln(Name);
        TCol(White);
        LogError('Unknown Command : ' + Cmds + ' In Module : ' + Name);
      end;
end;
(*..........................................................................*)
{ Process Line }
procedure Process;
var
  Start, ends, i : Integer;
  Outs : String;
  Dude : Boolean;
begin
  Dude := False;
  { Needs looking into }
  MenuDisplay := true;
  //MenuDisplay := False;
  Start := 1;
  ends  := 1;
  i := 1;
  Repeat
    If Line[i] = Chr($20) then
      begin
        Inc(Start);
        Inc(i);
      end;
  Until Line[i] <> Chr($20);
  Repeat
    If Line[i] <> Chr($20) then
      begin
        Inc(Ends);
        Inc(i);
      end;
  Until Line[i] = chr($20);
  cmd := Copy(line, Start, Ends - 1);
  For i:= 1 to Length(Cmd) do
    Cmd[i] := UpCase(Cmd[i]);
if BeginCmd <> True then   { Begin  }
  begin                    {  Start }
   { Check Commands }
  If Jump = False then
   begin
     CmdLine(Cmd, Start, Ends);
   end
  Else
    begin
      If Cmd = JumpLa then Jump := False;
    end;
  end  { Begin }
       { End   }
    else
      begin
        If Temp = Cmd then
          begin
            Bit   := Start + ends;
            Start := Bit;
            Ends  := 0;
            Repeat
              If Line[Bit] = Chr($20) then
                begin
                  Inc(Start);
                  Inc(Bit);
                end;
            Until Line[Bit] <> chr($20);
            Repeat
              If Line[Bit] <> Chr($2C) then
                begin
                  Inc(ends);
                  Inc(Bit);
                end;
            Until Line[Bit] = chr($2C);
            Cmd := Copy(Line, Start, Ends);
            val(Cmd, Level, Code);
            If  UserInfo.UserLevel >= Level then
               begin
                Bit   := Start + (Ends + 1);
                Start := Bit;
                Ends  := 0;
                Repeat
                If Line[Bit] = Chr($20) then
                  begin
                    Inc(Start);
                    Inc(Bit);
                  end;
                Until Line[Bit] <> chr($20);
                Repeat
                If Line[Bit] <> Chr($20) then
                  begin
                   Inc(ends);
                    Inc(Bit);
                  end;
                Until Line[Bit] = chr($20);
                Cmd := Copy(Line, Start, Ends);
                For i:= 1 to Length(Cmd) do
                   Cmd[i] := UpCase(Cmd[i]);
                CmdLine(Cmd, Start, Ends);
                Temp := Chr(0);
              end
             Else
               begin
                 if ListBox.Display then
                  begin
                   { Yes display a alert box }
                   SetY('11');
                   SetX('26');
                   Colour(BRed);
                   Colour(FWhite);
                   Print('Ŀ');
                   SetY('12');
                   SetX('26');
                   Print(' Higher Access Required ');
                   SetY('13');
                   SetX('26');
                   Print('');
                   colour(bblack);
                   delay(1500);
                   Menu;
                  end
                 else
                  begin
                    Print('Higher Access Required.');
                    delay(500);
                    If (UserInfo.UserCls = True) and (MenuDisplay) Then Menu
                     else LineFeed;
                  end;
               end;
              Temp := Chr(0);
            end
          Else
            begin
              if eof(InF) then
               begin
                 If Temp <> Chr(0)  then
                   begin
                     Print(CommandNotFound);
		     Temp := Chr(0);
		     {$IFDEF _LINUX_}
                       Delay(500);
                     {$ELSE}
	               Wait(50);
	             {$ENDIF}
                     If (UserInfo.UserCls = True) and (MenuDisplay) Then Menu
                      else LineFeed;
                   end;
               end;
            end;
           if Not eof(Inf) then Exit;
           Times := TimeLeft;
           If Times = 0 then
             begin
               ScriptFile := 'end';
               FinScript  := True;
               {Exit;}
             end;
           If (UserInfo.UserLevel = 9) and (Scriptfile <> 'sysop.sfi') and (not ListBox.Display) then
             begin
               LineFeed;
               Print(SysopMenu);
               LineFeed;
               Colour(FWhite);
             end;
           If Quotes then
              begin
                DisplayQuote;
              end;
           If ShowTime then
             begin
               Print(ShowTime1);
               Temp := '';
               Str(MinutesPast, Temp);
               Print(Temp);
               Print(ShowTime2);
               Temp := '';
               Str(Times, Temp);
               Colour(FCyan);
               Print(Temp);
               Print(ShowTime3);
               LineFeed;
             end
           Else
             begin
               If Times <= 5 then
                 begin
                   LineFeed;
                   Print ('You Have Only ');
                   Temp := '';
                   Str(Times, Temp);
		   Print(Temp);
                   Print(' Minutes Left OnLine');
                   LineFeed;
                 end;
             end;
       if ListBox.Display then
        begin
          Temp := DisplayListBox + Chr($2C);
        end
       else
        begin
          Print(Prompt);
          Temp := ReadKB(30) + Chr($2C);
          LineFeed;
          LineFeed;
        end;
     end;
end;
(*..........................................................................*)
{ Open Script File }
procedure SFi(FileName : String);
Var
  FileNames : String;
  Loop : integer;
begin
  Jump      := False;
  Name      := '';
  Name      := FileName;
  Prompt    := '---> '; { Default Prompt }
  Cmd       := '';
  Jump      := False;
  JumpLa    := '';
  Temp      := chr(0);
  BeginCmd  := False;
  Level     := 0;
  Code      := 0;
  Bit       := 0;
  FinScript := False;
  ShowTime  := False;
  Quotes    := False;
  LineNumber := 0;
  ListBox.Display := false;

  Code := Length(BBSCfg.ScriptDir);
  If BBSCfg.ScriptDir[Code] = Directory_Seperator then
    begin
      FileNames := BBSCfg.ScriptDir + FileName;
    end
  Else
    begin
      FileNames := BBSCfg.ScriptDir + Directory_Seperator + FileName;
    end;
  Code := 0;
  Assign(InF, FileNames);
  Repeat { BeginCmd }
  {$I-} Reset(inf); {$I+}
  FileError := IOResult;
  If FileError = 0 then
    begin
      While not eof(InF) do { Read Script File }
        begin
          Line := '';
          Cmd  := '';;
          Bit  := 0;
          Readln(InF, Line);
          inc(LineNumber);
          Process;
          If FinScript then
           begin
             Close(inf); { Close Current Script File }
             Exit;       { Exit From Procedure       }
           end;
        end;
      Close(inf);
      If Jump = True then
       begin
          Writeln;
          TCol(LightRed + 128);
          Write('SCRIPT ERROR ');
          TCol(White);
          Write('LABEL ');
          TCol(Yellow);
          Writeln(JumpLa);
          TCol(White);
          Write('Not Found In Script File ');
          TCol(Yellow);
          Write(Name);
          TCol(White);
          Write(' Line ');
          TCol(Yellow);
          Writeln(LineNumber);
          TCol(White);
          Write('All Labels Must Be In Capitails EG -> ');
          TCol(Yellow);
          Writeln(':LABEL, jump LABEL, then LABEL');
          TCol(White);
	  WaitKey;
          Halt(1);
        end;
     end
    else
     begin
      LogError('Error Opening Script File : ' + FileNames + ' - ' + ErrorString(FileError));
      writeln('Error Opening Script File : ', FileNames, ' - ', ErrorString(FileError), FileError);
      Halt(1);
    end
Until BeginCmd = False;
end;
end.
