{ $Id: linuxlock.pp,v 1.2 2008-02-22 22:27:45 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   LINUXLOCK.PP    			                    *)
(*									    *)
(* DESCRIPTION	:   DOES NOT ALLOW THE SAME USER TO LOG IN MORE THEN ONE    *)
(*              :   LINE, IN MULTI USER MODE                                *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1998 - 2008                                *)
(*									    *)
(*..........................................................................*)
(*
  History:
  2008-02-21 simon
  added node number to user lock file
  added getnodenumber function
  2008-02-20 simon
  added to cvs

*)

Unit LinuxLock;

interface

Uses Dos, Crt, Data, Dates, Errorlog, Colours,Unix, strutils, BaseUnix, netdb, sockets;

Procedure RecordLogin;
Procedure LockUserFile(node : smallint);
Function GetNodeNumber : smallint;
Procedure DeleteLockUserFile;
procedure updatelocktime(door : boolean);
procedure deleteoldlockfiles;
function getguestnumber : smallint;

implementation

procedure RecordLogin;
var
  LoginFile : file of logins;
  LoginData : logins;
  LoginDB   : string;
  Loop      : integer;
begin
  if BBSCfg.DataDir[length(BBSCfg.DataDir)] = '/' then LoginDB := BBSCfg.DataDir + 'login.dat'
   else LoginDB := BBSCfg.DataDir + '/' + 'login.dat';
  {** Add if file exists routinue rather than reset}
  assign(LoginFile, LoginDB);
  {$I-}
  reset(LoginFile);
  if IOResult  <> 0 then
   begin
     { Lets assume the file does not exist and create it }
     rewrite(LoginFile);
     FileError := IOResult;
     if FileError <> 0 then
      begin
        LogError('Error creating - ' + LoginDB + ' Error(' + ErrorString(FileError) + ')');
        exit;
      end
     else
      begin
        if fpChmod(LoginDB, &0666) <> 0 then LogError('Unable to change permissions on login file - ' + LoginDB + '-' +  ErrorString(IOResult));
      end;
   end;
  { Do we already have 5 Users, if so, lets remove the oldest }
  { Caller 6 is always the curent connection }
  if FileSize(LoginFile) = 6 then
   begin
     for Loop := 1 to (FileSize(LoginFile) - 1) do
      begin
        seek(LoginFile, Loop);
        read(LoginFile, LoginData);
        seek(LoginFile, (Loop - 1));
        write(LoginFile, LoginData);
      end;
      { Delete the last record }
      seek(LoginFile,(FileSize(LoginFile) - 1));
      truncate(LoginFile);
   end;
   LoginData.Node := NodeNo;
   LoginData.Who  := UserInfo.UserName;
   LoginData.From := UserInfo.UserTown;
   LoginData.TimeStamp := fptime;
   if FileSize(LoginFile) <> 0 then
    begin
      seek(LoginFile, FileSize(LoginFile));
    end
   else
    begin
      seek(LoginFile, 0);
    end;
   write(LoginFile, LoginData);
   FileError := IOResult;
   if FileError <> 0 then LogError('Error writing to login database - ' + LoginDB + ' Error (' + ErrorString(FileError) + ')');
   close(LoginFile)
   {$I+}
end;

Procedure DeleteLockUserFile;
var
  LocFile : file of Locknode;
  FileMask : string;
begin
  If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      { if user is a guest, then lock on the remote host }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + ThisUser + '.' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + userinfo.username + '.lock';
       end;
    end
  Else
    begin
      { Same as above, but includes / }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + '/' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + '/' + userinfo.username + '.lock';
       end;
    end;
  Assign(LocFile, FileMask);
  {$I-}
  erase(LocFile);
  If IOResult = 0 then LogError('Lock File Deleted  :' + filemask)
   else LogError('Unable to Delete Lock File :' + filemask);
  {$I+}
end;

Procedure LockUserFile(node : smallint);
Var
  LocFile    : File of LockNode;
  FileMask,
  Strgs,
  hostAddr,
  hostip,
  aaa,
  bbb,
  ccc,
  ddd        : string;
  ipbit,
  ipbitinc   : integer;
  NodeIP     : LockNode;
  Ans : Array [1..10] of THostAddr;
begin
 filemask := '';
 hostip := '';
 hostaddr := '';
 aaa := '';
 bbb := '';
 ccc := '';
 ddd := '';

 if ResolveName(remotehost,ans) = 1 then
   begin
     ipbitinc := 0;
     hostaddr := hostaddrtostr(ans[1]);
     for ipbit := 0 to length(hostaddr) do
       begin
        if hostaddr[ipbit] = '.' then
         begin
           inc(ipbitinc);
         end
       else
         begin
	   if (hostaddr[ipbit] > char(47)) and (hostaddr[ipbit] < char(58)) then
            begin
             case ipbitinc of
                0: begin
                    ddd := ddd + hostaddr[ipbit];
                   end;
                1: begin
                    ccc := ccc + hostaddr[ipbit];
                   end;		
                2: begin
                    bbb := bbb + hostaddr[ipbit];
                   end;
                3: begin
                    aaa := aaa + hostaddr[ipbit];
                   end;
             end;
            end;
         end;
      end;
     remoteip := aaa +  '.' + bbb + '.' + ccc + '.' + ddd;
   end
  else
   begin
     remoteip := remotehost;
   end;
  If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      { if user is a guest, then lock on the remote host }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + ThisUser + '.' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + userinfo.username + '.lock';
       end;
    end
  Else
    begin
      { Same as above, but includes / }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + '/' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + '/' + userinfo.username + '.lock';
       end;
    end;
  {NodeNum.NodeNumber := BBSCfg.Node;}
  Assign(LocFile, FileMask);
  {$I-}
  Reset(LocFile);
  If IOResult = 0 then
    begin  { Checks To See Wether User Is Already On Other Nodes }
      LogError('Duplicate User/host (' + userinfo.username + ') (' + remotehost + ') Tried To Log On To System :' + filemask);
      Error := 1;
      Close(LocFile);
    end
  Else
    begin
      NodeIP.Node := node;
      NodeIP.Who  := UserInfo.UserName;
      NodeIP.From := UserInfo.UserTown;
      NodeIP.hostname := remotehost;
      NodeIP.ipaddr := remoteip;
      NodeIP.page   := scripttitle;
      NodeIP.timestamp := fptime;
      NodeIP.logontime := fptime;
      NodeIP.Door      := false;
      if UserInfo.UserUID = GuestUID then NodeIP.guest := true
       else NodeIP.guest := false;
      rewrite(LocFile);
      Write(LocFile, NodeIP); { Write Node Number To Loc File }
      if IOResult = 0 then
       begin
         Close(LocFile);
         LogError('Lock File Created  :' + filemask);
         if fpChmod(filemask, &0666) <> 0 then LogError('Unable to change permissions on lock file - ' + filemask + '-' +  ErrorString(IOResult));
         Error := 0;
       end
      else
       begin
         Logerror('Error writing lock file : ' + filemask + ':' + Errorstring(IOResult));
       end;
    end;
  {$I+}
end;

{ Updates the users lock file with a timestamp }
{ if the users lock file is left after a hangup }
{ then the next user will remove the lock file }
{ after the timeout period }
{ if the user is in a door, then this file is not }
{ update periodically, so we lock the node file with }
{ the door true flag sa it cannot be removed by another }
{ node if the timestamp has not been updated. If the user }
{ in a door and hangsup/disconnected the node door lock will }
{ not be removed, so the bbs maintenance script will remove the}
{ file }
procedure updatelocktime(door : boolean);
var
  locfile: file of locknode;
  NodeIP: locknode;
  filemask : string;

begin
  If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      { if user is a guest, then lock on the remote host }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + ThisUser + '.' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + userinfo.username + '.lock';
       end;
    end
  Else
    begin
      { Same as above, but includes / }
      if UserInfo.UserUID = GuestUID then
       begin
         FileMask := BBSCfg.NodeDir + '/' + ThisUser + '.' + remoteip + '.lock';
       end
      else
       begin
         FileMask := BBSCfg.NodeDir + '/' + userinfo.username + '.lock';
       end;
    end;
  {NodeNum.NodeNumber := BBSCfg.Node;}
  Assign(LocFile, FileMask);
  {$I-}
  Reset(LocFile);
  FileError := IOResult;
  If FileError = 0 then
    begin
      Seek(LocFile, 0);
      Read(LocFile, NodeIP);
      RemoteIP := NodeIP.ipaddr;
      NodeIP.timestamp := fptime;
      NodeIP.from := userinfo.usertown;
      NodeIP.Page := ScriptTitle;
      if door then NodeIP.Door := true
       else NodeIP.Door := false;
      Seek(LocFile, 0);
      write(LocFile, NodeIP);
      FileError := IOResult;
      if FileError <> 0 then LogError('Error updating lock file :' + filemask + '-' + ErrorString(FileError));
    end
  else
    begin
      LogError('Error opening lock file :' + filemask + '-' + ErrorString(FileError));
    end;
    Close(LocFile);
  {$I+}
end;

{ Get Number of guests on line }
function getguestnumber : smallint;
var
  LocFile      : File of LockNode;
  guestsonline :smallint;
  NodeIP       : locknode;
  DirInfo      : SearchRec;
  FileMask,
  ReadEntry    : string;
begin
 guestsonline := 0;
 { search for lock files }
  if BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      FileMask := BBSCfg.NodeDir + '*.lock';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '/*.lock';
    end;
  FindFirst(FileMask, AnyFile, DirInfo);
  While DosError = 0 do
   begin
     If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
       begin
           ReadEntry := BBSCfg.NodeDir + DirInfo.Name;
        end
     Else
        begin
            ReadEntry := BBSCfg.NodeDir + '/' + Dirinfo.Name;
        end;
     {$I-}
     Assign(LocFile, ReadEntry);
     Reset(LocFile);
     FileError := IOResult;
     If FileError <> 0 then
       begin
         LogError('Unable to read for node entry: ' + ReadEntry + ' - ' + ErrorString(FileError));
       end
     Else
       begin
         Seek(LocFile, 0);
         Read(LocFile, NodeIP);
         close(LocFile);
         if nodeip.guest = true then inc(guestsonline);
       end;
      FindNext(DirInfo);
   end;
  {$I+}
  getguestnumber := guestsonline;
end;


{ Get next available node }
function getnodenumber : smallint;
var
  LocFile   : File of LockNode;
  nodes     : array[0..100] of smallint;
  nodeinc,
  step,node,
  nextnode  : smallint;
  foundnode : boolean;
  NodeIP    : locknode;
  FileMask,
  ReadEntry,
  UserNumber  : string;
  DirInfo     : SearchRec;
begin
 nextnode := 1;
 nodeinc := 0;
 foundnode := false;
 { Clear out the node array }
 for step := 1 to BBSCfg.BBSNodes do
  begin
    nodes[step] := 0;
  end;
 { search for lock files }
  if BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      FileMask := BBSCfg.NodeDir + '*.lock';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '/*.lock';
    end;
  FindFirst(FileMask, AnyFile, DirInfo);
  While DosError = 0 do
   begin
     If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
       begin
           ReadEntry := BBSCfg.NodeDir + DirInfo.Name;
        end
     Else
        begin
            ReadEntry := BBSCfg.NodeDir + '/' + Dirinfo.Name;
        end;
     {$I-}
     Assign(LocFile, ReadEntry);
     Reset(LocFile);
     FileError := IOResult;
     If FileError <> 0 then
       begin
         LogError('Unable to read for node entry: ' + ReadEntry + ' - ' + ErrorString(FileError));
       end
     Else
       begin
         Seek(LocFile, 0);
         Read(LocFile, NodeIP);
         close(LocFile);
         nodes[nodeip.node] := nodeip.node;
         inc(nodeinc);
       end;
      FindNext(DirInfo);
   end;
  {$I+}
  if nodeinc > 0 then
   begin
    { Get available node number }
    for node := 1 to bbscfg.bbsnodes do
     begin
      //writeln('node=',nodes[node],' findnum=',findnum(node, nodes));
      //if (findnum(node, nodes) = 0) and (not foundnode) then
      if (nodes[node] = 0) and (not foundnode) then
       begin
         nextnode := node;
         foundnode := true;
         //writeln('Found Node = ', node);
       end;
     end;
     if foundnode then getnodenumber := nextnode
      else getnodenumber := 0;
   end
  else
    getnodenumber := 1;
end;

procedure deleteoldlockfiles;
Var
  LocFile     : File of LockNode;
  FileMask,
  ReadEntry,
  Strgs,
  UserNumber  : string;
  DirInfo     : SearchRec;
  NodeIP     : LockNode;
  idletime,
  timeround   : integer;
begin
  { search for lock files }
  if BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      FileMask := BBSCfg.NodeDir + '*.lock';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '/*.lock';
    end;
  FindFirst(FileMask, AnyFile, DirInfo);
  While DosError = 0 do
   begin
     If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
       begin
           ReadEntry := BBSCfg.NodeDir + DirInfo.Name;
        end
     Else
        begin
            ReadEntry := BBSCfg.NodeDir + '/' + Dirinfo.Name;
        end;
     {$I-}
     Assign(LocFile, ReadEntry);
     Reset(LocFile);
     FileError := IOResult;
     If FileError <> 0 then
       begin
         LogError('Unable Read ' + ReadEntry + ' - ' + ErrorString(FileError));
       end
     Else
       begin
         Seek(LocFile, 0);
         Read(LocFile, NodeIP);
         close(LocFile);
         { Only check the timestamp on the lock file }
         { if it is not door locked }
         if not nodeip.door then
          begin
            idletime := fptime - nodeip.timestamp;
            timeround := round((idletime / 60));
            { if session has an idle time of x minutes }
            { then the rm lock file }
            if (timeround > BBSCfg.idletime) or (timeround < 0) then
             begin
               erase(LocFile);
               logerror('Lock file removed after timeout :' + readentry);
             end;
         end;
       end;
      FindNext(DirInfo);
   end;
  {$I+}
end;

end.
