(* $Id: lib.pp,v 1.9 2008-02-23 01:44:42 simon Exp $                       *)
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   LIB.PAS         			                    *)
(*									    *)
(* DESCRIPTION	:   FUNCTION LIBRARY UNIT                                   *)
(*									    *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2008                                *)
(*									    *)
(*..........................................................................*)
(*
   $Log: lib.pp,v $
   Revision 1.9  2008-02-23 01:44:42  simon
   Fixed error in HoldPage..

   Revision 1.8  2008-02-22 22:27:45  simon
   bug fixes

   Revision 1.7  2008-02-20 16:41:27  simon
   FIXED: daily session time not being subtracted from user level session time.
          error in timeleft procedure

   Revision 1.6  2008-02-20 00:11:03  simon
   Tidy up code..

   Revision 1.5  2008-02-19 21:58:07  simon
   see todo.txt

   Revision 1.3  2008/02/11 22:40:36  simon
   Removed old units

*)
Unit Lib;

Interface

{$IFDEF _LINUX_}
  Uses Linux, Crt, Dos, dates, Display, Data,  ErrorLog, Colours, Strings, Linuxlock, baseunix, SQLDB;
{$ELSE}
  Uses Crt, Dos, Display, PIBAsync, Data, CDrop, Stats, ErrorLog, page, Colours,
       Wins, WaitTix;
{$ENDIF}

{procedure CurSw(Switch : Boolean);}
function MakePasswordTag(OldPassword, NewPassword : string) : boolean;
procedure AddtoLoginList;
procedure CreateSessionLockFile;
procedure DeleteSessionLockFile;
procedure WhosBeenOnline;
procedure SessionWhosOnline;
function UpDateBBSCalls : boolean;
procedure TCol(Col1 : Integer);
procedure BCol(Col2 : Integer);
procedure Center(X : Integer; Buffer : String);
procedure Printfile(FileName : String);
procedure ColourPrint(buffer : String);
procedure Print(Buffer : String);
procedure LocalPrint(Buffer : String);
function ReadKB(Flag : Integer): string;
function ReadKeys(Code : Boolean): Integer;  { Reads Local Keyboard }
procedure ClearKBuffer;
procedure LineFeed;
procedure ClearDisplay(DisplayUserStats : Boolean);
procedure SetX(Col : String);
procedure SetY(Col : String);
procedure ResetTime;
function MinutesPast : Word;
function TimeLeft : word;
function GetSec : Word;
procedure HoldPage;
procedure SetCur(Row, Col : string);
function guestsonline : smallint;
procedure Idle(Sets : Boolean);

Implementation

Var
   Fin   : Word;
   Sec,
   Start,
   U,I    : Integer;

(*..........................................................................*)
function MakePasswordTag(OldPassword, NewPassword : string) : boolean;
Var
  PassWordTagFile : text;
  PasswordTag     : string;
begin
     PasswordTag := Home_Directory + '/password.tag';
     Assign(PasswordTagFile, PasswordTag);
     {$I-}
     Rewrite(PasswordTagFile);
     FileError := IOResult;
     If FileError <> 0 Then
      begin
        LogError('Unable To Create User Password Tag File.: ' + PasswordTag + ' : ' + ErrorString(FileError));
        { Sends User Error }
        LineFeed;
        Print('Sorry, Unable Change Password At The Moment..');
        Delay(1000);
        MakePasswordTag := false;
        exit;
      end;
     writeln(PasswordTagFile, OldPassword);
     writeln(PasswordTagFile, AddUser.UserPass);
     close(PasswordTagFile);
  {  end; }
   {$I+}
   MakePasswordTag := true;
end;
(*..........................................................................*)
procedure CreateSessionLockFile;
var
  newnode : smallint;
begin
  deleteoldlockfiles;
  newnode := getnodenumber;
  if newnode = 0 then
   begin
     maxnodes := true;
   end
  else
    begin
      Lockuserfile(newnode);
      NodeNo := newnode;
    end;
end;
(*..........................................................................*)
procedure AddtoLoginList;
begin
  RecordLogin;
end;
(*..........................................................................*)
function guestsonline : smallint;
begin
  { Check that the current user is a Guest }
  if UserInfo.UserUID = GuestUID then
   begin
     { Check that there are no old lockfiles }
     deleteoldlockfiles;
     { Get the number of Guests currently online }
     guestsonline := getguestnumber;
   end;
end;
(*..........................................................................*)
procedure DeleteSessionLockFile;
begin
  deletelockuserfile;
end;
(*..........................................................................*)
procedure WhosBeenOnline;
var
  LoginFile : file of Logins;
  LoginData : Logins;
  LoginDB,
  Strgs     : string;
  Loop,
  Step,
  XPos       : integer;
begin
  XPos := WhereX;
  if BBSCfg.DataDir[length(BBSCfg.DataDir)] = '/' then LoginDB := BBSCfg.DataDir + 'login.dat'
   else LoginDB := BBSCfg.DataDir + '/' + 'login.dat';
  assign(LoginFile, LoginDB);
  {$I-}
  reset(LoginFile);
  FileError := IOResult;
  if FileError  <> 0 then
   begin
     LogError('Reading logins - ' + LoginDB + ' - ' + ErrorString(FileError));
     exit;
   end
  else
   begin
     Step := (FileSize(LoginFile) - 1);
     LineFeed;
     Colour(FBlue);
     Str(XPos, Strgs);
     SetX(Strgs);
     Print('Call  Who          Location                  Date Called             Node ');
     LineFeed;
     Colour(FCyan);
     SetX(Strgs);
     Print('--------------------------------------------------------------------------');
     for Loop := 1 to (FileSize(LoginFile) - 1) do
      begin
        dec(Step);
        seek(LoginFile, Step);
        read(LoginFile, LoginData);
        lineFeed;
        Str((XPos + 1), Strgs);
        Setx(Strgs);
        Str(Loop, Strgs);
        Colour(FRed);
        Print(Strgs);
        Str((XPos + 6), Strgs);
        Setx(Strgs);
        Colour(FYellow);
        Print(LoginData.Who);
        Colour(FCyan);
        Str((XPos + 19), Strgs);
        Setx(Strgs);
        Print(LoginData.From);
        Str((XPos + 45), Strgs);
        Setx(Strgs);
        Print(EpochtoDateString(LoginData.TimeStamp));
        Str((XPos + 70), Strgs);
        Setx(Strgs);
        Str(LoginData.Node, Strgs);
        Print(Strgs);
      end;
     close(LoginFile);
     {$I+}
   end;
end;
(*..........................................................................*)
procedure SessionWhosOnline;
Var
  LocFile     : File of LockNode;
  FileMask,
  ReadEntry,
  Strgs,
  UserNumber  : string;
  DirInfo     : SearchRec;
  NodeIP     : LockNode;
  XPos, idletime,
  timeround,
  Colour1, Colour2,
  count, IPs  : integer;
  NodeNo   : array[1..50] of integer;
  Nodewho  : array[1..50] of string[30];
  NodeFrom : array[1..50] of string[30];
  Nodeips  : array[1..50] of string[30];
  NodeWhr  : array[1..50] of string[30];
  Nodetime : array[1..50] of string[30];
begin
  Xpos := WhereX;
  { Clear all arrays }
  for count := 1 to BBSCfg.BBSNodes do
   begin
     NodeNo[count] := 0;
     Nodewho[count] := '';
     NodeFrom[count] := '';
     Nodeips[count] := '';
     NodeWhr[count] := '';
     Nodetime[count] := '';
   end;
   count := 1;
{  if UserInfo.UserCls = True then ClearDisplay(True); }
   if BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
    begin
      FileMask := BBSCfg.NodeDir + '*.lock';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '/*.lock';
    end;
  FindFirst(FileMask, AnyFile, DirInfo);
  While DosError = 0 do
   begin
     If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '/' then
       begin
           ReadEntry := BBSCfg.NodeDir + DirInfo.Name;
        end
     Else
        begin
            ReadEntry := BBSCfg.NodeDir + '/' + Dirinfo.Name;
        end;
     {$I-}
     Assign(LocFile, ReadEntry);
     Reset(LocFile);
     FileError := IOResult;
     If FileError <> 0 then
       begin
         LogError('Unable Read ' + ReadEntry + ' - ' + ErrorString(FileError));
       end
     Else
       begin
         Seek(LocFile, 0);
         Read(LocFile, NodeIP);
         //str(nodeip.node, strgs);
         NodeNo[NodeIP.Node] := NodeIP.Node;
         NodeWho[NodeIP.Node] := NodeIP.who;
         idletime := fptime - nodeip.logontime;
         timeround := round((idletime / 60));
         str(timeround, strgs);
         NodeFrom[NodeIP.Node] := NodeIP.From;
         NodeTime[NodeIP.Node] := strgs;
         NodeIPs[NodeIP.Node]  := NodeIP.IPAddr;
         NodeWhr[NodeIP.Node]  := NodeIP.Page;
         Close(LocFile);
         {I$+}
       end;
      FindNext(DirInfo);
   end;
  LineFeed;
  Str(XPos, Strgs);
  SetX(Strgs);
  Colour(FBlue);
  case BBSCfg.ShowIP of
     1: Print('Node  Who          Location                  IP                    Time On');
     2: Print('Node  Who          Location                  Where on BBS          Time On');
   else
     Print('Node  Who          Location                                        Time On');
  end;
  LineFeed;
  Colour(FCyan);
  SetX(Strgs);
  Print('--------------------------------------------------------------------------');
  LineFeed;
   for Count := 1 to BBSCfg.BBSNodes do
   begin
     //val(NodeNo[Count], IPs, CodeData);
     if NodeNo[count] = count then
       begin
         if NodeIPs[Count] = remoteip then
           begin
             colour1 := fred;
             colour2 := fwhite
           end
          else
           begin
             colour1 := fred;
             colour2 := fyellow;
           end;
         Str(XPos + 1, Strgs);
         SetX(Strgs);
         str(NodeNo[Count], Strgs);
         Colour(Colour1);
         Print(strgs);
         Colour(Colour2);
         Str(XPos + 6, Strgs);
         SetX(Strgs);
         Print(NodeWho[count]);
         Str(XPos + 19, Strgs);
         SetX(Strgs);
         Print(NodeFrom[count]);
         Str(XPos + 45, Strgs);
         SetX(Strgs);
         case BBSCfg.ShowIP of
            1: Print(NodeIPs[Count]);
            2: Print(NodeWhr[Count]);
           else
             Print(' ');
         end;
//         if (BBSCfg.ShowIP = 1) or (UserInfo.UserUID = BBSCfg.SysopUID) then  Print(NodeIPs[count])
//          else Print('');
         Str(XPos + 70, Strgs);
         SetX(Strgs);
         Print(NodeTime[count]);
       end
     else
       begin
         Str(XPos + 1, Strgs);
         SetX(Strgs);
         str(Count, Strgs);
         Colour(FRed);
         Print(Strgs);
         Colour(FCyan);
         Str(XPos + 6, Strgs);
         SetX(Strgs);
         print('Waiting for call.......');
       end;
     LineFeed;
   end;
end;
(*..........................................................................*)
function UpDateBBSCalls : boolean;
begin
  query := 'update bbs_config set calls=calls+1';
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating BBS Calls - ' + querystr);
         UpDateBBSCalls := false;
       end
      else
       begin
         UpdateBBSCalls := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating BBS Calls - ' + sqlerror);
      UpdateBBSCalls := false;
    end;
    logerror(querystr);
end;
(*..........................................................................*)
procedure PromptQuotes(StringSize : byte);
var
   X1 : byte;
   X2 : string;
   Step : integer;
begin
  if PromptQuote then
    begin
      X1 := WhereX - 1;
      (*
      Print('[');
      Str((X1 + StringSize), X2);
      *)
      for step := 1 to stringsize do
       begin
         Print(' ');
       end;
      (*
      SetX(X2);
      Print(']');
      *)
      Str(X1, X2);
      SetX(X2);
   end;
end;
(*..........................................................................*)
procedure Help;
var
  Key : char;
begin
  U := WhereX;
  I := WhereY;
  If StatsBox = 4 then StatsBox := 1
    Else inc(StatsBox);
  {$IFDEF _LINUX_}
  {$ELSE}
    UserStats;
  {$ENDIF}
  GotoXY(U,I);
end;
(*..........................................................................*)
(* CurSw Funcition Not Used in Linux Version                                *)
(*..........................................................................*)
(*
procedure CurSw(Switch : Boolean);
begin
  if Switch then
   begin
     regs.ah := $01;
     regs.ch := $03;
     regs.cl := $01;
   end
  else
   begin
     regs.ah := $01;
     regs.ch := $01;
     regs.cl := $20;
   end;
 Intr($10, regs);
end;
*)
(*..........................................................................*)
procedure TCol(Col1 : Integer);
begin
  TextColor(Col1);
end;
(*..........................................................................*)
procedure BCol(Col2 : Integer);
begin
  TextBackground(Col2);
end;
(*..........................................................................*)
(* Scroll BBS Screen Up One Line                                            *)
(*..........................................................................*)
procedure ScrollUp;
begin
{$IFDEF _LINUX_}
   print(' ');
   if SOnOff then
     begin
       { ScrollWindow(3, 1, 80, 25, 1); }
     end
   else
     begin
       { ScrollWindow(1, 1, 80, 25, 1); }
     end;
{$ELSE}
   Regs.AH := $06;
   Regs.AL := $01; { Lines To Scroll }
   Regs.BH := $00; { Colour Attribute For New Line / Black }
   if SOnOff then   { Status Bar On / Off }
    begin
       Regs.CH := $02; { Top Row  / 1 }
     end
   Else
     begin
       Regs.CH := $00;
     end;
   Regs.CL := $00; { Left Column / 0 }
   Regs.DH := 25; { Bottom Row / 25 }
   Regs.DL := $50; { Right Column / 80 }
   Intr($10, Regs);
{$ENDIF}
end;
(*..........................................................................*)
procedure ControlScreen(Flag : Byte);
Var
  X, Y : Integer;
begin
  Y := WhereY; { Store Current Cursor Posistions }
  X := WhereX;
  Case Flag of
    0 : begin { Increment Screen Up One }
          ScrollUp;
        end;
    1 : begin
          {$IFDEF _LINUX_}
          {$ELSE}
           UserStats;
          {$ENDIF}
          BBSLines  := 0;
          LineCount :=0;
        end;
  end; { Case End }
end;
(*..........................................................................*)
procedure HoldPage;
var
  Step,
  YPos  : Integer;
  Strgs : string;
begin
  LineCount := 0; { Reset Line Counter }
  Print(PausePage);
  YPos := WhereY;
  echo := false;
  repeat
    Response := ReadKB(1);
    //if Response <> '' then Print(Chr($08));
  until (Response = 'c') or (Response = 'C');
  echo := true;
  for Step := 0 to WhereX do
    begin
      Print(Chr($08));
      Print(Chr($20));
      Print(Chr($08));
    end;

  Print(Chr($20));
  Print(Chr($08));

  Str(YPos,Strgs);
  SetY(Strgs);
end;
(*..........................................................................*)
procedure Center(X : Integer; Buffer : String);
var
  A, B : Integer;
begin
  A := 81 - Length(Buffer);
  B := Trunc(A DIV 2);
  GotoXY(B,X);
  Write(Buffer);
end;
(*..........................................................................*)
procedure Printfile(FileName : String);
Var
  GetLine  : Char;
  PFile    : Text;
  TextGrab,
  Outs     : String;
begin
  LineCount := 0;
  TextGrab  := '';
  Assign(PFile, FileName);
  {$I-} Reset(PFile);
  FileError := IOResult;
  {$I+}
  if FileError <> 0 then
    begin
      LogError('Unable To Open ' + FileName);
    end
  Else
    begin
      While not eof(PFile) do
       begin
         Read(PFile, GetLine);
         TextGrab := TextGrab + GetLine;
         If (Ord(GetLine) = 10) and (LineCount = 0)
             or (BBSLines = CurrentLine) then
              begin
                GetLine := Chr(0);
                If BBSLines = CurrentLine then Dec(BBSLines);
              end
          Else
           begin { If Hold Page Has Just Been Used Then Do not LineFeed }
             If Local then
               begin
                 if (GetLine >= Chr(224)) and (GetLine <= Chr(239)) then
                   begin  { Sauron Colour Codes }
                     Colour(Ord(GetLine));
                   end
                  Else
                   begin
                     Disp(Getline); { Display Local Only }
                   end;
               end
              Else
               begin
                 {$IFDEF _LINUX_}
                 {$ELSE}
                   If Async_Carrier_Drop then
                     begin
                       NoCarrier;
                     end;
                  {$ENDIF}
                 if (GetLine >= Chr(224)) and (GetLine <= Chr(239)) then
                   begin  { Sauron Colour Codes }
                     Colour(Ord(GetLine));
                   end
                 Else
                   begin
                    {$IFDEF _LINUX_}
                       if GetLine > Chr(128) then Getline := '.';
                       {rite(GetLine);}
		       Disp(GetLine);
                     {$ELSE}
                       { Send To Modem }
                       Async_Send(GetLine);
                       Disp(Getline);
                       { SendFChar(Ord(Getline));} { FOSSIL COMMAND }
                     {$ENDIF}
                   end;
                end;
              If Ord(GetLine) = 13 then
                begin
                  Inc(LineCount);
                  Inc(BBSLines);
                end;
              If BBSLines = CurrentLine then ControlScreen(0);
              If LineCount = 23 then
                begin
		  HoldPage;
		  ClearDisplay(False);
		end;
              If Length(TextGrab) > 4 Then TextGrab := '';
              If (TextGrab = #27 + '[2J') or (TextGrab = #12) then
                begin
                  ControlScreen(1);
                  TextGrab := '';
                end;
          end;
       end;
     Close(PFile);
    end;
end;
(*..........................................................................*)
procedure Idle(Sets : Boolean);
Var
    H,M,S,Hund  : word;
begin
  GetTime(H,M,S,Hund);
  If Sets then
    begin
      Start := 0;
      Fin   := 0;
      Fin   := 60 * BBSCfg.IdleTime;
      Sec := S;
    end
  Else
    begin
      if Sec <> S then
        begin
          Inc(Start);
          Sec := S;
        end;
      If Start >= Fin then
        begin
          LineFeed;
          LineFeed;
          PrintFile(BBSCfg.SysDir + '/idle.txt');
          {$IFDEF _LINUX_}
            Delay(10000);
            LogError('User Was Idle To Long');
            deletelockuserfile;
            closedatafiles;
            halt(1);
          {$ELSE}
	    Wait(100);
	    LogError('User Was Idle To Long');
	    NoCarrier;
          {$ENDIF}
        end;
    end;
end;
(*..........................................................................*)
procedure ColourPrint(buffer : String);
Var
  Stringlen, Y,
  Step  : Integer;
begin
  Y := WhereY;
  Stringlen := 0;
  StringLen := Length(Buffer);
  For Step  := 1 to Stringlen do
          begin
            If (Buffer[Step] = Chr(10)) and (Y = 25) then
              begin
                ControlScreen(0)
              end
            Else
              begin
                { Sauron Colour Codes }
                if (Buffer[Step] >= Chr(224)) and ((Buffer[Step]) <= Chr(239)) then
                  begin
                    Colour(Ord(Buffer[Step]));
                    Disp(Buffer[Step]);
                  end
                Else
                  begin
                    Disp(Buffer[Step]);
                  end;
              end;
         end;
end;
(*..........................................................................*)
procedure Print(buffer : String);
Var
  Stringlen, Y,
  Step  : Integer;
begin
  Y := WhereY;
  If Local Then
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Step  := 1 to Stringlen do
          begin
            If (Buffer[Step] = Chr(10)) and (Y = 25) then
              begin
                ControlScreen(0)
              end
            Else
              begin
                { Sauron Colour Codes }
                if (Buffer[Step] >= Chr(224)) and ((Buffer[Step]) <= Chr(239)) then
                  begin
                    Colour(Ord(Buffer[Step]));
                  end
                Else
                  begin
                    Disp(Buffer[Step]);
                  end;
              end;
         end;
    end
  Else
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Step  := 1 to Stringlen do
          begin
            {$IFDEF _LINUX_}
            {$ELSE}
             If Async_Carrier_Drop then NoCarrier;
            {$ENDIF}
            If (Buffer[Step] = Chr(10)) and (Y = 25) then
              begin
                {$IFDEF _LINUX_}
                  write(Buffer[Step]);
                {$ELSE}
                  ControlScreen(0);
                  Async_Send(Buffer[Step]);
                {$ENDIF}
                { SendFChar(Ord(Buffer[Step])); } { FOSSIL }
              end
            Else
             begin
                { Sauron Colour Codes }
                if (Buffer[Step] >= Chr(224)) and ((Buffer[Step]) <= Chr(239)) then
                  begin
                    Colour(Ord(Buffer[Step]));
                  end
                Else
                  begin
                    {$IFDEF _LINUX_}
                     write(Buffer[Step]);
                    {$ELSE}
                     Async_Send(Buffer[Step]);
                    {$ENDIF}
                    { SendFChar(Ord(Buffer[Step])); }
               {    Disp(Buffer[Step]); }
                  end;
              end;
          end;
      end;
end;
(*..........................................................................*)
procedure LocalPrint(Buffer : String);
begin
  If Local = False then
    begin
      Local := True;
      Print(Buffer);
      Local := False;
    end
  Else
    begin
      Print(Buffer);
    end;
end;
(*..........................................................................*)
procedure ClearKBuffer;
begin
  {$IFDEF _LINUX_}
  {$ELSE}
    Regs.Ah := $0C;
    Intr($21, Regs);
  {$ENDIF}
end;
(*..........................................................................*)
function ReadKeys(Code : Boolean): integer;
begin
  {$IFDEF _LINUX_}
  {$ELSE}
    Regs.Ah := $01;
    Intr($16, Regs);
    if Code then
      ReadKeys := Regs.Al  { Get ASCII Code From Keyboard Buffer }
    Else
      ReadKeys := Regs.Ah; { Get Keyboard Scan Code From Buffer }
  {$ENDIF}
end;
(*..........................................................................*)
function ReadKB(Flag : Integer): string;
Var
  Buffer   : String;
  KeyIn    : Integer;
  Key      : Integer;
  ch	   : char;
begin
  Buffer := '';
  Key    := 0;
  updatelocktime(false);
  Idle(True);
  PromptQuotes(Flag);
  Repeat
    Idle(False);
    If Local Then
      begin
        If Keypressed then
          begin
            KeyIn :=Ord(ReadKey);
            case Chr(KeyIn) of
                 #0 : begin
                        Case ReadKey of
                    {F1}  #59 : begin  { Help / Local Only }
                                  If Not NewUser then Help;
                                end;
                    {F2}  #60 : begin
				  {$IFDEF _LINUX_}
				  {$ELSE}
                                    Chats;
                                    KeyIn := 13;
                                  {$ENDIF}
                                end;
                    {F3}  #61 : begin
                                  LineFeed;
                                  LineFeed;
                                  PrintFile('force.txt');
				  LogError('User Forced Of System');
				  {$IFDEF _LINUX_}
				  {$ELSE}
				    NoCarrier;
				  {$ENDIF}
                                end;
                    {F4}  #62 : begin
                                end;
                    {F5}  #63 : begin
                                  If SOnOff then
                                    begin
                                      U := WhereX;
                                      I := WhereY + 2;
                                      SOnOff := False;
                                      Window(1,1,80,25);
                                      GotoXY(1,1);
                                      textbackground(Black);
                                      ClrEol;
                                      GotoXY(1,2);
                                      ClrEol;
                                      GotoXY(U,I);
                                    end
                                  Else
                                    begin
                                      U := WhereX;
                                      I := WhereY - 2;
                                      SOnOff := True;
                                      {$IFDEF _LINUX_}
                                      {$ELSE}
                                       UserStats;
                                      {$ENDIF}
                                      GotoXY(U,I);
                                    end;
                                end;
                           #80 : begin
                                   Inc(Key);
                                   Insert(Chr(62), Buffer, Key); { Do not Store CR }
                                   Idle(True);
                                 end;
                           #72 : begin
                                   Inc(Key);
                                   Insert(Chr(60), Buffer, Key); { Do not Store CR }
                                   Idle(True);
                                 end;
                           #75 : begin
                                   Inc(Key);
                                   Insert(Chr(91), Buffer, Key); { Do not Store CR }
                                   Idle(True);
                                 end;
                           #77 : begin
                                   Inc(Key);
                                   Insert(Chr(93), Buffer, Key); { Do not Store CR }
                                   Idle(True);
                                 end;

                         end; { Case End }
                      end;
                #17 :  begin              { Exit To Dos / Local Only }
                         CloseDataFiles;
                         Halt(1);
                       end;
            end; { Case End }
         end
       Else
         begin
           KeyIn := 0;
         end;
      end
    Else
        begin
          KeyIn := 0;
          {$IFDEF _LINUX_}
            If Local then { Should Never Be True }
              begin
                { Added to keep the structure small }
              end
          {$ELSE}
            If Async_Carrier_Drop then
              begin
                NoCarrier;
              end
           {$ENDIF}
          Else
            { writeln('Hello');  }
            if Keypressed then
              begin
                ch := ReadKey;
                KeyIn := Ord(ch);
                Case Chr(KeyIn) of
                  #0 : begin
                         Case ReadKey of
                    {F1}  #59 : begin  { Help / Local Only }
                                  If Not NewUser Then Help;
                                end;
		    {F2}   #60 :begin
				  {$IFDEF _LINUX_}
				  {$ELSE}
                                    Chats;
				    KeyIn := 13;
				  {$ENDIF}
                                end;
                    {F3}  #61 : begin
                                  LineFeed;
                                  LineFeed;
                                  PrintFile('force.txt');
				  LogError('User Forced Of System');
				  {$IFDEF _LINUX_}
				  {$ELSE}
				    NoCarrier;
				  {$ENDIF}
                                end;
                    {F4}  #62 : begin
                                end;
                    {F5}  #63 : begin
                                  If SOnOff then
                                    begin
                                      U := WhereX;
                                      I := WhereY + 2;
                                      SOnOff := False;
                                      Window(1,1,80,25);
                                      GotoXY(1,1);
                                      textbackground(Black);
                                      ClrEol;
                                      GotoXY(1,2);
                                      ClrEol;
                                      GotoXY(U,I);
                                    end
                                  Else
                                    begin
                                      U := WhereX;
                                      I := WhereY - 2;
                                      SOnOff := True;
                                      {UserStats}
                                      GotoXY(U,I);
                                    end;
                                end;
                        {$IFDEF _LINUX_}
                          #83 : begin   { Rub Out }
                                  If Key > 0 then
                                    begin
                                      If Echo then
                                         begin
                                           Print(Chr($08));
                                           Print(Chr($20));
                                           Print(Chr($08));
                                         end;
                                      Delete(Buffer, Key, 1);
                                      Dec(Key);
                                      Idle(True);
                                    end;
                                end;
                        {$ENDIF}
                         end; { Case End }
                       end;
                end; { Case End }
              end
            Else
             begin
               { PeakFChar <> 0 }
               {$IFDEF _LINUX_}
               {$ELSE}
                 If Async_Buffer_Check Then  { Checks Port For Key Press }
                   begin
                     PortStatus := Async_Receive(ModemChar);
                     if PortStatus then keyIn := ord(ModemChar);
                     { KeyIn := ReadFChar; }
                 end;
               {$ENDIF}
             end;
          end;
        Case KeyIn of
        32..125 : begin
                     if key < Flag then Inc(Key);
                     //inc(key);
                     If Echo then
                       If (Not PassEcho) and (not NewUserKB) then
                         Print(Chr(KeyIn));
                       //else if (PassEcho) and (keyin <> 32) then Print('*');
                     if (NewUserKB) and (key < flag) then
                      begin
                        case keyin of
                          48..57 : begin
                         //            write('-',key,'-');
                                     Insert(chr(keyin), buffer, key);  { 0 - 9 }
                                     if not PassEcho then print(chr(keyin))
                                      else print('*');
                                   end;
                          65..90 : begin
                                     Insert(chr(keyin), buffer, key);  { a - z }
                                     if not PassEcho then print(chr(keyin))
                                      else print('*');
                                   end;
                          97..122 : begin
                                      Insert(chr(keyin), buffer, key); { A - Z }
                                      if not PassEcho then print(chr(keyin))
                                       else print('*');
                                    end;
                          else
                           if key < flag then dec(key);
                        end;
                      end
                     else
                      begin
                        if not NewUserKB then Insert(Chr(KeyIn), Buffer, Key)
                          else if key = Flag then dec(key);
                      end;
                     Idle(True);
                   end;
              8 : begin { Rub Out }
                     If Key >= 1 then
                       begin
                         If Echo then
                           begin
                             Print(Chr(KeyIn));
                             Print(Chr($20));
                             Print(Chr(KeyIn));
                           end;
                         //write('KEY',key);
                         Delete(Buffer, Key, 1);
                         Dec(Key);
                         Idle(True);
                      end;
                   end;
       end; { Case End }
      Until (KeyIn = 13) or (Key = Flag) and (not NewUserKB) or (KeyIn = 10);
      If Not NoUpper then
        begin
          For Loop := 1 to Key do
            begin  { Convert To Upper Case }
              Buffer[Loop] := UpCase(Buffer[Loop]);
            end;
        end;
      ReadKB := Buffer;
      {$IFDEF _LINUX_}
      {$ELSE}
        if not local then Async_Purge_Buffer;
      {$ENDIF}
      { If InputReady then PurgeInput; }
end;
(*..........................................................................*)
procedure LineFeed;
var
  X, Y : Integer;
begin
  Y := WhereY;
{  If Y = 25 Then ControlScreen(0); }
  (*
  Print(Chr(13));
  Print(Chr(10));
  *)
  writeln;
end;
(*..........................................................................*)
procedure ClearDisplay(DisplayUserStats : Boolean);
begin
  BBSLines := 0;
  If UserInfo.UserCls = True then
    begin
      if Local then ClrScr;
      if UserInfo.UserAnsi = 1 then
        begin
          Print(#27 + '[2J');
        end
      Else
        begin
          Print(Chr($0C));
       end;
   end
 else
   LineFeed;
 {$IFDEF _LINUX_}
 {$ELSE}
  if DisplayUserStats then
   begin
     if not NewUser then UserStats
   end
  Else
   begin
     FirstStats;
   end;
  {$ENDIF}
end;
(*..........................................................................*)
procedure ResetTime;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  GetTime(H,M,S,Hund);
  StartTimes := M;
  Minutes := 0;
end;
(*..........................................................................*)
function MinutesPast: word;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  GetTime(H,M,S,Hund);
  If M <> StartTimes then
    begin
      Inc(Minutes);
      StartTimes := M;
    end;
  MinutesPast := Minutes;
end;
(*..........................................................................*)
function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;
(*..........................................................................*)
function TimeLeft : Word;
begin
  SessionLength := MinutesPast;
(* not needed for linux
  If (UserNumber > -1) and (UserInfo.UserLevel > 0) then
    begin
*)
      If SessionLength <= (SessionTime - LastOnTime) then
        begin
          TimeLeft := (sessionTime - lastontime) - SessionLength;
        end
      Else
        begin
        (*

          LineFeed;
          LineFeed;
          Print(' ---- Sorry You Ran Out Of Time ---- ');
          LineFeed;

	  {$IFDEF _LINUX_}
	    Delay(1000);
	  {$ELSE}
	    Wait(100);
          {$ENDIF}
        *)
          Timeleft := 0;
        end;
{    end; }
end;
(*..........................................................................*)
function GetSec : word;
Var h,m,S,hu : Word;
begin
  GetTime(h,m,s,hu);
  GetSec := s;
end;
(*..........................................................................*)
{ Cursor Control }
procedure SetX(Col : string);
var
  Y, X : byte;
begin
  if UserInfo.UserAnsi = 1 then { ANSI }
    begin
      Col := '[' + Col + 'C';
      Print(#13 + Col);
    end
  Else
    begin
      If UserInfo.UserAnsi = 2 then  { AVATAR }
        begin
          Y := WhereY;
          Val(Col, X, Code);
          Print(#22 + #8 + Chr(Y) + Chr(X));
        end
      Else
        begin
          { Sauron }
        end;
    end;
end;
(*..........................................................................*)
procedure SetY(Col : string);
var
  Y, X : integer;
begin
  if UserInfo.UserAnsi = 1 then { ANSI }
    begin
      Val(Col, Y, X);
      Dec(Y);
      Str(Y, Col);
      Print(#27 + '[0;0H' + #27 + '[' + Col + 'B');
    end
  else
    begin
      if UserInfo.UserAnsi = 2 then  { AVATAR }
        begin
          Y := WhereX;
          Val(Col, X, Code);
          Print(#22 + #8 + Chr(X) + Chr(Y));
        end
      else
        begin
          { Sauron }
        end;
    end;
end;
(*..........................................................................*)
{ Cursor Control : ANSI Only Command }
procedure SetCur(Row, Col : string);
begin
  Print(Chr(27));
  Print('[0;0H');
  Print(Chr(27));
  Print('[');
  Print(Row + 'B');
  Print(Chr(27));
  Print('[');
  Col := Col + 'C';
  Print(Col);
end;
end.
