{ Linux Test Version }

program GOBBS;

uses Crt,linux;

{ Modem data }
type
  Cfg = record
     ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[50];
     InitString2 : String[50];
     InitString3 : String[50];
     InitAnswear : String[20];
     LockBaud    : Boolean;
     Node        : Byte;
     MultiNode   : Boolean;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;   { Level Time }
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;   { Level Calls Per Day }
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     TempDir,
     NodeDir    : String[30];  { Node Directory Is Where All nodes Share Info }
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[20];
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg     : Word;
     LogFile,
     ErrFile    : String[12];
     Bulletin   : word;
end;
{ SimpleBBS Data Information  SIMPBBS.DAT }
type
  bbs = record
    NextUser   : integer;
    Line       : string;
    from       : string;
    date       : string;
    time       : word;
    Fax        : integer;
    FaxTime    : string;
end;
{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName : String[12];
    Size     : LongInt;      { FileSize }
    FDate    : String[8];    { FileDate }
    Descript : String[40];   { File Description }
    DLTimes  : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser   : String[30];   { User Who Uploaded File }
end;
{ Sauron BBS File Areas  AREAS.DAT }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;
{ Sauron BBS File Areas }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[30];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[30];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

{ Sauron Message Index File }
type
  Index = Record
     MsgNumber : Integer;
end;

{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;
    AreaName  : String[30];
end;


{ Sauron Message Number }
type
  MS = record
    MsgNumber : integer;
end;

type
  User = record
    UserAcc    : String[3];
    UserAnsi   : byte;         { 1 = ANSI 2 = AVATAR *3 = SAURON }
    UserColour : byte;         { 0 = No Colour  1 = Colour }
    Userlevel  : byte;
    UserName   : string[30];
    UserPass   : string[10];
    UserTown   : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;
    UserLines  : byte;
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;
    CallsToday : integer;
    LCallDate  : String[10];
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;
    DownLoads  : integer;
    Uploads    : integer;
    BytesDL    : LongInt;
    BytesUL    : LongInt;
end;

var
  bbsinfo    : bbs;
  Userinfo   : user;
  Areas      : FileAreas;
  SAreas     : Area;
  FInfo      : FileInfo;
  Idx        : Index;
  Msg        : MsgArea;
  MsIndex    : Ms;
  bbscfg     : Cfg; 
  DataFile   : File of user;    { UserFile }
  BBSini     : File of bbs;     { BBS Data File }
  MsgNum     : File of MS;
  FileArea   : File of FileAreas;  { File Directorys }
  Files      : File of FileInfo;
  CatArea    : File of Area;
  IdxFile    : File of Index;
  MsgFile    : File of MsgArea;
  CfgFile    : File of Cfg;

{ Msg(1, 1, 'Hello'); }
procedure Msgs(X , Y : integer; Buffer : string);
begin
  Gotoxy(X,Y);
  writeln(Buffer);
end;

{ Colour(1, 7);}
procedure Colour(Col1, Col2 : integer);
begin
  Textcolor(Col1);
  Textbackground(Col2);
end;

{ Open All Data Files needed To Run SimpleBBS }
procedure OpenDataFiles;
begin
  WriteLn;
  writeln('Creating Data Files.... ');
  writeln;
  Write('Creating ');
  Textcolor(15);
  writeln('simpbbs.dat');
  TextColor(7);
  Assign(BBSini,'simpbbs.dat');
  {$I-} Rewrite(BBSini); {$I+}
  if IOResult = 0 then
    begin
      bbsinfo.NextUser := 0;
      bbsinfo.line     := 'SYSTEM RESET : NO USERS';
      bbsinfo.from     := 'NO WHERE';
      bbsinfo.Date     := '1 January, 1998 12:00pm';
      bbsinfo.time     := 0;
      bbsinfo.faxtime  := 'SYSTEM RESET';
      bbsinfo.fax      := 0;
      seek(bbsini,0);
      write(BBSini,bbsinfo);
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('simpbbs.dat', octal (777)) then
        begin
        Writeln('Error..');
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('  ERROR :- Unable To Create SIMPBBS.DAT  ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Write('Creating ');
  Textcolor(15);
  writeln('userinfo.data');
  TextColor(7);
  Assign(DataFile,'userinfo.data');
  {$I-} Rewrite(DataFile); {$I+}
  if IOResult = 0 then
    begin
      UserInfo.UserAcc    := '0';
      UserInfo.UserAnsi   := 1;
      UserInfo.UserColour := 1;
      UserInfo.Userlevel  := 4;
      UserInfo.UserName   := 'Simon';
      UserInfo.UserPass   := 'syds';
      UserInfo.UserTown   := 'Andover';
      UserInfo.UserInfo1  := 'NULL';
      UserInfo.UserInfo2  := 'NULL';
      UserInfo.UserInfo3  := 'NULL';
      UserInfo.Userinfo4  := 'NULL';
      UserInfo.Userinfo5  := 'NULL';
      UserInfo.Userinfo6  := 'NULL';
      UserInfo.Userinfo7  := 'NULL';
      UserInfo.Userinfo8  := 'NULL';
      UserInfo.UserCls    := True;
      UserInfo.Bulletin   := 0;
      UserInfo.UserLines  := 24;
      UserInfo.MailCount  := 0;      { User Mail }
      UserInfo.LastMsgNum := 0;
      UserInfo.Calls      := 0;
      UserInfo.CallsToday := 0;
      UserInfo. LCallDate  := '1/1/95';
      UserInfo.LastCall   := '1st January 1995';
      UserInfo.CallNumber := 0;
      UserInfo.TimeOnLine := 0;
      UserInfo.FileArea   := 0;
      UserInfo.DownLoads  := 0;
      UserInfo.Uploads    := 0;
      UserInfo.BytesDL    := 0;
      UserInfo.BytesUL    := 0;
      Seek(DataFile, 0);
      write(DataFile, UserInfo);
      writeln('This file is now created by createuser..');
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('userinfo.data', octal (777)) then
        begin
          Writeln('Error...');
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln(' ERROR :- Unable To Create USERLOG.DAT  ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
   Write('Creating ');  
   Textcolor(15);
   writeln('msindex.dat');
   TextColor(7);
   Assign(MsgNum,'msindex.dat');
  {$I-} Rewrite(MsgNum); {$I+}
  if IOResult = 0 then
    begin
      MsIndex.MsgNumber := 0;
      Write(MsgNum, MsIndex);
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('msindex.dat', octal (777)) then
        begin
          Writeln('Error....');
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln(' ERROR :- Unable To Open MSINDEX.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Write('Creating ');
  Textcolor(15);
  writeln('areas.dat');
  TextColor(7);
  Assign(CatArea, 'areas.dat');
  {$I-} Rewrite(CatArea); {$I+}
  if IOResult = 0 then
    begin
      SAreas.AreaNumber  := '001';
      SAreas.Description := 'SAURON FILE ARCHIVE 1';
      SAreas.OpenClosed  := True;
      SAreas.FileNumber  := 99999;
      SAreas.CatNumber   := 1; 
      write(CatArea, SAreas);
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('areas.dat', octal (777)) then
        begin
          Writeln('Error...');       
        end;
    end
  else
    begin
      Writeln(' ERROR :- Unable To Create AREAS.DAT');
      Halt(1);
    end;
  Write('Creating ');
  Textcolor(15);
  writeln('area.1');
  TextColor(7);
  Assign(FileArea,'area.1');
  {$I-} Rewrite(FileArea); {$I+}
  if IOResult = 0 then
    begin
      Areas.DirNo   := 1;                         { Number Of File Directorys }
      Areas.Dir     := '/usr/sauron/files/';      { Directory path       }
      Areas.DirDes  := 'SAURON FILE POOL';        { Directory Area Name  }
      Areas.FileLst := '/usr/sauron/filelist';    { Files List & Path    }
      Areas.Uploads := 0;                         { Uploads Allowed      }
      Areas.DnLoads := 1;                         { DownLoads Allowed    }
      Areas.Access  := 1;                         { Minimum Level Access }
      Write(FileArea, Areas);
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('area.1', octal (777)) then
        begin
          Writeln('Error....');
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln(' ERROR :- Unable To Create AREA.1');
      writeln(' Please Run HelpBBS for more information');
      Halt(1);
    end;
  Write('Creating ');
  Textcolor(15);
  writeln('message.dat');
  TextColor(7);
  Assign(MsgFile,'message.dat');
  {$I-} Rewrite(MsgFile); {$I+}
  if IOResult = 0 then
    begin
      Msg.MsgNumber :='1';
      Msg.AreaName  := 'GENERAL TOPICS';
      Write(MsgFile, Msg);
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('message.dat', octal (777)) then
        begin
          Writeln('Error....');
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open MESSAGE.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Write('Creating ');
  Textcolor(15);
  writeln('sauron.cfg');
  TextColor(7);
  Assign(CfgFile, 'sauron.cfg');
  {$I-} Rewrite(CfgFile); {$I+}
  if IOResult = 0 then
   begin
      bbsCfg.ComPort     := 0;
      bbsCfg.BaudRate    := 0;
      bbsCfg.InitString1 := 'ATZ';
      bbsCfg.InitString2 := 'ATZ'; 
      bbsCfg.InitString3 := 'ATZ'; 
      bbsCfg.InitAnswear := 'ATZ'; 
      bbsCfg.LockBaud    := TRUE;
      bbsCfg.Node        := 1;
      bbsCfg.MultiNode   := TRUE;
      bbsCfg.L1T	      := 999;
      bbsCfg.L2T	      := 999;
      bbsCfg.L3T	      := 999;
      bbsCfg.L4T	      := 999;
      bbsCfg.L5T	      := 999;
      bbsCfg.L6T	      := 999;
      bbsCfg.L7T	      := 999;
      bbsCfg.L8T	      := 999;
      bbsCfg.L9T	      := 999;
      bbsCfg.L1C	      := 999;
      bbsCfg.L2C	      := 999;
      bbsCfg.L3C	      := 999;
      bbsCfg.L4C	      := 999;
      bbsCfg.L5C	      := 999;
      bbsCfg.L6C	      := 999;
      bbsCfg.L7C	      := 999;
      bbsCfg.L8C	      := 999;
      bbsCfg.L9C	      := 999;
      bbsCfg.SysDir      := '/usr/sauron/sys/';
      bbsCfg.ScriptDir   := '/usr/sauron/script/';
      bbsCfg.MenuDir     := '/usr/sauron/menu/';
      bbsCfg.BBSMailDir  := '/usr/sauron/mail/';
      bbsCfg.MsgDir      := '/usr/sauron/message/';
      bbsCfg.TempDir     := '/usr/sauron/temp/';
      bbsCfg.NodeDir     := '/usr/sauron/node/';
      bbsCfg.SysopFirst  := 'Simon';
      bbsCfg.SysopSec    := 'Horton';
      bbsCfg.BBSName     := 'The Maxx BBS';
      bbsCfg.BBSTele     := '+44 (0) 1264 396924';
      bbsCfg.Calls       := 0;
      bbsCfg.NuLevel     := 1;
      bbsCfg.IdleTime    := 5;
      bbsCfg.MaxUsers    := 100;
      bbsCfg.MaxMsg      := 100;
      bbsCfg.LogFile     := 'user.log';
      bbsCfg.ErrFile     := 'error.log';
      bbsCfg.Bulletin    := 1;
      Write(CfgFile,bbscfg);	
      writeln('Changing file to Full Access.. (777) - Test Version Only');
      if not chmod('sauron.cfg', octal (777)) then
        begin
          Writeln('Error....');
        end;
   end
  else
   begin
     writeln;
     writeln;
     writeln('   ERROR :- Unable To Create node1.cfg   ');
     writeln(' Please Run HelpBBS for more information ');
     Halt(1);
   end;
end;

procedure Start;
Var
  Key : Char;
begin
  Colour(7,0);
  ClrScr;
  Colour(0,7);
  Msgs(1,1,' GOBBS Ver 0.0.1 Sauron Linux BBS  copyright (C) Simon C Horton  January - 1998 ');
  Colour(7,0);
  Write('!! ');
  Textcolor(Red + 128);
  Write('WARNING');
  TextColor(7);
  Write(' !! This will Reset all Your Data Files, Continue(Y/n) ? ');
  Key := ReadKey;
  If (Key = 'y') or (Key = 'Y') then OpenDataFiles
   Else
     begin
      Writeln;
      Writeln;
      Halt(1);
     end;
  Writeln;
  Writeln('Data Files Created...');
  writeln;
end;

{ Main }
begin
  Start;
  close(bbsini);
  Close(DataFile);
  Close(MsgNum);
  Close(FileArea);
  Close(MsgFile);
end.
