(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   FORUM.PP                                                *)
(*                                                                          *)
(* DESCRIPTION  :   FORUM UNIT                                              *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 2008                                       *)
(*                                                                          *)
(*..........................................................................*)

Unit forum;

Interface

Uses Dos, Crt, Lib, Data, Dates,Colours, ErrorLog,FullEditor,baseunix,sqldb,strings;

function ForumCount: integer;
function ForumTotalReplies(LastLogOn : time_t) : integer;
function ForumTotalPosts(LastLogon : time_t) : integer;
function ForumPosts(fid : integer) : integer;
procedure ForumSelect(fid : integer);
procedure ForumPostMessage(fid : integer);
procedure ForumPostReply(mid, index : integer);
function PostNew(timestamp : time_t; fid, mid : integer) : integer;
function ReplyNew(timestamp : time_t; fid, mid, rid : integer) : integer;

var
  ForumID,                    { Current Forum ID }
  ForumPostLo,                { Minimum Post User Level }
  ForumPostHi,                { Maximum Post User Level }
  ForumRead   : integer;      { Mim user level allowed to read posts }
  ForumTitle,                 { Current Forum Title }
  ForumDesc   : string[80];   { Current Forum Description }

  PostRemoved : boolean;      { Set to true if Post has been removed }

implementation

{ Stores Forum List }
type
   ForumHeader = record
 	Fid    : integer;
        Title  : string[40];
        Desc   : string[80];
        Posts  : integer;
        Reply  : integer;
        PostLo : integer;
        PostHi : integer;
end;

{ Stores Forum Posts }
type
     Posts = record
        Mid       : integer;
        UserName  : string[33];
        Subject   : string[40];
        Date      : string;
        Reply     : integer;
        Lock      : integer;
        Time      : time_t;
        deletetag : integer;
end;

{ View Post Msg }
type
  msg = record
    msgline : string[80];
end;

{ View Post Reply Msg }
type
  replypost = record
    replymsgline : string[80];
end;

var
   { Store upto 500 Forums }
   ForumHdr : array[0..500] of ForumHeader;
   PostHdr  : array[0..8000] of Posts;
   { Number of forums/Posts }
   PostNo,
   ForumNo  : integer;
   { Post Msg Content }
   post : array[0..1000] of msg;
   PostMsgSize : integer;
   { Post Reply Content }
   replymsg   : array[0..1000] of replypost;
   { Stores reply fids }
   replynos   : array[0..500] of integer;

   ReplyMsgSize,
   ReplyNo,
   ReplyTotal,
   ReplyID        : integer;
   ReplyDate,
   ReplyUserName,
   ReplySubject   : string;
   { Full Editor }
   ForumMsgData,
   MsgData        : LinePtr;

(*..........................................................................*)
procedure PostMsgHeader(mid, reply : integer;  date, from, subject : string; time : time_t);
var
  strgs : string;
begin
  ClearDisplay(True);
  Colour(FGreen);
  Print('Forum   :                                             Post No : ');
  Colour(FYellow);
  SetX('10');
  Print(ForumTitle);
  SetX('64');
  Str(mid, strgs);
  Print(strgs);
  LineFeed;
  Colour(FGreen);
  Print('Date    :                                             Replies : ');
  Colour(FYellow);
  SetX('10');
  Print(date);
  SetX('64');
  str(reply, strgs);
  Print(strgs);
  LineFeed;
  Colour(FGreen);
  Print('From    : ');
  Colour(FYellow);
  SetX('10');
  Print(from);
  LineFeed;
  Colour(FGreen);
  Print('Subject : ');
  Colour(FYellow);
  SetX('10');
  Print(subject);
  Linefeed;
  Colour(FCyan);
  Print('____');
  Colour(FWhite);
  Colour(BCyan);
  print(' POST ');
  Colour(BBlack);
  Colour(FCyan);
  Print('_____________________________________________________________________');
  if PostNew(UserInfo.UserLogon, 0, mid) > 0 then
   begin
     Colour(FRed);
     SetX('70');
     Print('[NEW]');
     Colour(FCyan);
  end;
   
  Linefeed;
  colour(FWhite);
end;
(*..........................................................................*)
procedure ReplyMsgHeader(rid, reply, replies : integer;  date, from, subject : string);
var
  strgs : string;
begin
  ClearDisplay(True);
  Colour(FGreen);
  Print('Forum   :                                            Reply No :');
  Colour(FYellow);
  SetX('10');
  Print(ForumTitle);
  SetX('64');
  Str(rid, strgs);
  Print(strgs);
  LineFeed;
  Colour(FGreen);
  Print('Date    :                                               Reply :' );
  Colour(FYellow);
  SetX('10');
  Print(date);
  SetX('64');
  str(reply, strgs);
  Print(strgs + ' of ');
  str(replies, strgs);
  Print(strgs);
  LineFeed;
  Colour(FGreen);
  Print('From    : ');
  Colour(FYellow);
  SetX('10');
  Print(from);
  LineFeed;
  Colour(FGreen);
  Print('Subject : ');
  Colour(FYellow);
  SetX('10');
  Print(subject);
  Linefeed;
  Colour(FCyan);
  Print('____');
  Colour(FWhite);
  Colour(BCyan);
  print(' REPLY ');
  Colour(BBlack);
  Colour(FCyan);
  print('____________________________________________________________________');
  if ReplyNew(UserInfo.UserLogon, 0, 0, rid) > 0 then
   begin
     Colour(FRed);
     SetX('70');
     Print('[NEW]');
     Colour(FCyan);
  end;
  Linefeed;
  colour(FWhite);
end;
(*..........................................................................*)
procedure PostMsgFooter(deletetag : integer);
var
  Strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(PostMsgSize, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Lines ');
  Colour(BBLack);
  //SetY('24');
  LineFeed;
(*
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('U');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Unquoted Reply ');
*)
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('R');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Reply ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('->');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('N');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Replies ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('<-');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('Q');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Exit');
  if UserInfo.Userlevel = 9 then
   begin
     Colour(FRed);
     Print(' [E] Edit ');
     if deletetag = 1 then Print('Post Tagged for deletion')
      else Print('[D] Delete');
   end;
  SetY('4');
  Colour(FWhite);
end;
(*..........................................................................*)
procedure ReplyMsgFooter;
var
  Strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(ReplyMsgSize, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Lines ');
  Colour(BBLack);
  //SetY('24');
  LineFeed;
  //int('[U] Unquoted [R] Reply [-> / N] Next Reply [<- / P] Previous Reply [Q] Exit');
  Colour(FYellow);
(*
  Print('[');
  Colour(FGreen);
  Print('U');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Unquoted Reply ');
  Colour(FYellow);
*)
  Print('[');
  Colour(FGreen);
  Print('R');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Reply ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('->');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('N');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Next ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('<-');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('P');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Previous ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('Q');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Quit ');
  if UserInfo.Userlevel = 9 then
   begin
     Colour(FRed);
     Print(' [E] Edit [D] Delete');
   end;
  SetY('4');
  Colour(FWhite);
end;
(*..........................................................................*)
procedure PostHeader(Forum : string);
begin
  ClearDisplay(True);
  Print('[0;25;37;40m[27C[33m[25C[0m [1;33mForum : ' + Forum  + ' [0m');
  LineFeed;
  Print('[36m___[1;37;46m Post Message [0;36;40m_______________________________________________________________');
  LineFeed;
  LineFeed;
end;
(*..........................................................................*)
procedure ForumDisplayHeader;
begin
  ClearDispLay(True);
  Colour(FCyan);
  Print('                                   ARROWS');
  Colour(FYellow);
  Print(' [');
  Colour(FGreen);
  Print('-> ');
  Colour(FYellow);
  Print('/');
  Colour(FGreen);
  Print(' ENTER');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Read Post ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('<-');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('E');
  Colour(Fyellow);
  Print(']');
  Colour(FCyan);
  Print(' Exit ');
  if UserInfo.UserLevel = 9 then
   begin
     SetX('1');
     Colour(FRed);
     Print('[D] Delete Forum');
   end;
  LineFeed;
  Colour(FCyan);
  Print('___');
  Colour(FWhite);
  Colour(BCyan);
  Print(' Select Forum ');
  Colour(FCyan);
  Colour(BBLack);
  Print('______________________________________________________________');
  LineFeed;
  Colour(FYellow);
  Print(' No   Forum                                                Posts      Replies  ');
  LineFeed;
end;
(*..........................................................................*)
procedure ForumDisplayFooter;
var
  Strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(ForumNo, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Forums ');
  Colour(BBLack);
  SetY('24');
  Colour(FCyan);
  Print('Index : ');
  Colour(FYellow);
  Print('(');
  Colour(FWhite);
  Print('N');
  Colour(FYellow);
  Print(') New Post or (');
  Colour(FWhite);
  Print('R');
  Colour(FYellow);
  Print(') New Reply since last login');
  SetY('4');
  Colour(FWhite);
end;
(*..........................................................................*)
procedure PostDisplayHeader;
begin
  ClearDispLay(True);
  Colour(FCyan);
  Print('                      ARROWS');
  Colour(FYellow);
  Print(' [');
  Colour(FGreen);
  Print('P');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' New Post ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('-> ');
  Colour(FYellow);
  Print('/');
  Colour(FGreen);
  Print(' ENTER');
  Colour(FYellow);
  Print(']');
  Colour(FCyan);
  Print(' Read Post ');
  Colour(FYellow);
  Print('[');
  Colour(FGreen);
  Print('<-');
  Colour(FYellow);
  Print(' / ');
  Colour(FGreen);
  Print('E');
  Colour(Fyellow);
  Print(']');
  Colour(FCyan);
  Print(' Exit ');
  LineFeed;
  Print('___');
  Colour(FWhite);
  Colour(BCyan);
  Print(' Select Post ');
  Colour(FCyan);
  Colour(BBLack);
  Print('_______________________________________________________________');
  LineFeed;
  Colour(FYellow);
  Print(' No   Username      Subject                       Date                Replies  ');
  LineFeed;
end;
(*..........................................................................*)
procedure PostDisplayFooter;
var
  Strgs : string;
begin
  SetY('23');
  Colour(FCyan);
  Print('_______________________________________________________________________________');
  Str(PostNo, Strgs);
  Colour(FYellow);
  Colour(BCyan);
  SetX('60');
  Print(' ' + Strgs);
  Colour(FWhite);
  Print(' Posts ');
  Colour(BBLack);
  SetY('24');
  Colour(FCyan);
  Print('Index : ');
  Colour(FYellow);
  Print('(');
  Colour(FWhite);
  Print('A');
  Colour(FYellow);
  Print(') Announcement (');
  Colour(FWhite);
  Print('N');
  Colour(FYellow);
  Print(') New Post or (');
  Colour(FWhite);
  Print('R');
  Colour(FYellow);
  Print(') New Reply since last login');
  SetY('4');
  Colour(FWhite);
end;
(*..........................................................................*)
function PostNew(timestamp : time_t; fid, mid : integer) : integer;
var
  results : recbuf;
  timestr,
  fidstr,
  midstr  : string;
begin
  str(timestamp, timestr);
  str(fid, fidstr);
  str(mid, midstr);
  if mid > 0 then querystr := 'select time from forum_messages where time > ' + timestr + ' and mid = ' + midstr
   else querystr := 'select time from forum_messages where time > ' + timestr + ' and fid = ' + fidstr;
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  if sql_query(query) then
    begin
      results := sql_store_results;
      if results <> nil then PostNew := sql_num_rows(results)
        else PostNew := 0;
      { clear memory }
      sql_free_results(results);
    end
  else
    begin
      PostNew := 0;
    end;
  dispose(query);
end;
(*..........................................................................*)
function ReplyNew(timestamp : time_t; fid, mid, rid : integer) : integer;
var
  results : recbuf;
  timestr,
  ridstr,
  fidstr,
  midstr  : string;
begin
  str(timestamp, timestr);
  str(fid, fidstr);
  str(rid, ridstr);
  str(mid, midstr);
  if mid > 0 then  querystr := 'select time from forum_replies where time > ' + timestr + ' and mid = ' + midstr
   else if fid > 0 then querystr := 'select time from forum_replies where time > ' + timestr + ' and fid = ' + fidstr
     else if rid > 0 then querystr := 'select time from forum_replies where time > ' + timestr + ' and rid = ' + ridstr;
  query := StrAlloc (length(querystr) + 1);
  logsqlerror(querystr);
  strpcopy(query, querystr);
  if sql_query(query) then
    begin
      results := sql_store_results;
      if results <> nil then ReplyNew := sql_num_rows(results)
        else ReplyNew := 0;
      { clear memory }
      sql_free_results(results);
    end
  else
    begin
      LogSQLError('REPLYNEW - ' + sqlerror);
      ReplyNew := 0;
    end;
  dispose(query);
end;
(*..........................................................................*)
{ Tags forum for deletion  }
function ForumDelete(Fid : integer) : boolean;
var
  results : recbuf;
begin
  str(Fid, qstr);
  querystr := 'update forum set deletetag=1 where fid=' + qstr;
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  { delete post from database }
  if sql_query(query) then
   begin
     {results := sql_store_results;}
     if sql_affected_rows > 0 then
      begin
        ForumDelete := true;
      end;
   end
  else
   begin
     LogSQLError(sqlerror);
   end;
  dispose(query);
end;
(*..........................................................................*)
{ Delete posts and any replies }
function DeletePost(Mid : integer) : boolean;
var
  results : recbuf;
begin
  DeletePost := false;
  str(mid, qstr);
  querystr := 'update forum_messages set deletetag=1 where mid=' + qstr;
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  { delete post from database }
  if sql_query(query) then
   begin
     {results := sql_store_results;}
     if sql_affected_rows = 1 then 
      begin
        dispose(query);
        { lets tagg all replies to the post }
        querystr := 'update forum_replies set deletetag=1 where mid=' + qstr;
        query := StrAlloc (length(querystr) + 1);
        strpcopy(query, querystr);
        sql_query(query);
        DeletePost := true;
      end;
   end
  else
   begin
     LogSQLError(sqlerror);
   end;
  dispose(query);
end;
(*..........................................................................*)
{ Delete replies }
function DeleteReply(Rid : integer) : boolean;
var
  results : recbuf;
begin
  DeleteReply := false;
  str(rid, qstr);
  querystr := 'update forum_replies set deletetag=1 where rid=' + qstr;
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  { delete post from database }
  if sql_query(query) then
   begin
     {results := sql_store_results;}
     if sql_affected_rows = 1 then
      begin
        DeleteReply := true;
      end;
   end
  else
   begin
     LogSQLError(sqlerror);
   end;
  dispose(query);
end;
(*..........................................................................*)
{ Returns the number forums }
function ForumCount: integer;
var
  results : recbuf;
begin
   query := 'select * from forum';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then ForumCount :=  sql_num_rows(results)
         else ForumCount := 0;
     end
   else
     begin
       ForumCount := 0;
     end;
end;
(*..........................................................................*)
{ Returns the total number of forum replies }
function ForumTotalReplies(LastLogOn : time_t) : integer;
var
  results : recbuf;
  strgs   : string;
begin
   str(LastLogOn, strgs);
   if LastLogOn > 0 then querystr := 'select * from forum_replies where time > ' + strgs + ' and deletetag=0'
    else querystr := 'select * from forum_replies where deletetag=0';
   query := pchar(querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then ForumTotalReplies :=  sql_num_rows(results)
         else ForumTotalReplies := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       ForumTotalReplies := 0;
     end;
end;
(*..........................................................................*)
{ Returns the total number of forum posts }
function ForumTotalPosts(LastLogon : time_t) : integer;
var
  results : recbuf;
  strgs   : string;
begin
   str(LastLogOn, strgs);
   if LastLogOn > 0 then querystr := 'select * from forum_messages where time > ' + strgs + ' and deletetag=0'
    else querystr := 'select * from forum_messages where deletetag=0';
   query := pchar(querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then ForumTotalPosts :=  sql_num_rows(results)
         else ForumTotalPosts := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       ForumTotalPosts := 0;
       LogSQLError(sqlerror);
     end;
end;
(*..........................................................................*)
{ Returns the number of posts in a forum }
function ForumPosts(fid : integer) : integer;
var
  results : recbuf;
begin
   str(fid, qstr);
   querystr := 'select * from forum_messages where deletetag=0 and fid=' + qstr;
   query := StrAlloc (length(querystr) + 1);
   strpcopy(query, querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> nil then ForumPosts :=  sql_num_rows(results)
         else ForumPosts := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       ForumPosts := 0;
     end;
   dispose(query);
end;
(*..........................................................................*)
{ Returns the number of replies in a forum }
function ForumReplies(fid : integer) : integer;
var
  results : recbuf;
begin
   str(fid, qstr);
   querystr := 'select * from forum_replies where deletetag=0 and fid=' + qstr;
   query := StrAlloc (length(querystr) + 1);
   strpcopy(query, querystr);
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> nil then ForumReplies :=  sql_num_rows(results)
         else ForumReplies := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       ForumReplies := 0;
     end;
   dispose(query);
end;
(*..........................................................................*)
{ Returns the number of post replies }
function PostReplies(mid : integer) : integer;
var
  results   : recbuf;
  querystrg : ansistring;
  sqlquery  : pchar;
begin
   str(mid, qstr);
   querystrg := 'select * from forum_replies where mid=' + qstr;
   sqlquery := StrAlloc (length(querystrg) + 1);
   strpcopy(sqlquery, querystrg);
   if sql_query(sqlquery) then
     begin
       results := sql_store_results;
       if results <> nil then PostReplies :=  sql_num_rows(results)
         else PostReplies := 0;
       { clear memory }
       sql_free_results(results);
     end
   else
     begin
       PostReplies := 0;
       LogSQLError(SQLError);
     end;
   dispose(sqlquery);
end;
(*..........................................................................*)
{ gets all the reply ids for the post }
function GetReplyID(mid : integer) : boolean;
var
  results   : recbuf;
  rows      : rowbuf;
  querystrg : string;
  sqlquery  : pchar;
  ValCode,
  Number    : integer;
begin
  ReplyTotal := 0;
  str(mid, qstr);
  querystrg := 'select rid from forum_replies where mid=' + qstr + ' order by rid';
  sqlquery := stralloc (length(querystrg) + 1);
  strpcopy(sqlquery, querystrg);
  if sql_query(sqlquery) then
   begin
     results := sql_store_results;
     if (results <> nil) then
      begin
        rows := sql_fetch_row(results);
        for number := 1 to sql_num_rows(results) do
        //if (rows <> nil) then
         begin
          inc(ReplyTotal);
          val(ansistring(rows[0]), ReplyNos[ReplyTotal], valcode);
          rows := sql_fetch_row(results);
         end;
        GetReplyID := true;
      end;
     { clear memory }
     sql_free_results(results);
   end
  else
   begin
     GetReplyID := false;
     LogSQLError(SQLError);
   end;
  dispose(sqlquery);
end;
(*..........................................................................*)
{ Gets the post reply }
procedure GetPostReply(rid : integer);
var
  results : recbuf;
  rows    : rowbuf;
  d,col,
  PageLine,
  valcode  : integer;
  msgline  : string[80];
  Pid,
  Date,
  user,
  Reply,
  Subject : string;
begin
  PageLine := 1;
  ReplyMsgSize := 1;
  col     := 1;
  msgline := '';
  str(rid, qstr);
  querystr := 'select * from forum_replies where rid=' + qstr + ' LIMIT 1';
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  querystr := '';
  if sql_query(query) then
    begin
      results := sql_store_results;
      if results <> nil then
       begin
         rows := sql_fetch_row(results);
         if rows <> nil then
          begin
           val(ansistring(rows[0]), ReplyID, valcode);
           ReplyDate := ansistring(rows[3]);
           ReplyUserName := ansistring(rows[8]);
           ReplySubject  := ansistring(rows[5]);
           querystr := ansistring(rows[6]);
           { store remote host/ip in msg if a sysop }
           if UserInfo.Userlevel = 9 then
            begin
              replymsg[1].replymsgline := 'HostName : ' + ansistring(rows[9]);
              replymsg[2].replymsgline := 'Host IP  : ' + ansistring(rows[10]);
              replymsg[3].replymsgline := '';
              ReplyMsgSize := 4;
            end;
          rows := sql_fetch_row(results);
          end;
       end;
      { clear memory }
      sql_free_results(results);
     end
   else
     begin
       { sql query error }
     end;
   dispose(query);
   { convert the pchar in line strings for the BBS }
   for d := 1 to length(querystr) do
    begin
      if (querystr[d] = chr(13)) or (col = 80) then
       begin
         replymsg[ReplyMsgSize].replymsgline := msgline;
         msgline := '';
         inc(ReplyMsgSize);
         col := 1;
       end
      else
       begin
         if (querystr[d] <> chr(10)) then
          begin
            insert(querystr[d], msgline, col);
            inc(col);
          end;
       end;
    end;
end;
(*..........................................................................*)
{ Gets the post message }
procedure GetPostMsg(mid : integer);
var
  results : recbuf;
  rows    : rowbuf;
  d,col,
  PageLine    : integer;
  msgline : string[80];
  Pid,
  Date,
  user,
  Reply,
  Subject : string;
begin
  { Clear any previous post data }
  for d := 1 to 1000 do
   begin
     post[d].msgline := '';
   end;
  PageLine := 1;
  PostMsgSize := 1;
  col     := 1;
  msgline := '';
  str(mid, qstr);
  querystr := 'select * from forum_messages where mid=' + qstr + ' LIMIT 1';
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  querystr := '';
  if sql_query(query) then
    begin
      results := sql_store_results;
      if results <> nil then
       begin
         rows := sql_fetch_row(results);
         if rows <> nil then
          begin
           Pid := ansistring(rows[0]);
           User := ansistring(rows[3]);
           Date := ansistring(rows[4]);
           Subject := ansistring(rows[5]);
           querystr := ansistring(rows[6]);
           Reply := ansistring(rows[8]);
           { store remote host/ip in msg if a sysop }
           if UserInfo.Userlevel = 9 then
            begin
              post[1].msgline := 'HostName : ' + ansistring(rows[14]);
              post[2].msgline := 'Host IP  : ' + ansistring(rows[15]);
              post[3].msgline := '';
              PostMsgSize := 4; 
            end;
           rows := sql_fetch_row(results);
          end;
       end;
      { clear memory }
      sql_free_results(results);
     end
   else
     begin
       { sql query error }
     end;
   dispose(query);
   { convert the pchar in line strings for the BBS }
   for d := 1 to length(querystr) do
    begin
      if (querystr[d] = chr(13)) or (col = 80) then
       begin
         post[PostMsgSize].msgline := msgline;
         msgline := '';
         inc(PostMsgSize);
         col := 1;
       end
      else
       begin
         if (querystr[d] <> chr(10)) then
          begin
            insert(querystr[d], msgline, col);
            inc(col);
          end;
       end;
    end;
(*
   { Display Post header }
   PostMsgHeader(Pid, Date, User, Subject, Reply);
   for d := 1 to PostMsgSize do
    begin
      print(post[d].msgline );
      linefeed;
      inc(PageLine);
      if PageLine = UserInfo.UserLines then
       begin
         PageLine := 1;
         HoldPage;
       end;
    end;
   delay(2000);
*)
end;
(*..........................................................................*)
procedure DisplayReplyMsg(counter, mailno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 6;
  sety('6');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= Mailno then
     begin
       // counter <= 4 then Colour(FGreen)
        //else Colour(FWhite);
       print(ReplyMsg[Counter].ReplyMsgline);
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
//  until (Counter > MailNo) or (LineNo = 23);
end;
(*..........................................................................*)
procedure DisplayPostMsg(counter, mailno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 6;
  sety('6');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= Mailno then
     begin
       // counter <= 4 then Colour(FGreen)
        //else Colour(FWhite);
       print(Post[Counter].Msgline);
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
//  until (Counter > MailNo) or (LineNo = 23);
end;
(*..........................................................................*)
procedure ReadPostMsg(mid, index : integer);
var
  step,
  replyStep : integer;
  ReplyDone : boolean;
begin
   Step := 20;
  { Get the post content }
  GetPostMsg(Mid);
  PostMsgHeader(Mid, PostHdr[Index].Reply, PostHdr[Index].Date, PostHdr[Index].UserName, PostHdr[Index].Subject, PostHdr[Index].Time);
  PostMsgFooter(PostHdr[index].deletetag);
  { Display Post Message }
  DisplayPostMsg(1, PostMsgSize);
  repeat
    echo := false;
    Response := readKB(1);
    echo := true;
    { tag post for deletion, sysops only }
    if (Response = 'D') and (UserInfo.UserLevel = 9) and (PostHdr[Index].deletetag = 0) then
     begin
       SetY('11');
       SetX('8');
       Colour(BRed);
       Colour(FWhite);
       Print('Ŀ');
       SetY('12');
       SetX('8');
       Print(' Are you sure you want to tag this post for deletion (y/n) ');
       SetY('13');
       SetX('8');
       Print('');
       colour(bblack);
       echo := false;
       Response := ReadKB(1);
       echo := true;
       if Response = 'Y' then
        begin
          { delete post and replies }
          if DeletePost(mid) then 
           begin
             logerror('Deleted Forum Post : ' + PostHdr[Index].Subject);
             PostHdr[Index].DeleteTag := 1;
             PostMsgHeader(Mid, PostHdr[Index].Reply, PostHdr[Index].Date, PostHdr[Index].UserName, PostHdr[Index].Subject, PostHdr[Index].Time);
             PostMsgFooter(PostHdr[index].deletetag);
             DisplayPostMsg(1, PostMsgSize);
           end
          else 
           begin
             LogError('Unable to delete Forum Post : ' + PostHdr[index].Subject);
             DisplayPostMsg(1, PostMsgSize);
           end;
        end
       else
        begin
          DisplayPostMsg(1, PostMsgSize);
        end;
     end;
    { Unquoted Reply }
    if Response = 'R' then
     begin
       { check to see if the post is locked, if so, then no reply }
       if PostHdr[index].lock <> 1 then
        begin
          { check that the user is allowed to post to this forum }
          if (UserInfo.UserLevel >= ForumPostLo) and (UserInfo.UserLevel <= ForumPostHi) then
            begin
              ForumPostReply(mid, index);
              exit;
              PostMsgHeader(Mid, PostHdr[Index].Reply, PostHdr[Index].Date, PostHdr[Index].UserName, PostHdr[Index].Subject, PostHdr[Index].Time) ;
              PostMsgFooter(PostHdr[index].deletetag);
              DisplayPostMsg(1, PostMsgSize);
            end
          else
            begin
              { User does not have post rights to selected forum }
              SetY('11');
              SetX('14');
              Colour(BRed);
              Colour(FWhite);
              Print('Ŀ');
              SetY('12');
              SetX('14');
              Print('      Sorry, you can not post to this forum      ');
              SetY('13');
              SetX('14');
              Print('');
              colour(bblack);
              delay(2000);
              DisplayPostMsg(1, PostMsgSize);
            end;
        end
       else
        begin
          SetY('11');
          SetX('14');
          Colour(BRed);
          Colour(FWhite);
          Print('Ŀ');
          SetY('12');
          SetX('14');
          Print('   Sorry, you can not reply to an announcement   ');
          SetY('13');
          SetX('14');
          Print('');
          colour(bblack);
          delay(2000);
          DisplayPostMsg(1, PostMsgSize);
        end;
     end;
    { Right Arrrow - Read Replies }
    if Response = chr(93) then
     begin
       { get all the reply ids }
       if (GetReplyID(mid)) and (PostHdr[Index].Reply > 0) then
        begin
          ReplyStep := 20;
          { set to first reply }
          ReplyNo := 1;
          { Display all replies }
          repeat
            ReplyDone := false;
            { Get reply }
            GetPostReply(ReplyNos[ReplyNo]);
            { Display Reply }
            ReplyMsgHeader(ReplyNos[ReplyNo], ReplyNo, ReplyTotal, ReplyDate, ReplyUserName, ReplySubject);
            ReplyMsgFooter;
            DisplayReplyMsg(1, ReplyMsgSize);
            repeat
              echo := false;
              Response := readKB(1);
              echo := true;
              { Post Reply }
              if Response = 'R' then
               begin
                 { check that the user is allowed to post to this forum }
                 if (UserInfo.UserLevel >= ForumPostLo) and (UserInfo.UserLevel <= ForumPostHi) then
                  begin
                    ForumPostReply(mid, index);
                    exit;
                    { Display Reply }
                    ReplyMsgHeader(ReplyNos[ReplyNo], ReplyNo, ReplyTotal, ReplyDate, ReplyUserName, ReplySubject);
                    ReplyMsgFooter;
                    DisplayReplyMsg(1, ReplyMsgSize);
                    ReplyStep := 20;
                  end
                 else
                  begin
                    { User does not have post rights to selected forum }
                    SetY('11');
                    SetX('14');
                    Colour(BRed);
                    Colour(FWhite);
                    Print('Ŀ');
                    SetY('12');
                    SetX('14');
                    Print('      Sorry, you can not post to this forum      ');
                    SetY('13');
                    SetX('14');
                    Print('');
                    colour(bblack);
                    delay(2000);
                    DisplayReplyMsg(1, ReplyMsgSize);
                    ReplyStep := 20;
                  end;
               end;
              { exit }
              if Response = 'Q' then
               begin
                 ReplyNo := 0;
                 ReplyDone := true;
               end;
              { Reply Arrow down }
              if response = chr(62) then
               begin
                 if ReplyStep < ReplyMsgSize then
                  begin
                    inc(ReplyStep);
                    DisplayReplyMsg((ReplyStep - 19), ReplyMsgSize);
                  end;
               end;
              { Reply Arrow Up }
              if response = chr(60) then
               begin
                 if ReplyStep > 20 then
                  begin
                    dec(ReplyStep);
                    DisplayReplyMsg((ReplyStep - 19), ReplyMsgSize);
                  end;
               end;
              { Reply Arrow Left or P }
              if (response = chr(91)) or (response = 'P') then
               begin
                 { If this is the first reply, then return to post }
                 if ReplyNo = 1 then
                  begin
                    ReplyNo := 0;
                    ReplyDone := true;
                  end
                 else
                  begin
                    { Get the Previous Reply }
                    dec(ReplyNo);
                    ReplyDone := true;
                  end;
               end;
              { Reply Arrorw Right or N }
              if (response = chr(93)) or (response = 'N') then
               begin
                 { If this is not the last reply }
                 if ReplyNo < ReplyTotal then
                  begin
                    { Get next reply }
                    inc(ReplyNo);
                    ReplyDone := true;
                  end;
               end;
            until ReplyDone;
          until ReplyNo = 0;
          Response := '';
          { Display Post }
          PostMsgHeader(Mid, PostHdr[Index].Reply, PostHdr[Index].Date, PostHdr[Index].UserName, PostHdr[Index].Subject, PostHdr[Index].Time);
          PostMsgFooter(PostHdr[index].deletetag);
          DisplayPostMsg(1, PostMsgSize);
        end;
     end;
    { Arrow down }
    if Response = chr(62) then
     begin
       if Step < PostMsgSize then
        begin
          inc(step);
          DisplayPostMsg((Step - 19), PostMsgSize);
        end;
     end;
    { Arrow up }
    if Response = chr(60) then
     begin
       if Step > 20 then
        begin
          dec(step);
          DisplayPostMsg((Step - 19), PostMsgSize);
        end;
     end;
  until (Response = 'Q') or (Response = chr(91));
end;
(*..........................................................................*)
{ Post Message Reply }
procedure ForumPostReply(mid, index : integer);
var
  ForumMsgTemp : ansistring;
  Response,
  PostID,
  PostLock,
  PostSubject,
  PostEpochTime,
  UserUID,
  Strgs        : string;
  Loop         : integer;
  Results      : recbuf;
  OK           : boolean;
begin
  ForumMsgTemp := '';
  //PostHeader(ForumTitle);
  { SubJect }
  PostSubject := 'RE: ' + PostHdr[Index].Subject;
  (*
  repeat
   LineFeed;
   Print('Post Subject : ');
   Colour(FGreen);
   NoUpper := true;
   PostSubject := ReadKB(40);
   NoUpper := false;
   if length(PostSubject) < 5 then OK := false
    else OK := true;
  until OK;
  *)
  { Create new Data pointer }
  new(ForumMsgData);
  { Start Full Editor }
  ForumMsgData := Fulledit(ForumMsgData,' Subject : ' + PostSubject,'',1000);
  { Check to see if there is any data in the returned data pointer }
  if ForumMsgData^.next <> nil then
   begin
      { store forum post into a temp string * maybe better to store this in a memory block }
      while ForumMsgData <> nil do
        begin
           ForumMsgTemp := ForumMsgTemp + ForumMsgData^.data + chr(13) + chr(10);
           ForumMsgData := ForumMsgData^.next ;
        end; { end while }
      { Dispose of the forum message data pointer }
      dispose(ForumMsgData);
      { Setup SQL string }
      str(UserInfo.UserUID, UserUID);
      str(ForumID,Strgs);
      str(fptime, PostEpochTime);
      str(mid, PostID);
      ForumMsgTemp := sql_addslashes(ForumMsgTemp);
      PostSubject  := sql_addslashes(PostSubject);
      querystr := 'insert into forum_replies values(NULL,''' + PostID  + ''',''' + PostEpochTime +''',''' + TodayShort + ''',''' + UserUID + ''',''' + PostSubject  +  ''',''' + ForumMsgTemp + ''',''' + strgs + ''','''  + UserInfo.UserName  + ''',''' +  remotehost + ''',''' + remoteip + ''',0)';
      query := pchar(querystr);
      if not sql_query(query) then
       begin
         if UserInfo.UserLevel = 9 then
          begin
            LineFeed;
            Print('Error: ' + SqlError);
          end;
         LogSQLError(SqlError);
       end
      else
       begin
         Linefeed;
         Print('Message Reply Saved..');
         Linefeed;
         delay(2000);
       end;
  end;
end;

(*..........................................................................*)
{ Posts a message to the forum }
procedure ForumPostMessage(fid : integer);
var
  ForumMsgTemp : ansistring;
  Response,
  UserUID,
  PostLock,
  PostSubject,
  PostEpochTime,
  Strgs        : string;
  PostLines,
  Loop         : integer;
  Results      : recbuf;
  OK           : boolean;
begin
  ForumMsgTemp := '';
  PostHeader(ForumTitle);
  { Ask sysop if this is an annoucement message }
  if (UserInfo.UserLevel = 9) and (ForumID <> BBSCfg.BulletinForum) then
   begin
     Print('Annoucement Post!');
     Linefeed;
     Linefeed;
     Print('An annoucement post will always be on the top of displayed messages and users');
     Linefeed;
     Print('will not be able to reply to the post.');
     Linefeed;
     Linefeed;
     Print('Do you want this message to be an annoucement (Y/n) ? : ');
     Response := ReadKB(1);
     Linefeed;
     if Response = 'Y' then PostLock := '1'
      else PostLock := '0';
     { todo: include post expiry question  }
     LineFeed;
   end
  else
   begin
     PostLock := '0';
   end;
  { SubJect }
  repeat
   Colour(FWhite);
   Print('Subject must be > 5 chars! Press [ENTER] to exit..');
   LineFeed;
   LineFeed;
   Colour(FYellow);
   Print('Post Subject : ');
   Colour(FGreen);
   NoUpper := true;
   PostSubject := ReadKB(40);
   NoUpper := false;
   case length(PostSubject) of
      0  : exit;
    1..5 : OK := false;
     else
         OK := True;
   end;
   LineFeed;
   {
   if length(PostSubject) < 5 then OK := false
    else OK := true;
   }
   LineFeed;
  until OK;
  { Create new Data pointer }
  new(ForumMsgData);
  { If this is the bulletin forum, then only allow a max of 20 lines }
  if ForumID = BBSCfg.BulletinForum then PostLines := 20
   else PostLines := 1000;
  { Start Full Editor }
  ForumMsgData := Fulledit(ForumMsgData,' Subject : ' + PostSubject,'',PostLines);
  { Check to see if there is any data in the returned data pointer }
  if ForumMsgData^.next <> nil then
   begin
      { store forum post into a temp string * maybe better to store this in a memory block }
      while ForumMsgData <> nil do
        begin
           ForumMsgTemp := ForumMsgTemp + ForumMsgData^.data + chr(13) + chr(10);
           ForumMsgData := ForumMsgData^.next ;
        end; { end while }
      { Dispose of the forum message data pointer }
      dispose(ForumMsgData);
      { Setup SQL string }
      str(UserInfo.UserUID, UserUID);
      //str(ForumID,Strgs);
      str(Fid,Strgs);
      str(fptime, PostEpochTime);
      ForumMsgTemp := sql_addslashes(ForumMsgTemp);
      PostSubject  := sql_addslashes(PostSubject);
      querystr := 'insert into forum_messages values(NULL,''' + UserUID  + ''',1,''' + UserInfo.UserName +''',''' + TodayShort + ''',''' + PostSubject  +  ''',''' + ForumMsgTemp + ''',0,0,' + PostLock +  ',' + Strgs + ',' + PostEpochTime + ',0,0,''' +  remotehost + ''',''' + remoteip + ''')';
      query := pchar(querystr);
      if not sql_query(query) then
       begin
         if UserInfo.UserLevel = 9 then
          begin
            LineFeed;
            Print('Error: ' + SqlError);
          end;
         LogSQLError(SqlError);
       end
      else
       begin
         Linefeed;
         Print('Message Post Saved..');
         Linefeed;
         delay(2000);
       end;
  end;
end;
(*..........................................................................*)
{ gets forum post data from SQL and store into array PostHdr  }
function PostList(Fid : integer) : boolean;
var
  Strgs   : string;
  results : recbuf;
  rows    : rowbuf;
  Loop,
  Posts,
  ValCode,
  DelTag  : integer;
begin
  Posts    := 0;
  PostList := false;
  str(fid, strgs);
  { Get Announcement Posts First }
  querystr := 'select mid, username, title, date, replies, locked, time, deletetag  from forum_messages where fid=' + strgs + ' and locked=1 order by mid DESC';
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  if sql_query(query) then
   begin
     { get query results }
     results := sql_store_results;
     if results <> nil then
      begin
        rows := sql_fetch_row(results);
        while rows <> nil do
         begin
           val(strpas(rows[7]), DelTag, ValCode);
           { do not show posts that are tagged for deletion, unless it is a sysop }
           if (DelTag = 0) or (UserInfo.Userlevel = 9) then
            begin
              inc(Posts);
              val(strpas(rows[0]), PostHdr[Posts].Mid, ValCode);
              PostHdr[Posts].UserName := strpas(rows[1]);
              PostHdr[Posts].Subject  := strpas(rows[2]);
              PostHdr[Posts].Date     := strpas(rows[3]);
              PostHdr[Posts].Reply := PostReplies(PostHdr[Posts].Mid);
              val(strpas(rows[5]), PostHdr[Posts].Lock, ValCode);
              val(strpas(rows[6]), PostHdr[Posts].Time, ValCode);
              val(strpas(rows[7]), PostHdr[Posts].Deletetag, ValCode);
           end;
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
        { there are announcements, so lets set the postlist to true }
        PostList := true;
      end;
     { release the old query memory }
     dispose(query);
     { get remaining posts }
     querystr := 'select mid, username, title, date, replies, locked, time, deletetag from forum_messages where fid=' + strgs + ' and locked=0 order by mid DESC';
     query := StrAlloc (length(querystr) + 1);
     strpcopy(query, querystr);
     if sql_query(query) then
      begin
        { get query results }
        results := sql_store_results;
        if results <> nil then
         begin
           rows := sql_fetch_row(results);
           while rows <> nil do
            begin
              val(strpas(rows[7]), DelTag, ValCode);
              { do not show posts that are tagged for deletion, unless it is a sysop }
              if (DelTag = 0) or (UserInfo.Userlevel = 9) then
               begin
                 inc(Posts);
                 val(strpas(rows[0]), PostHdr[Posts].Mid, ValCode);
                 PostHdr[Posts].UserName := strpas(rows[1]);
                 PostHdr[Posts].Subject  := strpas(rows[2]);
                 PostHdr[Posts].Date     := strpas(rows[3]);
                 PostHdr[Posts].Reply := PostReplies(PostHdr[Posts].Mid);
                 val(strpas(rows[5]), PostHdr[Posts].Lock, ValCode);
                 val(strpas(rows[6]), PostHdr[Posts].Time, ValCode);
                 val(strpas(rows[7]), PostHdr[Posts].Deletetag, ValCode);
               end;
              rows := sql_fetch_row(results);
            end;
           { clear memory }
           sql_free_results(results);
           { there are announcements, so lets set the postlist to true }
           PostList := true;
        end
       else
         begin
           { no results from query, there are proberly no posts }
           exit;
         end;
        dispose(query);
        PostNo := Posts;
      end
     else
      begin
        { Error running query on remaining posts }
        LogSQLError(sqlerror);
        dispose(query);
        PostNo := 0;
        // add user error message..
      end;
   end
  else
   begin
     { Error running query on annoucement posts }
     LogSQLError(sqlerror);
     dispose(query);
     PostNo := 0;
     // add user error message..
   end;
end;
(*..........................................................................*)
{ gets forum data from SQL and stores into array ForumHdr }
function ForumList : boolean;
var
  fid      : integer;
  fidlevel : integer;
  strgs    : string;
  results  : recbuf;
  rows     : rowbuf;
begin
  { ForumHdr counter }
  fid := 0;
  query := 'select * from forum order by fid';
  if sql_query(query) then
   begin
     { get results from query }
     results := sql_store_results;
     if results <> nil then
      begin
        { get forum details }
        rows := sql_fetch_row(results);
        while (rows <> nil) do
         begin
           val(strpas(rows[3]), FidLevel, CodeData);
           { Does the user have access to view this forum }
           if FidLevel <= UserInfo.UserLevel then
            begin
              inc(fid);
              { store forums in array to for ForumDisplay }
              ForumHdr[fid].Title := strpas(rows[1]);
              val(strpas(rows[0]), FidLevel, CodeData);
              ForumHdr[fid].Fid := FidLevel;
              ForumHdr[fid].Posts := ForumPosts(FidLevel);
              ForumHdr[fid].Reply := ForumReplies(FidLevel);
              val(strpas(rows[4]), FidLevel, CodeData);
              ForumHdr[fid].PostLo := FidLevel;
              val(strpas(rows[5]), FidLevel, CodeData);
              ForumHdr[fid].PostHi := FidLevel;
            end;
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
        ForumList := true;
        ForumNo := fid;
        exit;
      end
   end;
  { no forums }
  ForumList := false;
end;
(*..........................................................................*)
{ Post Display Pages }
procedure PostDisplayPages(counter, postno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 4;
  sety('4');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= postno then
     begin
       Str(Counter, Strgs);
       SetX('1');
       if PostHdr[Counter].Lock = 1 then Colour(FRed)
        else Colour(FGreen);
       Print(strgs);
       SetX('6');
       if PostHdr[Counter].lock = 1 then Colour(FRed)
        else Colour(FMagenta);
       Print(PostHdr[Counter].Username);
       SetX('20');
       if PostHdr[Counter].lock = 1 then Colour(FRed)
        else Colour(FWhite);
       Print(PostHdr[Counter].Subject);
       if PostHdr[Counter].Lock = 1 then Colour(FRed)
        else Colour(FWhite);
       SetX('50');
       Print(PostHdr[Counter].Date);
       if PostHdr[Counter].lock = 1 then Colour(FRed)
        else Colour(FGreen);
       SetX('72');
       Str(PostHdr[Counter].Reply, Strgs);
       Print(Strgs);
       { Tag an annocement post with an A }
       if PostHdr[Counter].Lock = 1 then
        begin
          Colour(FRed);
          SetX('78');
          Print('A');
        end;
       { Checks for new replies since user last login }
       if ReplyNew(UserInfo.UserLogon,0, PostHdr[Counter].mid, 0) > 0 then
        begin
          Colour(FRed);
          SetX('76');
          Print('R');
        end;
       { Checks for new posts since user last login }
       if PostNew(UserInfo.UserLogon, 0, PostHdr[Counter].mid) > 0 then
        begin
          Colour(FRed);
          SetX('77');
          Print('N');
        end;
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
//  until (Counter > postNo) or (LineNo = 23);
end;
(*..........................................................................*)
{ ForumDisplay Pages }
procedure ForumDisplayPages(counter, fidno : integer);
var
  Strgs : string;
  LineNo : integer;
begin
  LineNo := 4;
  sety('4');
  { Display mail list }
  repeat
    colour(bblack);
    Print(#27+'0K');
    if Counter <= fidno then
     begin
       Str(Counter, Strgs);
       SetX('1');
       Colour(FGreen);
       Print(strgs);
       SetX('6');
       Colour(FMagenta);
       Print(FOrumHdr[Counter].Title);
       SetX('60');
       Colour(FWhite);
       Str(ForumHdr[Counter].Posts, Strgs);
       Print(Strgs);
       Colour(FGreen);
       SetX('72');
       Str(ForumHdr[Counter].Reply, Strgs);
       Print(Strgs);
       { Checks for new replies since user last login }
       if ReplyNew(UserInfo.UserLogon, ForumHdr[Counter].fid, 0, 0) > 0 then
        begin
          Colour(FRed);
          SetX('77');
          Print('R');
        end;
       { Checks for new posts since user last login }
       if PostNew(UserInfo.UserLogon, ForumHdr[Counter].fid,0) > 0 then
        begin
          Colour(FRed);
          SetX('78');
          Print('N');
        end;
       inc(counter);
     end;
    Linefeed;
    inc(lineNo);
  until LineNo = 23;
//  until (Counter > fidNo) or (LineNo = 23);
end;
(*..........................................................................*)
{ Display available Posts - returns Forum ID on selection or 0 for exit }
function PostDisplay : integer;
var
  Step,
  Post,
  Post1,   { First forum number to display }
  Counter,
  Loop,
  CYPos,
  CYPos1,
  ForumNoID : integer;
  Strgs     : string;

begin
  { Check that we have forums to display }
  if PostList(ForumID) then
   begin
     Step    := 0;
     Post    := 1;
     Post1   := 1;
     Counter := 4;
     Loop    := 1;
     PostDisplay := 0;
     { Display Page Header and Footer }
     PostDisplayHeader;
     PostDisplayFooter;
     { Display the first page of available forums }
     PostDisplayPages(1, PostNo);
     Step   := 0;
     CYPos  := 4;
     CYPos1 := 3;
     { Highlight the first message }
     SetY('4');
     SetX('1');
     colour(bcyan);
     { Clear EOF with highlight }
     Print(#27+'0K');
     if PostHdr[1].Lock = 1 then Colour(FRed)
      else Colour(FGreen);
     Print('1');
     SetX('6');
     if PostHdr[1].Lock = 1 then Colour(FRed)
      else Colour(FMagenta);
     Print(PostHdr[1].UserName);
     SetX('20');
     if PostHdr[1].Lock = 1 then Colour(FRed)
      else Colour(FWhite);
     Print(PostHdr[1].Subject);
     if PostHdr[1].Lock = 1 then Colour(FRed)
       else Colour(FWhite);
     SetX('50');
     Print(PostHdr[1].Date);
     if PostHdr[1].Lock = 1 then Colour(FRed)
      else Colour(FGreen);
     SetX('72');
     Str(PostHdr[1].Reply, Strgs);
     Print(Strgs);
     { Tag an annocement post with an A }
     if PostHdr[1].Lock = 1 then
      begin
        Colour(FRed);
        SetX('78');
        Print('A');
      end;
     { Checks for new replies since user last login }
     if ReplyNew(UserInfo.UserLogon,0, PostHdr[1].mid, 0) > 0 then
      begin
        Colour(FRed);
        SetX('76');
        Print('R');
      end;
     { Checks for new posts since user last login }
     if PostNew(UserInfo.UserLogon, 0, PostHdr[1].mid) > 0 then
      begin
        Colour(FRed);
        SetX('77');
        Print('N');
      end;
     colour(bblack);
     { List Box }
     Repeat
       NoUpper := False;
       Echo := false;
       Response := ReadKB(1);
       Echo := true;
       if (Response = 'E') or (Response = chr(91)) then
        begin
          PostDisplay := 0;
          exit;
        end;
       if Response = 'P' then
        begin
          { check that the user is allowed to post to this forum }
          if (UserInfo.UserLevel >= ForumPostLo) and (UserInfo.UserLevel <= ForumPostHi) then
           begin
             ForumPostMessage(ForumID);
     	     { Display Page Header and Footer }
             PostDisplayHeader;
             PostDisplayFooter;
           end
          else
           begin
             { User does not have post rights to selected forum }
             SetY('11');
             SetX('14');
             Colour(BRed);
             Colour(FWhite);
             Print('Ŀ');
             SetY('12');
             SetX('14');
             Print('      Sorry, you can not post to this forum      ');
             SetY('13');
             SetX('14');
             Print('');
             colour(bblack);
             delay(2000);
           end;
          { Relist posts }
          PostList(ForumID);
          { Display the first page of available forums }
          PostDisplayPages(Post1, PostNo);
          { Highlight the first message }
	  //tY('4');
          str(counter,strgs);
          sety(strgs);
     	  SetX('1');
          colour(bcyan);
          { Clear EOF with highlight }
          Print(#27+'0K');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FGreen);
          Str(Post, Strgs);
          Print(strgs);
          SetX('6');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FMagenta);
          Print(PostHdr[Post].UserName);
          SetX('20');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FWhite);
          Print(PostHdr[Post].Subject);
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FWhite);
          SetX('50');
          Print(PostHdr[Post].Date);
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FGreen);
          SetX('72');
          Str(PostHdr[Post].Reply, Strgs);
          Print(Strgs);
          { Tag an annocement post with an A }
          if PostHdr[Post].Lock = 1 then
           begin
             Colour(FRed);
             SetX('78');
             Print('A');
           end;
          { Checks for new replies since user last login }
          if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post].mid, 0) > 0 then
           begin
             Colour(FRed);
             SetX('76');
             Print('R');
           end;
          { Checks for new posts since user last login }
          if PostNew(UserInfo.UserLogon, 0, PostHdr[Post].mid) > 0 then
           begin
            Colour(FRed);
            SetX('77');
            Print('N');
          end;
          colour(bblack);
        end;
       { Select Post arrow right }
       if (Response = chr(93)) or (Response = '') then
        begin
          ReadPostMsg(PostHdr[Post].Mid, Post);
          { Relist posts }
          PostList(ForumID);
          { Check if a post has been deleted }
          if PostRemoved then
           begin
             PostRemoved := false;
             if counter > 1 then 
              begin
                dec(counter);
//                dec(post);
                //dec(post1);
                dec(PostNo);
              end
             else
              begin 
                counter := 0;
                exit;
              end;
           end;
          { Display Page Header and Footer }
          PostDisplayHeader;
          PostDisplayFooter;
          { Display the first page of available forums }
          PostDisplayPages(Post1, PostNo);
          { Highlight the first message }
	  //tY('4');
          str(counter,strgs);
          sety(strgs);
     	  SetX('1');
          colour(bcyan);
          { Clear EOF with highlight }
          Print(#27+'0K');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FGreen);
          Str(Post, Strgs);
          Print(strgs);
          SetX('6');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FMagenta);
          Print(PostHdr[Post].UserName);
          SetX('20');
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FWhite);
          Print(PostHdr[Post].Subject);
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FWhite);
          SetX('50');
          Print(PostHdr[Post].Date);
          if PostHdr[Post].Lock = 1 then Colour(FRed)
           else Colour(FGreen);
          SetX('72');
          Str(PostHdr[Post].Reply, Strgs);
          Print(Strgs);
          { Tag an annocement post with an A }
          if PostHdr[Post].Lock = 1 then
           begin
             Colour(FRed);
             SetX('78');
             Print('A');
           end;
          { Checks for new replies since user last login }
          if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post].mid, 0) > 0 then
           begin
             Colour(FRed);
             SetX('76');
             Print('R');
           end;
          { Checks for new posts since user last login }
          if PostNew(UserInfo.UserLogon, 0, PostHdr[Post].mid) > 0 then
           begin
            Colour(FRed);
            SetX('77');
            Print('N');
          end;
         colour(bblack);
       end;
       { down arrow }
       if (Response = chr(62)) and (Post < PostNo)  then
         begin
           if Post < PostNo then
            begin
              if counter = 22 then
               begin
                 Post1 := (Post - 17);
                 PostDisplayPages(Post1,PostNo);
                 str(Counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Post + 1, Strgs);
                 SetX('1');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post + 1].UserName);
                 SetX('20');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post + 1].Subject);
	  	 if PostHdr[Post + 1].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post + 1].Date);
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post + 1].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post + 1].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post + 1].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post + 1].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
               end
              else
               begin
                 str(counter,strgs);
                 sety(strgs);
                 colour(bblack);
                 Print(#27+'0K');
                 Str(Post, Strgs);
                 SetX('1');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post].UserName);
                 SetX('20');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post].Subject);
                 if PostHdr[Post].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post].Date);
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
                 inc(counter);
                 str(counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Post + 1, Strgs);
                 SetX('1');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post + 1].UserName);
                 SetX('20');
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post + 1].Subject);
                 if PostHdr[Post + 1].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post + 1].Date);
                 if PostHdr[Post + 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post + 1].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post + 1].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post + 1].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post + 1].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
               end;
              inc(Post);
            end;
         end;
       { arrow up }
       if (Response = chr(60)) and (Post > 1)  then
         begin
           if Post > 1 then
            begin
              if counter = 4 then
               begin
                 Post1 := (Post - 1);
                 PostDisplayPages(Post1,PostNo);
                 str(Counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Post - 1, Strgs);
                 SetX('1');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post - 1].Username);
                 SetX('20');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post - 1].Subject);
                 if PostHdr[Post - 1].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post - 1].Date);
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post - 1].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post - 1].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post - 1].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post - 1].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
               end
              else
               begin
                 str(counter,strgs);
                 sety(strgs);
                 colour(bblack);
                 colour(bblack);
                 Print(#27+'0K');
                 Str(Post, Strgs);
                 SetX('1');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post].UserName);
                 SetX('20');
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post].Subject);
                 if PostHdr[Post].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post].Date);
                 if PostHdr[Post].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
                 dec(counter);
                 str(counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Post - 1, Strgs);
                 SetX('1');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FMagenta);
                 Print(PostHdr[Post - 1].UserName);
                 SetX('20');
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 Print(PostHdr[Post - 1].Subject);
                 if PostHdr[Post - 1].lock = 1 then Colour(FRed)
                  else Colour(FWhite);
                 SetX('50');
                 Print(PostHdr[Post - 1].Date);
                 if PostHdr[Post - 1].Lock = 1 then Colour(FRed)
                  else Colour(FGreen);
                 SetX('72');
                 Str(PostHdr[Post - 1].Reply, Strgs);
                 Print(Strgs);
                 { Tag an annocement post with an A }
                 if PostHdr[Post - 1].Lock = 1 then
                  begin
                    Colour(FRed);
                    SetX('78');
                    Print('A');
                  end;
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon,0, PostHdr[Post - 1].mid, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('76');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, 0, PostHdr[Post - 1].mid) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('N');
                 end;
                 colour(bblack);
               end;
              if Post <> 1 then dec(Post);
            end;
         end;
     Until Response = 'Q';
   end
  else
   begin
     PostDisplay := 0;
   end;
end;
(*..........................................................................*)
{ Display available Forums - returns Forum ID on selection or 0 for exit }
function ForumDisplay : integer;
var
  Step,
  Forum,
  Forum1,   { First forum number to display }
  Counter,
  Loop,
  CYPos,
  CYPos1,
  ForumNoID : integer;
  Strgs     : string;

begin
  { Check that we have forums to display }
  if ForumList then
   begin
     Step    := 0;
     Forum   := 1;
     Forum1  := 1;
     Counter := 4;
     Loop    := 1;
     ForumDisplay := 0;
     { Display Page Header and Footer }
     ForumDisplayHeader;
     ForumDisplayFooter;
     { Display the first page of available forums }
     ForumDisplayPages(1, ForumNo);
     Step   := 0;
     CYPos  := 4;
     CYPos1 := 3;
     { Highlight the first Message }
     SetY('4');
     SetX('1');
     colour(bcyan);
     { Clear EOF with highlight }
     Print(#27+'0K');
     Colour(FGreen);
     Print('1');
     SetX('6');
     Colour(FMagenta);
     Print(FOrumHdr[1].Title);
     SetX('60');
     Colour(FWhite);
     Str(ForumHdr[1].Posts, Strgs);
     Print(Strgs);
     Colour(FGreen);
     SetX('72');
     Str(ForumHdr[1].Reply, Strgs);
     Print(Strgs);
     { Checks for new replies since user last login }
     if ReplyNew(UserInfo.UserLogon, ForumHdr[1].fid,0,0) > 0 then
      begin
        Colour(FRed);
        SetX('77');
        Print('R');
      end;
     { Checks for new posts since user last login }
     if PostNew(UserInfo.UserLogon, ForumHdr[1].fid,0) > 0 then
      begin
        Colour(FRed);
        SetX('78');
        Print('N');
      end;
     colour(bblack);
     { List Box }
     Repeat
       NoUpper := False;
       Echo := false;
       Response := ReadKB(1);
       Echo := true;
       if (Response = 'D') and (UserInfo.UserLevel = 9) then
        begin
          SetY('11');
          SetX('9');
          Colour(BRed);
          Colour(FWhite);
          Print('Ŀ');
          SetY('12');
          SetX('9'); 
          Print(' Are you sure you want to tag this forum for deletion? (y/n) ');
          SetY('13');
          SetX('9');
          Print('');
          colour(bblack);
          echo := false;
          response := readkb(1);
          echo := true;
          if response = 'Y' then ForumDelete(ForumHdr[Forum].fid);
          { Display the first page of available forums }
          ForumDisplayPages(1, ForumNo);
        end;
       if (Response = 'E') or (Response = chr(91)) then
        begin
          ForumDisplay := 0;
          exit;
        end;
       { Select Forum }
       if (Response = '')  or (Response = chr(93)) then
        begin
          { Check that the forum Has posts before we try and list them }
          if ForumHdr[Forum].Posts = 0 then
           begin
             { no posts, ask users to post }
             { check that the user is allowed to post to this forum }
             if (UserInfo.UserLevel >= ForumHdr[Forum].PostLo) and (UserInfo.UserLevel <= ForumHdr[Forum].PostHi) or (UserInfo.UserLevel = 9) then
              begin
                SetY('11');
                SetX('6');
                Colour(BRed);
                Colour(FWhite);
                Print('Ŀ');
                SetY('12');
                SetX('6');
                Print(' There are no messages, would you like to post to this forum? (y/n) ');
                SetY('13');
                SetX('6');
                Print('');
                colour(bblack);
                echo := false;
                response := readkb(1);
                echo := true;
                if response = 'Y' then 
                  begin
                    ForumPostMessage(ForumHdr[Forum].fid);
                    { Rebuild the forum list }
                    ForumList;
                    { Display Page Header and Footer }
                    ForumDisplayHeader;
                    ForumDisplayFooter;
                  end;
                { Display the first page of available forums }
                ForumDisplayPages(1, ForumNo);
                str(Counter,strgs);
                sety(strgs);
                colour(bcyan);
                Print(#27+'0K');
                Str(Forum, Strgs);
                SetX('1');
                Colour(FGreen);
                Print(strgs);
                SetX('6');
                Colour(FMagenta);
                Print(FOrumHdr[Forum].Title);
                SetX('60');
                Colour(FWhite);
                Str(ForumHdr[Forum].Posts, Strgs);
                Print(Strgs);
                Colour(FGreen);
                SetX('72');
                Str(ForumHdr[Forum].Reply, Strgs);
                Print(Strgs);
                { Checks for new replies since user last login }
                if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('R');
                 end;
               { Checks for new posts since user last login }
               if PostNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0) > 0 then
                begin
                  Colour(FRed);
                  SetX('78');
                  Print('N');
                end;
                colour(bblack);
              end
             else
              begin
                { User does not have post rights to selected forum }
                SetY('9');
                SetX('14');
                Colour(BRed);
                Colour(FWhite);
                Print('Ŀ');
                SetY('10');
                SetX('14');
                Print('     Sorry, there are no posts in this forum     ');
                Sety('11');
                SetX('14');
                Print('     and your user level does not allow you to   ');
                Sety('12');
                SetX('14');
                Print('     post to the forum                           ');
                SetY('13');
                SetX('14');
                Print('');
                delay(3000);
                ForumDisplayPages(1, ForumNo);
                str(Counter,strgs);
                sety(strgs);
                colour(bcyan);
                Print(#27+'0K');
                Str(Forum, Strgs);
                SetX('1');
                Colour(FGreen);
                Print(strgs);
                SetX('6');
                Colour(FMagenta);
                Print(FOrumHdr[Forum].Title);
                SetX('60');
                Colour(FWhite);
                Str(ForumHdr[Forum].Posts, Strgs);
                Print(Strgs);
                Colour(FGreen);
                SetX('72');
                Str(ForumHdr[Forum].Reply, Strgs);
                Print(Strgs);             
                { Checks for new replies since user last login }
                if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('77');
                   Print('R');
                 end;
               { Checks for new posts since user last login }
               if PostNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0) > 0 then
                begin
                  Colour(FRed);
                  SetX('78');
                  Print('N');
                end;
                colour(bblack);
              end; 
           end
          else
           begin
             ForumDisplay := ForumHdr[Forum].Fid;
             exit;
           end;
        end;
       { down arrow }
       if (Response = chr(62)) and (Forum < ForumNo)  then
         begin
           if forum < ForumNo then
            begin
              if counter = 22 then
               begin
                 Forum1 := (Forum - 17);
                 ForumDisplayPages(Forum1,ForumNo);
                 str(Counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Forum + 1, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(FOrumHdr[Forum + 1].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum + 1].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum + 1].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum + 1].fid,0, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum + 1].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
               end
              else
               begin
                 str(counter,strgs);
                 sety(strgs);
                 colour(bblack);
                 Print(#27+'0K');
                 Str(Forum, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(FOrumHdr[Forum].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
                 inc(counter);
                 str(counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Forum + 1, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(ForumHdr[Forum + 1].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum + 1].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum + 1].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum + 1].fid,0, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum + 1].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
               end;
              inc(Forum);
            end;
         end;
       { arrow up }
       if (Response = chr(60)) and (Forum > 1)  then
         begin
           if Forum > 1 then
            begin
              if counter = 4 then
               begin
                 Forum1 := (Forum - 1);
                 ForumDisplayPages(Forum1,ForumNo);
                 str(Counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Forum - 1, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(FOrumHdr[Forum - 1].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum - 1].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum - 1].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum - 1].fid,0,0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum - 1].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
               end
              else
               begin
                 str(counter,strgs);
                 sety(strgs);
                 colour(bblack);
                 colour(bblack);
                 Print(#27+'0K');
                 Str(Forum, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(FOrumHdr[Forum].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0,0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
                 dec(counter);
                 str(counter,strgs);
                 sety(strgs);
                 colour(bcyan);
                 Print(#27+'0K');
                 Str(Forum - 1, Strgs);
                 SetX('1');
                 Colour(FGreen);
                 Print(strgs);
                 SetX('6');
                 Colour(FMagenta);
                 Print(FOrumHdr[Forum - 1].Title);
                 SetX('60');
                 Colour(FWhite);
                 Str(ForumHdr[Forum - 1].Posts, Strgs);
                 Print(Strgs);
                 Colour(FGreen);
                 SetX('72');
                 Str(ForumHdr[Forum - 1].Reply, Strgs);
                 Print(Strgs);
                 { Checks for new replies since user last login }
                 if ReplyNew(UserInfo.UserLogon, ForumHdr[Forum - 1].fid,0, 0) > 0 then
                  begin
                    Colour(FRed);
                    SetX('77');
                    Print('R');
                  end;
                { Checks for new posts since user last login }
                if PostNew(UserInfo.UserLogon, ForumHdr[Forum - 1].fid,0) > 0 then
                 begin
                   Colour(FRed);
                   SetX('78');
                   Print('N');
                 end;
                 colour(bblack);
               end;
              if Forum <> 1 then dec(Forum);
            end;
         end;
     Until Response = 'Q';
   end
  else
   begin
     ForumDisplay := 0;
   end;
end;
(*..........................................................................*)
{ Select Forum }
procedure ForumSelect(fid : integer);
var
  Select,
  ReadPosts  : boolean;
  ForumLevel : integer;
  results    : recbuf;
  rows       : rowbuf;
begin
   Select := false;
   ReadPosts := false;
   { if fid is already set, then we will assume that the BBS }
   { is using readposts command }
   if fid = 0 then ReadPosts := true;
   repeat
      if fid <> 0 then
       begin
         { Get Forum Data }
         str(fid, qstr);
         querystr := 'select * from forum where fid=' + qstr;
         query := stralloc(length(querystr) + 1);
         strpcopy(query, querystr);
         if sql_query(query) then
          begin
            { are there results from the query }
            results := sql_store_results;
            if results <> Nil then
             begin
               { Get forum details }
               rows := sql_fetch_row(results);
               while (rows <> nil) do
                 begin
                   val(strpas(rows[3]),ForumLevel, CodeData);
                   if ForumLevel <= UserInfo.UserLevel then
                    begin
                      val(strpas(rows[0]),ForumID, CodeData);
                      ForumTitle := strpas(rows[1]);
                      ForumDesc  := strpas(rows[2]);
                      val(strpas(rows[4]),ForumPostLo, CodeData);
                      val(strpas(rows[5]),ForumPostHi, CodeData);
                    end
                   else
                    begin
                      linefeed;
                      print('Sorry you need higher access to read this forum.');
                      linefeed;
                      select := true;
                    end;
                   rows := sql_fetch_row(results);
               end;
               { clear memory }
               sql_free_results(results);
               dispose(query);
               if ReadPosts then
                 begin
                  PostDisplay;
                  fid := ForumDisplay;
                  if fid = 0 then select := true;
                 end
                else Select := true;
             end
            else
             begin
               { no results from the query }
             end
          end
        else
          begin
            { Error Forum does not exist }
            { Display Forums }
            Fid := ForumDisplay;
            if fid = 0 then select := true;
          end;
       end
      else
       begin
         { Display Forums }
         Fid := ForumDisplay;
         if fid = 0 then select := true;
       end;
  until Select = true;
  ReadPosts := false;
end;
(*..........................................................................*)

end.
