{ $Id: filetag.pp,v 1.3 2008-02-26 21:14:18 simon Exp $ }
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   FILETAG.PAS     			                    *)
(*									    *)
(* DESCRIPTION	:   TAG FILES FOR DOWNLOAD                                  *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2008                                *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
(*

  TODO: CLose Tag List

  $Log: filetag.pp,v $
  Revision 1.3  2008-02-26 21:14:18  simon
  Improved file library routines, increased string values for filelist storeage

  Revision 1.2  2008-02-20 16:43:27  simon
  file.lst and file.tag now stored in user home, hostname added for guest accounts
  FIXED: program crash when tag file not found/denied/etc


*)

Unit FileTag;

Interface

{$IFDEF _LINUX_}
  Uses Crt, Dos, Data, Lib, Colours, ErrorLog, baseunix;
{$ELSE}
  Uses Crt, Dos, Data, Lib, Colours, ErrorLog, WaitTix;
{$ENDIF}

procedure DeleteTagFile;
procedure Tag(Number : Integer);
procedure ShowTags;
procedure MakeTagList;

Implementation
(*..........................................................................*)
procedure DeleteTagFile;
Var
  UserTag: String;
begin
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      UserTag := Home_Directory + '/file.tag.' + RemoteHost;
    end
   else
    begin
      UserTag := Home_Directory + '/file.tag'
    end;
  Assign(TagInfo, UserTag);
  //{$I-} Reset(TagInfo); {$I+}
  FileError := IOResult;
  If FileError =  0 then
   begin
     {$I-}
     Erase(TagInfo);
     if IOresult <> 0 then LogError('Error removeing tag list for ' + UserTag + ' - ' + ErrorString(IOResult))
      else LogError('Tag file removed : ' + UserTag);
     {$I+}
   end
  else
   begin
     LogError('Error removeing tag list for ' + UserTag + ' - ' + ErrorString(FileError));
   end;
end;
(*..........................................................................*)
procedure OpenTagFile;
Var
  UserTag,
  DirSeperator : String;
begin
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      UserTag := Home_Directory + '/file.tag.' + RemoteHost;
    end
   else
    begin
      UserTag := Home_Directory + '/file.tag'
    end;
  Assign(TagInfo, UserTag);
  {$I-} Reset(TagInfo); {$I+}
  If IOResult <> 0 then
   begin
     {$I-}
     Rewrite(TagInfo);
     FileError := IOResult;
     If FileError <> 0 Then
      begin
        LogError('Unable To Create User Tag File.: ' + UserTag + ' : ' + ErrorString(FileError));
        { Sends User Error }
        LineFeed;
	Print('Sorry, Unable Tag File At The Moment..');
	Delay(1000);
      end;
   end;
   if FileError = 0 then
     begin
       TagSize := FileSize(TagInfo);
     end;
   {$I+}
end;
(*..........................................................................*)
procedure Tag(Number : Integer);
Var
  FileName : String;
  Step, St : Integer;
  Found    : Boolean;
begin
  OpenTagFile;
  if TagSize >= BBSCfg.MaxTags then
   begin
     LineFeed;
     Print('Sorry you have reached the maximum tag size...');
     LineFeed;
     exit;
   end;
  St := Number;
  LineFeed;
  If Number = -1 then
    begin
      Print('Enter File Number To Tag : ');
      Response := ReadKB(5);
      Val(Response, St, Step);
    end;
  if (St <= FileSize(Files)) and (St >= 0) then
    begin
      {$I-}
        Seek(Files, St);
        Read(Files, FInfo);
      {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
          LogError('Error Reading File List : ' + ErrorString(FileError));
          LineFeed;
          Colour(FYellow);
          Print('Unable To Tag File..');
	  Colour(FWhite);
	  Delay(3000);
          Exit;
        end;
      { Check to see the if the file has been realease for download }
      if (not FInfo.DLAllowed) or (FInfo.Delete) and (UserInfo.UserLevel <> 9)  then
       begin
         LineFeed;
         Print('Sorry you cannot tag this file for download. This file has either');
         LineFeed;
         Print('been recently uploaded and not yet released, or it has been tagged for');
         LineFeed;
         Print('deletion...!');
         LineFeed;
         LineFeed;
         Print('Please send a message to the sysop for info..');
         delay(2000);
         exit;
       end;
      FileName := FInfo.FileName;
      LineFeed;
      Print('TAGGING ' + Filename);
      found := false;
      for St := 0 to FileSize(Files) - 1 do
      begin
      {$I-}
      //if (UserInfo.UserLevel <> 9) then  Seek(Files, St);
        Seek(Files, St);
        Read(Files, FInfo);
      {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
          LogError('Error Reading File List : ' + ErrorString(FileError));
          LineFeed;
          Colour(FYellow);
          Print('Unable To Tag File..');
	  Colour(FWhite);
	  Delay(3000);
          Exit;
        end;
      If Pos(FileName, FInfo.FileName) <> 0 then
      begin
        {Check For Duplicate}
        If TagSize <> 0 then
          begin
           for Step := 0 to TagSize - 1 do
            begin
              {$I-}
                Seek(TagInfo, Step);
                Read(TagInfo, Tags);
              {$I+}
              FileError := IOResult;
              If FileError <> 0 then
                begin
                  LogError('Error Reading User Tag File : ' + ErrorString(FileError));
                  LineFeed;
                  Colour(FYellow);
                  Print('Unable To Tag File..');
		  Colour(FWhite);
		  {$IFDEF _LINUX_}
	  	    Delay(3000);
		  {$ELSE}
                    Wait(30);
		  {$ENDIF}
                  Exit;
              end;
              If (Pos(FileName, Tags.FileName) > 0) and (Tags.Tagged <> 0) then
                begin
                  LineFeed;
		  Print('File Already Tagged..');
		  {$IFDEF _LINUX_}
                    Delay(3000);
        	  {$ELSE}
		    Wait(30);
		  {$ENDIF}
                  Found := True;
                  Exit;
                end
              Else
                begin
                 {$I-}
                    Seek(TagInfo, TagSize);
                    Tags.FileName  := FileName;
                    Tags.Dir       := Areas.Dir;
                    Tags.DirLst    := Areas.FileLst;
                    Tags.Des       := FInfo.Des1;
                    Tags.Tagged    := 1;
                    Tags.Size      := FInfo.Size;
                    Tags.DLTimes   := FInfo.DLTimes;
                    Tags.ULUser    := FInfo.ULUser;
                    Tags.Date      := FInfo.FDate;
                    Tags.RecNumber := St;
                    Write(TagInfo, Tags);
                  {$I+}
                  FileError := IOResult;
                  If FileError <> 0 then
                    begin
                      LogError('Error Writing To Tag File : ' + ErrorString(FileError));
                      LineFeed;
                      Colour(FYellow);
                      Print('Unable To Tag File..');
                      Colour(FWhite);
		      {$IFDEF _LINUX_}
		        Delay(3000);
		      {$ELSE}
		        Wait(30);
		      {$ENDIF}
                      Exit;
                    end;
                  Found := True;
                end;
             end;
          end
       Else
         begin
           If Found Then Exit;
           {$I-}
             Seek(TagInfo, TagSize);
             Tags.FileName  := FileName;
             Tags.Dir       := Areas.Dir;
             Tags.DirLst    := Areas.FileLst;
             Tags.Des       := FInfo.Des1;
             Tags.Tagged    := 1;
             Tags.Size      := FInfo.Size;
             Tags.DLTimes   := FInfo.DLTimes;
             Tags.ULUser    := FInfo.ULUser;
             Tags.Date      := FInfo.FDate;
             Tags.RecNumber := St;
             Write(TagInfo, Tags);
           {$I+}
           FileError := IOResult;
           if FileError <> 0 then
             begin
               LogError('Error Writing To Tag File : ' + ErrorString(FileError));
               LineFeed;
               Colour(FYellow);
               Print('Unable To Tag File..');
	       Colour(FWhite);
	       {$IFDEF _LINUX_}
		 Delay(3000);
	       {$ELSE}
		 Wait(30);
	       {$ENDIF}
               Exit;
             end;
           Found := True;
	  end;
       end;
     end;
     {$I-}
       Close(TagInfo);
     {$I+}
      FileError := IOResult;
    If FileError <> 0 then LogError('Error Closing Tag File : ' + ErrorString(FileError));
    If Not Found then
     begin
       LineFeed;
       Print('*Unable To Locate File..');
       {$IFDEF _LINUX_}
         Delay(3000);
       {$ELSE}
         Wait(30);
       {$ENDIF}
     end;
   end
  Else
   begin
     LineFeed;
     Colour(FYellow);
     Print('Invalid File Number..');
     Colour(FWhite);
     {$IFDEF _LINUX_}
       Delay(3000);
     {$ELSE}
       Wait(30);
     {$ENDIF}
   end;
end;
(*..........................................................................*)
procedure ShowTags;
Var
  Step, Nx : Integer;
  DLTime   : Integer;
  CPS, NOS : Real;
  Strgs    : String;
  ToTalMin : Integer;
  Fart     : Integer;
begin
  OpenTagFile;
  TotalMin := 0;
  Nx       := 4;
  Fart     := 0;
  If TagSize = 0 then
   begin
     Colour(FGreen);
     Print('There Are No Files Tagged..');
     Colour(FWhite);
     {$IFDEF _LINUX_}
       Delay(3000);
     {$ELSE}
       Wait(30);
     {$ENDIF}
   end
  Else
   begin
     ClearDisplay(True);
     { Display Tagged Files }
     For Step := 1 to TagSize  do
       begin
         {$I-}
           Seek(TagInFo, Step - 1);
           Read(TagInfo, Tags);
         {$I+}
         FileError := IOResult;
         if FileError <> 0 then LogError('Error Reading User Tag File : ' + ErrorString(FileError));
      If Tags.Tagged = 1 then
           begin
             Inc(Fart);
             CPS := 0;
             NOS := 0;
             DLTime := 0;
             If Fart = Nx then
               begin
                 LineFeed;
              If UserInfo.UserColour = 1 then
                   begin
                     Colour(FMagenta);
                   end;
                 Print('Press Any Key To Continue..');
                 Response := ReadKB(1);
                 ClearDisplay(True);
                 Nx := Nx + 3;
               end;
          LineFeed;
             Colour(FWhite);
             Print('Filename      : ');
             If UserInfo.UserColour = 1 then
             Colour(FGreen);
             Print(Tags.FileName);
             Colour(FWhite);
             SetX('32');
             Print('UpLoad Date : ');
          Colour(FGreen);
             Print(Tags.Date);
             str(Step, Strgs);
             Colour(FRed);
             SetX('60');
             Print('Tag No : ');
             Colour(FMagenta);
             Print(Strgs);
             LineFeed;
          Colour(FWhite);
             Print('FileSize      : ');
             Colour(FGreen);
             Str(Tags.Size, strgs);
             Print(Strgs);
             LineFeed;
             Colour(FWhite);
             Print('Description   : ');
             Colour(FGreen);
          Print(Tags.Des);
             Colour(FWhite);
             LineFeed;
             If not Local then { Calculate Approximate Download Time }
               begin
                 CPS    := LineBaud DIV 11; { 512Kbs }
                 NOS    := Tags.Size / CPS;
		 DLTime := Trunc(NOS / 60);
               end
          Else
                DLTime := 0;
             TotalMin := TotalMin + DLTime;
             Print('Download Time : ');
             Colour(FGreen);
             if DLTime <= 0 then
              begin
                Print('< 1');
              end
          else
              begin
                Str(DLTime, Strgs);
                Print(Strgs);
             end;
             If UserInfo.UserColour = 1 then
             Colour(FWhite);
             Print(' Minutes Approx');
             LineFeed;
          Print('Uploaded By   : ');
             Colour(FGreen);
             Print(Tags.ULUser);
             LineFeed;
             Colour(FWhite);
             Print('Downloaded    : ');
             Colour(FGreen);
             Str(Tags.DLTimes, Strgs);
             Print(Strgs);
          Colour(FWhite);
             Print(' Times');
             LineFeed;
           end;
       end;
    LineFeed;
    Colour(FGreen);
    Print('Total Tag Files : ');
    Str(Fart, Strgs);
 Colour(FMagenta);
    Print(Strgs);
    Colour(FGreen);
    Print('   Total DownLoad Time : ');
    Str(TotalMin, Strgs);
    Colour(FMagenta);
    Print(Strgs);
    Colour(FGreen);
    Print(' Minutes Approx.');
 LineFeed;
    Colour(FWhite);
    Print('*[C] Clear All Tags / [R] Remove Tagged File / [Enter] Continue : ');
    Response := ReadKB(1);
    If (Response = 'c') or (Response = 'C') then
     begin
       {$I-} Close(TagInfo);
             Erase(TagInfo); {$I+}
       If IOResult <> 0 then
      begin
           LogError('ERROR Deleting User TAG File.. ' + ErrorString(IOResult));
         end
       Else
         begin
           LineFeed;
           Colour(FYellow);
           Print('All Tags Clear..');
	   Colour(FWhite);
{$IFDEF _LINUX_}
	     Delay(3000);
           {$ELSE}
	     Wait(30);
	   {$ENDIF}
           Exit;
         end;
     end;
    If (Response = 'r') or (Response = 'R') then
   begin
        Nx := 0;
        LineFeed;
        Colour(FCyan);
        Print('Enter Tag Number : ');
        Colour(FMagenta);
        Response := ReadKB(3);
        Val(Response, Nx, TotalMin);
        If Nx > TagSize then
       begin
            Colour(FWhite);
            Print('InVaild Tag Number ');
	    Colour(FYellow);
	    {$IFDEF _LINUX_}
	      Delay(3000);
            {$ELSE}
  	      Wait(30);
 	    {$ENDIF}
       end
        Else
          begin
            {$I-} Seek(TagInfo, Nx - 1);
                  Read(TagInfo, Tags);
                  Tags.Tagged := 0;
                  Seek(TagInfo, Nx - 1);
                  Write(TagInfo, Tags); {$I-}
            FileError := IOResult;
         if (FileError <> 0) then
              begin
                LogError('Error Reading User Tag File - ' + ErrorString(FileError));
                LineFeed;
		Print('Unable To Remover Requested File..');
		{$IFDEF _LINUX_}
	          Delay(3000);
                {$ELSE}
	          Wait(30);
         {$ENDIF}
              end
            else
              begin
                Colour(FYellow);
                Print('Tagged File ReMoved');
                Colour(FWhite);
		{$IFDEF _LINUX_}
          	  Delay(3000);
             {$ELSE}
	          Wait(30);
        	{$ENDIF}
              end;
            If Fart = 1 then
              begin
                {$I-}
                  Close(TagInfo);
                  Erase(TagInfo);
             {$I+}
                FileError := IOResult;
                if FileError <> 0 then
                  begin
                    LogError('Unable To Remove User Tag File : ' + ErrorString(FileError));
                  end;
              end;
            Exit;
          end;
   end;
   end;
  Close(TagInfo);
end;
(*..........................................................................*)
procedure MakeTagList;
Var
  Lst          : Text;
  Step,
  DLTime       : Integer;
  CPS,
  NOS          : Real;
  List,
  ListFile,
  DirSerperator : String;
  DownLoadTime  : Integer;
begin
  OpenTagFile;
  DownLoadTime := 0;
  { If a guest then add the hostname to the file name }
  if fpGetUID = GuestUID then
    begin
      ListFile := Home_Directory + '/file.lst.' + RemoteHost;
    end
   else
    begin
      ListFile := Home_Directory + '/file.lst'
 end;
  Assign(Lst, ListFile);
  {$I-} Rewrite(Lst); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Unable To Create Tag List : ' + ListFile);
      LineFeed;
      Print('Unable To Create Tag List..');
   {$IFDEF _LINUX_}
	Delay(3000);
      {$ELSE}
	Wait(30);
      {$ENDIF}
    end
  Else
    begin
      If TagSize <= 0 then
     begin
          Close(Lst);
          Erase(Lst);
          LineFeed;
	  Print('No Tagged Files To Download');
	  {$IFDEF _LINUX_}
	    Delay(3000);
          {$ELSE}
	    Wait(30);
       {$ENDIF}
          Error := 1;  { Exit Command With Error 1 }
          Exit;
        end
      Else
        begin
          For Step := 0 to TagSize - 1 do
             begin
               Seek(TagInfo, Step);
            Read(TagInfo, Tags);
               If Tags.Tagged = 1 then
                 begin
                   List := '';
		   List := Tags.Dir + '/' + Tags.FileName;
                   Print('Preparing: ' + Tags.FileName);
                   LineFeed;
                   Writeln(Lst, List);
                   If not Local then
                  begin
                       CPS    := LineBaud DIV 11;
                       NOS    := Tags.Size / CPS;
		       DLTime := trunc(NOS / 60) + 1;
                     end
                   Else
                     begin
                       DLTime := 0;
                     end;
                DownLoadTime := DownLoadTime + DLTime;
                 end;
             end;
          Close(lst);
          DlFile := '';
          DlFile := '@' + ListFile;
          Error  := 0;
          Tagged := True;
        end;
 end;
  If DownLoadTime > TimeLeft then
    begin
      LineFeed;
      Print('*Total DownLoad Time Exceeds Your OnLine Time');
      LineFeed;
      LineFeed;
      Print('*Press Any Key To Continue');
      Response := ReadKB(1);
   Error := 1;
    end;
end;
end.
