(* ........................................................................ *)
(*        								    *)
(* MODULE	:   FILELIST.PAS    			                    *)
(*									    *)
(* DESCRIPTION	:   DISPLAYS ALL FILES IN THE SELECTED AREA                 *)
(*		                                                            *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.5 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
(* TODO                                                                     *)
(*                                                                          *)
(* Linux - Directory List needs cleaning up                                 *)
(*..........................................................................*)
Unit FileList;

Interface
{$IFDEF _LINUX_}
  Uses Dos, Crt, Strings, Data, Lib, FileTag, Colours, ErrorLog, BaseUnix, Unix;
{$ELSE}
  Uses Crt, Dos, Data, Lib, FileTag, Colours, ErrorLog, WaitTix;
{$ENDIF}

procedure ListFiles;
{$IFDEF _LINUX_ }
 function Display_Directory(FilePAth : string) : integer;
{$ENDIF}
Implementation

{$IFDEF _LINUX_ }
 type
    Directory = record
       Entry,
       Size 	 : longint;
       EntryName : string[30];  { File or Directory Name }
       Directory : boolean;
 end;
{$ENDIF}

//type
//  FileRemove = record;
//    FilePath  : string[255]; { Path and FileName to be removed }
//    FileLst   : string[255]; { File List DB path and name }
//    FileID    : integer;     { File List DB record Number }
//    FileDes   : string[60];  { First Line of Description }
//end;
(*..........................................................................*)
procedure deletetag(ID : integer);
var
 DelDB  : string;
 DBSize : integer;
begin
  if BBSCfg.DataDir[length(BBSCfg.DataDir)] = '/' then DelDB := BBSCfg.DataDir + 'filedelete.dat'
   else DelDB := BBSCfg.DataDir + '/filedelete.dat';
  assign(FileDelDB,DelDB);
  {$I-}
  reset(FileDelDB);
  FileError := IOResult;
  { If the DB does not exists then create it}
  if FileError <> 0 then
   begin
     rewrite(FileDelDB);
     FileError := IOResult;
     if FileError <> 0 then
      begin
        LogError('Unable to create ' + DelDB + ' ' + ErrorString(FileError));
        LineFeed;
        Print('SYSOP: Unable to create filedelete.dat - see log for more info.');
        delay(1500);
        exit;
      end;
   end;
  FileDel.FilePath := Areas.Dir + FInfo.FileName;
  FileDel.FileLst  := Areas.FileLst;
  FileDel.FileID   := ID;
  FIleDel.FileDes  := FInfo.Des1;
  DBSize := FileSize(FileDelDB);
  seek(FileDelDB, DBSize);
  write(FileDelDB,FileDel);
  FileError := IOResult;
  if FileError <> 0 then
   begin
     LogError('Unable to add to ' + DelDB + ' ' + ErrorString(FileError));
     LineFeed;
     Print('SYSOP: Unable to add file into filedelete.dat - see error.log for more info.');
     delay(1500);
   end;
  close(FileDelDB);
  FInfo.Delete := true;
  Seek(Files, ID);
  write(Files, FInfo);
  LineFeed;
  Print('File Tagged For Deletion..');
  LogError('Tagged ' + FileDel.FilePath + ' for deletion..');
  delay(1500);
  {$I+}
end;
(*..........................................................................*)
procedure Header;
begin
  {$IFDEF _LINUX_}
    ClearDisplay(True);
    Print(FileHead1);
    LineFeed;
    Print(FileHead2);
    LineFeed;
    Print(FileHead3);
    LineFeed;
  {$ELSE}
    ClearDisplay(True);
    Print(FileHead1);
    LineFeed;
    Print(FileHead2);
    LineFeed;
    Print(FileHead3);
    LineFeed;
  {$ENDIF}
end;
(*..........................................................................*)
procedure DirectoryListHeader;
begin
    ClearDisplay(True);
    Print(DFileHead1);
    LineFeed;
    Print(DFileHead2);
    LineFeed;
    Print(DFileHead3);
    LineFeed;
end;
(*..........................................................................*)
procedure View;
Var
 DLTime,
 Num,
 Code     : integer;
 Strgs    : String;
 CPS, NOS : Real;
begin
  LineFeed;
  Print(ViewFile);
  Response := ReadKB(5);
  LineFeed;
  Val(Response, Num, Code);
  If (Num < 0) or (Num > FileSize(Files)) then
    begin
    end
  else
    begin
      Header;
      Seek(Files, Num);
      Read(Files, FInfo);
      Colour(FRed);
      SetX('2');
      Str(Num, Strgs);
      Print(Strgs);
      Colour(FGreen);
      SetX('8');
      Print(FInfo.FileName);
      Colour(FYellow);
      SetX('36');
      Str(FInfo.Size, Strgs);
      Print(Strgs);
      SetX('51');
      Print(FInfo.FDate);
      Str(FInfo.DLTimes, Strgs);
      Colour(FBlue);
      SetX('73');
      Print(Strgs);
      LineFeed;
      LineFeed;
      Colour(FWhite);
      SetX('7');
      Print(FInfo.Des1);
      LineFeed;
      SetX('7');
      Print(FInfo.Des2);
      LineFeed;
      SetX('7');
      Print(FInfo.Des3);
      LineFeed;
      SetX('7');
      Print(FInfo.Des4);
      LineFeed;
      SetX('7');
      Print(FInfo.Des5);
      LineFeed;
      SetX('7');
      Print(FInfo.Des6);
      LineFeed;
      SetX('7');
      Print(FInfo.Des7);
      LineFeed;
      SetX('7');
      Print(FInfo.Des8);
      LineFeed;
      SetX('7');
      Print(FInfo.Des9);
      LineFeed;
      SetX('7');
      Print(FInfo.Des10);
      LineFeed;
      SetX('7');
      Print(FInfo.Des11);
      LineFeed;
      SetX('7');
      Print(FInfo.Des12);
      LineFeed;
      SetX('7');
      Print(FInfo.Des13);
      LineFeed;
      SetX('7');
      Print(FInfo.Des14);
      LineFeed;
      SetX('7');
      Print(FInfo.Des15);
      LineFeed;
      Print(UpLoadBy);
      Colour(FGreen);
      Print(' ' + FInfo.ULUser + ' ');
      Print(DownTime + ' ');
      Colour(FBlue);
(*
      If not Local then { Calculate Approximate Download Time }
        begin
*)
          CPS    := LineBaud DIV 11;
          NOS    := FInfo.Size / CPS;
          DLTime := Trunc(NOS / 60);
(*
         end
       Else
         DLTime := 0;
*)
      Str(DlTime, Strgs);
      Print(Strgs);
      Print(' ' + DownMinutes);
      if (not FInfo.DLAllowed) or (FInfo.Delete) then
       begin
        Colour(FRed);
        Print(' (Download unavailable)');
        { Ask sysop if they want to release the file }
        if (UserInfo.Userlevel = 9) and (not FInfo.Delete) then
         begin
           Linefeed;
           LineFeed;
           Print('Sysop, would you like to release this file for download? (Y/N) : ');
           Response := ReadKB(1);
           if (Response = 'y') or (Response = 'Y') then
            begin
              FInfo.DLAllowed := true;
              {$I-}
               Seek(Files, Num);
               write(Files, FInfo);
              {$I+}
              FileError := IOResult;
              if FileError <> 0 then
               begin
                 LogError('Unable to release file for download ' + FInfo.FileName + ' ' + ErrorString(FileError));
                 Linefeed;
                 Print('Unable to release file for download ' + FInfo.FileName + ' ' + ErrorString(FileError));
                 Linefeed;
                 Linefeed;
               end
              else
                begin
                  LineFeed;
                  Print('*File released for download..');
                  LineFeed;
                 Linefeed;
                end;
              HoldPage;
            end;
         end;
       end;
      LineFeed;
      LineFeed;
      Print(VFilePrompt1);
      if (UserInfo.UserLevel = 9) and (not FInfo.Delete) then
       begin
         Colour(FRed);
         Print(' [D]elete');
       end;
      LineFeed;
      Print(VFilePrompt2);
      Response := ReadKB(30);
      If Response = VTagFile then Tag(Num);
      if (Response = 'D') and (UserInfo.UserLevel = 9) and ( not FInfo.Delete) then DeleteTag(Num);
      LineFeed;
    end;
end;
(*..........................................................................*)
procedure ListFiles;
  Label Relist, Stops;
Var
  Counter  : Integer;
  Counts   : String;
  FSize    : LongInt;
  Step     : Integer;
  DirInfo  : SearchRec;
  FileName,
  Strgs    : String;
  NoDown   : boolean;
begin
  NoUpper := False;
  ReList:
  NoDown := false;
  Assign(Files, Areas.FileLst);
  {$I-} Reset(Files); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Error Opening' + Areas.FileLst + ' - ' + ErrorString(FileError));
      Print(' Sorry Unable To Locate File List - Error Has Been Logged');
      LineFeed;
      {$IFDEF _LINUX_}
	Delay(3000);
      {$ELSE}
	Wait(30);
      {$ENDIF}
      Close(Files);
      Exit;
   end
  Else
    begin
      Header;
      FSize := FileSize(Files);
      If UserInfo.UserAnsi = 1 then
        begin
          Counter := 2;
        end
      Else
        begin
          Counter := 0;
        end;
      Step := 0;
      Repeat
          {$I-}
           Seek(Files, Step);
           Read(Files, FInfo);
          {$I+}
          FileError := IOResult;
          If FileError <> 0 then
           begin
             LogError('Seek Error Reading ' + Areas.FileLst + ' - ' + ErrorString(FileError));
             Close(Files);
             Exit;
           end;
          Inc(Counter);
          Colour(FRed);
          SetX('3');
          Str(Step, Strgs);
          Print(Strgs);
          Colour(FGreen);
          SetX('8');
          Print(FInfo.FileName);
          Colour(FYellow);
          SetX('36');
          Str(FInfo.Size, Counts);
          Print(Counts);
          SetX('51');
          Print(FInfo.FDate);
          Str(FInfo.DLTimes, Strgs);
          Colour(FBlue);
          SetX('73');
          Print(Strgs);
          if (not FInfo.DLAllowed) or (FInfo.Delete) then
            begin
             SetX('75');
             Colour(FRed);
             Print('*');
             NoDown := true;
            end;
          LineFeed;
          Colour(FWhite);
          SetX('7');
          Print(FInfo.Des1);
          LineFeed;
            If Counter = 11 then
              begin
                Repeat
                  if NoDown then
                   begin
                     LineFeed;
                     Print('(*) Download unavailable');
                   end;
                  LineFeed;
                  Print(LFilePrompt1);
                  LineFeed;
                  Print(LFilePrompt2);
                  NoUpper := False;
                  Response := ReadKB(30);
                  If Response = TagFile then
                    begin
                      Tag(-1);
                    end;
                  If Response = FileListStop then goto Stops;
                  If Response = FileView then
                    begin
                      View;
                      Step := Step - 10;
                    end;
                Until Response = '';
                Header;
                Counter := 2;
              end;
           Inc(Step);
        Until Step = FSize;
      end;
  Repeat
    if NoDown then
     begin
       LineFeed;
       Colour(FRed);
       Print('(*) Download unavailable');
     end;
    LineFeed;
    Print(LFilePrompt1);
    LineFeed;
    Print(LFilePrompt2);
    NoUpper := False;
    Response := ReadKB(30);
    If Response = TagFile then
     begin
       Tag(-1);
     end;
    If Response = FileView then View;
    If Response = FileRelist then
      begin
        Close(Files);
        Goto Relist;
     end;
  Until Response = '';
  Stops:
  Close(Files);
end;
(*..........................................................................*)
{$IFDEF _LINUX_ }
{ Returns TRUE if successful }
function Read_Directory(FilePath : string) : boolean;
var
   LDir     :  Directory;
   FDir	    :  file of Directory;
   TheDir   : PDir;
   ADirent  : PDirent;
   Entry    : Longint;
   Strgs    : string;
   Dire     : string;
   FileInfo : Stat;
   Success  : integer;
begin
  assign(FDir, UserInfo.UserName + '.filelist.data.tmp');
  {$I-}
    rewrite(FDir);
  {$I+}
  FileError := IOResult;
  if  fpchmod(UserInfo.UserName + '.filelist.data.tmp', &777) = 0 then
    begin
      { Not working for ARM }
      {FileError := LinuxError;}
    end;
   if FileError <> 0 then
    begin
      writeln('Error : ',ErrorString(FileError),'=', filepath);
      delay(3000);
      Read_Directory := False;
    end
   else
    begin
      Dire := StrAlloc(Length(FilePath) + 1);
      {if StrPCopy(Dire, FilePath) <> Dire then exit;}
      TheDir := fpOpenDir(FilePath);
      Repeat
        {Entry := fpTellDir(TheDir);}
        ADirent := fpReadDir(TheDir^);
        If ADirent <> Nil then
        With ADirent^ do
          begin
            if (strpas(pchar(@d_name[0])) <> '.') and (strpas(pchar(@d_name[0])) <> 'directory.info') then
             begin
               LDir.Entry     :=  Entry;
               LDir.EntryName := StrPas(pchar(@d_name[0]));
               fpStat (FilePath + LDir.EntryName, FileInfo);
               if fpS_ISDIR(FileInfo.Mode) then LDir.Directory := True
                else LDir.Directory := False;
               LDir.Size := FileInfo.Size;
              {$I-}
                write(FDir, LDir);
              {$I+}
              if IOResult <> 0 then Read_Directory := False
               else Read_Directory := True;
            end;
          end;
      Until ADirent = Nil;
      close(FDir);
    end;
    fpCloseDir(TheDir^);
end;
(*..........................................................................*)
function Nav_Directory(filepath : string) : string;
   Label Relist, Stops;
var
  LDir     :  Directory;
  FDir     :  file of Directory;
  Counter  : Integer;
  Counts   : String;
  FSize    : LongInt;
  Step     : Integer;
  DirInfo  : SearchRec;
  FileName,
  Strgs,
  InfoFile,
  DirText,
  CurrentDirectory : String;
  CYPos    : integer;
  DirNameInfo  : text;
begin
  if FilePath[length(filepath)] = '/' then InfoFile := FilePath + 'directory.info'
   else InfoFile := FilePath + '/directory.info';
  assign(DirNameInfo,InfoFile);
  {$I-}
  reset(DirNameInfo);
  if IOResult = 0 then
   begin
     read(DirNameInfo,DirText);
     close(DirNameInfo);
   end
  else
   begin
     DirText := 'No directory.info file found..!';
   end;
  {$I+}
  CurrentDirectory := FilePath;
  if not Read_Directory(FilePath) then
   begin
     LineFeed;
     Print('Unable To Read Directory...');
     LineFeed;
     LogError('Unable To Read : ' + FilePath);
     Delay(3000);
   end
  else
   begin
     ReList:
     NoUpper := False;
     Assign(FDir, UserInfo.UserName + '.filelist.data.tmp');
     {$I-} Reset(FDir); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
         LogError('Error Opening filelist.data.tmp - ' + ErrorString(FileError));
         Print(' Sorry Unable Read Directory - Error Has Been Logged');
         LineFeed;
	 Delay(3000);
         Close(Files);
         Exit;
       end
      Else
       begin
         DirectoryListHeader;
         LineFeed;
         {
         Colour(FWhite);
         Print('Area : ');
         Colour(FYellow);
         Print(DirText);
	 LineFeed;
         }
         FSize := FileSize(FDir);
         If UserInfo.UserAnsi = 1 then
           begin
             Counter := 2;
           end
         Else
           begin
             Counter := 0;
           end;
         Step  := 1;
         CYPos := 5;
//         SetY('7');
         Repeat
          {$I-}
           Seek(FDir, Step);
           Read(FDir, LDir);
          {$I+}
          FileError := IOResult;
          If FileError <> 0 then
           begin
             LogError('Seek Error Reading filelist.data.tmp - ' + ErrorString(FileError));
             Close(FDir);
             Exit;
           end;
          Inc(Counter);
          Colour(FRed);
          SetX('3');
          Str(Step, Strgs);
          Print(Strgs);
          Colour(FGreen);
          SetX('8');
          if LDir.Directory then
            begin
              Colour(FGreen);
              Print('/');
            end
          else
            begin
              Colour(FCyan);
            end;
          Print(LDir.EntryName);
          Colour(FYellow);
          SetX('41');
          Counts := '';
          Str(LDir.Size, Counts);
          Print(Counts);
          SetX('61');
          Colour(FWhite);
          if LDir.Directory then Print('Directory')
           else Print('File');
          LineFeed;
           If Counter = 18 then
              begin
                Repeat
                  Str(CYPos, Strgs);
                  SetX('2');
                  SetY(Strgs);
                  Print('>');
                  SetY('22');

                  LineFeed;
                  Colour(FYellow);
                  Print('Archive : ');
                  Colour(FGreen);
                  Print(DirText);
                  {
                  LineFeed;
                  Print(DLFilePrompt2);
                  }
                  NoUpper := False;
                  echo := false;
                  Response := ReadKB(1);
                  echo := true;
                  if Response = #62   then
                    begin
                      if CYPos < (Counter + 2) then
                        begin
                          Str(CYPos, Strgs);
                          SetX('2');
                          SetY(Strgs);
                          Print(' ');
                          inc (CYPos);
                          Str(CYPos, Strgs);
                          SetX('2');
                          SetY(Strgs);
                          Print('>');
                        end;
                    end;
                  if Response = #60 then
                    begin
                      if CYPos > 5 then
                        begin
                          Str(CYPos, Strgs);
                          SetX('2');
                          SetY(Strgs);
                          Print(' ');
                          dec (CYPos);
                          Str(CYPos, Strgs);
                          SetX('2');
                          SetY(Strgs);
                          Print('>');
                        end;
                    end;
                  if Response = DAction then
                    begin
                      {$I-}
                        Seek(FDir, ((Step - 18) + (CYPos - 3)) + 1);
                        Read(FDir, LDir);
                      {$I+}
                      if LDir.Directory then
                        begin
                          Nav_Directory := LDir.EntryName;
                          goto Stops;
                        end
                      else
                        begin
                          Linefeed;
                          print(LDir.EntryName);
                          LineFeed;
                          Print(ActionPrompt1);
                          LineFeed;
                          Print(ActionPrompt2);
                          NoUpper  := False;
                          Response := ReadKB(1);
                          if Response = DDownload then
                            begin
                              Nav_Directory := '@';
                              DLFile := CurrentDirectory + LDir.EntryNAme;
                              goto stops; { Yuk .. }
                            end
                          else
                            if Response = DFileView then
                              begin
                                 Response :=  CurrentDirectory + LDir.EntryName;
                                 Exec(file_viewer, Response);
                              end;
                          goto Relist;
                        end;
                    end;
                  if Response = DStop then
                    begin
                      Nav_Directory := '*';
                      goto Stops;
                    end;
                  if Response = FileView then
                    begin
                      Writeln('FileView 1');
                      Step := Step - 10;
                    end;
                Until Response = DNext;
                DirectoryListHeader;
                LineFeed;
                CYPos := 5;
                {
                Colour(FWhite);
                Print(' Area : ');
                Colour(FYellow);
                Print(DirText);
                LineFeed;
                }
                Counter := 2;
              end;
           Inc(Step);
        Until Step = FSize;
      end;
    CYPos := 5;
    Repeat
      Str(CYPos, Strgs);
      SetX('2');
      SetY(Strgs);
      Print('>');
      SetY('22');
      {
      LineFeed;
      Print(DLFilePrompt1);
      LineFeed;
      Print(DLFilePrompt2);
      }
      LineFeed;
      Colour(FYellow);
      Print('Archive : ');
      Colour(FGreen);
      Print(DirText);

      echo := false;
      NoUpper := False;
      Response := ReadKB(1);
      echo := true;
      if Response = #62 then
       begin
         if CYPos < (Counter + 2) then
          begin
            Str(CYPos, Strgs);
            SetX('2');
            SetY(Strgs);
            Print(' ');
            inc (CYPos);
            Str(CYPos, Strgs);
            SetX('2');
            SetY(Strgs);
            Print('>');
          end;
        end;
        if Response = #60 then
          begin
            if CYPos > 5 then
              begin
                Str(CYPos, Strgs);
                SetX('2');
                SetY(Strgs);
                Print(' ');
                dec (CYPos);
                Str(CYPos, Strgs);
                SetX('2');
                SetY(Strgs);
                Print('>');
              end;
           end;
           if Response = DAction then
             begin
               if Step < 18 then Counter := CYPos - 4
                 else Counter := Step - (CYPos - 5);
               {$I-}
                Seek(FDir, Counter);
                Read(FDir, LDir);
               {$I+}
                if LDir.Directory then
                  begin
                    Nav_Directory := LDir.EntryName;
                    goto Stops;
                  end
                else
                  begin
                    Linefeed;
                    print(LDir.EntryName);
                    LineFeed;
                    Print(ActionPrompt1);
                    LineFeed;
                    Print(ActionPrompt2);
                    NoUpper  := False;
                    Response := ReadKB(30);
                    if Response = DDownload then
                      begin
                        Nav_Directory := '@';
                        DLFile := CurrentDirectory + LDir.EntryNAme;
                        goto stops; { Yuk .. }
                       end
                     else
                       if Response = DFileView then
                         begin
                           Response :=  CurrentDirectory + LDir.EntryName;
                           Writeln('File = ', Response);
                           Exec(file_viewer, Response);
                         end;
                        goto Relist;
                  end;
                end;
                if Response = DContinue then
                 begin
                   Nav_Directory := '*';
                   goto Stops;
                  end;
                if Response = FileView then
                  begin
                    Writeln('FileView');
                    Step := Step - 10;
                  end;
    Until Response = DStop;
    //Nav_Directory := '..';
    Nav_Directory := '*';
    Stops:
    Close(FDir)
   end;
  LineFeed;
end;
(*..........................................................................*)
function Display_Directory(FilePath : string) : integer;
var
  New_Directory,
  Directory      : string;
  Dir_No	 : byte;
  Dir_Tree 	 : array[1..30] of string[80];
begin
  Display_Directory := 0;
  Dir_No := 1;
  Directory := FilePath;
  If Directory[length(Directory)] <> '/' then Directory := Directory + '/';
  Dir_Tree[Dir_No] := Directory;
  repeat
   New_Directory := Nav_Directory(Directory);
   if (New_Directory <> '*') or (New_Directory <> '@') then
     begin
       if New_Directory = '..' then
         begin
           if Dir_No <> 1 then dec(Dir_No);
           Directory := Dir_Tree[Dir_No];
         end
       else
         begin
           if  Directory[length(Directory)] = '/' then
             begin
               Directory := Directory + New_Directory + '/';
             end
           Else
             begin
               Directory := Directory + '/' + New_Directory + '/';
             end;
           if fpAccess(Directory, R_OK) = 1 then { Has The User Access Rights }
             begin
               inc(Dir_No);
               Dir_Tree[Dir_No] := Directory;
             end
           else
            begin
              Directory := Dir_Tree[Dir_No];
            end;
       end;
     end;
   if New_Directory = '@' then
     begin
       Display_Directory := 1; { DownLoad }
       New_Directory := '*';
     end;
  until New_Directory = '*';
end;
{$ENDIF}
(*..........................................................................*)
end.
