(* ........................................................................ *)
(*        								    *)
(* MODULE	:   EDITOR.PAS      			                    *)
(*									    *)
(* DESCRIPTION	:   MAIL & MESSAGE EDITOR                                   *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 1998 & ALEX HENRIKSEN 1997 - 1998   *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.dos                                                              *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Editor;

interface

{$Linklib c}

{$IFDEF _LINUX_}
  Uses Crt,linux, Dos, Lib, Data, Dates, Msgs, ErrorLog, Colours, Unix,  BaseUnix;
{$ELSE}
  Uses Crt, Dos, Lib, Data, Dates, Msgs, ErrorLog, PIBAsync, CDrop, Colours,
       WaitTix;
{$ENDIF}

procedure EditMail;
procedure ListMail;
procedure TextEditStart(Flag : Boolean; User, Subject : String);
procedure ReadEMail(MSG : String);
procedure ReadMessage;
procedure SelectMessageArea(Area : Word);
//fnction CountMail : byte;
{$IFDEF _LINUX_}
  function InternetMail : byte;
{$ENDIF}

implementation

function getpwuid(ID : integer) : TUserPasswd ; cdecl; external;

Var
   Line       : array [1..100] of string[70];
   Show,
   All,
   Exits,
   EndEditor,
   EMail      : Boolean;
   MailCount,
   Max,
   Hello,
   Num         : Integer;
   MailPath,
   MailTo,                  { Send Mail To   }
   MailFrom,                { Mail Sent From }
   CurrentUser,
   CurrentArea,
   DirSeperator,
   Wildcard,
   SUID        : String;
   DirInfo     : SearchRec;
(*..........................................................................*)
{$IFDEF _LINUX_}
function InternetMail : byte;
var
   MailPath : string;
   FileInfo : stat;
begin
 MailPath := GetEnv('MAIL');
 if fpStat(MailPath, FileInfo) = 0 then
  begin
    InternetMail := 0;
  end
 else
  begin
    if FileInfo.Size <> 0 then InternetMail := 1
      else InternetMail := 0;
  end;
end;
{$ENDIF}
(*..........................................................................*)
procedure Header;
begin
  ClearDisplay(True);
  LineFeed;
end;
(*..........................................................................*)
procedure MailListHeader;
begin
  ClearDispLay(True);
  Colour(FWhite);
  Print('                                                        [Q] Quit [ENTER] View  ');
  LineFeed;
  Colour(FCyan);
  Print('___');
  Colour(FWhite);
  Colour(BCyan);
  Print(' Mail Messages ');
  Colour(FCyan);
  Colour(BBLack);
  Print('_____________________________________________________________');
  LineFeed;
  Colour(FYellow);
  Print(' ID  From           Subject                      Date                          ');
  LineFeed;
end;
(*..........................................................................*)
procedure ListMail;
label relist;
var
  files	   : text;
  Line,
  Strgs    : string;
  Step,
  MailNo,
  Mail,
  Mail1,
  Counter,
  Loop,
  CYPos,
  CYPos1,
  MailNoID : integer;
  MailID   : array[1..500] of string;
  DisplayPrompt : boolean;
begin
  DisplayPrompt := false;
  DirSeperator := '/';
  Wildcard     := '*';
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
    begin
      MailPath := BBSCfg.BBSMailDir;
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + DirSeperator;
    end;
  relist:
  Step    := 0;
  Mail	  := 1;
  Mail1   := 0;
  MailNo  := 0;
  Counter := 1;
  Loop    := 1;
  str(UserInfo.UserUID, SUID);
  FindFirst(MailPath + SUID + WildCard , Archive, DirInfo);
  while DosError = 0 do
   begin
     inc(MailNo);
     MailID[MailNo] := DirInfo.Name;
     FindNext(DirInfo);
   end;
   if MailNo = 0 then
    begin
      LineFeed;
      Print('MailBox Empty..');
      delay(1500);
      exit;
    end;
   MailListHeader;
   while Loop <= MailNo do
    begin
      Assign(Files, MailPath + MailID[Loop]);
      {I$-} Reset(Files);
      FileError := IOResult;
      {$I+}
      If FileError <> 0 then
       begin
         { Error Message }
         LogError('Unable To Access ' + MailPath + DirInfo.Name + ' - ' + ErrorString(FileError));
       end
      Else
       Begin
	 While not Eof(Files) do
           begin
             Readln(Files, Line);
             if (Step <= 4) and (Step >=1) then
              begin
                 case Step of
                   1: begin
		        SetX('1');
			Colour(FGreen);
		        Str(Loop, Strgs);
			Print(Strgs);
                        SetX('48');
                        Strgs := Copy(Line, 10, 30);
                        Print(Strgs);
			{MailID[MailNo] := DirInfo.Name;}
			inc(Loop);
			inc(Counter);
                       end;
                   2: begin
                        SetX('4');
			Colour(FMagenta);
                        Strgs := Copy(Line, 10, 30);
                        Print(Strgs);
                       end;
		   3: begin
                        SetX('19');
			Colour(FWhite);
                        Strgs := Copy(Line, 10, 30);
                        Print(Strgs);
                       end;
                 end;
              end;
             inc(Step);
          end;
         Close(Files);
       end;
      LineFeed;
      Step   := 0;
      CYPos  := 4;
      CYPos1 := 3;
      if (Counter = 10) or ((Loop - 1) = MailNo) then
       begin
         Repeat
	   if Counter < 10 then DisplayPrompt := true;
          (*
	   LineFeed;
	   Colour(FYellow);
	   Print('Mails : ');
	   Str((Loop - 1), Strgs);
	   Print(Strgs);
	   Colour(FYellow);
	   Print(' of ');
	   Str(MailNo, Strgs);
	   Colour(FGreen);
	   Print(Strgs);
           *)
           if CYPos1 >= 4 then
            begin
	      Colour(FGreen);
              Str((CYPos1), strgs);
              SetY(Strgs);
              SetX('0');
              Str(Mail1, Strgs);
              Print(' ' + Strgs + '  ');
            end;
	   Colour(FWhite);
           Str(CYPos, strgs);
           SetY(Strgs);
           SetX('0');
           Str(Mail, Strgs);
           //Colour(BGreen);
           Print('>' + Strgs + '  ');
           //Colour(BBlack);
	   NoUpper := False;
           Response := ReadKB(1);
	   if Response = 'E' then exit;
	   if (Response = chr(62)) and (Mail < MailNo)  then
            begin
              inc(Mail);
              inc(CYPos);
              CYPos1 := CYPos - 1;
              Mail1 := Mail - 1;
            end;
	   if (Response = chr(60)) and (Mail > 1)  then
            begin
              dec(Mail);
              dec(CYPos);
              CYPos1 := CYPos + 1;
              Mail1 := Mail + 1;
            end;
           if (Response = '') and (Response <> chr(62)) and (Response <> Chr(60)) then
	     begin
	       //val(Response, MailNoID, CodeData);
               MailNoID := Mail;
	       if (MailNoID >=1) and (MailNoID <= MailNo) then
	        begin
		  dec(loop);
		  ReadEMail(MailID[MailNoID]);
		  Counter := 1;
		  if (Loop > 1) and (not DisplayPrompt) then Loop := Loop - 1;
           	  if Loop < 11 then Loop := 1;
		  { Reload mail messages incase a msg has been deleted}
		  MailNo := 0;
		  str(UserInfo.UserUID, SUID);
		  FindFirst(MailPath + SUID + WildCard , Archive, DirInfo);
		  while DosError = 0 do
   		   begin
		     inc(MailNo);
      	             MailID[MailNo] := DirInfo.Name;
                     FindNext(DirInfo);
                   end;
		   Response := '';
		   if MailNo = 0 then
		    begin
		      LineFeed;
		      Print('Mailbox empty...');
		      delay(2000);
		      exit;
		    end;
		  goto relist;
		end
             else
	        begin
		  Linefeed;
		  Print('Invalid Mail ID..');
		  Delay(2000);
		  LineFeed;
		end;
	     end;
         Until Response = 'Q';
	 Counter := 1;
	 ClearDispLay(True);
	 Str(MailNo, Strgs);
  	 if Loop <= MailNo then MailListHeader;
       end;
    end;
end;
(*..........................................................................*)
procedure EditLine;
Label ExitProc;
Var
  LNum,
  LCode   : Integer;
begin
  LineFeed;
  Print('*Enter Line Number To Edit : ');
  Response := ReadKb(1);
  {$IFDEF _LINUX_}
  {$ELSE}
    If (Not Local) and (Async_Carrier_Drop) then
          begin
            NoCarrier;
            Goto ExitProc;
	  end;
  {$ENDIF}
  Val(Response, LNum, LCode);
  If LNum > Num then
    begin
      LineFeed;
      Print(' InVaild Line Number');
      {$IFDEF _LINUX_}
	Delay(3000);
      {$ELSE}
	Wait(30);
      {$ENDIF}
    end
  Else
    begin
      Header;
      LineFeed;
      Print(' Old Line : ');
      Print(Line[LNum]);
      LineFeed;
      Print(' New Line : ');
      Response := ReadKB(65);
      {$IFDEF _LINUX_}
      {$ELSE}
        If (Not Local) and (Async_Carrier_Drop) then
          begin
            NoCarrier;
            Goto ExitProc;
	  end;
      {$ENDIF}
        Line[LNum] := Response;
      {$IFDEF _LINUX_}
      {$ELSE}
        If (Not Local) and (Async_Carrier_Drop) then
          begin
            NoCarrier;
            EndEditor := True;
	  end;
      {$ENDIF}
    end;
  ExitProc:
end;
(*..........................................................................*)
procedure ReadEMail(MSG : string);
Label ExitProc;
Var
  Files     : Text;
  Step,
  Count     : Integer;
  Line,
  Strgs,
  Subject,
  ReplyMail : string;
  ReadMails : Boolean;
begin
  {$IFDEF _LINUX_}
     DirSeperator := '/';
     Wildcard	  := '*';
  {$ELSE}
     DirSeperator := '\';
     Wildcard	  := '*.*';
  {$ENDIF}
  Subject := '';
  str(UserInfo.UserUID, SUID);
  Case Length(SUID) of
     1 : MailTo := '000' + SUID;
     2 : MailTo := '00' + SUID;
     3 : MailTo := '0' + SUID;
   Else
     MailTo := SUID;
  end; { Case End }
  { Check For Existing Mail }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
    begin
      MailPath := BBSCfg.BBSMailDir;
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + DirSeperator;
    end;
  if MSG <> '' then FindFirst(MailPath + MSG , Archive, DirInfo)
   else FindFirst(MailPath + MailTo + WildCard , Archive, DirInfo);
  While DosError = 0 do
    begin
      ClearDispLay(True);
      ReplyMail := DirInfo.Name;
      Assign(Files, MailPath + DirInfo.Name);
      {I$-} Reset(Files); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
       begin
         { Error Message }
         LogError('Unable To Access ' + MailPath + DirInfo.Name + ' - ' + ErrorString(FileError));
       end
      Else
       Begin
         Print(RMailPrompt1);
         LineFeed;
         Print(RMailPrompt2);
         LineFeed;
         Step := 1;
         Colour(FYellow);
         While not Eof(Files) do
           begin
             Readln(Files, Line);
	     if Step = 4 then
	      begin
		Strgs := Copy(Line, 11, 30);
		Subject := Strgs;
	      end;
             If (Step = 5) then Colour(FWhite);
             Inc(Step);
             Print(Line);
             LineFeed;
             if Step = UserInfo.UserLines then
               begin
                 Step := 1;
                 HoldPage;
               end;
	     {$IFDEF _LINUX_}
             {$ELSE}
	        If (Not Local) and (Async_Carrier_Drop) then
                 begin
                    NoCarrier;
                    Goto ExitProc;
		 end;
	     {$ENDIF}
           end;
         Close(Files);
         NoUpper := False;
         Echo := false;
       Repeat
         Echo := false;
	 Response := ReadKB(1);
         Echo := True;
	 {$IFDEF _LINUX_}
	 {$ELSE}
            If (Not Local) and (Async_Carrier_Drop) then
              begin
                 NoCarrier;
                 Goto ExitProc;
	       end;
         {$ENDIF}
         If Response = MailDelete then
           begin
             Erase(Files);
             LineFeed;
             Print(MailDeleted);
	     {$IFDEF _LINUX_}
	       Delay(1500);
  	     {$ELSE}
	       Wait(30);
             {$ENDIF}
             Response := 'Q';
           end;
         If Response = MailRead then ReadMails := False;
         If Response = MailReply then
           begin
             { Reply To EMail }
             Step := 1;
             {Strgs := Copy(ReplyMail, 5, 4); }
             ReplyMail := Copy(ReplyMail, 5, 4);
            { for Count := 1 to 4 do
               begin
                 if Strgs[Count] = '0' then inc(Step);
               end;
             ReplyMail := Copy(Strgs, Step, (10 - (Step + 1)));
            }
             Header;
             TextEditStart(True, ReplyMail, Subject);
             Response := 'Q';
           end;
      Until Response = 'Q';
       end;
      FindNext(DirInfo);
    end;
  Colour(FWhite);
  LineFeed;
  ExitProc:
end;
(*..........................................................................*)
procedure EmailUser(User, Subject : string);
Var
  Step,
  StartUID     : Integer;
  Found        : Boolean;
  MailPath     : string;
  User_Data : TUserPasswd;
begin
  StartUID := 2001; { Include in linux.ini }
  str(UserInfo.UserUID, SUID);
  Case Length(SUID) of
     1 : MailFrom := '000' + SUID;
     2 : MailFrom := '00' + SUID;
     3 : MailFrom := '0' + SUID;
   Else
     MailFrom := SUID;
  end; { Case End }
  CurrentUser := SUID;
  Found       := False;
  Exits       := False;
  MailCount   := 0;
  Colour(FGreen);
  Print(' From    : ');
  Colour(FWhite);
  Print(UserInfo.UserName);
  Colour(FGreen);
  Line[26] := 'From    : ' + UserInfo.UserName;
  if User <> '0' then
    begin
      Colour(FWhite);
      Response := User;
      Colour(FGreen);
    end
  else
    begin  { If No User Number Then Ask For User ID }
      LineFeed;
      Print(' To      : ');
      Colour(FWhite);
      NoUpper := False;
      Response := ReadKB(30);
      NoUpper := True;
      Colour(Green);
   end;
  If Response = 'ALL' then All := True
   Else
     begin
       {CurrentUser := UserInfo.UserUID;}
        repeat
          User_Data := getpwuid(StartUID);
	  if User_Data <> NIL then
           begin
	     str(StartUID, SUID);
             if (lowercase(Response) = User_Data^.pw_name) or (Response = SUID) then
                begin
                  Response  := User_Data^.pw_name;
                  Case Length(SUID) of
                       1 : MailTo := '000' + SUID;
                       2 : MailTo := '00' + SUID;
                       3 : MailTo := '0' + SUID;
                       4 : MailTo := SUID;
                  end; { Case }
                  { Check For Existing Mail }
	          DirSeperator := '/';
	          WildCard     := '*';
	          If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
                    begin
                      MailPath := BBSCfg.BBSMailDir + MailTo + WildCard;
                    end
                  Else
                    begin
		      MailPath := BBSCfg.BBSMailDir + DirSeperator + MailTo + WildCard;
                    end;
                  FindFirst(MailPath, Archive, DirInfo);
                  While DosError = 0 do
                   begin
                     Inc(MailCount);
                     FindNext(DirInfo);
                   end;
                  Found := True;
               end;
            end;
            inc(StartUID);
         until getpwuid(StartUid) = NIL;
     end;

  {Val(CurrentUser, Step, Hello);
  Seek(DataFile, Step);
  Read(DataFile, UserInfo);}

  If Found = False then
    begin
      LineFeed;
      LineFeed;
      Print(MailUserError);
      {$IFDEF _LINUX_}
	Delay(3000);
      {$ELSE}
	Wait(30);
      {$ENDIF}
      NoUpper := False;
      Exits := True;
    end
  Else
    begin
      LineFeed;
      LineFeed;
      Print(' Sending Mail To ');
      Colour(FWhite);
      Print(Response);
      Line[28] := Response;
      LineFeed;
      LineFeed;
      Colour(FGreen);
      if Subject <> '' then
       begin
         Line[27] := 'Subject : RE:' + Subject;
	 Print(' ' + Line[27]);
         Colour(FWhite);
       end
      else
       begin
         Print(' Subject : ');
         Colour(FWhite);
         Response := ReadKB(30);
         Line[27] := 'Subject : ' + Response;
       end;
      LineFeed;
      LineFeed;
      Colour(FWhite);
      {eader;}
    end;
end;
(*..........................................................................*)
procedure PostMessage;
begin
  Exits := False;
  Print(' Area        : ');
  Colour(FCyan);
  Line[28] := Msg.AreaName;
  Print(Line[28]);
  Colour(FGreen);
  LineFeed;
  Print(' Subject     : ');
  NoUpper := True;
  Promptquote := true;
  Colour(BBLue);
  Colour(FWhite);
  Response := ReadKB(30);
  Promptquote := False;
  Colour(BBlack);
  Line[27] := 'Post Subject: ' + Response;
  LineFeed;
  Header;
end;
(*..........................................................................*)
procedure TextEdit(User, Subject : String);
Label ExitProc;
begin
  Header; { ClearScreen }
  If Show then   { Show Is Used When Once The E-Mail or Message Has Been Saved }
    begin
      If EMail then
        begin
          print(' To      : ');
          Print(Line[28]);
          LineFeed;
          print(' ');
          Print(Line[27]);
        end
     Else
        begin
          Print(' Area    : ');
          Print(Line[28]);
          LineFeed;
          Print(' ');
          Print(Line[27]);
        end;
    end;
  If not Show then
    begin
     If EMail then
       begin
         Colour(FYellow);
         Print(' E-MAIL');
         Colour(FGreen);
         Linefeed;
         EMailUser(User,Subject);
       end
     Else
       begin
         Colour(FYellow);
         Print(' POST MESSAGE');
         Colour(FGreen);
         Linefeed;
         PostMessage;
       end;
    end;
  If Exits Then Exit;
  Num := 0;
  If Not Show Then
   begin
    Max := 25;
    Print(MailHead1);
    LineFeed;
    Print(MailHead2);
    LineFeed;
    LineFeed;
    Print('  |----------------------------------------------------------------------|');
   end;
  LineFeed;
  Repeat
  Temp := '';
  Inc(Num);
  (*
  Colour(FGreen);
  Print(' Line ');
  Str(Num, Temp);
  Colour(FYellow);
  Print(Temp);
  *)
  Colour(FGreen);
  Print(' > ');
  Colour(FWhite);
  If Not Show Then
    begin
      Response := '';
      Response := ReadKB(70);
      Line[Num] := Response;
    end
  Else
     Print(Line[Num]);
  LineFeed;
  Until (Response = '$') or (Num = Max);
  Line[Num] := ' ';
  Max := Num;
  ExitProc:
end;
(*..........................................................................*)
procedure SaveEMail;
var
  Mail,
  MailNumber  : String;
  Mails       : Text;
  Step        : Integer;
begin
  If All then
    begin
    end
  Else
    begin
      MailCount := MailCount + 1;
      {Str(MailCount, MailNumber);}
      Str(fptime,MailNumber);
      Case Length(MailNumber) of
         0..1 : MailNumber := '00' + MailNumber;
            2 : MailNumber := '0' + MailNumber;
      end;
      {$IFDEF _LINUX_}
         DirSeperator := '/';
	 WildCard     := '*';
      {$ELSE}
	 DirSeperator := '\';
         WildCard     := '*.*';
      {$ENDIF}
      Step := Length(BBSCfg.BBSMailDir);
      If BBSCfg.BBSMailDir[Step] = DirSeperator then
        begin
          Mail := BBSCfg.BBSMailDir + MailTo + MailFrom + '.' + MailNumber;
        end
      Else
        begin
	  Mail := BBSCfg.BBSMailDir + DirSeperator + MailTo + MailFrom + '.' + MailNumber;
        end;
      Assign(Mails, Mail);
      {$I-} Rewrite(Mails); {$I+}
      If IOResult <> 0 then
       begin
         LineFeed;
         Print(MailError);
	 {$IFDEF _LINUX_}
	   Delay(3000);
         {$ELSE}
	   Wait(30);
	 {$ENDIF}
         Exit;
       end
      Else
       begin
         Writeln(Mails, 'Mail No : ', MailNumber);
         WriteLn(Mails, 'Date    : ', Today);
         Writeln(Mails, Line[26], ' (', Userinfo.UserNameFull,')');
         Writeln(Mails, Line[27]);
         Writeln(Mails);
         For Step := 1 to Num do
           begin
             Writeln(Mails, Line[Step]);
           end;
         Close(Mails);
         LineFeed;
         Print(MailSaved);
	 if fpChmod(Mail, &0777) <> 0 then LogError('Unable to change permissions on - ' + Mail);
	 {$IFDEF _LINUX_}
	   Delay(3000);
         {$ELSE}
           Wait(30);
         {$ENDIF}
       end;
    end;
  EndEditor := True;
end;
(*..........................................................................*)
procedure ReadMessage;
Label ReadEnd;
var
  IndexPath,
  Strgs,
  FileName   : String;
  Message    : text;
  Step,
  Max        : word;
begin
  OpenUserReadMsgDB;
  {$IFDEF _LINUX_}
     DirSeperator := '/';
 {$ELSE}
     DirSeperator := '\';
  {$ENDIF}
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = DirSeperator then
    begin
      IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + DirSeperator;
    end
   Else
    begin
      IndexPath := BBSCfg.MsgDir + DirSeperator + Msg.MsgNumber + DirSeperator;
    end;
  ListMessages;
  Assign(IdxFile, IndexPath + 'message.idx');
  {$I-} Reset(IdxFile); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Error Opening ' + IndexPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
      LineFeed;
      Print('Sorry, This Message Area Is Empty..');
      {$IFDEF _LINUX_}
        Delay(3000);
      {$ELSE}
        Wait(30);
      {$ENDIF}
    end
  Else
    begin
      Str(fileSize(IdxFile), Strgs);
      LineFeed;
      Print('*Enter Number To Start From [1 - ' + Strgs + '] / (Enter) - Stop : ');
      Response := ReadKB(5);
      { Exit If Enter Is Pressed }
      if length(Response) = 0 then Exit;
      Val(Response, Max, Step);
      If (Max > FileSize(IdxFile)) or (Max = 0) then
        begin
          LineFeed;
          Print('*InValid Message Number.');
	  {$IFDEF _LINUX_}
	    Delay(3000);
          {$ELSE}
	    Wait(30);
          {$ENDIF}
        end
      else
        begin
          For Step := 0 to FileSize(IdxFile) - 1 do
            begin
              {$I-}
                 Seek(IdxFile, Max);
                 Read(IdxFile, idx);
              {$I+}
              FileError := IOResult;
              If FileError <> 0 then
                begin
                  LogError('Error Opening : ' + IndexPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
                  Exit;
                end
              else
                begin
                  Str(Idx.MsgNumber, Strgs);
                  FileName := IndexPath + Strgs + '.msg';
                  logerror(filename);
                  Assign(Message, FileName);
                  {$I-} Reset(Message); {$I+}
                  FileError := IOResult;
                  if FileError <> 0 then
                    begin
                      LogError('Unable To Open ' + FileName + ' - ' + ErrorString(FileError));
                    end
                 Else
                    begin
                      ClearDisplay(True);
                      Max  := 0;
                      Code := 1;
                      while not Eof(Message) do
                        begin
                          Inc(Max);
                          Inc(Code);
                          If (Max < 7) and (UserInfo.UserAnsi = 1) then colour(FCyan);
                          if Max = 8 then
                            begin
                              If UserInfo.UserAnsi = 1 then colour(FWhite);
                            end;
                          Readln(Message, Strgs);
                          Print(Strgs);
                          LineFeed;
                          if Code = UserInfo.UserLines then
                            begin
                              Code := 1;
                              HoldPage;
                            end;
                        end;
                        Close(Message);
			UserMsgRead(Idx.MsgNumber);
                        Print('*[S] - Stop / [Enter] - Next Message : ');
                        Response := ReadKB(2);
			If Response = 'S' then goto ReadEnd;
                     end;
                 end;
             end;
        end;
      ReadEnd:
      Close(IdxFile);
    end;
end;
(*..........................................................................*)
procedure SaveMessage;
Label Redo;
var
  CurrentArea,
  IndexPath,
  Directory,
  MsgFileName,
  Strgs         : String;
  MessageNumber,
  Step          : Integer;
  MsgTFile      : Text;
begin
  CurrentArea := Msg.MsgNumber;   { Store Current Message Area }
  Inc(MsIndex.MsgNumber);         { Increment Message Number }
  (* Val(CurrentArea, Step, MessageNumber); *)
  {$IFDEF _LINUX_}
     DirSeperator := '/';
  {$ELSE}
     DirSeperator := '\';
  {$ENDIF}
  MessageNumber := MsIndex.MsgNumber;
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = DirSeperator then
     begin
       IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + DirSeperator;
     end
  Else
     begin
       IndexPath := BBSCfg.MsgDir + DirSeperator + Msg.MsgNumber + DirSeperator;
     end;
  Assign(IdxFile, IndexPath + 'message.idx');
  Redo: { <- Whats this...  A goto statment must be larking some where! }
  {$I-} Reset(IdxFile); {$I+}
  Step := IOResult;
  If Step <> 0 then
    begin
     {$IFDEF _LINUX_}
       if Step = 2 then { As DOS }
     {$ELSE}
       If Step = 3 then { 3 Path Not Found, Create One }
     {$ENDIF}
        begin
          LogError(IndexPath + ErrorString(Step));
	  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = DirSeperator then
            begin
              Directory := BBSCfg.MsgDir + Msg.MsgNumber;
            end
          Else
            begin
	      Directory := BBSCfg.MsgDir + DirSeperator + Msg.MsgNumber;
            end;
          {$I-} MkDir(Directory); {$I+}
          FileError := IOResult;
          If FileError <> 0 then
            begin
              LogError('Unable To Create ' + Directory + ' - ' + ErrorString(FileError));
            end
          Else
            begin
              {$IFDEF _LINUX_}
              { Change file params to full access by everyone }
                if  fpchmod(Directory, &0777) = 0 then
                  begin
                    LogError('Unable to change file params (777) on ' + Directory);
                  end;
              {$ENDIF}
              LogError('Created Directory ' + Directory);
              Goto Redo;
              { Print To Log Directory Created }
            end;
        end;
      If Step = 2 then
        begin
          {$I-} Rewrite(IdxFile); {$I+}
          FileError := IOResult;
          If FileError <> 0 then
            begin
              LogError('Unable To Create MESSAGE.IDX In ' + Msg.AreaName + ErrorString(FileError));
              { Print To Error Log }
            end
          Else
            begin
              {$IFDEF _LINUX_}
                { Change file params to full access by everyone }
                if fpchmod(IndexPath + 'message.idx', &0777) = 0 then
                  begin
                    LogError('Unable to change file params on ' + indexpath + 'message.idx');
                  end;
              {$ENDIF}
              LogError('Created MESSAGE.IDX In ' + Msg.AreaName);
              { Print To Log Index file Created }
	      Goto Redo; { <-- }
            end;
       end;
    end
  Else
    begin
      Str(MessageNumber, Strgs);
      MsgFileName := IndexPath + Strgs + '.msg';
      Assign(MsgTFile, MsgFileName);
      {$I-} Rewrite(MsgTFile); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
          LogError('Unable To Create Message' + ErrorString(FileError));
          LineFeed;
	  Print(' Message Area Full, Unable To Save Message');
	  {$IFDEF _LINUX_}
            Delay(3000);
          {$ELSE}
            Wait(30);
          {$ENDIF}
	end
      Else
        begin
          {$IFDEF _LINUX_ }
            Writeln(MsgTFile, ' ');
            Writeln(MsgTFile, 'Host : ', RemoteHost,' (', RemoteIP,')');
            Writeln(MsgTFile, 'Full Name   : ', UserInfo.UserNameFull);
	    Writeln(MsgTFile, 'Message No  : ', MessageNumber);
	    Writeln(MsgTFile, 'Forum       : ', Line[28]);
            WriteLn(MsgTFile, 'Date        : ', CallDate);
            Writeln(MsgTFile, 'Posted By   : ', UserInfo.UserName);
            Writeln(MsgTFile, Line[27]);
            Writeln(MsgTFile, ' ');
          {$ELSE}
            Writeln(MsgTFile, '��������������������������������������������������������������������������
���');
            Writeln(MsgTFile, ' Message No : ', MessageNumber);
            WriteLn(MsgTFile, ' Date       : ', Today);
            Writeln(MsgTFile, ' Posted By  : ', UserInfo.UserName, ' #',UserInfo.UserACC);
            Writeln(MsgTFile, ' Area       : ', Line[28]);
            Writeln(MsgTFile, Line[27]);
            Writeln(MsgTFile, '��������������������������������������������������������������������������
���');
          {$ENDIF}
          For Step := 1 to Num do
            begin
              Writeln(MsgTFile, Line[Step]);
            end;
          Close(MsgTFile);
          {$IFDEF _LINUX_}
            { Change file params to full access by everyone }
             if  fpchmod(MsgFileName, &666) = 0 then
               begin
                 LogError('Unable to change file params on ' + MsgFileName);
               end;
          {$ENDIF}
          Idx.MsgNumber := MessageNumber;
          If FileSize(IdxFile) <> 0 then
            begin
              {$I+}
		Seek(IdxFile, FileSize(IdxFile));
	      {$I-}
	       Write(IdxFile, Idx);
            end
          Else
            begin
              Write(IdxFile, Idx);
            end;
          Val(CurrentArea, Step, Max);
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
          Seek(MsgFile, 0);
          MsIndex.MsgNumber := MessageNumber;
          Write(MsgFile, Msg);
          Seek(MsgFile, Step - 1);
          Read(MsgFile, Msg);
          Seek(MsgNum, 0);
          Write(MsgNum, MsIndex);
        end;
      AreaSize := FileSize(IdxFile);
      Close(IdxFile);
      ExpireOldMessages(AreaSize, CurrentArea);
    end;
  EndEditor := True;
end;
(*..........................................................................*)
procedure TextEditStart(Flag : Boolean; User, Subject : String);
begin
  EndEditor := False;
  Show      := False;
  All       := False;
  If Flag then
    EMail     := True
  Else
    EMail     := False;
{  If not EMail Then Show := True; }
  TextEdit(User, Subject);
  If Exits then Exit;
  Show := True;
  Repeat
  LineFeed;
  LineFeed;
  Print(MailPrompt1);
  LineFeed;
  Print(MailPrompt2);
  Response := '';
  NoUpper := False;
  Response := ReadKB(30);
  If Response = MailView then TextEdit(User, Subject);
  If Response = MailSave then
    begin
      If EMail then SaveEMail
       Else SaveMessage;
    end;
  If Response = MailEdit then EditLine;
  If Response = MailAbort then
    begin
      LineFeed;
      Print(MailAborted);
      Response := ReadKB(30);
      If Response = MailAbortYes then EndEditor := True;
    end;
  Until EndEditor = True;
  Colour(FWhite);
end;
(*..........................................................................*)
procedure EditMail;
Label View;
var
  Step,
  PageInc,
  UserNo    : Integer;
  MailPath,
  Strgs,
  User      : String;
  Mail      : Text;
  Filenames : array[1..12] of string[12];
begin
  {$IFDEF _LINUX_}
     DirSeperator := '/';
     WildCard	  := '*';
  {$ELSE}
     DirSeperator := '\';
     WildCard	  := '*.*';
  {$ENDIF}
  str(UserInfo.UserUID, SUID);
  CurrentUser := SUID;
  Case Length(SUID) of
     1 : MailFrom := '000' + SUID;
     2 : MailFrom := '00' + SUID;
     3 : MailFrom := '0' + SUID;
   Else
     MailFrom := SUID;
  end; { Case End }
  MailCount := 0;
  Strgs     := '';
  User      := '';
  PageInc   := 0;
  { Check For Mail Sent By User }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
    begin
      MailPath := BBSCfg.BBSMailDir + WildCard;
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + DirSeperator + WildCard;
    end;
  ClearDisplay(True);
  { Needs to be changed with UserInfo.UserColour }
  Colour(FYellow);
  Print('Searching..');
  Colour(FWhite);
  LineFeed;
  LineFeed; {mailpath}
  FindFirst(MailPath, Archive, DirInfo);
  While DosError = 0 do
    begin
      If MailCount <= 100 then { Store Up to 100 Mails }
        begin
          IF Pos(MailFrom, DirInfo.Name) > 0 then    { Search File Name For }
            begin                                    { User Number          }
              Inc(MailCount);
              FileNames[MailCount] := DirInfo.Name;
            end;
        end;
      FindNext(DirInfo);
    end;
  If MailCount > 0 then
    begin
      Colour(FYellow);
      Print(' Users You Have Sent Mail To And Are Unread..');
      LineFeed;
      LineFeed;
      for Step := 1 to MailCount do
        begin
          Str(Step, Strgs);
          SetX('2');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
           Print(Strgs);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;37m');
            end;
          Print(' : ');
          Strgs := Copy(FileNames[Step], 1, 4); { Get User Name }
          Val(Strgs, UserNo, MAx);
          Seek(DataFile, UserNo);
          Read(DataFile, UserInfo);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;32m');
            end;
          Print(UserInfo.UserName);
          SetX('45');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
         Print('UserNo # ');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;35m');
            end;
	  Print(SUID);
          LineFeed;
          UserNo := 0;
          User   := '';
          Strgs  := '';
          inc(PageInc);
          if (PageInc = (UserInfo.UserLines - 3)) then
            begin
              PageInc := 0;
              HoldPage;
            end;
        end;
     Val(CurrentUser, UserNo, Max);
     Seek(DataFile, UserNo);     { Restore Current User }
     Read(DataFile, UserInfo);
     If UserInfo.UserAnsi = 1 then
       begin
         Print(#27 + '[34m');
       end;
     LineFeed;
     Print('Please Select Mail To Edit : ');
     Response := ReadKB(90);
     If Response <> #13 then
       begin
         Val(Response, UserNo, Max);
         If UserNo <= Step then
           begin
            If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = DirSeperator then
               begin
                 MailPath := BBSCfg.BBSMailDir + FileNames[UserNo];
               end
             Else
               begin
		 MailPath := BBSCfg.BBSMailDir + DirSeperator + FileNames[UserNo];
               end;
             NoUpper := True;
             UserNo := 1;
             Assign(Mail,MailPath);
             {$I-} Reset(Mail); {$I+}
             If IOResult = 0 then
               begin
                 While not eof(Mail) do
                  begin
                    Readln(Mail, Strgs);
                    Line[UserNo] := Strgs;
                    Inc(UserNo);
                  end;
                 View:
                 Num := 0;
                 Header;
                 Repeat
                   Temp := '';
                   Inc(Num);
                   If UserInfo.UserANSi = 1 then
                     Print('[32m Line ')
                   Else
                     Print(' Line ');
                   Str(Num, Temp);
                   If UserInfo.UserANSI = 1 then Print('[33m');
                   Print(Temp);
                   If UserInfo.UserANSI = 1 then
                     Print('[32m >[37m ')
                   Else
                     Print(' > ');
                   Print(Line[Num]);
                   LineFeed;
                   If Num = 23 then
                     begin
                       Print('Press Any Key To Continue');
                       Response := ReadKB(1);
                       Print(#13);
                       Print('                         ');
                       Print(#13);
                     end;
                   Until Num = UserNo - 1;
                   LineFeed;
                   EndEditor := False;
                   Repeat
                   LineFeed;
                   If UserInfo.UserANSI = 1 then
                     begin
                       Print('[31m [[33mS[31m] [36mSave Message  [31m[[33mA[31m] [36mAbort Message  ');
                       Print('[31m[[33mE[31m] [36mEdit Line  [31m[[33mV[31m] [36mView Message');
                    end
                   Else
                    Print(' [S] Save Message  [A] Abort Message  [E] Edit Line  [V] View Message');
                   LineFeed;
                   If UserInfo.UserAnsi = 1 then
                     Print(' [37mPlease Select Option  [32m:  [33m')
                   Else
                     Print(' Please Select Option : ');
                   Response := '';
                    Response := ReadKB(2);
                   If (Response = 'v') or (Response = 'V') then Goto View;
                   If (Response = 's') or (Response = 'S') then
                     begin
                       {I$-} Rewrite(Mail); {$I+}
                       If IOResult = 0 then
                         begin
                           For Step := 1 to UserNo -1 do
                            begin
                              Writeln(Mail, Line[Step]);
                            end;
                           Print('*Mail Saved');
                           EndEditor := True;
                         end
                       Else
                         begin
                           { IO Error }
                         end;
                     end;
                   If (Response = 'e') or (Response = 'E') then EditLine;
                   If (Response = 'a') or (Response = 'A') then
                    begin
                     LineFeed;
                     Print('*Abort (Y/n) : ');
                     Response := ReadKB(1);
                     If (Response = 'y') or (Response = 'Y') then EndEditor := True;
                   end;
                 Until EndEditor = True;
                 Close(Mail);
               end
             Else
               begin
                 { IO Error }
               end;
           end
         Else
           begin
             LineFeed;
             Print('Invalid Number');
	     LineFeed;
	     {$IFDEF _LINUX_}
               Delay(3000);
             {$ELSE}
               Wait(30);
             {$ENDIF}
           end;
       end;
    end
 Else
    begin
      { There Is No Mail By User }
    end;
  NoUpper := False;
end;
(*..........................................................................*)
procedure SelectMessageArea(Area : Word);
Label Again, ExitProc;
begin
  CurrentArea := Msg.MsgNumber; { Store Current Message Area Number }
  If Area <= 0 then
   begin
     Again: { Loops & Gotos, what was I thinking - TWAT}
     ListMessageAreas;
     Print('Select Message Area or (Enter) - Exit / (?) - List Areas : ');
     Response := ReadKB(3);
     If Response = '?' then
        begin
          ListMessageAreas;
          Goto Again;
        end;
     Val(Response, ValWord, ValCode);
     If (ValWord <> 0) and (ValWord <= FileSize(MsgFile)) then
        begin
         {$I-}
         Seek(MsgFile, ValWord - 1);
         Read(MsgFile, Msg);
         {$I-}
         CurrentArea := Msg.MsgNumber;
        end
     Else
       begin
         {If No Selection Then Restore Current Message Area }
         Val(CurrentArea, ValWord, ValCode);
         Seek(MsgFile, ValWord - 1);
         Read(MsgFile, Msg);
       end;
   end
 Else
   begin
     If Area > FileSize(MsgFile) then
       begin
         LineFeed;
         Print('InValid Message Area Selection');
	 LineFeed;
	 {$IFDEF _LINUX_}
           Delay(3000);
         {$ELSE}
	   Wait(30);
         {$ENDIF}
       end
     Else
       begin
         {$I-}
         Seek(MsgFile, Area - 1);
         Read(MsgFile, Msg);
         {$I+}
       end;
   end;
  LineFeed;
  ExitProc:
  //if Area > 0 then Print('Forum Selected : ' + Msg.AreaName);
end;
end.
