(* ........................................................................ *)
(*        								    *)
(* MODULE	:  CREATION.PP      			                    *)
(*									    *)
(* DESCRIPTION	:  Creates all new users stored in the adduser.dat database *)
(*									    *)
(* ENVIRONMENT  :  PPC386 PASCAL Ver 2.0.4  			            *)
(*									    *)
(* COPYRIGHT	:  SIMON C HORTON  1999 - 2007                              *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Creation;

interface

uses Dos, Crt, Linux, Errorlog, Data, FileCopy, Strings;

function Get_User_Size : integer;
function Check_For_Existing_User(AUname : pchar) : Boolean;
function Get_User_Info(RecNo : integer) : boolean;
function Create_User : Boolean;

implementation

var
  { Get functions from external library }
  function getpwnam(UName : PChar) : TUserPasswd ; cdecl; external;
  function getpwuid(ID : integer) : TUserPasswd ; cdecl; external;
  function crypt(Pass : PChar; Salt : PChar) : PChar ; cdecl; external;

(*..........................................................................*)
{ Close adduser database }
procedure Close_Database;
begin
  {$I-}
    Close(UserDB);
    fSuccess := IOResult;
    if fSuccess <> 0 then 
     begin
       LogError('Unable to close user creation database [' + AddUserdb + '] Error = ' + ErrorString(DosError));
       {$IFDEF _DEBUG_}
         writeln(' [DEBUG] Unable to close adduser database [',ErrorString(DosError),']');
       {$ENDIF}
     end;
  {$I+}        
end;  
(*..........................................................................*)
{ Open adduser database }
function Open_Database : boolean;
var
  Db_Path : string;
begin
  if Output_Verbose then writeln('> Reading user creation database..');
  Db_Path := Config.new_user_files;
  if Db_Path[Length(Db_Path)] = '/' then Db_Path := Db_Path + AddUserdb
   else Db_Path := Db_Path + '/' + AddUserdb;  
  {$I-}
  assign(UserDb, Db_Path);
  reset(UserDb);
  fSuccess := IOResult;
  if fSuccess <> 0 then
   begin
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] Unable to open ', AddUserdb,' : Error = [', ErrorString(DosError),']');
    {$ENDIF} 
    Close(UserDB);
    Open_Database := False;
    LogError('Unable to open user creation database [' + AddUserdb + '] Error = ' + ErrorString(DosError)); 
   end
  else
   begin
     Open_Database := TRUE;
   end; 
  {$I+} 
end;
(*..........................................................................*)
function Check_For_Existing_User(AUname : pchar) : Boolean;
begin   
  Check_For_Existing_User := TRUE;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Checking for any existing user called [', AUname,']');
  {$ENDIF}  
  if getpwnam(AUname) <> NIL then
   begin
     if Output_Verbose then writeln('> User ',AUname,' Already Exists..');
     LogError('User ' + StrPas(AUname) + ' already exists..');
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] User [', AUname,'] already exists.. This should not happen');
     {$ENDIF}  
     Check_For_Existing_User := FALSE; 
   end;
end;        
(*..........................................................................*)
function Get_User_Info(RecNo : integer) : boolean;
begin
  if Output_Verbose then writeln('> Reading user information from user creation database..');
  Get_User_Info := TRUE;
  if not Open_Database then
   egin
   end
  else
   begin
     {$I-}
       seek(UserDB, RecNo);
       read(UserDB, User_Data);
     {$I+}
     fSuccess := IOResult;
     if fSuccess <> 0 then 
      begin
        Get_User_Info := False;
        Str(RecNo, S1);
        LogError('Unable to read user creation database, record No.(' + S1 +') Error = ' + ErrorString(DosError));
        {$IFDEF _DEBUG_}
          writeln(' [DEBUG] Unable to read user database, record No.(',S1,') Error = ', ErrorString(DosError));
        {$ENDIF}  
      end
     else
      begin
        {$IFDEF _DEBUG_}
          writeln(' [DEBUG] UserName : ', User_Data.User_Name);
          writeln(' [DEBUG] UserPass : ', User_Data.User_Pass);
        {$ENDIF}  
      end;
   end;
   Close_Database;
end;
(*..........................................................................*)
{ Get number of users to create, returns -1 if an error occurred }
function Get_User_Size : integer;
begin
  if not Open_Database then
   begin
     Get_User_Size := -1;
   end
  else
   begin
     Get_User_Size := FileSize(UserDB);
     Close_Database;
   end; 
end;
(*..........................................................................*)
function Create_User : Boolean;
var
  Uid, 
  UUid, 
  Gid        : integer;
  Crypt_Pass,
  Password,
  Sal        : pchar;
  St,
  Dir_Home,
  Mail_Dir,
  PCrypt     : string;
  t,
  Tt	     : longint;
  Salts	     : array[1..2] of string;
  Open_File  : text;
  G1,
  G2	     : PGlob;
begin
  if Output_Verbose then writeln('> Creating user..', User_Data.User_Name);
  LogError('Creating user ' + User_Data.User_Name);
  { Setup }
  if HomeDir[Length(HomeDir)] = '/' then Dir_Home := HomeDir + User_Data.User_Name
   else Dir_Home := HomeDir + '/' + User_Data.User_Name;
  { Set Group ID }
  Gid := 100;  
  { Get next available UID }
  Uid := 1000;
  repeat 
   inc(Uid);
  until getpwuid(Uid) = NIL;
  UUid := Uid;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Next available UID = [', UUid,']');
  {$ENDIF}
  { Encrypt Password }
  t := GetEpochtime;
  tt := ( t and $0F );
  Str(tt, St);
  Salts[1] := St + 'A';
  tt := ( t and $F0 ) >> 4;
  Str(tt, St);
  Salts[2] := St + 'a';
  St := Salts[1] + Salts[2];
  Password := StrAlloc(Length(User_Data.User_Pass) + 1);
  StrPCopy(Password, User_Data.User_Pass);
  Sal := StrAlloc(Length(St) + 1);
  StrPCopy(Sal, St);
  Crypt_Pass := crypt(Password, Sal);
  PCrypt := StrPas(Crypt_Pass);
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Encrypted Password = [', PCrypt,']');
  {$ENDIF}  
  { Add user information to passwd file }
  {$I-}
   assign(Open_File, PasswdFile);
   append(Open_File);
  {$I+}
  fSuccess := IOResult;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Opening passwrd file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
  {$ENDIF}  
  if fSuccess <> 0 then
   begin
     LogError('Unable to open passwd file : ' + ErrorString(DosError));
     Create_User := False;
   end
  else
   begin
    writeln(Open_File,User_Data.User_Name,':',ShadowToken,':',UUid,':',Gid,':',User_Data.Full_Name,':',Dir_Home,':',    DefaultShell);
    Close(Open_File); 
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] ',      User_Data.User_Name,':',ShadowToken,':',UUid,':',Gid,':',User_Data.Full_Name,':',Dir_Home,':',DefaultShell);
    {$ENDIF}
    {$I-}
      assign(Open_File, ShadowFile);
      append(Open_File);
    {$I+}
    fSuccess := IOResult;
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] Opening shadow file: fSuccess (', fSuccess,') = [', ErrorString(fSuccess),']');
    {$ENDIF} 
    if fSuccess <> 0 then
     begin
       LogError('Unable to open shadow file : ' + ErrorString(DosError));
       Create_User := False;
     end
    else
     begin
       writeln(Open_File, User_Data.User_Name,':', PCrypt,'::::::::');
       Close(Open_File);
       {$IFDEF _DEBUG_}
         writeln(' [DEBUG] ', User_Data.User_Name,':', PCrypt, '::::::::');
       {$ENDIF} 
       { Create user mail file }
       if Output_Verbose then writeln('> Creating user mail file..');
       if MailDir[Length(MailDir)] = '/' then Mail_Dir := MailDir + User_Data.User_Name
        else Mail_Dir := MailDir + '/' + User_Data.User_Name;
       {$I+} 
       assign(Open_File, Mail_Dir);
       rewrite(Open_File);
       {$I+}
       Success := IOResult;   
       if Success <> 0 then LogError('Unable to create - ' + Mail_Dir + 'Error = ' + ErrorString(DosError))
        else 
         begin      
           Close(Open_File);
           LogError('Created user mail file - ' + Mail_Dir);
          { Make sure file permission and ownership are correct }
          if Output_Verbose then writeln('> Changing permissions on user mail file..');
          if not Chmod(Mail_Dir, octal(0660)) then LogError('Unable to change permissions on - ' + Mail_Dir)
           else LogError('Changed permissions on - ' + Mail_Dir);
          if not Chown(Mail_Dir, UUid, MailGrp) then LogError('Unable to change ownership on - ' + Dir_Home)
           else LogError('Changed ownership of mail directory - ' + Mail_Dir);   
        end;   
       { Create home directory }
       if Output_Verbose then writeln('> Creating user home directory..');
       {$I+} MkDir(Dir_Home); {$I+}
       Success := IOResult;   
       if Success <> 0 then LogError('Unable to create - ' + Dir_Home)
        else LogError('Created home directory - ' + Dir_Home);
       { Make sure file permission and ownership are correct }
       if Output_Verbose then writeln('> Changing permissions on user home directory..');
       if not Chmod(Dir_Home, octal(HomeDirPerms)) then LogError('Unable to change permissions on - ' + Dir_Home)
        else LogError('Changed permissions on - ' + Dir_Home);
       if not Chown(Dir_HOME, UUid, Gid) then LogError('Unable to change ownership on directory - ' + Dir_Home)
        else LogError('Changed ownership of home directory - ' + Dir_Home);
       { Copy form skel directory }
       if Output_Verbose then writeln('> Copyng files from ', SkelDir,' to user home directory..');
       if SkelDir[Length(SkelDir)] = '/' then Command := 'cp -r ' + SkelDir + '.??* ' + Dir_Home
        else Command := 'cp -r ' + SkelDir + '/.??* ' + Dir_Home;
       LogError('Copied files from ' + SkelDir);
       Success := Copy_File(SkelDir, Dir_Home, '.??*');
       {$IFDEF _DEBUG_}
         writeln(' [DEBUG] No of files copied [', Success,']');
       {$ENDIF}
       { Changing file permissions on files in user home directory } 
       if Output_Verbose then writeln('> Changing file permmisions on files in user home directory..');
       LogError('Changing ownership permissions on user files in home directory..');
       S2 := Dir_Home + '/.??*';
       G1 := Glob(S2);
       if LinuxError = 0 then
        begin
          G2 := G1;
          while G2 <> NIL do
           begin
             S1 := StrPas(G2^.Name);
             Chmod(Dir_Home + '/' + S1, octal(0644));
             Chown(Dir_Home + '/' + S1, UUid, Gid);
             {$IFDEF _DEBUG_}
               writeln(' [DEBUG] Changed permissions on [', Dir_Home,'/',G2^.Name,']'); 
             {$ENDIF} 
             G2 := G2^.Next;  
           end;   
           LogError('Changed permissions on [' + Dir_Home + '/' + S1 + ']');
        end;
       GlobFree(G1); 
       Create_User := True; 
     end;  
   end; 
end;

end.
