(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   BULLETIN.PP                                             *)
(*                                                                          *)
(* DESCRIPTION  :   BULLETIN UNIT                                           *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 2008                                       *)
(*                                                                          *)
(*..........................................................................*)

Unit bulletin;

Interface

Uses Dos, Crt, Lib, Data, Dates,Colours, ErrorLog,FullEditor,baseunix,sqldb,strings;

function BulletinNumber(bulletinfid : integer) : integer;
procedure DisplayBulletins(bulletinforum : integer);

implementation

(*..........................................................................*)
{ Returns the number of bulletin }
function BulletinNumber(bulletinfid : integer) : integer;
var
  results : recbuf;
  querystrg : ansistring;
  sqlquery  : pchar;
begin
   qstr := '';
   str(bulletinfid, qstr);
   querystrg := 'select mid from forum_messages where fid=' + qstr;
   sqlquery := StrAlloc (length(querystrg) + 1);
   strpcopy(sqlquery, querystrg);
   if sql_query(sqlquery) then
     begin
       results := sql_store_results;
       if results <> NIL then BulletinNumber :=  sql_num_rows(results)
         else BulletinNumber := 0;
     end
   else
     begin
       BulletinNumber := 0;
       LogSQLError(sqlerror);
     end;
  dispose(sqlquery);
end;
(*..........................................................................*)
procedure DisplayBulletins(bulletinforum : integer);
var
  results  : recbuf;
  rows     : rowbuf;
  strgs,
  response : string;
  Step,
  YPos,
  loop,
  No       : integer;
begin
  No := BulletinNumber(bulletinforum);
  str(bulletinforum, qstr);
  querystr := 'select * from forum_messages where fid=' + qstr + ' order by mid DESC';
  query := StrAlloc (length(querystr) + 1);
  strpcopy(query, querystr);
  if sql_query(query) then
    begin
      results := sql_store_results;
      if results <> nil then
       begin
         rows := sql_fetch_row(results);
         for loop := 1 to no do
//         if rows <> nil then
          begin
           //inc(loop);
           //linefeed;
           colour(FRed);
           print('Update ');
           colour(FYellow);
           print(ansistring(rows[4]));
           linefeed;
           linefeed;
           //colour(FGreen);
           //print('Subject : ');
           colour(FBlue);
           print(ansistring(rows[5]));
           linefeed;
           linefeed;
           colour(FWhite);
           print(ansistring(rows[6]));
           linefeed;
           colour(FGreen);
           print('Bulletin ');
           colour(FYellow);
           str(loop, qstr);
           print(qstr);
           colour(FGreen);
           print(' of ');
           colour(FYellow);
           str(No, qstr);
           print(qstr);
           linefeed;
           YPos := WhereY;
           colour(FYellow);
           print('[');
           colour(FGreen);
           print('N');
           colour(FYellow);
           print(']');
           colour(FCyan);
           print('ext Bulletin ');
           colour(FYellow);
           print('[');
           colour(FGreen);
           print('E');
           colour(FYellow);
           print(']');
           colour(FCyan);
           print('xit');
           repeat
             echo := false;
             response := readkb(1); 
             echo := true;
           until (response = 'E') or (response = 'N');
           for Step := 0 to WhereX do
             begin
               Print(Chr($08));
               Print(Chr($20));
               Print(Chr($08));
             end;

            Print(Chr($20));
            Print(Chr($08));

            Str(YPos,Strgs);
            SetY(Strgs);

           linefeed;
           if response = 'E' then
            begin
              dispose(query);
              sql_free_results(results);
              exit;
            end;
           rows := sql_fetch_row(results);
          end;
       end;
      { clear memory }
      sql_free_results(results);
     end
   else
     begin
       { sql query error }
       writeln(sqlerror);
       writeln(querystr);
       delay(1500);

     end;
   dispose(query);
end;
(*..........................................................................*)
end.

