// Filename:   sysexec.h
// Purpose:    Provide system-specific operations (primarily exec)
// Author: Greg Shaw
// Created:    5/14/94

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _SYSTEM_H_
#define _SYSTEM_H_

#include "bbshdr.h"

#define NUKEHIM    255          // returned from sysint when user has used all of
// his time in an external

// Object: sysexec
// Purpose:    encapsulate unusual system operations
// Methods:    sysint() - a sysexec() call that doesn't block SIGHUP
// Author: Greg Shaw
// Created:    5/18/94

class sysexec: public filelock
{
	// pid_t   running_pid;
	public:
			sysexec();              // constructor
			~sysexec();             // destructor
		// execute command with SIGHUP handling
		int	sysint(char *command, time_t logoff_time, int quiet);
};


#endif                          // _SYSTEM_H_






