// Filename:   ports.h
// Contents:   the definitions for every ipc port used by the bbs system.
// Notes:  see document 'ports' in the design directory for port
//     definitions
// Author:     Greg Shaw
// Created:        7/12/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _PORTS_H_
#define    _PORTS_H_

// base port that everything keys from
#define ROCAT_BASE_PORT 22300

// error logger daemon contact port
#define ERRLOG_PORT    ROCAT_BASE_PORT+1

// system monitor contact port
#define MONITOR_PORT   ROCAT_BASE_PORT+2

// chat sockets
                                // master connection point
#define CHAT_MASTER_PORT   ROCAT_BASE_PORT+3
                                // master connection point
#define CHAT_PRIVATE_MASTER_PORT  ROCAT_BASE_PORT+4
// status information
#define CHAT_INFO_MASTER_PORT  ROCAT_BASE_PORT+5
// admin status
#define CHAT_ADMIN_MASTER_PORT ROCAT_BASE_PORT+6
#define CHAT_BROADCAST_ADMIN_MASTER_PORT ROCAT_BASE_PORT+7
#define CHAT_PRIVATE_ADMIN_MASTER_PORT ROCAT_BASE_PORT+8
#define CHAT_BROADCAST_PORT ROCAT_BASE_PORT+9
                                // base port for client use
#define CHAT_CLIENT_BASE  ROCAT_BASE_PORT+10
// max port for client use
                                // 10 per chat room
#define MAX_CLIENTS        MAX_CHAT_ROOMS*10
#define CHAT_CLIENT_MAX        CHAT_CLIENT_BASE+MAX_CLIENTS
#define CHAT_PRIVATE_CLIENT_BASE   CHAT_CLIENT_MAX+1
#define MAX_PRIVATE_CLIENTS    MAX_CHAT_ROOMS*2
#define CHAT_PRIVATE_CLIENT_MAX CHAT_PRIVATE_CLIENT_BASE+MAX_PRIVATE_CLIENTS

#endif                          // _PORTS_H_






