// Filename:	msqlmsg.h
// Contents:	the object definition for the msql to message system
// Author:	Greg Shaw
// Created:	2/14/96

#ifndef _MSQLMSG_H_
#define _MSQLMSG_H_

#include "bbshdr.h"

// Table names within the database:
#define	INFO_TABLE_NAME		"info"
#define	TAGLINE_TABLE_NAME	"tagline"
#define DATABASE_NAME		"rocat"

// Structure:	Group
// Contents:	the data fields that make up a group list
// Author:	Greg Shaw
// Created:	3/17/96

typedef struct grouping
{
	char	section[MAX_SECTION];		// short name of table
	int	group;		// group ID
	int	high_message;		// highest read message in group
	int	selected;		// did they select this group from list?
	struct grouping *next;
} Group;

// Structure:	Msg
// Contents:	the data fields that make up a message
// Author:	Greg Shaw
// Created:	2/14/96

typedef struct message
{
	int	message_number;		// ordinal message number
	char	from_[MAX_FROM_TO];	// 'from'
	char	to[MAX_FROM_TO];	// 'to'
	char	subject[MAX_SUBJECT];	// subject of message
	long	date;			// date of posting
	char	*text;			// text of message
	int	link_number;		// message number of a link message
	char	link_section[MAX_SECTION];// message number of a link message
	int	thread_number;		// thread id
	int	local_origin;		// locally originated
	struct	message *next;		// next message
} Msg;

// Structure:	SectionHdr
// Contents:	the header information for a message table
// Author:	Greg Shaw
// Created:	2/14/96

typedef struct sectionhdr
{
	char	table_name[MAX_SECTION];// short name of table
	int	high_message;		// highest message number
	int	high_thread;		// highest thread
	int	num_messages;		// number of messages in section
	int	section_type;		// type of section
	int	acl;			// access level to view
	int	flags;			// flags to view
	int	modifier;		// acl/flags modifier
	int	read_only;		// are messages read-only?
	int	anonymous;		// allow anonymous posts?
	int	group;			// group read number
	int	days;			// # days to keep messages before delete
	int	maxlines;		// max # of lines per message
	int	tagline;		// use a tagline?
	long	last_import;		// date of last import run
	int	high_import;		// highest messsage number imported (usenet)
	char	external_name[150];	// the external name of the group (fido/usenet)
	long	date;			// date of last update
	char	moderator[100];		// email address of moderator
					// login (firstname lastname)
	char	long_name[150];		// long name of section
	struct sectionhdr *next;	// next section 
} SectionHdr;


// Object:	msqlmsg
// Purpose:	interface between msql and message system record format
// Attributes:	
// Methods:
// Author:	Greg Shaw
// Created:	2/14/96

class msqlmsg : public msqllock
{
	int		dbsock;			// database socket
	// message storage
	m_result	*msgresult;	// result of message query
	m_row		msg_row;	// current message
	int		msgpos;		// position within query
	int		msgrows;	// number of rows returned

	SectionHdr	*areas;		// section headers
	SectionHdr	*current;	// current section
public:
	msqlmsg();		// constructor
	~msqlmsg();		// destructor

	int	add_hdr(SectionHdr *hdr);	// add to cache
	int	add_header(SectionHdr *hdr);	// add header to info table
		// add a new message to the table
	int	add_msg(char *table_name, Msg *newmsg, int lock); 

	int	build_thread_list(Group *glist, mllist *tlist);	// build thread list

	int	clean_threads(char *section);	// clean up threads for section
	int	clear_hdr(SectionHdr *hdr);	// nuke cache entry
	int	clear_messages(void);		// throw away message results
	int	clear_message(Msg **cur);		// free message memory

	int	delete_header(SectionHdr *hdr);	// delete header from info table
	int	delete_mail(char *section);	// delete all user's mail
	int	delete_message(char *section, Msg *msg, int has_thread);	// delete message from message list
	int	delete_message_list(void);	// delete message list
	int	delete_thread(char *section, Thread *t);	// delete thread from db
	void	expire(void);		// expire messages

	SectionHdr	*find_hdr(char *section);	// find header

	int	get_bbs_group(Group **glist, int group);	// get bbs group
	int	get_header(char *section, SectionHdr *hdr, int use_cache);// get section information
	int	get_messages(char *section, int thread_number, int high_message);	// get messages in thread
		// return (and increment) highest message number
	int	get_message_number(char *section);
	int	get_private_messages(char *section, int keep);	// get private messages
		// get a random tagline (if possible)
	int	get_tagline(int tag, char *tagline);
		// get thread number (or new thread)
	Thread *get_thread(char *section, char *subject);
	int	get_thread_number(char *section, char *subject);

	Msg	*head(void);		// head of message list

	int	iterate_header(SectionHdr *hdr, int num, int include_private); // iterate headers

	int	list_messages(char *section, int item, char row[3][255]);	// list messages in section

	SectionHdr *open(char *section);	// get section information

	Msg	*next(void);		// next message
	int 	num_messages(char *section);	// number of messages in section
	int	num_threads(char *section);	// number of threads in section
	

	Msg	*previous(void);	// previous message
	int	post(char *section, Msg *newmsg, int priv);	// post messages

	Msg	*rowtomsg(m_row row);	// convert row to a message
	
	int	save_header(SectionHdr *hdr, int full);	// update a header record
	int	save_thread(char *section, Thread *t, int lock);	// save thread information
	int	scan(SectionHdr *sec, time_t last_logon);	// scan for messages to the user

	Msg	*tail(void);		// tail of message list

};






#endif // _MSQLMSG_H_
