// Filename:	msgutil.C
// Contents:	the messages utility program methods
// Author:	Greg Shaw
// Created:	4/15/96

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _MSGUTIL_C_
#define _MSGUTIL_C_

#include "bbshdr.h"
#include "msgutil.h"


User user;                      // defined here for extern references elsewhere
moncon mon_obj;                 // monitor connection object (not used)
Chat chatobj;                   // chat connections (not used)


#ifdef USE_DATABASE

// Function:	pimport
// Purpose:	import private messages into the BBS
// Input:       a message stream
// Output:      if a message can be found, it will be sent to the BBS
//		if not, a bounce message will be sent back to sendmail
// Author:      Greg Shaw
// Created:     4/15/95
// Notes:	The is some pretty gnarly code.  However, I was unable to
//		think of a better way to do it.  Until that brainstorm occurs,
//		it will stay gnarly.  

int msgutil::pimport(void)
{
	Msg	newmsg;	// new message
	char	buf[MAX_IMPORT_MESSAGE];	// buffer used to store message
	char	fname[100];	// first name of sender
	char	lname[100];	// last name of sender
	char	section[MAX_SECTION_LENGTH];
	char	email[100];		// email addres
	char	login[20];		// login name of recipient
	char	tmpstr[255];
	char	c,*t,*w,*u;
	struct tm date;
	int	recipient = 0;
	int	bounce = 0;		// bounce the message?
	char	bouncemsg[100];		// reason for bounce
	int	state = 0;		// state of message digestion
	int	priv = 0;		// private message?
	int	uexists;		// user exists?
	char 	delimiters[] = " <(=";	// From: field delimiters

	// read the whole message info the new message
	bouncemsg[0] = 0;
	t = buf;
	while (!feof(stdin))
	{
		if (c = fgetc(stdin), c != EOF)
		{
			*t++ = c;
			if (t-buf > MAX_IMPORT_MESSAGE-1)
			{
				*t = 0;	
				bounce++;
				sprintf(bouncemsg,"Message too large: must be less than %ld chars.",(long)MAX_IMPORT_MESSAGE);
			}
		}
	}
	*t = 0;	 // add null 
	// now digest message
	while (state != 4)
	{
		switch(state)
		{
		case 0:	// From digestion
			// find 'From'
			// look for 'From:' first (better than simple 'From')
			if (t = strstr(buf, "\nFrom:"), t != NULL)
			{
				// format: From: some_number_words [<|(] email address [)|>] 
				// example: From: Firstname MI Lastname <user@somehost.domain>
				// skip 'From:'
				fname[0] = 0;
				lname[0] = 0;
				email[0] = 0;
				t++;	// looking at \n
				for (w = t; !isspace(*w); w++);
				w++;
				t = w;
				// copy it to a line
				w = tmpstr;
				for (u = t; !iseol(*u); u++)
					*w++ = *u;
				*w = 0;
				// remove any quotes
				for (w = strchr(tmpstr,'"'); w != NULL; w = strchr(tmpstr,'"'))
					*w = ' ';
				// get the firstname
				u = fname;
				for (w=t; strchr(delimiters,*w) == NULL; w++)
					if (u-fname < 100)
						*u++ = *w;
				*u = 0;
				// skip lastname if email address found
				if (*w != '<' || *w != '(' || *w != '=')
				{
					// grab the rest up to the <
					u = lname;
					for (; *w != '<' && *w != '('; w++)
						if (u-lname < 100)
							*u++ = *w;
					if (u != lname)
						u--;	// space will be at end
					*u = 0;
				}
				else
					lname[0] = 0;
				// skip any ISO information for font
				// selection.  Yes, I know, a bad idea, but
				// since the bbs doesn't officially use ISO
				// font sets...
				if (*w == '=')
				{
					w++;
					while (*w != 0 && *w != '=' )
						w++;
				}
				w++;	// skip '<' or '('
				u = email;
				// now grab the email address
				for (; *w != '>' && *w != ')'; w++)
					*u++ = *w;
				*u = 0;
				// now put it into the 'from' field of the new message
				if (strchr(tmpstr,'@') != NULL)	// no @ in msg?
				{
					if (strchr(email,'@') == NULL)	// no @?
					{
						// then find it elsewhere
						if (strchr(fname,'@') != NULL)
						{
							sprintf(newmsg.from_,"%s (%s %s)",fname,email,lname);
						}
						else if (strchr(lname,'@') != NULL)
						{
							sprintf(newmsg.from_,"%s (%s %s)",lname,email,fname);
						}
					}
					else
						sprintf(newmsg.from_,"%s (%s %s)",email,fname,lname);
				}
				else
					sprintf(newmsg.from_,"%s (%s %s)",email,fname,lname);
				if (strlen(newmsg.from_) > MAX_FROM_TO)
					newmsg.from_[MAX_FROM_TO - 1] = 0;

			}
			else if (t = strstr(buf,"From "), t != NULL)
			{
				// format: From user@somehost.domain
				// skip 'From'
				for (w = t; !isspace(*w); w++);
				// save the rest as email address
				w++;
				u = email;
				for (; !isspace(*w); w++)
					*u++ = *w;
				*u = 0;
				sprintf(newmsg.from_,"%s",email);
			}
			else	// no from found -- garbled message
			{
				for (t = buf; !iseol(*t); t++);
				*t = 0;
				ap_log("Unable to digest message: No 'From' found");
				ap_log(buf); // dump first line of message

				return(0);	// can't bounce -- no one to send message to
			}
			state++;
			break;
		case 1:	// to digestion
			// go by the user running the program.  
			// email headers aren't changed by aliases -- 
			// mail from news forwarded to shaw will look like 
			// it's addressed to 'news' even though it's in
			// shaw's mailbox.
			// get the username -- the 'to' field isn't always right
			strcpy(newmsg.to,username());
			recipient = 1;
//			if (t = strstr(buf, "To:"), t != NULL)
//			{
//				// format: To: user@somehost.domain
//				// eliminate any < > pairs
//				for (v=t; !iseol(*v); v++);
//				c = *v;
//				*v = 0;
//				while (u = strchr(t,'<'), u != NULL)
//					*u = ' ';
//				while (u = strchr(t,'>'), u != NULL)
//					*u = ' ';
//				for (w = t; !isspace(*w); w++);
//				w++;
//				sscanf(w,"%s",newmsg.to);
//				*v = c;
//				recipient = 1;
//			}
//			else 	// no 'to'?
//			{
//				strcpy(newmsg.to,"???");
//				for (t = buf; !iseol(*t); t++);
//				c = *t;
//				*t = 0;
//				ap_log("Unable to digest message: No 'To' found");
//				ap_log(buf); // dump first line of message
//				bounce++;
//				strcpy(bouncemsg,"No valid recipients: No To: line found.");
//				*t = c;
//			}
			state++;
			break;
		case 2:	// date digestion
			if (t = strstr(buf, "\nDate:"), t != NULL)
			{
				// format: Date: DOW, DOM month yr HH:MM:SS TZ-OFFSET
				t++;
				// skip Date:
				for (w = t; !isspace(*w); w++);
				w++;
				// skip day of week
				for (; !isspace(*w); w++);
				w++;
				// get day of month
				sscanf(w,"%d",&date.tm_mday);
				for (; !isspace(*w); w++);
				w++;
				// get month
				sscanf(w,"%s",tmpstr);	// get month only
				date.tm_mon = monthnum(tmpstr);
				for (; !isspace(*w); w++);
				w++;
				// get year
				sscanf(w,"%d",&date.tm_year);
				for (; !isspace(*w); w++);
				w++;
				// get time
				sscanf(w,"%d:%d:%d",&date.tm_hour,&date.tm_min,&date.tm_sec);
				newmsg.date = mktime(&date);

			}
			else 	// no 'date'?
			{
				// then furnish one
				time(&newmsg.date);
			}
			state++;
			break;
		case 3:	// subject digestion
			if (t = strstr(buf, "Subject:"), t != NULL)
			{
				t++;
				// format: Subject: ...
				for (w = t; !isspace(*w); w++);
				w++;
				t = newmsg.subject;
				for (u = w; !iseol(*w); w++)
					*t++ = *w;
				*t = 0;
			}
			else 	// no 'Subject'?
			{
				strcpy(newmsg.subject,"");
			}
			state++;
			break;
		}
	}
	// look for rocat specific header information
	if (t = strstr(buf,"rocat-section:"), t != NULL)
	{
		// skip section
		for (w = t; !isspace(*w); w++);
		w++;
		sscanf(w,"%s",section);	// get section
		// now replace the above with spaces
		for (w=t; !iseol(*w); w++)
			*w = ' ';
	}
	else	// assume private email import if no section found
	{
		strcpy(section,"private");
	}
	if (!bounce && !strcmp(section,"private"))
	{
		priv = 1;
		t = login;
		for (u = newmsg.to; *u != '@' && *u != 0; u++)
			*t++ = *u;
		*t = 0;
		uexists = user.exists(login);
		switch(uexists)
		{
		case 0:	// user not found
			bounce++;
			sprintf(bouncemsg,"%s: No such user found.",login);
			break;
		case 1: // recipient found
			break;
		case 2:	// BBSDIR not found
		//	bounce++;
			sprintf(bouncemsg,"bbsdir env var not set");
			break;
		case 3: // unable to open userlog
		//	bounce++;
			sprintf(bouncemsg,"unable to open userlog");
			break;
		}
	}
	// skip the header information
	t = buf;
	while (!(iseol(*t) && iseol(*(t+1))))
		t++;
	// fill in the other fields of the message
	newmsg.text = t;
	if (log_mail_import())	// log imported mail?
	{
		sprintf(tmpstr,"msg import: to: %s from: %s",newmsg.to,newmsg.from_);
		ap_log(tmpstr);
	}
	if (!bounce)	// not already bounced?
	{
		// send on to the database
		bounce = post_msg(section, &newmsg,0,priv);
		sprintf(bouncemsg,"Unable to post to database: section %s, error %d",section, bounce);
	}
	if (bounce)	// error -- bounce message
	{
		if (recipient)
		{
			if (t = (char *)malloc(strlen(buf)+1000), t == NULL)
			{
				ap_log("pimport: out of memory!");
				return(0);
			}
			// copy buf back in
			sprintf(t,"%s",bouncemsg);	// add bounce message
			strcat(t,buf);
			newmsg.text = t;
			sprintf(tmpstr,"bounced message: to: %s from: %s",newmsg.to,newmsg.from_);
			ap_log(tmpstr);
			ap_log(bouncemsg);
			newmsg.to = newmsg.from_;	// return to sender
			strcpy(newmsg.from_,newmsg.to);
			forward_to_sendmail(&newmsg);
		}
		else
		{
			ap_log("Unable to bounce message: no recipients.");
		}
	}
	return(0);
}

#endif // USE_DATABASE

// Function:   	usage
// Purpose:    	give the user some clue as to how to execute program
// Input:  	none
// Output: 	a (hopefully) useful display of what the program should do
// Author: 	Greg Shaw
// Created:    	4/15/96

void usage(void)
{
	printf("Usage: msgutil -p\n");
	printf("       msgutil -e\n");
};


main(int argc,char *argv[])
{
#ifdef USE_DATABASE
	msgutil msgobj;           // files object for utilities
#endif // USE_DATABASE
	char   c;                   // character sent back by getopt



        // copy name of program into progname global (for error logging)
	msgobj.set_progname(msgobj.last_path_item(argv[0]));


	// all options are mutually exclusive
	c = getopt(argc,argv,"pe");
	// so one only should be present
	if (c == EOF)
		usage();
	else
	{
		switch(c)
		{
			case 'p':           // import private mail
#ifdef USE_DATABASE
				msgobj.pimport();
#endif // USE_DATABASE
				break;
			case 'e':           // expire messages
#ifdef USE_DATABASE
				msgobj.expire();
#endif // USE_DATABASE
				break;
			default:
				usage();
		}
	}
	return(0);
};




#endif // _MSGUTIL_C_
