// Filename:	mllist.h
// Contents:	the object definition for the doubly linked list object
// Author: 	Greg Shaw
// Created:	3/23/96

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _MLLIST_H_
#define _MLLIST_H_

// Structure:   Thread
// Contents:    thread information
// Author:      Greg Shaw
// Created:     3/17/96

typedef struct thread
{
        char    subject[MAX_SUBJECT];   // thread subject
        char    section[MAX_SECTION];   // section of thread
        int     thread_number;          // thread id
        int     messages;               // number of messages in thread
        struct thread *next;            // next thread
        struct thread *previous;            // next thread
} Thread;


#include "bbshdr.h"


// Object: mllist
// Purpose:    encapsulate a doubly linked list object with
//     self-sorting capabilities.
// Attributes: numrec - number of records in list
//     head - head of list
//         tail - tail of list
// Methods:    add - add to list
//         clear - nuke list
//     previous - return 'previous' record
//     next - return 'next' record
// Author: Greg Shaw
// Created:    3/23/96

class mllist : public errlog
{
	int    numrec;              // number of records in list
	Thread  *thead;               // head of list
	Thread  *ttail;               // tail (end) of list
	Thread  *here;               // current list record pointer
public:
		mllist();               // constructor
		~mllist();              // destructor

	int	add(Thread *rec);        // add to list


	int	clear_list(void);       // nuke list

	int	head(void);              // go to head of list

	Thread 	*next(void);      // next record
	int	numrecs(void)           // return number of records
		{
			return(numrec);
		};

	Thread 	*previous(void);  // previous record
	int 	pos(Thread *rec);	// ordinal position of this record in list
	int 	position(void);	// numeric position in list

	Thread 	*rewind(int pos);	// rewind pos records

	Thread 	*search(Thread *pos, char *str);	// search for string in subject
	Thread 	*seek(int pos);	// seek forward pos records
	int 	setpos(Thread *pos);	// set the position in the list

	int	tail(void);           // go to tail of list

};


#endif                          // _MLLIST_H_







