// Filename:   mllist.C
// Contents:   the doubly linked list object methods
// Author: Greg Shaw
// Created:    3/23/96

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _MLLIST_C_
#define _MLLIST_C_

#include "bbshdr.h"

#ifdef USE_DATABASE

// Method: constructor
// Purpose:    initialize the object to a known state
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

mllist::mllist()
{
	thead=ttail=NULL;
	numrec = 0;
	here = NULL;
};


// Method: destructor
// Purpose:    clean up after the object
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

mllist::~mllist()
{
	clear_list();
};


// Method: add
// Purpose:    add a record to the object
// Input:  rec - the record to add to the object
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

int mllist::add(Thread *rec)
{
	Thread  *newrec;

	if (newrec = (Thread *)malloc(sizeof(Thread)), newrec == NULL)
	{
		ap_log("mllist: Unable to malloc new Thread record.");
		return(-1);
	}
	memcpy(newrec,rec,sizeof(Thread));	// quick copy
	newrec->previous = NULL;
	newrec->next = NULL;
	if (thead == NULL)
	{
		thead = newrec;
		ttail=newrec;
	}
	else
	{
		newrec->previous = ttail;
		ttail->next = newrec;
		ttail = newrec;
	}
	numrec++;
	return(0);
};


// Function:   clear
// Purpose:    add a record to the object
// Input:  rec - the record to add to the object
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

int mllist::clear_list(void)
{
	Thread  *tmprec, *tmprec2;

	tmprec = thead;
	for (tmprec = thead; tmprec != NULL; )
	{
		tmprec2 = tmprec;
		tmprec = tmprec->next;
		free(tmprec2);
	}
	numrec = 0;
	thead = ttail = NULL;
	return(0);
};


// Function:  thead
// Purpose:    set 'here' tothead of the list
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

int mllist::head(void)
{
	here = NULL;
	return(0);
};


// Function:	next
// Purpose:	return the 'next' record in the array
// Input:  	none
// Output: 	none
// Author:	Greg Shaw
// Created:    3/23/96

Thread *mllist::next(void)
{
	if (here == ttail)	// if at end, return NULL
		return(NULL);
	else if (here != NULL)
		here = here->next;	// else return the next record
	else
		here = thead;	// return first record if at start
	return(here);
};


// Function:   pos
// Purpose:    return the ordinal position of a record in the list
// Input:  	rec - the record to look for
// Output: 	see above
// Author: 	Greg Shaw
// Created:    	3/23/96

int mllist::pos(Thread *rec)   // ordinal position of this record in list
{
	Thread *tptr;
	register int x;

	x = 1;
	for (tptr = thead; tptr != NULL && tptr != rec; tptr = tptr->next)
		x++;
	return(tptr!=NULL?x:0);
}



// Function:   position
// Purpose:    return the current pointer position
// Input:  	none
// Output: 	the numeric position in the list of 'here'
// Author: 	Greg Shaw
// Created:    	3/23/96

int mllist::position(void)
{
	Thread *pos;
	register int x;

	if (here == NULL)
		return(-1);
	x = 0;
	for (pos =thead; pos != here && pos != NULL; pos=pos->next)
	{
		x++;
	}
	if (pos == NULL)
		return(-1);
	return(x);
}

// Function:   previous
// Purpose:    return the previous record in the list
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

Thread *mllist::previous(void)
{
	if (here == thead)		// if at start, return NULL
		return(NULL);	
	else if (here != NULL)				// return previous record
		here = here->previous;
	else	// set to tail if head == NULL
		here = ttail;
	return(here);
};


// Function:   	rewind
// Purpose:    	rewind some number of records in the list
// Input: 	pos - how many positions to rewind 
// Output: 	the record at that position, the start of the list
// Author: 	Greg Shaw
// Created:    	3/23/96

Thread *mllist::rewind(int pos)
{
	int x;

	for (x = 0; x< pos; x++)
	{
		if (here == thead)
		{
			here = NULL;
			return(NULL);
		}
		else
			here = here->previous;
	}
	return(here);
}

// Function:   	search
// Purpose:    	search for some string in the thread list
// Input: 	pos - the record to start the search from 
//		(NULL to start at the beginning)
//		str - the string to search for
// Output: 	a record (if found) or NULL
// Author: 	Greg Shaw
// Created:    	3/24/96
// Notes:	this isn't case sensitive

Thread *mllist::search(Thread *pos, char *str)
{
	Thread *rec;
	int    found;
	char	tmpstr[MAX_SUBJECT+1];
	char	key[MAX_SUBJECT+1];

	setpos(pos);
	strcpy(key,str);
	wordtolower(key);
	rec = thead;
	for (found = 0; !found && rec != NULL; rec = rec->next)
	{
		strcpy(tmpstr,rec->subject);
		wordtolower(tmpstr);
		if (strstr(tmpstr,key) == 0)
			found++;
	}
	return(rec);
};


// Function:   	seek
// Purpose:    	seek some number of records forward in the list
// Input: 	pos - how many positions to seek
// Output: 	the record at that position, or the end of the list
// Author: 	Greg Shaw
// Created:    	3/23/96

Thread *mllist::seek(int pos)
{
	int x;

	for (x = 0; x< pos; x++)
	{
		if (here == ttail)
		{
			here = NULL;
			return(here);
		}
		else
			here = here->next;
	}
	return(here);
}

// Function:   	setpos
// Purpose:    	set the 'here' pointer to the current record
// Input: 	pos - a pointer to the position
// Output: 	non zero for error
// Author: 	Greg Shaw
// Created:    	3/24/96

int mllist::setpos(Thread *pos)
{
	// NOTE: I really should be checking this against the list, but
	// for speed, I'm going to 'trust' the calling object
	here = pos;
	return(0);
}


// Function:   tail
// Purpose:    set 'here' to end of the list
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    3/23/96

int mllist::tail(void)
{
	here = NULL;
	return(0);
};


#endif 	// USE_DATABASE

#endif                          //_MLLIST_C_






