// Filename:   files.h
// Contents:   the files management object
// Author: Greg Shaw
// Created:    7/27/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _FILES_H_
#define _FILES_H_

#include "bbshdr.h"

// definitions
#define NO_FILE_POSITION	-1	// invalid file position

// Object: files
// Purpose:    encapsulate all file operations for the BBS.  this includes
//     upload, download, deletion, descriptions, automatic
//     checking, etc.
// Attributes: up_path - upload directory (where to place uploads)
//     dn_path - download directory (where files reside normally)
//     acl - access level for this section
//     num_files - number of files in section
//     name - name of section
//     age - age of file for automatic deletion
//     sysop - sysop's (if sub) login (for mail)
//     long_desc - long description of files area
//     type - type of files section
//     header_path - location of files header (for CDROM filesystems)
// Methods:
// Author: Greg Shaw
// Created:    7/27/93

class files: public language
{
	char   up_path[255];        // upload path
	int    acl;                 // access level of section
	int    num_files;           // number of files in section
	char   name[MAX_SECTION_LENGTH];// name of section
	int    age;                 // age at which to delete files (days)
	char   sysop[15];           // sysop of section
	FInfo  *selfiles[20];       // selected files for download (20 max)
	int    numsel;              // number of selected files
	int    ksel;                // number of K selected
	CardRec    *thisuser;       // user card
	char   long_desc[100];       // long description of files area
	char   type;                // type of files section
	// header path (if not rocat type)
	char   header_path[MAXPATHLEN+1];
	public:
		files();                // constructor
	char	dn_path[255];    // download path
	dllist	list_obj;        // list object


	int	create();

	int	download(FInfo *list[], int numfiles, int increment, time_t logofftime);
		// download file(s)
	int	download_possible(CardRec *user, int numfiles, long kbytes, 
			unsigned int *totkbytes, unsigned int totfiles,
			float uratio);

	int	edit_file(FInfo *item); // edit a file entry

	int	get_file_status(FInfo *rec);	// get file date and status
		// increment # of downloads field
	int	increment_dls(FInfo *list[], int numfiles);
	int	info(FInfo *fptr, char ldesc[3][100], char *machreq);
		// get detailed info on file

		// list files
	int	list(int can_download, CardRec *user, unsigned int *kused, 
			time_t since_time, float uratio, int timelimit, 
			time_t logon, int timeused, unsigned int *totkused,
			unsigned int totfiles, int lines);

		// download one file
	int	one_download(unsigned int *kused, float uratio, 
			char *filename, int counts, CardRec *user, 
			unsigned int totfiles, unsigned int *totk);
	int	one_upload(char *uname, char *uppath);
	int	open(char *name, CardRec *user); // open section

		// search files section for something
	int	search(int can_download, int timelimit, time_t logon, int timeused);
	int	search_sections(int can_download, int timelimit, time_t logon, int timeused);
		// update file information
	int	update_information(FInfo *item, char *origname, char desc[3][100],
			char *machreq, int del);
	int	upload(char *uname, char *editor, int *credit); // upload file(s)
	void 	waitmsg(void) { sstrcrl("WORKING"); };

};


#endif                          // _FILES_H_






