// Filename:   errlog.h
// Contents:   the error logger object.  Used in the entire BBS system to
//             serve as a cental error repository
// Author:     Greg Shaw
// Created:        7/11/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _ERRLOG_H_
#define _ERRLOG_H_

// Object:     errlog
// Purpose:        serve as the central BBS error logging function
// Attributes:
//                 none
// Methods:
//     ap_log  append to the log file
//         er_log  append to log file and abort program (should be rarely used)
// Author:     Greg Shaw
// Created:        7/11/93

// inherited from bbsipc object
class errlog: public bbsipc, public bbsinfo
{                               // and bbsinfo object
	bbsipc err_ipcobj;              // ipc object
	public:
	int	ap_log(char *msg);      // append to log file
	int	er_log(char *msg);      // append to log file and exit
		void set_progname(char *pname);	// set the program name
};


#endif                          // _ERRLOG_H_







