// Filename:   bbsutil.h
// Contents:   functions that don't belong in any other object 
// Author:     Greg Shaw
// Created:    12/31/95

/*

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSUTIL_H_
#define _BBSUTIL_H_

// Object:     bbsutil
// Purpose:    serve generalized functions that don't fit with other 
//		objects
// Attributes: none
// Methods:
// Author:     Greg Shaw
// Created:    12/31/95

class bbsutil
{
	public:
		int	colortonum(char *color);// convert color to ordinal

		char	*dequote(char *string);	// change ' to \'
		int	domainname(char *name);	// get domainname

		char	*getline(FILE *ifile);//  get a line

		unsigned long hashpjw(const char* x);	// generate hash
		int	hostname(char *name);	// get hostname

		char	*last_path_item(char *path);	// return last item in path

		inline int	iseol(int c) { // return true for eol
			if (c == '\r' || c == '\n')
				return(1); 
			return(0);
			};	

		int	monthnum(char *name);	// convert from month to ord

		int	read_file(char **ptr,char *path);	// read file into malloc'ed storage

		char	*username(void);   // return name of current user

		int	wordtolower(char *word);	// convert word to lower case
};


#endif                          // _BBSUTIL_H_







