// Filename:	bbsutil.C
// Contents:	the methods for the bbsutil object
// Author:	Greg Shaw
// Created:	12/31/95

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSUTIL_C_
#define _BBSUTIL_C_

#include "bbshdr.h"


// Function:	colortonum
// Purpose:	return the ordinal number for a card color
// Input:	color - the color to check 
// Output:	an ordinal number for the card color
// Author:	Greg Shaw
// Created:	8/23/95
int bbsutil::colortonum(char *color)
{
	if (strstr(color,"red") != NULL)
		return(0);
	if (strstr(color,"blue") != NULL)
		return(1);
	if (strstr(color,"green") != NULL)
		return(2);
	if (strstr(color,"white") != NULL)
		return(3);
	if (strstr(color,"grey") != NULL)
		return(4);
	if (strstr(color,"pink") != NULL)
		return(5);
	if (strstr(color,"yellow") != NULL)
		return(6);
	if (strstr(color,"rose") != NULL)
		return(7);
	if (strstr(color,"violet") != NULL)
		return(8);
	if (strstr(color,"azure") != NULL)
		return(9);
	if (strstr(color,"brown") != NULL)
		return(10);
	if (strstr(color,"peach") != NULL)
		return(11);
	if (strstr(color,"black") != NULL)
		return(12);
	else
		return(-1);
}

// Function:	dequote
// Purpose:	backtick quotes found in a string
// Input:	string - the string to check
// Output:	the domainname of the current machine
// Author:	Gregory Shaw
// Created:	5/19/96

char *bbsutil::dequote(char *string)
{
	char *buf;	// 4k max
	register char *c,*t;
	register int quotes;

	quotes = 0;
	for (c = string; *c != 0; c++)
		if (*c == '\'')
			quotes++;
	if (buf = (char *)malloc(strlen(string)+quotes+1), buf == NULL)
		return(NULL);	// nasty, but there isn't much to do about it
	if (strchr(string,'\'') == NULL)
		strcpy(buf,string);
	else
	{
		t = buf;
		for (c=string; *c != 0; c++)
		{
			if ((unsigned int)(t-buf) < strlen(string)*2)
			{
				if (*c == '\'')
				{
					*t++ = '\\';
				}
				*t++ = *c;
			}
		}
		*t = 0;
	}
	return(buf);
}

// Function:	domainname
// Purpose:	get the domain name of the current machine
// Input:	none
// Output:	the domainname of the current machine
// Author:	Gregory Shaw
// Created:	3/14/96

int bbsutil::domainname(char *name)
{
	struct utsname sys;

	if (uname(&sys) != 0)
		return(-1);
	strcpy(name,sys.__domainname);
	return(0);
}

// Function:	getline
// Purpose:	get an entire line into a buffer
// Input:	file - the file pointer for the file
// Output:	(none)
// Author:	Gregory Shaw
// Created:	7/8/95
// Notes:	This function should return some error when the line is
//		longer than MAXPATHLEN.

char *bbsutil::getline(FILE *infile)
{
        static char tmpstr[MAXPATHLEN+1];        // buffer storage
        char *c;


        c = tmpstr;
        while (*c = fgetc(infile), !iseol(*c) && !feof(infile))
		if (c - tmpstr < MAXPATHLEN)
			c++;
        *c = 0;
        return(tmpstr);
}

// Method:	hashpjw
// Purpose:	generate a hash from a string
// Input:	character string
// Output:	hash of character string
// Author:	Gregory Shaw
// Notes:	this function has been shamelessly copied from libg++.
// Created:	11/10/94

// From Dragon book, p436
unsigned long bbsutil::hashpjw(const char* x)
{
        register unsigned int h = 0;
        register unsigned int g;

        while (*x != 0)
        {
                h = (h << 4) + *x++;
                if ((g = h & 0xf0000000) != 0)
                        h = (h ^ (g >> 24)) ^ g;
        }
        return h; 
}

// Function:	hostname
// Purpose:	get the host name of the current machine
// Input:	none
// Output:	the hostname of the current machine
// Author:	Gregory Shaw
// Created:	3/14/96

int bbsutil::hostname(char *name)
{
	struct utsname sys;

	if (uname(&sys) != 0)
		return(-1);
	strcpy(name,sys.nodename);
	return(0);
}

// Function:	last_path_item
// Purpose:	return the last item in the path
// Input:		item - the path to look through
// Output:		the final item in the path 
// Author:		Greg Shaw
// Created:		7/7/96 

char *bbsutil::last_path_item(char *path)
{
	char *u;
	char *p = path;

	u = path;
	while(*u != 0)
	{
		if (*u == '/')
			p = u+1;
		u++;
	}
	return(p);
}

// Function:	monthnum
// Purpose:	return the ordinal month number based on the name
// Input:		mname - the name of the month
// Output:		the ordinal month number
// Author:		Greg Shaw
// Created:		5/19/96

int bbsutil::monthnum(char *mname)
{
	char umname[10];
	char *u;

	// convert to lower case
	for (u = umname; *mname != 0; mname++)
		*u++ = tolower(*mname);
	*u = 0;
	if (!strcmp(umname,"jan"))
		return(0);
	if (!strcmp(umname,"feb"))
		return(1);
	if (!strcmp(umname,"mar"))
		return(2);
	if (!strcmp(umname,"apr"))
		return(3);
	if (!strcmp(umname,"may"))
		return(4);
	if (!strcmp(umname,"jun"))
		return(5);
	if (!strcmp(umname,"jul"))
		return(6);
	if (!strcmp(umname,"aug"))
		return(7);
	if (!strcmp(umname,"sep"))
		return(8);
	if (!strcmp(umname,"oct"))
		return(9);
	if (!strcmp(umname,"nov"))
		return(10);
	if (!strcmp(umname,"dec"))
		return(11);
	else
		return(-1);
}

// Function:	read_file
// Purpose:	read a file into malloc'd storage
// Input:	ptr - pointer to store storage into (unallocated)
//		path - path to read file
// Output:	0 for no error, non-zero on error
// Author:	Greg Shaw
// Created:	11/1/98
// Notes:	After use, the ptr should be free'd
//		This function doesn't use implicit locking 

int bbsutil::read_file(char **ptr, char *path)
{
	FILE *in;		// file
	char *p;		// ptr
	struct stat fistat;	// file status

	if (stat(path,&fistat) == 0 && S_ISREG(fistat.st_mode))
	{
		if (in = fopen(path,"r"), in == NULL)
			return(-1);
		// allocate storage
		if (*ptr = (char *)malloc(fistat.st_size+1), *ptr == NULL)
			return(-1);
		p = *ptr;
		while (!feof(in))
			*p++ = fgetc(in);
		fclose(in);
		*p = 0;
		return(0);
	}
	return(-1);
}

// Function:	username
// Purpose:	return the login name of the current user
// Input:	none
// Output:	true/false
// Author:	Greg Shaw
// Created:	7/13/93

char *bbsutil::username(void)
{
	struct passwd *thisuser;
	static char name[MAX_LOGIN_LENGTH] = "";

	if (strlen(name) != 0)	// cache the name
		return(name);
	if (thisuser = getpwuid(geteuid()), thisuser == NULL)
		return(NULL);
	else
	{
		strcpy(name,thisuser->pw_name);
// causes core dump on Red Hat 3.0.3 distribution
//		free(thisuser);	// free alloced storage
		return(name);
	}
};


// Function:	wordtolower
// Purpose:	convert a word to lower case
// Input:	word - the word to convert
// Output:	the string, converted to lower case
// Author:	Greg Shaw
// Created:	12/31/95

int bbsutil::wordtolower(char *word)
{
	char *p;
	register char c;

	for (p = word; *p != 0; p++)
	{
		c = tolower(*p);
		*p = c;
	}
	return(0);
}

#endif                          // _BBSUTIL_C_
